//
// ========================================================================
// Copyright (c) 1995 Mort Bay Consulting Pty Ltd and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// https://www.eclipse.org/legal/epl-2.0, or the Apache License, Version 2.0
// which is available at https://www.apache.org/licenses/LICENSE-2.0.
//
// SPDX-License-Identifier: EPL-2.0 OR Apache-2.0
// ========================================================================
//

package org.eclipse.jetty.ee11.webapp;

import org.eclipse.jetty.util.Loader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * <p>JSP Configuration</p>
 * <p>This configuration configures the WebAppContext server/system classes to
 * be able to see the org.eclipse.jetty.jsp and org.eclipse.jetty.apache packages.
 * This class is defined in the webapp package, as it implements the {@link Configuration} interface,
 * which is unknown to the jsp package.
 * </p>
 */
public class JspConfiguration extends AbstractConfiguration
{
    private static final Logger LOG = LoggerFactory.getLogger(JspConfiguration.class);

    public JspConfiguration()
    {
        super(new Builder()
            .addDependencies(WebXmlConfiguration.class, MetaInfConfiguration.class, WebInfConfiguration.class, FragmentConfiguration.class)
            .addDependents(WebAppConfiguration.class)
            .protectAndExpose("org.eclipse.jetty.ee11.jsp.")
            .expose("org.eclipse.jetty.ee11.apache.")
            .hide("org.eclipse.jdt."));
    }

    @Override
    public boolean isAvailable()
    {
        try
        {
            return Loader.loadClass("org.eclipse.jetty.ee11.jsp.JettyJspServlet") != null;
        }
        catch (Throwable e)
        {
            LOG.trace("IGNORED", e);
            return false;
        }
    }
}

