/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.wasp.taglibs.standard.tag.common.core;

import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.JspTagException;
import jakarta.servlet.jsp.tagext.BodyTagSupport;
import jakarta.servlet.jsp.tagext.Tag;
import java.util.LinkedList;
import java.util.List;
import org.glassfish.wasp.taglibs.standard.resources.Resources;
import org.glassfish.wasp.taglibs.standard.tag.common.core.ParamParent;
import org.glassfish.wasp.taglibs.standard.tag.common.core.Util;

public abstract class ParamSupport
extends BodyTagSupport {
    protected String name;
    protected String value;
    protected boolean encode = true;

    public ParamSupport() {
        this.init();
    }

    private void init() {
        this.value = null;
        this.name = null;
    }

    @Override
    public int doEndTag() throws JspException {
        Tag t = ParamSupport.findAncestorWithClass(this, ParamParent.class);
        if (t == null) {
            throw new JspTagException(Resources.getMessage("PARAM_OUTSIDE_PARENT"));
        }
        if (this.name == null || this.name.equals("")) {
            return 6;
        }
        ParamParent parent = (ParamParent)((Object)t);
        String value = this.value;
        if (value == null) {
            value = this.bodyContent == null || this.bodyContent.getString() == null ? "" : this.bodyContent.getString().trim();
        }
        if (this.encode) {
            String enc = this.pageContext.getResponse().getCharacterEncoding();
            parent.addParameter(Util.URLEncode(this.name, enc), Util.URLEncode(value, enc));
        } else {
            parent.addParameter(this.name, value);
        }
        return 6;
    }

    @Override
    public void release() {
        this.init();
    }

    public static class ParamManager {
        private List<String> names = new LinkedList<String>();
        private List<String> values = new LinkedList<String>();
        private boolean done = false;

        public void addParameter(String name, String value) {
            if (this.done) {
                throw new IllegalStateException();
            }
            if (name != null) {
                this.names.add(name);
                if (value != null) {
                    this.values.add(value);
                } else {
                    this.values.add("");
                }
            }
        }

        public String aggregateParams(String url) {
            if (this.done) {
                throw new IllegalStateException();
            }
            this.done = true;
            StringBuffer newParams = new StringBuffer();
            for (int i = 0; i < this.names.size(); ++i) {
                newParams.append(this.names.get(i)).append("=").append(this.values.get(i));
                if (i >= this.names.size() - 1) continue;
                newParams.append("&");
            }
            if (newParams.length() > 0) {
                int questionMark = url.indexOf(63);
                if (questionMark == -1) {
                    return url + "?" + newParams;
                }
                StringBuilder workingUrl = new StringBuilder(url);
                workingUrl.insert(questionMark + 1, newParams + "&");
                return workingUrl.toString();
            }
            return url;
        }
    }
}

