/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.wasp.servlet;

import jakarta.servlet.Servlet;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.UnavailableException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.jsp.tagext.TagInfo;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.jsp.api.JspProbeEmitter;
import org.glassfish.wasp.JspCompilationContext;
import org.glassfish.wasp.Options;
import org.glassfish.wasp.WaspException;
import org.glassfish.wasp.compiler.JspRuntimeContext;
import org.glassfish.wasp.compiler.Localizer;
import org.glassfish.wasp.runtime.JspSourceDependent;

public class JspServletWrapper {
    private static Logger log = Logger.getLogger(JspServletWrapper.class.getName());
    private Servlet theServlet;
    private String jspUri;
    private Class<?> servletClass;
    private Class<?> tagHandlerClass;
    private JspCompilationContext ctxt;
    private long available = 0L;
    private ServletConfig config;
    private Options options;
    private boolean firstTime = true;
    private boolean reload = true;
    private boolean isTagFile;
    private int tripCount;
    private WaspException compileException;
    private JspProbeEmitter jspProbeEmitter;
    private long servletClassLastModifiedTime = 0L;
    private File jspFile;
    private long lastModificationTest = 0L;

    JspServletWrapper(ServletConfig config, Options options, String jspUri, boolean isErrorPage, JspRuntimeContext rctxt) throws WaspException {
        this.isTagFile = false;
        this.config = config;
        this.options = options;
        this.jspUri = jspUri;
        this.jspProbeEmitter = (JspProbeEmitter)config.getServletContext().getAttribute("org.glassfish.jsp.monitor.probeEmitter");
        this.ctxt = new JspCompilationContext(jspUri, isErrorPage, options, config.getServletContext(), this, rctxt);
        String jspFilePath = this.ctxt.getRealPath(jspUri);
        if (jspFilePath != null) {
            this.jspFile = new File(jspFilePath);
        }
    }

    public JspServletWrapper(ServletContext servletContext, Options options, String tagFilePath, TagInfo tagInfo, JspRuntimeContext rctxt, URL tagFileJarUrl) throws WaspException {
        this.isTagFile = true;
        this.config = null;
        this.options = options;
        this.jspUri = tagFilePath;
        this.tripCount = 0;
        this.ctxt = new JspCompilationContext(this.jspUri, tagInfo, options, servletContext, this, rctxt, tagFileJarUrl);
    }

    public JspCompilationContext getJspEngineContext() {
        return this.ctxt;
    }

    public void setReload(boolean reload) {
        this.reload = reload;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Servlet getServlet() throws ServletException, IOException, ClassNotFoundException {
        if (this.reload) {
            JspServletWrapper jspServletWrapper = this;
            synchronized (jspServletWrapper) {
                if (this.reload) {
                    this.destroy();
                    try {
                        this.servletClass = this.ctxt.load();
                        this.theServlet = (Servlet)this.servletClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                    catch (ReflectiveOperationException ex1) {
                        throw new WaspException(ex1);
                    }
                    this.theServlet.init(this.config);
                    if (!this.firstTime) {
                        this.ctxt.getRuntimeContext().incrementJspReloadCount();
                        if (this.jspProbeEmitter != null) {
                            this.jspProbeEmitter.jspReloadedEvent(this.jspUri);
                        }
                    }
                    this.reload = false;
                    if (this.jspProbeEmitter != null) {
                        this.jspProbeEmitter.jspLoadedEvent(this.jspUri);
                    }
                }
            }
        }
        return this.theServlet;
    }

    public ServletContext getServletContext() {
        return this.config.getServletContext();
    }

    public void setCompilationException(WaspException je) {
        this.compileException = je;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setServletClassLastModifiedTime(long lastModified) {
        if (this.servletClassLastModifiedTime < lastModified) {
            JspServletWrapper jspServletWrapper = this;
            synchronized (jspServletWrapper) {
                if (this.servletClassLastModifiedTime < lastModified) {
                    this.servletClassLastModifiedTime = lastModified;
                    this.reload = true;
                }
            }
        }
    }

    public long getServletClassLastModifiedTime() {
        return this.servletClassLastModifiedTime;
    }

    public Class<?> loadTagFile() throws WaspException {
        try {
            this.ctxt.compile();
            if (this.reload) {
                this.tagHandlerClass = this.ctxt.load();
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (FileNotFoundException ex) {
            log.log(Level.SEVERE, Localizer.getMessage("jsp.error.compiling"));
            throw new WaspException(ex);
        }
        return this.tagHandlerClass;
    }

    public Class<?> loadTagFilePrototype() throws WaspException {
        this.ctxt.setPrototypeMode(true);
        try {
            Class<?> clazz = this.loadTagFile();
            return clazz;
        }
        finally {
            this.ctxt.setPrototypeMode(false);
        }
    }

    public List<String> getDependants() {
        try {
            Servlet target;
            if (this.isTagFile) {
                if (this.reload) {
                    this.tagHandlerClass = this.ctxt.load();
                }
                target = this.tagHandlerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            } else {
                target = this.getServlet();
            }
            if (target instanceof JspSourceDependent) {
                return ((JspSourceDependent)((Object)target)).getDependants();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public boolean isTagFile() {
        return this.isTagFile;
    }

    public int incTripCount() {
        return this.tripCount++;
    }

    public int decTripCount() {
        return this.tripCount--;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(HttpServletRequest request, HttpServletResponse response, boolean precompile) throws ServletException, IOException {
        try {
            if (this.ctxt.isRemoved()) {
                this.jspFileNotFound(request, response);
                return;
            }
            if (this.available > 0L && this.available < Long.MAX_VALUE) {
                response.setDateHeader("Retry-After", this.available);
                response.sendError(503, Localizer.getMessage("jsp.error.unavailable"));
            }
            if (!this.options.getUsePrecompiled() && (this.options.getDevelopment() || this.firstTime)) {
                JspServletWrapper jspServletWrapper = this;
                synchronized (jspServletWrapper) {
                    this.firstTime = false;
                    this.ctxt.compile();
                }
            } else if (this.compileException != null) {
                throw this.compileException;
            }
            try {
                this.getServlet();
            }
            catch (ClassNotFoundException ex) {
                this.jspFileNotFound(request, response);
                return;
            }
            if (precompile) {
                return;
            }
            this.theServlet.service(request, response);
        }
        catch (UnavailableException ex) {
            String includeRequestUri = (String)request.getAttribute("jakarta.servlet.include.request_uri");
            if (includeRequestUri != null) {
                throw ex;
            }
            int unavailableSeconds = ex.getUnavailableSeconds();
            if (unavailableSeconds <= 0) {
                unavailableSeconds = 60;
            }
            this.available = System.currentTimeMillis() + (long)unavailableSeconds * 1000L;
            response.sendError(503, ex.getMessage());
        }
        catch (ServletException | IOException | IllegalStateException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new WaspException(ex);
        }
    }

    public void destroy() {
        if (this.theServlet != null) {
            this.theServlet.destroy();
            if (this.jspProbeEmitter != null) {
                this.jspProbeEmitter.jspDestroyedEvent(this.jspUri);
            }
        }
    }

    public long getLastModificationTest() {
        return this.lastModificationTest;
    }

    public void setLastModificationTest(long lastModificationTest) {
        this.lastModificationTest = lastModificationTest;
    }

    public File getJspFile() {
        return this.jspFile;
    }

    private void jspFileNotFound(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        FileNotFoundException fnfe = new FileNotFoundException(this.jspUri);
        this.ctxt.incrementRemoved();
        String includeRequestUri = (String)request.getAttribute("jakarta.servlet.include.request_uri");
        if (includeRequestUri != null) {
            throw new ServletException(fnfe);
        }
        try {
            response.sendError(404, fnfe.getMessage());
        }
        catch (IllegalStateException ise) {
            log.log(Level.SEVERE, Localizer.getMessage("jsp.error.file.not.found", fnfe.getMessage()), fnfe);
        }
    }
}

