/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.wasp.servlet;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterRegistration;
import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRegistration;
import jakarta.servlet.SessionCookieConfig;
import jakarta.servlet.SessionTrackingMode;
import jakarta.servlet.descriptor.JspConfigDescriptor;
import jakarta.servlet.descriptor.JspPropertyGroupDescriptor;
import jakarta.servlet.descriptor.TaglibDescriptor;
import java.io.File;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.glassfish.wasp.WaspException;
import org.glassfish.wasp.xmlparser.ParserUtils;
import org.glassfish.wasp.xmlparser.TreeNode;

public class JspCServletContext
implements ServletContext {
    protected Hashtable<String, Object> myAttributes = new Hashtable();
    protected PrintWriter myLogWriter;
    protected URL myResourceBaseURL;
    private JspConfigDescriptor jspConfigDescriptor;
    private static final String WEB_XML = "/WEB-INF/web.xml";

    public JspCServletContext(PrintWriter aLogWriter, URL aResourceBaseURL) {
        this.myLogWriter = aLogWriter;
        this.myResourceBaseURL = aResourceBaseURL;
        this.parseWebDotXml();
    }

    @Override
    public Object getAttribute(String name) {
        return this.myAttributes.get(name);
    }

    @Override
    public Enumeration<String> getAttributeNames() {
        return this.myAttributes.keys();
    }

    @Override
    public String getContextPath() {
        return null;
    }

    @Override
    public ServletContext getContext(String uripath) {
        return null;
    }

    @Override
    public String getInitParameter(String name) {
        return null;
    }

    @Override
    public Enumeration<String> getInitParameterNames() {
        return new Vector().elements();
    }

    @Override
    public int getMajorVersion() {
        return 6;
    }

    @Override
    public String getMimeType(String file) {
        return null;
    }

    @Override
    public int getMinorVersion() {
        return 0;
    }

    @Override
    public int getEffectiveMajorVersion() {
        return 6;
    }

    @Override
    public int getEffectiveMinorVersion() {
        return 0;
    }

    @Override
    public RequestDispatcher getNamedDispatcher(String name) {
        return null;
    }

    @Override
    public String getRealPath(String path) {
        if (!this.myResourceBaseURL.getProtocol().equals("file")) {
            return null;
        }
        if (!path.startsWith("/")) {
            return null;
        }
        try {
            return this.getResource(path).getFile().replace('/', File.separatorChar);
        }
        catch (Throwable t) {
            return null;
        }
    }

    @Override
    public RequestDispatcher getRequestDispatcher(String path) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public URL getResource(String path) throws MalformedURLException {
        if (!path.startsWith("/")) {
            throw new MalformedURLException("Path '" + path + "' does not start with '/'");
        }
        URL url = new URL(this.myResourceBaseURL, path.substring(1));
        InputStream is = null;
        try {
            is = url.openStream();
        }
        catch (Throwable t) {
            url = null;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Throwable throwable) {}
            }
        }
        return url;
    }

    @Override
    public InputStream getResourceAsStream(String path) {
        try {
            return this.getResource(path).openStream();
        }
        catch (Throwable t) {
            return null;
        }
    }

    @Override
    public Set<String> getResourcePaths(String path) {
        String basePath;
        HashSet<String> thePaths = new HashSet<String>();
        if (!((String)path).endsWith("/")) {
            path = (String)path + "/";
        }
        if ((basePath = this.getRealPath((String)path)) == null) {
            return thePaths;
        }
        File theBaseDir = new File(basePath);
        if (!theBaseDir.exists() || !theBaseDir.isDirectory()) {
            return thePaths;
        }
        String[] theFiles = theBaseDir.list();
        for (int i = 0; i < theFiles.length; ++i) {
            File testFile = new File(basePath + File.separator + theFiles[i]);
            if (testFile.isFile()) {
                thePaths.add((String)path + theFiles[i]);
                continue;
            }
            if (!testFile.isDirectory()) continue;
            thePaths.add((String)path + theFiles[i] + "/");
        }
        return thePaths;
    }

    @Override
    public String getServerInfo() {
        return "JspCServletContext/1.0";
    }

    @Override
    public String getServletContextName() {
        return this.getServerInfo();
    }

    @Override
    public void log(String message) {
        this.myLogWriter.println(message);
    }

    @Override
    public void log(String message, Throwable exception) {
        this.myLogWriter.println(message);
        exception.printStackTrace(this.myLogWriter);
    }

    @Override
    public void removeAttribute(String name) {
        this.myAttributes.remove(name);
    }

    @Override
    public void setAttribute(String name, Object value) {
        this.myAttributes.put(name, value);
    }

    public void addServlet(String servletName, String description, String className, Map<String, String> initParameters, int loadOnStartup) {
    }

    public void addServletMapping(String servletName, String[] urlPatterns) {
    }

    public void addFilter(String filterName, String description, String className, Map<String, String> initParameters) {
    }

    @Override
    public boolean setInitParameter(String name, String value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ServletRegistration.Dynamic addServlet(String servletName, String className) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ServletRegistration.Dynamic addServlet(String servletName, Servlet servlet) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ServletRegistration.Dynamic addServlet(String servletName, Class<? extends Servlet> servletClass) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ServletRegistration.Dynamic addJspFile(String s, String s1) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T extends Servlet> T createServlet(Class<T> c) throws ServletException {
        throw new UnsupportedOperationException();
    }

    @Override
    public ServletRegistration getServletRegistration(String servletName) {
        throw new UnsupportedOperationException();
    }

    public Map<String, ServletRegistration> getServletRegistrations() {
        throw new UnsupportedOperationException();
    }

    @Override
    public FilterRegistration.Dynamic addFilter(String filterName, String className) {
        throw new UnsupportedOperationException();
    }

    @Override
    public FilterRegistration.Dynamic addFilter(String filterName, Filter filter) {
        throw new UnsupportedOperationException();
    }

    @Override
    public FilterRegistration.Dynamic addFilter(String filterName, Class<? extends Filter> filterClass) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T extends Filter> T createFilter(Class<T> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public FilterRegistration getFilterRegistration(String filterName) {
        throw new UnsupportedOperationException();
    }

    public Map<String, FilterRegistration> getFilterRegistrations() {
        throw new UnsupportedOperationException();
    }

    @Override
    public SessionCookieConfig getSessionCookieConfig() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setSessionTrackingModes(Set<SessionTrackingMode> sessionTrackingModes) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<SessionTrackingMode> getDefaultSessionTrackingModes() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<SessionTrackingMode> getEffectiveSessionTrackingModes() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addListener(String className) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T extends EventListener> void addListener(T t) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addListener(Class<? extends EventListener> listenerClass) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T extends EventListener> T createListener(Class<T> clazz) throws ServletException {
        throw new UnsupportedOperationException();
    }

    @Override
    public JspConfigDescriptor getJspConfigDescriptor() {
        return this.jspConfigDescriptor;
    }

    @Override
    public ClassLoader getClassLoader() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void declareRoles(String ... roleNames) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getVirtualServerName() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getSessionTimeout() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setSessionTimeout(int i) {
    }

    @Override
    public String getRequestCharacterEncoding() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setRequestCharacterEncoding(String s) {
    }

    @Override
    public String getResponseCharacterEncoding() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setResponseCharacterEncoding(String s) {
    }

    private void parseWebDotXml() {
        InputStream is = this.getResourceAsStream(WEB_XML);
        if (is == null) {
            return;
        }
        TreeNode web = null;
        try {
            web = new ParserUtils().parseXMLDocument(WEB_XML, is);
        }
        catch (WaspException ex) {
            this.log("Error in parsing web.xml", ex);
            return;
        }
        TreeNode jspConfig = web.findChild("jsp-config");
        if (jspConfig == null) {
            return;
        }
        ArrayList<TaglibDescriptor> taglibs = new ArrayList<TaglibDescriptor>();
        ArrayList<JspPropertyGroupDescriptor> jspPropertyGroups = new ArrayList<JspPropertyGroupDescriptor>();
        Iterator<TreeNode> children = jspConfig.findChildren("taglib");
        while (children.hasNext()) {
            TreeNode taglib = children.next();
            String tagUri = null;
            String tagLoc = null;
            TreeNode child = taglib.findChild("taglib-uri");
            if (child != null) {
                tagUri = child.getBody();
            }
            if ((child = taglib.findChild("taglib-location")) != null) {
                tagLoc = child.getBody();
            }
            if (tagUri == null || tagLoc == null) {
                return;
            }
            taglibs.add(new TaglibDescriptorImpl(tagUri, tagLoc));
        }
        children = jspConfig.findChildren("jsp-property-group");
        while (children.hasNext()) {
            ArrayList<String> urlPatterns = new ArrayList<String>();
            String pageEncoding = null;
            String scriptingInvalid = null;
            String elIgnored = null;
            String isXml = null;
            ArrayList<String> includePrelude = new ArrayList<String>();
            ArrayList<String> includeCoda = new ArrayList<String>();
            String trimSpaces = null;
            String poundAllowed = null;
            String buffer = null;
            String defaultContentType = null;
            String errorOnUndeclaredNamespace = null;
            TreeNode pgroup = children.next();
            Iterator<TreeNode> properties = pgroup.findChildren();
            while (properties.hasNext()) {
                TreeNode element = properties.next();
                String tname = element.getName();
                if ("url-pattern".equals(tname)) {
                    urlPatterns.add(element.getBody());
                    continue;
                }
                if ("page-encoding".equals(tname)) {
                    pageEncoding = element.getBody();
                    continue;
                }
                if ("is-xml".equals(tname)) {
                    isXml = element.getBody();
                    continue;
                }
                if ("el-ignored".equals(tname)) {
                    elIgnored = element.getBody();
                    continue;
                }
                if ("scripting-invalid".equals(tname)) {
                    scriptingInvalid = element.getBody();
                    continue;
                }
                if ("include-prelude".equals(tname)) {
                    includePrelude.add(element.getBody());
                    continue;
                }
                if ("include-coda".equals(tname)) {
                    includeCoda.add(element.getBody());
                    continue;
                }
                if ("trim-directive-whitespaces".equals(tname)) {
                    trimSpaces = element.getBody();
                    continue;
                }
                if ("deferred-syntax-allowed-as-literal".equals(tname)) {
                    poundAllowed = element.getBody();
                    continue;
                }
                if ("default-content-type".equals(tname)) {
                    defaultContentType = element.getBody();
                    continue;
                }
                if ("buffer".equals(tname)) {
                    buffer = element.getBody();
                    continue;
                }
                if (!"error-on-undeclared-namespace".equals(tname)) continue;
                errorOnUndeclaredNamespace = element.getBody();
            }
            jspPropertyGroups.add(new JspPropertyGroupDescriptorImpl(urlPatterns, isXml, elIgnored, scriptingInvalid, trimSpaces, poundAllowed, pageEncoding, includePrelude, includeCoda, defaultContentType, buffer, errorOnUndeclaredNamespace));
        }
        this.jspConfigDescriptor = new JspConfigDescriptorImpl(taglibs, jspPropertyGroups);
    }

    static class TaglibDescriptorImpl
    implements TaglibDescriptor {
        String uri;
        String loc;

        public TaglibDescriptorImpl(String uri, String loc) {
            this.uri = uri;
            this.loc = loc;
        }

        @Override
        public String getTaglibURI() {
            return this.uri;
        }

        @Override
        public String getTaglibLocation() {
            return this.loc;
        }
    }

    static class JspPropertyGroupDescriptorImpl
    implements JspPropertyGroupDescriptor {
        Collection<String> urlPatterns;
        String isXml;
        String elIgnored;
        String scriptingInvalid;
        String trimSpaces;
        String poundAllowed;
        String pageEncoding;
        Collection<String> includePrelude;
        Collection<String> includeCoda;
        String defaultContentType;
        String buffer;
        String errorOnUndeclaredNamespace;

        JspPropertyGroupDescriptorImpl(Collection<String> urlPatterns, String isXml, String elIgnored, String scriptingInvalid, String trimSpaces, String poundAllowed, String pageEncoding, Collection<String> includePrelude, Collection<String> includeCoda, String defaultContentType, String buffer, String errorOnUndeclaredNamespace) {
            this.urlPatterns = urlPatterns;
            this.isXml = isXml;
            this.elIgnored = elIgnored;
            this.scriptingInvalid = scriptingInvalid;
            this.trimSpaces = trimSpaces;
            this.poundAllowed = poundAllowed;
            this.pageEncoding = pageEncoding;
            this.includePrelude = includePrelude;
            this.includeCoda = includeCoda;
            this.defaultContentType = defaultContentType;
            this.buffer = buffer;
            this.errorOnUndeclaredNamespace = errorOnUndeclaredNamespace;
        }

        @Override
        public Collection<String> getUrlPatterns() {
            return this.urlPatterns;
        }

        @Override
        public String getElIgnored() {
            return this.elIgnored;
        }

        @Override
        public String getPageEncoding() {
            return this.pageEncoding;
        }

        @Override
        public String getScriptingInvalid() {
            return this.scriptingInvalid;
        }

        @Override
        public String getIsXml() {
            return this.isXml;
        }

        @Override
        public Collection<String> getIncludePreludes() {
            return this.includePrelude;
        }

        @Override
        public Collection<String> getIncludeCodas() {
            return this.includeCoda;
        }

        @Override
        public String getDeferredSyntaxAllowedAsLiteral() {
            return this.poundAllowed;
        }

        @Override
        public String getTrimDirectiveWhitespaces() {
            return this.trimSpaces;
        }

        @Override
        public String getDefaultContentType() {
            return this.defaultContentType;
        }

        @Override
        public String getBuffer() {
            return this.buffer;
        }

        @Override
        public String getErrorOnUndeclaredNamespace() {
            return this.errorOnUndeclaredNamespace;
        }

        @Override
        public String getErrorOnELNotFound() {
            return null;
        }
    }

    static class JspConfigDescriptorImpl
    implements JspConfigDescriptor {
        Collection<TaglibDescriptor> taglibs;
        Collection<JspPropertyGroupDescriptor> jspPropertyGroups;

        public JspConfigDescriptorImpl(Collection<TaglibDescriptor> taglibs, Collection<JspPropertyGroupDescriptor> jspPropertyGroups) {
            this.taglibs = taglibs;
            this.jspPropertyGroups = jspPropertyGroups;
        }

        @Override
        public Collection<TaglibDescriptor> getTaglibs() {
            return this.taglibs;
        }

        @Override
        public Collection<JspPropertyGroupDescriptor> getJspPropertyGroups() {
            return this.jspPropertyGroups;
        }
    }
}

