/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.wasp.runtime;

import jakarta.servlet.ServletContainerInitializer;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRegistration;
import jakarta.servlet.descriptor.JspConfigDescriptor;
import jakarta.servlet.descriptor.TaglibDescriptor;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.jsp.api.ResourceInjector;
import org.glassfish.wasp.WaspException;
import org.glassfish.wasp.compiler.Localizer;
import org.glassfish.wasp.runtime.Classpath;
import org.glassfish.wasp.xmlparser.ParserUtils;
import org.glassfish.wasp.xmlparser.TreeNode;

public class TldScanner
implements ServletContainerInitializer {
    private static Logger log = Logger.getLogger(TldScanner.class.getName());
    public static final int ABS_URI = 0;
    public static final int ROOT_REL_URI = 1;
    public static final int NOROOT_REL_URI = 2;
    private static final String FILE_PROTOCOL = "file:";
    private static final String JAR_FILE_SUFFIX = ".jar";
    private static Set<String> systemUris = new HashSet<String>();
    private static Set<String> systemUrisJsf = new HashSet<String>();
    private static Map<String, TldInfo[]> jarTldCache = new ConcurrentHashMap<String, TldInfo[]>();
    private static final String EAR_LIB_CLASSLOADER = "org.glassfish.javaee.full.deployment.EarLibClassLoader";
    private static final String IS_STANDALONE_ATTRIBUTE_NAME = "org.glassfish.jsp.isStandaloneWebapp";
    private Map<String, String[]> mappings;
    private Map<String, TldInfo[]> jarTldCacheLocal = new HashMap<String, TldInfo[]>();
    private ServletContext servletContext;
    private ResourceInjector resourceInjector;
    private boolean isValidationEnabled;
    private boolean useMyFaces;
    private boolean useMultiJarScanAlgo;
    private boolean scanListeners;
    private boolean doneScanning;
    private boolean blockExternal;
    private boolean noTagPrecreate;

    public TldScanner() {
    }

    public TldScanner(ServletContext servletContext, boolean isValidationEnabled) {
        this.servletContext = servletContext;
        this.isValidationEnabled = isValidationEnabled;
        this.useMyFaces = Boolean.TRUE.equals(servletContext.getAttribute("com.sun.faces.useMyFaces"));
        this.useMultiJarScanAlgo = Boolean.TRUE.equals(servletContext.getAttribute("org.glassfish.wasp.useMultiJarScanAlgo"));
        this.blockExternal = Boolean.parseBoolean(servletContext.getInitParameter("org.glassfish.wasp.XML_BLOCK_EXTERNAL"));
        this.noTagPrecreate = Boolean.parseBoolean(servletContext.getInitParameter("org.glassfish.wasp.NO_JSPTAG_PRECREATE"));
    }

    @Override
    public void onStartup(Set<Class<?>> c, ServletContext servletContext) throws ServletException {
        this.servletContext = servletContext;
        this.useMyFaces = Boolean.TRUE.equals(servletContext.getAttribute("com.sun.faces.useMyFaces"));
        this.useMultiJarScanAlgo = Boolean.TRUE.equals(servletContext.getAttribute("org.glassfish.wasp.useMultiJarScanAlgo"));
        this.noTagPrecreate = Boolean.parseBoolean(servletContext.getInitParameter("org.glassfish.wasp.NO_JSPTAG_PRECREATE"));
        ServletRegistration jspServletRegistration = servletContext.getServletRegistration("jsp");
        if (jspServletRegistration == null) {
            return;
        }
        this.resourceInjector = (ResourceInjector)servletContext.getAttribute("com.sun.appserv.jsp.resource.injector");
        String validating = jspServletRegistration.getInitParameter("validating");
        this.isValidationEnabled = "true".equals(validating);
        this.scanListeners = true;
        this.scanTlds();
        servletContext.setAttribute("com.sun.jsp.tldUriToLocationMap", this.mappings);
    }

    public String[] getLocation(String uri) throws WaspException {
        if (this.mappings == null) {
            this.mappings = (Map)this.servletContext.getAttribute("com.sun.jsp.tldUriToLocationMap");
        }
        if (this.mappings != null && this.mappings.get(uri) != null) {
            return this.mappings.get(uri);
        }
        if (!this.doneScanning) {
            this.scanListeners = false;
            this.scanTlds();
            this.doneScanning = true;
        }
        if (this.mappings == null) {
            return null;
        }
        return this.mappings.get(uri);
    }

    public static int uriType(String uri) {
        if (uri.indexOf(58) != -1) {
            return 0;
        }
        if (uri.startsWith("/")) {
            return 1;
        }
        return 2;
    }

    private void scanTlds() throws WaspException {
        this.mappings = new HashMap<String, String[]>();
        this.jarTldCacheLocal.putAll(jarTldCache);
        try {
            this.processWebDotXml();
            this.scanJars();
            this.processTldsInFileSystem("/WEB-INF/");
        }
        catch (WaspException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new WaspException(Localizer.getMessage("jsp.error.internal.tldinit"), ex);
        }
    }

    private void processWebDotXml() throws Exception {
        if (this.scanListeners) {
            return;
        }
        JspConfigDescriptor jspConfig = this.servletContext.getJspConfigDescriptor();
        if (jspConfig == null) {
            return;
        }
        for (TaglibDescriptor taglib : jspConfig.getTaglibs()) {
            if (taglib == null) continue;
            String taglibURI = taglib.getTaglibURI();
            Object taglibLocation = taglib.getTaglibLocation();
            if (taglibURI == null || taglibLocation == null || systemUris.contains(taglibURI) || !this.useMyFaces && systemUrisJsf.contains(taglibURI)) continue;
            if (TldScanner.uriType((String)taglibLocation) == 2) {
                taglibLocation = "/WEB-INF/" + (String)taglibLocation;
            }
            String tagLoc2 = null;
            if (((String)taglibLocation).endsWith(JAR_FILE_SUFFIX)) {
                taglibLocation = this.servletContext.getResource((String)taglibLocation).toString();
                tagLoc2 = "META-INF/taglib.tld";
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine("Add tld map from web.xml: " + taglibURI + "=>" + (String)taglibLocation + "," + tagLoc2);
            }
            this.mappings.put(taglibURI, new String[]{taglibLocation, tagLoc2});
        }
    }

    private void processTldsInFileSystem(String startPath) throws WaspException {
        Set<String> dirList = this.servletContext.getResourcePaths(startPath);
        if (dirList != null) {
            for (String path : dirList) {
                if (path.endsWith("/")) {
                    this.processTldsInFileSystem(path);
                }
                if (!path.endsWith(".tld")) continue;
                if (path.startsWith("/WEB-INF/tags/") && !path.endsWith("implicit.tld")) {
                    throw new WaspException(Localizer.getMessage("jsp.error.tldinit.tldInWebInfTags", path));
                }
                InputStream stream = this.servletContext.getResourceAsStream(path);
                TldInfo tldInfo = this.scanTld(path, null, stream);
                if (this.scanListeners) {
                    this.addListenerAndCreateTags(tldInfo, true);
                }
                this.mapTldLocation(path, tldInfo, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TldInfo scanTld(String resourcePath, String entryName, InputStream stream) throws WaspException {
        try {
            TreeNode tld = new ParserUtils(this.blockExternal).parseXMLDocument(resourcePath, stream, this.isValidationEnabled);
            String uri = null;
            TreeNode uriNode = tld.findChild("uri");
            if (uriNode != null) {
                uri = uriNode.getBody();
            }
            ArrayList<String> listeners = new ArrayList<String>();
            Iterator<TreeNode> listenerNodes = tld.findChildren("listener");
            while (listenerNodes.hasNext()) {
                String listenerClassName;
                TreeNode listener = listenerNodes.next();
                TreeNode listenerClass = listener.findChild("listener-class");
                if (listenerClass == null || (listenerClassName = listenerClass.getBody()) == null) continue;
                listeners.add(listenerClassName);
            }
            ArrayList<String> tagClasses = new ArrayList<String>();
            Iterator<TreeNode> tagClassesNodes = tld.findChildren("tag");
            while (tagClassesNodes.hasNext()) {
                String tagClassName;
                TreeNode tag = tagClassesNodes.next();
                TreeNode tagClass = tag.findChild("tag-class");
                if (tagClass == null || (tagClassName = tagClass.getBody()) == null) continue;
                tagClasses.add(tagClassName);
            }
            TldInfo tldInfo = new TldInfo(uri, entryName, listeners, tagClasses);
            return tldInfo;
        }
        finally {
            this.closeSilently(stream);
        }
    }

    private void scanJars() throws Exception {
        ClassLoader webappLoader;
        boolean isStandalone = Boolean.TRUE.equals(this.servletContext.getAttribute(IS_STANDALONE_ATTRIBUTE_NAME));
        if (this.useMultiJarScanAlgo) {
            for (URL url : Classpath.search("META-INF/", ".tld")) {
                this.scanJar(url, isStandalone);
            }
            return;
        }
        Map<URI, List<String>> tldMap = this.scanListeners ? this.getTldListenerMap() : this.getTldMap();
        for (ClassLoader loader = webappLoader = Thread.currentThread().getContextClassLoader(); loader != null; loader = loader.getParent()) {
            if (loader instanceof URLClassLoader) {
                URLClassLoader urlClassLoader = (URLClassLoader)loader;
                boolean isLocal = loader == webappLoader;
                ArrayList<String> manifestClassPathJars = new ArrayList<String>();
                for (URL url : urlClassLoader.getURLs()) {
                    JarURLConnection jarURLConnection = this.getJarURLConnection(url);
                    if (jarURLConnection == null) continue;
                    jarURLConnection.setUseCaches(false);
                    if (isLocal) {
                        this.addManifestClassPath(null, manifestClassPathJars, jarURLConnection);
                    }
                    this.scanJar(jarURLConnection, null, isLocal);
                }
                if (!manifestClassPathJars.isEmpty()) {
                    ArrayList<String> newJars;
                    do {
                        newJars = new ArrayList<String>();
                        for (String manifestClassPathJar : manifestClassPathJars) {
                            JarURLConnection jarURLConnection = (JarURLConnection)new URL("jar:" + manifestClassPathJar + "!/").openConnection();
                            jarURLConnection.setUseCaches(false);
                            if (!this.addManifestClassPath(manifestClassPathJars, newJars, jarURLConnection)) continue;
                            this.scanJar(jarURLConnection, null, true);
                        }
                        manifestClassPathJars.addAll(newJars);
                    } while (newJars.size() != 0);
                }
            }
            if (tldMap != null && (isStandalone || EAR_LIB_CLASSLOADER.equals(loader.getClass().getName()))) break;
        }
        if (tldMap != null) {
            for (URI uri : tldMap.keySet()) {
                this.scanJar((JarURLConnection)new URL("jar:" + uri.toString() + "!/").openConnection(), tldMap.get(uri), false);
            }
        }
    }

    private void scanJar(URL url, boolean isLocal) throws WaspException {
        String resourcePath = url.toString();
        TldInfo[] tldInfos = this.jarTldCacheLocal.get(resourcePath);
        if (tldInfos != null && tldInfos.length == 0) {
            return;
        }
        if (tldInfos == null) {
            ArrayList<TldInfo> tldInfoA = new ArrayList<TldInfo>();
            try {
                tldInfoA.add(this.scanTld(resourcePath, url.getFile(), url.openStream()));
            }
            catch (IOException ex) {
                this.logOrThrow(resourcePath, ex);
            }
            tldInfos = tldInfoA.toArray(new TldInfo[tldInfoA.size()]);
            this.updateTldCache(resourcePath, tldInfos, isLocal);
        }
        for (TldInfo tldInfo : tldInfos) {
            if (this.scanListeners) {
                this.addListenerAndCreateTags(tldInfo, isLocal);
            }
            this.mapTldLocation(resourcePath, tldInfo, isLocal);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scanJar(JarURLConnection jarURLConnection, List<String> tldNames, boolean isLocal) throws WaspException {
        String resourcePath = jarURLConnection.getJarFileURL().toString();
        TldInfo[] tldInfos = this.jarTldCacheLocal.get(resourcePath);
        if (tldInfos != null && tldInfos.length == 0) {
            this.closeSilently(jarURLConnection);
            return;
        }
        if (tldInfos == null) {
            JarFile jarFile = null;
            ArrayList<TldInfo> tldInfoA = new ArrayList<TldInfo>();
            try {
                jarFile = jarURLConnection.getJarFile();
                for (String tldFileName : this.getTLDFileNames(jarFile, tldNames)) {
                    tldInfoA.add(this.scanTld(resourcePath, tldFileName, jarFile.getInputStream(jarFile.getJarEntry(tldFileName))));
                }
            }
            catch (IOException ex) {
                this.logOrThrow(resourcePath, ex);
            }
            finally {
                this.closeSilently(jarFile);
            }
            tldInfos = tldInfoA.toArray(new TldInfo[tldInfoA.size()]);
            this.updateTldCache(resourcePath, tldInfos, isLocal);
        }
        for (TldInfo tldInfo : tldInfos) {
            if (this.scanListeners) {
                this.addListenerAndCreateTags(tldInfo, isLocal);
            }
            this.mapTldLocation(resourcePath, tldInfo, isLocal);
        }
    }

    private List<String> getTLDFileNames(JarFile jarFile, List<String> tldNames) {
        if (tldNames != null) {
            return tldNames;
        }
        ArrayList<String> collectedTldNames = new ArrayList<String>();
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            String name = entries.nextElement().getName();
            if (!name.startsWith("META-INF/") || !name.endsWith(".tld")) continue;
            collectedTldNames.add(name);
        }
        return collectedTldNames;
    }

    private void logOrThrow(String resourcePath, IOException ex) throws WaspException {
        if (!resourcePath.startsWith(FILE_PROTOCOL) || new File(resourcePath).exists()) {
            throw new WaspException(Localizer.getMessage("jsp.error.jar.io", resourcePath), ex);
        }
        log.log(Level.WARNING, ex, () -> Localizer.getMessage("jsp.warn.nojar", resourcePath));
    }

    private void updateTldCache(String resourcePath, TldInfo[] tldInfos, boolean isLocal) {
        this.jarTldCacheLocal.put(resourcePath, tldInfos);
        if (!isLocal) {
            jarTldCache.put(resourcePath, tldInfos);
        }
    }

    Map<URI, List<String>> getTldMap() {
        return (Map)this.servletContext.getAttribute("com.sun.appserv.tld.map");
    }

    Map<URI, List<String>> getTldListenerMap() {
        return (Map)this.servletContext.getAttribute("com.sun.appserv.tldlistener.map");
    }

    private void addListenerAndCreateTags(TldInfo tldInfo, boolean isLocal) {
        String uri = tldInfo.getUri();
        if (!systemUrisJsf.contains(uri) || isLocal && this.useMyFaces || !isLocal && !this.useMyFaces) {
            for (String listenerClassName : tldInfo.getListeners()) {
                log.log(Level.FINE, () -> "Add tld listener " + listenerClassName);
                this.servletContext.addListener(listenerClassName);
            }
            if (this.resourceInjector != null && !this.noTagPrecreate) {
                for (String tagClassName : tldInfo.tagClasses) {
                    try {
                        Class<?> tagClass = this.getClassLoader().loadClass(tagClassName);
                        Object tag = this.resourceInjector.createTagHandlerInstance(tagClass);
                        log.log(Level.FINE, () -> "Created tag " + tag);
                    }
                    catch (Exception e) {
                        log.log(Level.SEVERE, "Error creating " + tagClassName, e);
                    }
                }
            }
        }
    }

    private ClassLoader getClassLoader() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = this.getClass().getClassLoader();
        }
        return classLoader;
    }

    private void mapTldLocation(String resourcePath, TldInfo tldInfo, boolean isLocal) {
        String uri = tldInfo.getUri();
        if (uri == null) {
            return;
        }
        if (isLocal && this.mappings.get(uri) == null && !systemUris.contains(uri) && (!systemUrisJsf.contains(uri) || this.useMyFaces) || !isLocal && (this.mappings.get(uri) == null || systemUris.contains(uri) || systemUrisJsf.contains(uri) && !this.useMyFaces)) {
            String entryName = tldInfo.getEntryName();
            if (log.isLoggable(Level.FINE)) {
                log.fine("Add tld map from tld in " + (isLocal ? "WEB-INF" : "jar: ") + uri + "=>" + resourcePath + "," + entryName);
            }
            this.mappings.put(uri, new String[]{resourcePath, entryName});
        }
    }

    private JarURLConnection getJarURLConnection(URL url) throws IOException {
        URLConnection urlConnection = url.openConnection();
        if (urlConnection instanceof JarURLConnection) {
            return (JarURLConnection)urlConnection;
        }
        String urlStr = url.toString();
        if (urlStr.startsWith(FILE_PROTOCOL) && urlStr.endsWith(JAR_FILE_SUFFIX)) {
            return (JarURLConnection)new URL("jar:" + urlStr + "!/").openConnection();
        }
        return null;
    }

    private boolean addManifestClassPath(List<String> scannedJars, List<String> newJars, JarURLConnection jarURLConnection) {
        Manifest manifest;
        try {
            manifest = jarURLConnection.getManifest();
        }
        catch (IOException ex) {
            return false;
        }
        String file = jarURLConnection.getJarFileURL().toString();
        if (!file.contains("WEB-INF")) {
            return true;
        }
        if (manifest == null) {
            return true;
        }
        Attributes attributes = manifest.getMainAttributes();
        String classPath = attributes.getValue("Class-Path");
        if (classPath == null) {
            return true;
        }
        String[] paths = classPath.split(" ");
        int lastIndex = file.lastIndexOf(47);
        if (lastIndex < 0) {
            lastIndex = file.lastIndexOf(92);
        }
        String baseDir = "";
        if (lastIndex > 0) {
            baseDir = file.substring(0, lastIndex + 1);
        }
        for (String path : paths) {
            String p = path.startsWith("/") || path.startsWith("\\") ? FILE_PROTOCOL + path : baseDir + path;
            if (scannedJars != null && scannedJars.contains(p) || newJars.contains(p)) continue;
            newJars.add(p);
        }
        return true;
    }

    private void closeSilently(JarURLConnection jarURLConnection) {
        try {
            jarURLConnection.getJarFile().close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void closeSilently(JarFile jarFile) {
        if (jarFile != null) {
            try {
                jarFile.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private void closeSilently(InputStream stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    static {
        systemUrisJsf.add("http://java.sun.com/jsf/core");
        systemUrisJsf.add("http://java.sun.com/jsf/html");
        systemUris.add("http://java.sun.com/jsp/jstl/core");
    }

    static class TldInfo {
        private final String entryName;
        private final String uri;
        private final List<String> listeners;
        private final List<String> tagClasses;

        public TldInfo(String uri, String entryName, List<String> listeners, List<String> tagClasses) {
            this.uri = uri;
            this.entryName = entryName;
            this.listeners = listeners;
            this.tagClasses = tagClasses;
        }

        public String getEntryName() {
            return this.entryName;
        }

        public String getUri() {
            return this.uri;
        }

        public List<String> getListeners() {
            return this.listeners;
        }

        public List<String> getTagClasses() {
            return this.tagClasses;
        }
    }
}

