/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.wasp.runtime;

import jakarta.servlet.ServletConfig;
import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.tagext.JspTag;
import jakarta.servlet.jsp.tagext.Tag;
import org.glassfish.jsp.api.ResourceInjector;

public class TagHandlerPool {
    public static final String OPTION_TAGPOOL = "tagpoolClassName";
    public static final String OPTION_MAXSIZE = "tagpoolMaxSize";
    private JspTag[] handlers;
    private ResourceInjector resourceInjector;
    private int current;

    public static TagHandlerPool getTagHandlerPool(ServletConfig config) {
        TagHandlerPool result = null;
        String tpClassName = TagHandlerPool.getOption(config, OPTION_TAGPOOL, null);
        if (tpClassName != null) {
            try {
                result = Class.forName(tpClassName).asSubclass(TagHandlerPool.class).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
                result = null;
            }
        }
        if (result == null) {
            result = new TagHandlerPool();
        }
        result.init(config);
        return result;
    }

    protected void init(ServletConfig config) {
        int maxSize = -1;
        String maxSizeS = TagHandlerPool.getOption(config, OPTION_MAXSIZE, null);
        if (maxSizeS != null) {
            try {
                maxSize = Integer.parseInt(maxSizeS);
            }
            catch (Exception ex) {
                maxSize = -1;
            }
        }
        if (maxSize < 0) {
            maxSize = 5;
        }
        this.handlers = new JspTag[maxSize];
        this.current = -1;
        this.resourceInjector = (ResourceInjector)config.getServletContext().getAttribute("com.sun.appserv.jsp.resource.injector");
    }

    public TagHandlerPool() {
    }

    @Deprecated
    public TagHandlerPool(int capacity) {
        this.handlers = new JspTag[capacity];
        this.current = -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends JspTag> JspTag get(Class<T> handlerClass) throws JspException {
        TagHandlerPool tagHandlerPool = this;
        synchronized (tagHandlerPool) {
            if (this.current >= 0) {
                return this.handlers[this.current--];
            }
        }
        JspTag tagHandler = null;
        try {
            tagHandler = this.resourceInjector != null ? (JspTag)this.resourceInjector.createTagHandlerInstance(handlerClass) : (JspTag)handlerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new JspException(e.getMessage(), e);
        }
        return tagHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reuse(JspTag handler) {
        TagHandlerPool tagHandlerPool = this;
        synchronized (tagHandlerPool) {
            if (this.current < this.handlers.length - 1) {
                this.handlers[++this.current] = handler;
                return;
            }
        }
        if (handler instanceof Tag) {
            ((Tag)handler).release();
        }
        if (this.resourceInjector != null) {
            this.resourceInjector.preDestroy(handler);
        }
    }

    public synchronized void release() {
        for (int i = this.current; i >= 0; --i) {
            if (this.handlers[i] instanceof Tag) {
                ((Tag)this.handlers[i]).release();
            }
            if (this.resourceInjector == null) continue;
            this.resourceInjector.preDestroy(this.handlers[i]);
        }
    }

    protected static String getOption(ServletConfig config, String name, String defaultV) {
        if (config == null) {
            return defaultV;
        }
        String value = config.getInitParameter(name);
        if (value != null) {
            return value;
        }
        if (config.getServletContext() == null) {
            return defaultV;
        }
        value = config.getServletContext().getInitParameter(name);
        if (value != null) {
            return value;
        }
        return defaultV;
    }
}

