/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.wasp.compiler;

import jakarta.el.FunctionMapper;
import jakarta.servlet.jsp.tagext.FunctionInfo;
import jakarta.servlet.jsp.tagext.PageData;
import jakarta.servlet.jsp.tagext.TagAttributeInfo;
import jakarta.servlet.jsp.tagext.TagData;
import jakarta.servlet.jsp.tagext.TagExtraInfo;
import jakarta.servlet.jsp.tagext.TagInfo;
import jakarta.servlet.jsp.tagext.TagLibraryInfo;
import jakarta.servlet.jsp.tagext.ValidationMessage;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import org.glassfish.wasp.JspCompilationContext;
import org.glassfish.wasp.WaspException;
import org.glassfish.wasp.compiler.BeanRepository;
import org.glassfish.wasp.compiler.Compiler;
import org.glassfish.wasp.compiler.ELNode;
import org.glassfish.wasp.compiler.ELParser;
import org.glassfish.wasp.compiler.ErrorDispatcher;
import org.glassfish.wasp.compiler.JspConfig;
import org.glassfish.wasp.compiler.JspProperty;
import org.glassfish.wasp.compiler.JspUtil;
import org.glassfish.wasp.compiler.Localizer;
import org.glassfish.wasp.compiler.Node;
import org.glassfish.wasp.compiler.PageDataImpl;
import org.glassfish.wasp.compiler.PageInfo;
import org.glassfish.wasp.compiler.TagLibraryInfoImpl;
import org.glassfish.wasp.runtime.JspRuntimeLibrary;
import org.xml.sax.Attributes;

class Validator {
    Validator() {
    }

    public static void validate(Compiler compiler, Node.Nodes page) throws WaspException {
        String contentType;
        page.visit(new DirectiveVisitor(compiler));
        PageInfo pageInfo = compiler.getPageInfo();
        JspCompilationContext ctxt = compiler.getCompilationContext();
        JspConfig jspConfig = ctxt.getOptions().getJspConfig();
        JspProperty jspProperty = jspConfig.findJspProperty(ctxt.getJspFile());
        if (pageInfo.getBufferValue() == null && jspProperty.getBuffer() != null) {
            pageInfo.setBufferValue(jspProperty.getBuffer(), null, compiler.getErrorDispatcher());
        }
        if ((contentType = pageInfo.getContentType()) == null) {
            contentType = jspProperty.getDefaultContentType();
        }
        if (contentType == null || contentType.indexOf("charset=") < 0) {
            boolean isXml = page.getRoot().isXmlSyntax();
            String defaultType = contentType == null ? (isXml ? "text/xml" : "text/html") : contentType;
            String charset = null;
            if (isXml) {
                charset = "UTF-8";
            } else if (!page.getRoot().isDefaultPageEncoding()) {
                charset = page.getRoot().getPageEncoding();
            }
            if (charset != null) {
                pageInfo.setContentType(defaultType + ";charset=" + charset);
            } else {
                pageInfo.setContentType(defaultType);
            }
        }
        page.visit(new ValidateVisitor(compiler));
        Validator.validateXmlView(new PageDataImpl(page, compiler), compiler);
        page.visit(new TagExtraInfoVisitor(compiler));
    }

    private static void validateXmlView(PageData xmlView, Compiler compiler) throws WaspException {
        StringBuilder errMsg = null;
        ErrorDispatcher errDisp = compiler.getErrorDispatcher();
        for (TagLibraryInfo o : compiler.getPageInfo().getTaglibs()) {
            TagLibraryInfoImpl tli;
            ValidationMessage[] errors;
            if (!(o instanceof TagLibraryInfoImpl) || (errors = (tli = (TagLibraryInfoImpl)o).validate(xmlView)) == null || errors.length == 0) continue;
            if (errMsg == null) {
                errMsg = new StringBuilder();
            }
            errMsg.append("<h3>");
            errMsg.append(Localizer.getMessage("jsp.error.tlv.invalid.page", tli.getShortName()));
            errMsg.append("</h3>");
            for (int i = 0; i < errors.length; ++i) {
                if (errors[i] == null) continue;
                errMsg.append("<p>");
                errMsg.append(errors[i].getId());
                errMsg.append(": ");
                errMsg.append(errors[i].getMessage());
                errMsg.append("</p>");
            }
        }
        if (errMsg != null) {
            errDisp.jspError(errMsg.toString());
        }
    }

    static class DirectiveVisitor
    extends Node.Visitor {
        private PageInfo pageInfo;
        private ErrorDispatcher err;
        private static final JspUtil.ValidAttribute[] pageDirectiveAttrs = new JspUtil.ValidAttribute[]{new JspUtil.ValidAttribute("language"), new JspUtil.ValidAttribute("extends"), new JspUtil.ValidAttribute("import"), new JspUtil.ValidAttribute("session"), new JspUtil.ValidAttribute("buffer"), new JspUtil.ValidAttribute("autoFlush"), new JspUtil.ValidAttribute("isThreadSafe"), new JspUtil.ValidAttribute("info"), new JspUtil.ValidAttribute("errorPage"), new JspUtil.ValidAttribute("isErrorPage"), new JspUtil.ValidAttribute("contentType"), new JspUtil.ValidAttribute("pageEncoding"), new JspUtil.ValidAttribute("isELIgnored"), new JspUtil.ValidAttribute("deferredSyntaxAllowedAsLiteral"), new JspUtil.ValidAttribute("trimDirectiveWhitespaces"), new JspUtil.ValidAttribute("errorOnELNotFound")};
        private boolean pageEncodingSeen = false;

        DirectiveVisitor(Compiler compiler) throws WaspException {
            this.pageInfo = compiler.getPageInfo();
            this.err = compiler.getErrorDispatcher();
        }

        @Override
        public void visit(Node.IncludeDirective n) throws WaspException {
            boolean pageEncodingSeenSave = this.pageEncodingSeen;
            this.pageEncodingSeen = false;
            this.visitBody(n);
            this.pageEncodingSeen = pageEncodingSeenSave;
        }

        @Override
        public void visit(Node.PageDirective n) throws WaspException {
            JspUtil.checkAttributes("Page directive", n, pageDirectiveAttrs, this.err);
            Attributes attrs = n.getAttributes();
            for (int i = 0; attrs != null && i < attrs.getLength(); ++i) {
                String attr = attrs.getQName(i);
                String value = attrs.getValue(i);
                if ("language".equals(attr)) {
                    if (this.pageInfo.getLanguage(false) == null) {
                        this.pageInfo.setLanguage(value, n, this.err, true);
                        continue;
                    }
                    if (this.pageInfo.getLanguage(false).equals(value)) continue;
                    this.err.jspError((Node)n, "jsp.error.page.conflict.language", this.pageInfo.getLanguage(false), value);
                    continue;
                }
                if ("extends".equals(attr)) {
                    if (this.pageInfo.getExtends(false) == null) {
                        this.pageInfo.setExtends(value, n);
                        continue;
                    }
                    if (this.pageInfo.getExtends(false).equals(value)) continue;
                    this.err.jspError((Node)n, "jsp.error.page.conflict.extends", this.pageInfo.getExtends(false), value);
                    continue;
                }
                if ("contentType".equals(attr)) {
                    if (this.pageInfo.getContentType() == null) {
                        this.pageInfo.setContentType(value);
                        continue;
                    }
                    if (this.pageInfo.getContentType().equals(value)) continue;
                    this.err.jspError((Node)n, "jsp.error.page.conflict.contenttype", this.pageInfo.getContentType(), value);
                    continue;
                }
                if ("session".equals(attr)) {
                    if (this.pageInfo.getSession() == null) {
                        this.pageInfo.setSession(value, n, this.err);
                        continue;
                    }
                    if (this.pageInfo.getSession().equals(value)) continue;
                    this.err.jspError((Node)n, "jsp.error.page.conflict.session", this.pageInfo.getSession(), value);
                    continue;
                }
                if ("buffer".equals(attr)) {
                    if (this.pageInfo.getBufferValue() == null) {
                        this.pageInfo.setBufferValue(value, n, this.err);
                        continue;
                    }
                    if (this.pageInfo.getBufferValue().equals(value)) continue;
                    this.err.jspError((Node)n, "jsp.error.page.conflict.buffer", this.pageInfo.getBufferValue(), value);
                    continue;
                }
                if ("autoFlush".equals(attr)) {
                    if (this.pageInfo.getAutoFlush() == null) {
                        this.pageInfo.setAutoFlush(value, n, this.err);
                        continue;
                    }
                    if (this.pageInfo.getAutoFlush().equals(value)) continue;
                    this.err.jspError((Node)n, "jsp.error.page.conflict.autoflush", this.pageInfo.getAutoFlush(), value);
                    continue;
                }
                if ("isThreadSafe".equals(attr)) {
                    if (this.pageInfo.getIsThreadSafe() == null) {
                        this.pageInfo.setIsThreadSafe(value, n, this.err);
                        continue;
                    }
                    if (this.pageInfo.getIsThreadSafe().equals(value)) continue;
                    this.err.jspError((Node)n, "jsp.error.page.conflict.isthreadsafe", this.pageInfo.getIsThreadSafe(), value);
                    continue;
                }
                if ("isELIgnored".equals(attr)) {
                    if (this.pageInfo.getIsELIgnored() == null) {
                        this.pageInfo.setIsELIgnored(value, n, this.err, true);
                        continue;
                    }
                    if (this.pageInfo.getIsELIgnored().equals(value)) continue;
                    this.err.jspError((Node)n, "jsp.error.page.conflict.iselignored", this.pageInfo.getIsELIgnored(), value);
                    continue;
                }
                if ("isErrorPage".equals(attr)) {
                    if (this.pageInfo.getIsErrorPage() == null) {
                        this.pageInfo.setIsErrorPage(value, n, this.err);
                        continue;
                    }
                    if (this.pageInfo.getIsErrorPage().equals(value)) continue;
                    this.err.jspError((Node)n, "jsp.error.page.conflict.iserrorpage", this.pageInfo.getIsErrorPage(), value);
                    continue;
                }
                if ("errorPage".equals(attr)) {
                    if (this.pageInfo.getErrorPage() == null) {
                        this.pageInfo.setErrorPage(value);
                        continue;
                    }
                    if (this.pageInfo.getErrorPage().equals(value)) continue;
                    this.err.jspError((Node)n, "jsp.error.page.conflict.errorpage", this.pageInfo.getErrorPage(), value);
                    continue;
                }
                if ("info".equals(attr)) {
                    if (this.pageInfo.getInfo() == null) {
                        this.pageInfo.setInfo(value);
                        continue;
                    }
                    if (this.pageInfo.getInfo().equals(value)) continue;
                    this.err.jspError((Node)n, "jsp.error.page.conflict.info", this.pageInfo.getInfo(), value);
                    continue;
                }
                if ("pageEncoding".equals(attr)) {
                    if (this.pageEncodingSeen) {
                        this.err.jspError(n, "jsp.error.page.multi.pageencoding");
                    }
                    this.pageEncodingSeen = true;
                    this.comparePageEncodings(value, n);
                    continue;
                }
                if ("deferredSyntaxAllowedAsLiteral".equals(attr)) {
                    if (this.pageInfo.getDeferredSyntaxAllowedAsLiteral() == null) {
                        this.pageInfo.setDeferredSyntaxAllowedAsLiteral(value, n, this.err, true);
                        continue;
                    }
                    if (this.pageInfo.getDeferredSyntaxAllowedAsLiteral().equals(value)) continue;
                    this.err.jspError((Node)n, "jsp.error.page.conflict.deferred", this.pageInfo.getDeferredSyntaxAllowedAsLiteral(), value);
                    continue;
                }
                if ("trimDirectiveWhitespaces".equals(attr)) {
                    if (this.pageInfo.getTrimDirectiveWhitespaces() == null) {
                        this.pageInfo.setTrimDirectiveWhitespaces(value, n, this.err, true);
                        continue;
                    }
                    if (this.pageInfo.getTrimDirectiveWhitespaces().equals(value)) continue;
                    this.err.jspError((Node)n, "jsp.error.page.conflict.trim", this.pageInfo.getTrimDirectiveWhitespaces(), value);
                    continue;
                }
                if (!"errorOnELNotFound".equals(attr)) continue;
                if (this.pageInfo.getErrorOnELNotFound() == null) {
                    this.pageInfo.setErrorOnELNotFound(value, n, this.err, true);
                    continue;
                }
                if (this.pageInfo.getErrorOnELNotFound().equals(value)) continue;
                this.err.jspError((Node)n, "jsp.error.page.conflict.errorOnELNotFound", this.pageInfo.getErrorOnELNotFound(), value);
            }
            if (this.pageInfo.getBuffer() == 0 && !this.pageInfo.isAutoFlush()) {
                this.err.jspError(n, "jsp.error.page.badCombo");
            }
            if (this.pageInfo.isErrorPage() && this.pageInfo.getErrorPage() != null) {
                String rootPath = this.pageInfo.getRootPath();
                Object errorPath = this.pageInfo.getErrorPage();
                if (!((String)errorPath).startsWith("/")) {
                    String baseRootPath = rootPath.substring(0, rootPath.lastIndexOf(47));
                    errorPath = baseRootPath + "/" + (String)errorPath;
                }
                if (rootPath.equals(errorPath)) {
                    this.err.jspError((Node)n, "jsp.error.page.selfreferencing", rootPath);
                }
            }
            this.pageInfo.addImports(n.getImports());
        }

        @Override
        public void visit(Node.TagDirective n) throws WaspException {
            Attributes attrs = n.getAttributes();
            for (int i = 0; attrs != null && i < attrs.getLength(); ++i) {
                String attr = attrs.getQName(i);
                String value = attrs.getValue(i);
                if ("language".equals(attr)) {
                    if (this.pageInfo.getLanguage(false) == null) {
                        this.pageInfo.setLanguage(value, n, this.err, false);
                        continue;
                    }
                    if (this.pageInfo.getLanguage(false).equals(value)) continue;
                    this.err.jspError((Node)n, "jsp.error.tag.conflict.language", this.pageInfo.getLanguage(false), value);
                    continue;
                }
                if ("isELIgnored".equals(attr)) {
                    if (this.pageInfo.getIsELIgnored() == null) {
                        this.pageInfo.setIsELIgnored(value, n, this.err, false);
                        continue;
                    }
                    if (this.pageInfo.getIsELIgnored().equals(value)) continue;
                    this.err.jspError((Node)n, "jsp.error.tag.conflict.iselignored", this.pageInfo.getIsELIgnored(), value);
                    continue;
                }
                if ("pageEncoding".equals(attr)) {
                    if (this.pageEncodingSeen) {
                        this.err.jspError(n, "jsp.error.tag.multi.pageencoding");
                    }
                    this.pageEncodingSeen = true;
                    if (n.getRoot().hasBom()) {
                        String bom = n.getRoot().getPageEncoding();
                        if (!(value == null || value.equalsIgnoreCase(bom) || value.toLowerCase().startsWith("utf-16") && bom.toLowerCase().startsWith("utf-16"))) {
                            this.err.jspError((Node)n, "jsp.error.bom_tagdir_encoding_mismatch", bom, value);
                        }
                    }
                    n.getRoot().setPageEncoding(value);
                    continue;
                }
                if ("deferredSyntaxAllowedAsLiteral".equals(attr)) {
                    if (this.pageInfo.getDeferredSyntaxAllowedAsLiteral() == null) {
                        this.pageInfo.setDeferredSyntaxAllowedAsLiteral(value, n, this.err, false);
                        continue;
                    }
                    if (this.pageInfo.getDeferredSyntaxAllowedAsLiteral().equals(value)) continue;
                    this.err.jspError((Node)n, "jsp.error.tag.conflict.deferred", this.pageInfo.getDeferredSyntaxAllowedAsLiteral(), value);
                    continue;
                }
                if ("trimDirectiveWhitespaces".equals(attr)) {
                    if (this.pageInfo.getTrimDirectiveWhitespaces() == null) {
                        this.pageInfo.setTrimDirectiveWhitespaces(value, n, this.err, false);
                        continue;
                    }
                    if (this.pageInfo.getTrimDirectiveWhitespaces().equals(value)) continue;
                    this.err.jspError((Node)n, "jsp.error.tag.conflict.trim", this.pageInfo.getTrimDirectiveWhitespaces(), value);
                    continue;
                }
                if (!"errorOnELNotFound".equals(attr)) continue;
                if (this.pageInfo.getErrorOnELNotFound() == null) {
                    this.pageInfo.setErrorOnELNotFound(value, n, this.err, false);
                    continue;
                }
                if (this.pageInfo.getErrorOnELNotFound().equals(value)) continue;
                this.err.jspError((Node)n, "jsp.error.tag.conflict.errorOnELNotFound", this.pageInfo.getErrorOnELNotFound(), value);
            }
            this.pageInfo.addImports(n.getImports());
        }

        @Override
        public void visit(Node.AttributeDirective n) throws WaspException {
        }

        @Override
        public void visit(Node.VariableDirective n) throws WaspException {
        }

        private void comparePageEncodings(String pageDirEnc, Node.PageDirective pageDir) throws WaspException {
            String pageEnc;
            Node.Root root = pageDir.getRoot();
            String configEnc = root.getJspConfigPageEncoding();
            if (!(configEnc == null || pageDirEnc.equalsIgnoreCase(configEnc) || pageDirEnc.toLowerCase().startsWith("utf-16") && configEnc.toLowerCase().startsWith("utf-16"))) {
                this.err.jspError((Node)pageDir, "jsp.error.config_pagedir_encoding_mismatch", configEnc, pageDirEnc);
            }
            if (!(!root.isXmlSyntax() || !root.isEncodingSpecifiedInProlog() || pageDirEnc.equalsIgnoreCase(pageEnc = root.getPageEncoding()) || pageDirEnc.toLowerCase().startsWith("utf-16") && pageEnc.toLowerCase().startsWith("utf-16"))) {
                this.err.jspError((Node)pageDir, "jsp.error.prolog_pagedir_encoding_mismatch", pageEnc, pageDirEnc);
            }
            if (!(!root.hasBom() || pageDirEnc.equalsIgnoreCase(pageEnc = root.getPageEncoding()) || pageDirEnc.toLowerCase().startsWith("utf-16") && pageEnc.toLowerCase().startsWith("utf-16"))) {
                this.err.jspError((Node)pageDir, "jsp.error.bom_pagedir_encoding_mismatch", pageEnc, pageDirEnc);
            }
        }
    }

    static class ValidateVisitor
    extends Node.Visitor {
        private PageInfo pageInfo;
        private ErrorDispatcher err;
        private ClassLoader loader;
        private JspCompilationContext ctxt;
        private static final JspUtil.ValidAttribute[] jspRootAttrs = new JspUtil.ValidAttribute[]{new JspUtil.ValidAttribute("xsi:schemaLocation"), new JspUtil.ValidAttribute("version", true)};
        private static final JspUtil.ValidAttribute[] includeDirectiveAttrs = new JspUtil.ValidAttribute[]{new JspUtil.ValidAttribute("file", true)};
        private static final JspUtil.ValidAttribute[] taglibDirectiveAttrs = new JspUtil.ValidAttribute[]{new JspUtil.ValidAttribute("uri"), new JspUtil.ValidAttribute("tagdir"), new JspUtil.ValidAttribute("prefix", true)};
        private static final JspUtil.ValidAttribute[] includeActionAttrs = new JspUtil.ValidAttribute[]{new JspUtil.ValidAttribute("page", true), new JspUtil.ValidAttribute("flush")};
        private static final JspUtil.ValidAttribute[] paramActionAttrs = new JspUtil.ValidAttribute[]{new JspUtil.ValidAttribute("name", true), new JspUtil.ValidAttribute("value", true)};
        private static final JspUtil.ValidAttribute[] forwardActionAttrs = new JspUtil.ValidAttribute[]{new JspUtil.ValidAttribute("page", true)};
        private static final JspUtil.ValidAttribute[] getPropertyAttrs = new JspUtil.ValidAttribute[]{new JspUtil.ValidAttribute("name", true), new JspUtil.ValidAttribute("property", true)};
        private static final JspUtil.ValidAttribute[] setPropertyAttrs = new JspUtil.ValidAttribute[]{new JspUtil.ValidAttribute("name", true), new JspUtil.ValidAttribute("property", true), new JspUtil.ValidAttribute("value", false), new JspUtil.ValidAttribute("param")};
        private static final JspUtil.ValidAttribute[] useBeanAttrs = new JspUtil.ValidAttribute[]{new JspUtil.ValidAttribute("id", true), new JspUtil.ValidAttribute("scope"), new JspUtil.ValidAttribute("class"), new JspUtil.ValidAttribute("type"), new JspUtil.ValidAttribute("beanName", false)};
        private static final JspUtil.ValidAttribute[] plugInAttrs = new JspUtil.ValidAttribute[]{new JspUtil.ValidAttribute("type", true), new JspUtil.ValidAttribute("code", true), new JspUtil.ValidAttribute("codebase"), new JspUtil.ValidAttribute("align"), new JspUtil.ValidAttribute("archive"), new JspUtil.ValidAttribute("height", false), new JspUtil.ValidAttribute("hspace"), new JspUtil.ValidAttribute("jreversion"), new JspUtil.ValidAttribute("name"), new JspUtil.ValidAttribute("vspace"), new JspUtil.ValidAttribute("width", false), new JspUtil.ValidAttribute("nspluginurl"), new JspUtil.ValidAttribute("iepluginurl")};
        private static final JspUtil.ValidAttribute[] attributeAttrs = new JspUtil.ValidAttribute[]{new JspUtil.ValidAttribute("name", true), new JspUtil.ValidAttribute("trim"), new JspUtil.ValidAttribute("omit")};
        private static final JspUtil.ValidAttribute[] invokeAttrs = new JspUtil.ValidAttribute[]{new JspUtil.ValidAttribute("fragment", true), new JspUtil.ValidAttribute("var"), new JspUtil.ValidAttribute("varReader"), new JspUtil.ValidAttribute("scope")};
        private static final JspUtil.ValidAttribute[] doBodyAttrs = new JspUtil.ValidAttribute[]{new JspUtil.ValidAttribute("var"), new JspUtil.ValidAttribute("varReader"), new JspUtil.ValidAttribute("scope")};
        private static final JspUtil.ValidAttribute[] jspOutputAttrs = new JspUtil.ValidAttribute[]{new JspUtil.ValidAttribute("omit-xml-declaration"), new JspUtil.ValidAttribute("doctype-root-element"), new JspUtil.ValidAttribute("doctype-public"), new JspUtil.ValidAttribute("doctype-system")};

        ValidateVisitor(Compiler compiler) {
            this.pageInfo = compiler.getPageInfo();
            this.err = compiler.getErrorDispatcher();
            this.ctxt = compiler.getCompilationContext();
            this.loader = this.ctxt.getClassLoader();
        }

        @Override
        public void visit(Node.JspRoot n) throws WaspException {
            JspUtil.checkAttributes("Jsp:root", n, jspRootAttrs, this.err);
            String version = n.getTextAttribute("version");
            if (!(version.equals("1.2") || version.equals("2.0") || version.equals("2.1"))) {
                this.err.jspError((Node)n, "jsp.error.jsproot.version.invalid", version);
            }
            this.visitBody(n);
        }

        @Override
        public void visit(Node.IncludeDirective n) throws WaspException {
            JspUtil.checkAttributes("Include directive", n, includeDirectiveAttrs, this.err);
            this.visitBody(n);
        }

        @Override
        public void visit(Node.TaglibDirective n) throws WaspException {
            JspUtil.checkAttributes("Taglib directive", n, taglibDirectiveAttrs, this.err);
            String uri = n.getAttributeValue("uri");
            String tagdir = n.getAttributeValue("tagdir");
            if (uri == null && tagdir == null) {
                this.err.jspError(n, "jsp.error.taglibDirective.missing.location");
            }
            if (uri != null && tagdir != null) {
                this.err.jspError(n, "jsp.error.taglibDirective.both_uri_and_tagdir");
            }
        }

        @Override
        public void visit(Node.ParamAction n) throws WaspException {
            JspUtil.checkAttributes("Param action", n, paramActionAttrs, this.err);
            this.throwErrorIfExpression(n, "name", "jsp:param");
            n.setValue(this.getJspAttribute("value", null, null, n.getAttributeValue("value"), n, false, null));
            this.visitBody(n);
        }

        @Override
        public void visit(Node.ParamsAction n) throws WaspException {
            Node.Nodes subElems = n.getBody();
            if (subElems == null) {
                this.err.jspError(n, "jsp.error.params.emptyBody");
            }
            this.visitBody(n);
        }

        @Override
        public void visit(Node.IncludeAction n) throws WaspException {
            JspUtil.checkAttributes("Include action", n, includeActionAttrs, this.err);
            n.setPage(this.getJspAttribute("page", null, null, n.getAttributeValue("page"), n, false, null));
            this.visitBody(n);
        }

        @Override
        public void visit(Node.ForwardAction n) throws WaspException {
            JspUtil.checkAttributes("Forward", n, forwardActionAttrs, this.err);
            n.setPage(this.getJspAttribute("page", null, null, n.getAttributeValue("page"), n, false, null));
            this.visitBody(n);
        }

        @Override
        public void visit(Node.GetProperty n) throws WaspException {
            JspUtil.checkAttributes("GetProperty", n, getPropertyAttrs, this.err);
        }

        @Override
        public void visit(Node.SetProperty n) throws WaspException {
            boolean valueSpecified;
            JspUtil.checkAttributes("SetProperty", n, setPropertyAttrs, this.err);
            String property = n.getTextAttribute("property");
            String param = n.getTextAttribute("param");
            String value = n.getAttributeValue("value");
            n.setValue(this.getJspAttribute("value", null, null, value, n, false, null));
            boolean bl = valueSpecified = n.getValue() != null;
            if ("*".equals(property)) {
                if (param != null || valueSpecified) {
                    this.err.jspError(n, "jsp.error.setProperty.invalid");
                }
            } else if (param != null && valueSpecified) {
                this.err.jspError(n, "jsp.error.setProperty.invalid");
            }
            this.visitBody(n);
        }

        @Override
        public void visit(Node.UseBean useBean) throws WaspException {
            JspUtil.checkAttributes("UseBean", useBean, useBeanAttrs, this.err);
            String name = useBean.getTextAttribute("id");
            String scope = useBean.getTextAttribute("scope");
            JspUtil.checkScope(scope, useBean, this.err);
            String className = useBean.getTextAttribute("class");
            String type = useBean.getTextAttribute("type");
            BeanRepository beanInfo = this.pageInfo.getBeanRepository();
            if (className == null && type == null) {
                this.err.jspError(useBean, "jsp.error.usebean.missingType");
            }
            if (beanInfo.checkVariable(name)) {
                this.err.jspError((Node)useBean, "jsp.error.usebean.duplicate", name);
            }
            if ("session".equals(scope) && !this.pageInfo.isSession()) {
                this.err.jspError(useBean, "jsp.error.usebean.noSession");
            }
            Node.JspAttribute jattr = this.getJspAttribute("beanName", null, null, useBean.getAttributeValue("beanName"), useBean, false, null);
            useBean.setBeanName(jattr);
            if (className != null && jattr != null) {
                this.err.jspError(useBean, "jsp.error.usebean.notBoth");
            }
            if (className == null) {
                className = type;
            }
            beanInfo.addBean(useBean, name, className, scope);
            this.visitBody(useBean);
        }

        @Override
        public void visit(Node.PlugIn plugIn) throws WaspException {
            JspUtil.checkAttributes("Plugin", plugIn, plugInAttrs, this.err);
            this.throwErrorIfExpression(plugIn, "type", "jsp:plugin");
            this.throwErrorIfExpression(plugIn, "code", "jsp:plugin");
            this.throwErrorIfExpression(plugIn, "codebase", "jsp:plugin");
            this.throwErrorIfExpression(plugIn, "align", "jsp:plugin");
            this.throwErrorIfExpression(plugIn, "archive", "jsp:plugin");
            this.throwErrorIfExpression(plugIn, "hspace", "jsp:plugin");
            this.throwErrorIfExpression(plugIn, "jreversion", "jsp:plugin");
            this.throwErrorIfExpression(plugIn, "name", "jsp:plugin");
            this.throwErrorIfExpression(plugIn, "vspace", "jsp:plugin");
            this.throwErrorIfExpression(plugIn, "nspluginurl", "jsp:plugin");
            this.throwErrorIfExpression(plugIn, "iepluginurl", "jsp:plugin");
            String type = plugIn.getTextAttribute("type");
            if (type == null) {
                this.err.jspError(plugIn, "jsp.error.plugin.notype");
            }
            if (!type.equals("bean") && !type.equals("applet")) {
                this.err.jspError(plugIn, "jsp.error.plugin.badtype");
            }
            if (plugIn.getTextAttribute("code") == null) {
                this.err.jspError(plugIn, "jsp.error.plugin.nocode");
            }
            Node.JspAttribute width = this.getJspAttribute("width", null, null, plugIn.getAttributeValue("width"), plugIn, false, null);
            plugIn.setWidth(width);
            Node.JspAttribute height = this.getJspAttribute("height", null, null, plugIn.getAttributeValue("height"), plugIn, false, null);
            plugIn.setHeight(height);
            this.visitBody(plugIn);
        }

        @Override
        public void visit(Node.NamedAttribute namedAttribute) throws WaspException {
            JspUtil.checkAttributes("Attribute", namedAttribute, attributeAttrs, this.err);
            String omit = namedAttribute.getAttributeValue("omit");
            if (omit != null) {
                namedAttribute.setOmit(this.getJspAttribute("omit", null, null, omit, namedAttribute, false, null));
            }
            this.visitBody(namedAttribute);
        }

        @Override
        public void visit(Node.JspBody pagesBody) throws WaspException {
            this.visitBody(pagesBody);
        }

        @Override
        public void visit(Node.Declaration declaration) throws WaspException {
            if (this.pageInfo.isScriptingInvalid()) {
                this.err.jspError(declaration.getStart(), "jsp.error.no.scriptlets");
            }
        }

        @Override
        public void visit(Node.Expression expression) throws WaspException {
            if (this.pageInfo.isScriptingInvalid()) {
                this.err.jspError(expression.getStart(), "jsp.error.no.scriptlets");
            }
        }

        @Override
        public void visit(Node.Scriptlet scriptlet) throws WaspException {
            if (this.pageInfo.isScriptingInvalid()) {
                this.err.jspError(scriptlet.getStart(), "jsp.error.no.scriptlets");
            }
        }

        @Override
        public void visit(Node.ELExpression expression) throws WaspException {
            if (this.pageInfo.isELIgnored()) {
                return;
            }
            String expressions = expression.getText();
            if (expressions.charAt(0) == '#') {
                String versionString;
                Double version;
                if (this.pageInfo.isDeferredSyntaxAllowedAsLiteral()) {
                    return;
                }
                if (this.ctxt.isTagFile() && (version = Double.valueOf(versionString = this.ctxt.getTagInfo().getTagLibrary().getRequiredVersion())) < 2.1) {
                    return;
                }
                this.err.jspError(expression.getStart(), "jsp.error.not.in.template", "#{...}");
            }
            ELNode.Nodes el = ELParser.parse(expressions);
            this.validateFunctions(el, expression);
            JspUtil.validateExpressions(expression.getStart(), expressions, this.getFunctionMapper(el), this.err);
            expression.setEL(el);
        }

        @Override
        public void visit(Node.UninterpretedTag uninterpretedTag) throws WaspException {
            Attributes attrs;
            if (uninterpretedTag.getNamedAttributeNodes().size() != 0) {
                this.err.jspError(uninterpretedTag, "jsp.error.namedAttribute.invalidUse");
            }
            if ((attrs = uninterpretedTag.getAttributes()) != null) {
                int attrSize = attrs.getLength();
                Node.JspAttribute[] jspAttrs = new Node.JspAttribute[attrSize];
                for (int i = 0; i < attrSize; ++i) {
                    jspAttrs[i] = this.getJspAttribute(attrs.getQName(i), attrs.getURI(i), attrs.getLocalName(i), attrs.getValue(i), uninterpretedTag, false, null);
                }
                uninterpretedTag.setJspAttributes(jspAttrs);
            }
            this.visitBody(uninterpretedTag);
        }

        @Override
        public void visit(Node.CustomTag customTag) throws WaspException {
            TagInfo tagInfo = customTag.getTagInfo();
            if (tagInfo == null) {
                this.err.jspError((Node)customTag, "jsp.error.missing.tagInfo", customTag.getQName());
            }
            if (customTag.implementsSimpleTag() && tagInfo.getBodyContent().equals("JSP")) {
                this.err.jspError((Node)customTag, "jsp.error.simpletag.badbodycontent", tagInfo.getTagClassName());
            }
            if (tagInfo.hasDynamicAttributes() && !customTag.implementsDynamicAttributes()) {
                this.err.jspError((Node)customTag, "jsp.error.dynamic.attributes.not.implemented", customTag.getQName());
            }
            TagAttributeInfo[] tldAttrs = tagInfo.getAttributes();
            String customActionUri = customTag.getURI();
            Attributes attrs = customTag.getAttributes();
            int attrsSize = attrs == null ? 0 : attrs.getLength();
            for (int i = 0; i < tldAttrs.length; ++i) {
                String attr = null;
                if (attrs != null && (attr = attrs.getValue(tldAttrs[i].getName())) == null) {
                    attr = attrs.getValue(customActionUri, tldAttrs[i].getName());
                }
                Node.NamedAttribute na = customTag.getNamedAttributeNode(tldAttrs[i].getName());
                if (tldAttrs[i].isRequired() && attr == null && na == null) {
                    this.err.jspError((Node)customTag, "jsp.error.missing_attribute", tldAttrs[i].getName(), customTag.getLocalName());
                }
                if (attr == null || na == null) continue;
                this.err.jspError((Node)customTag, "jsp.error.duplicate.name.jspattribute", tldAttrs[i].getName());
            }
            Node.Nodes naNodes = customTag.getNamedAttributeNodes();
            int jspAttrsSize = naNodes.size() + attrsSize;
            Node.JspAttribute[] jspAttrs = null;
            if (jspAttrsSize > 0) {
                jspAttrs = new Node.JspAttribute[jspAttrsSize];
            }
            Hashtable<String, Object> tagDataAttrs = new Hashtable<String, Object>(attrsSize);
            this.checkXmlAttributes(customTag, jspAttrs, tagDataAttrs);
            this.checkNamedAttributes(customTag, jspAttrs, attrsSize, tagDataAttrs);
            TagData tagData = new TagData(tagDataAttrs);
            TagExtraInfo tei = tagInfo.getTagExtraInfo();
            if (tei != null && tei.getVariableInfo(tagData) != null && tei.getVariableInfo(tagData).length > 0 && tagInfo.getTagVariableInfos().length > 0) {
                this.err.jspError("jsp.error.non_null_tei_and_var_subelems", customTag.getQName());
            }
            customTag.setTagData(tagData);
            customTag.setJspAttributes(jspAttrs);
            this.visitBody(customTag);
        }

        @Override
        public void visit(Node.JspElement pagesElement) throws WaspException {
            int i;
            Attributes attrs = pagesElement.getAttributes();
            if (attrs == null) {
                this.err.jspError(pagesElement, "jsp.error.jspelement.missing.name");
            }
            int xmlAttrLen = attrs.getLength();
            Node.Nodes namedAttrs = pagesElement.getNamedAttributeNodes();
            int jspAttrSize = xmlAttrLen - 1 + namedAttrs.size();
            Node.JspAttribute[] jspAttrs = new Node.JspAttribute[jspAttrSize];
            int jspAttrIndex = 0;
            for (i = 0; i < xmlAttrLen; ++i) {
                if ("name".equals(attrs.getLocalName(i))) {
                    pagesElement.setNameAttribute(this.getJspAttribute(attrs.getQName(i), attrs.getURI(i), attrs.getLocalName(i), attrs.getValue(i), pagesElement, false, null));
                    continue;
                }
                if (jspAttrIndex >= jspAttrSize) continue;
                jspAttrs[jspAttrIndex++] = this.getJspAttribute(attrs.getQName(i), attrs.getURI(i), attrs.getLocalName(i), attrs.getValue(i), pagesElement, false, null);
            }
            if (pagesElement.getNameAttribute() == null) {
                this.err.jspError(pagesElement, "jsp.error.jspelement.missing.name");
            }
            for (i = 0; i < namedAttrs.size(); ++i) {
                Node.NamedAttribute na = (Node.NamedAttribute)namedAttrs.getNode(i);
                jspAttrs[jspAttrIndex++] = new Node.JspAttribute(na, false);
            }
            pagesElement.setJspAttributes(jspAttrs);
            this.visitBody(pagesElement);
        }

        @Override
        public void visit(Node.JspOutput pagesOutput) throws WaspException {
            JspUtil.checkAttributes("jsp:output", pagesOutput, jspOutputAttrs, this.err);
            if (pagesOutput.getBody() != null) {
                this.err.jspError(pagesOutput, "jsp.error.jspoutput.nonemptybody");
            }
            String omitXmlDecl = pagesOutput.getAttributeValue("omit-xml-declaration");
            String doctypeName = pagesOutput.getAttributeValue("doctype-root-element");
            String doctypePublic = pagesOutput.getAttributeValue("doctype-public");
            String doctypeSystem = pagesOutput.getAttributeValue("doctype-system");
            String omitXmlDeclOld = this.pageInfo.getOmitXmlDecl();
            String doctypeNameOld = this.pageInfo.getDoctypeName();
            String doctypePublicOld = this.pageInfo.getDoctypePublic();
            String doctypeSystemOld = this.pageInfo.getDoctypeSystem();
            if (omitXmlDecl != null && omitXmlDeclOld != null && !omitXmlDecl.equals(omitXmlDeclOld)) {
                this.err.jspError((Node)pagesOutput, "jsp.error.jspoutput.conflict", "omit-xml-declaration", omitXmlDeclOld, omitXmlDecl);
            }
            if (doctypeName != null && doctypeNameOld != null && !doctypeName.equals(doctypeNameOld)) {
                this.err.jspError((Node)pagesOutput, "jsp.error.jspoutput.conflict", "doctype-root-element", doctypeNameOld, doctypeName);
            }
            if (doctypePublic != null && doctypePublicOld != null && !doctypePublic.equals(doctypePublicOld)) {
                this.err.jspError((Node)pagesOutput, "jsp.error.jspoutput.conflict", "doctype-public", doctypePublicOld, doctypePublic);
            }
            if (doctypeSystem != null && doctypeSystemOld != null && !doctypeSystem.equals(doctypeSystemOld)) {
                this.err.jspError((Node)pagesOutput, "jsp.error.jspoutput.conflict", "doctype-system", doctypeSystemOld, doctypeSystem);
            }
            if (doctypeName == null && doctypeSystem != null || doctypeName != null && doctypeSystem == null) {
                this.err.jspError(pagesOutput, "jsp.error.jspoutput.doctypenamesystem");
            }
            if (doctypePublic != null && doctypeSystem == null) {
                this.err.jspError(pagesOutput, "jsp.error.jspoutput.doctypepulicsystem");
            }
            if (omitXmlDecl != null) {
                this.pageInfo.setOmitXmlDecl(omitXmlDecl);
            }
            if (doctypeName != null) {
                this.pageInfo.setDoctypeName(doctypeName);
            }
            if (doctypeSystem != null) {
                this.pageInfo.setDoctypeSystem(doctypeSystem);
            }
            if (doctypePublic != null) {
                this.pageInfo.setDoctypePublic(doctypePublic);
            }
        }

        @Override
        public void visit(Node.InvokeAction invokeAction) throws WaspException {
            JspUtil.checkAttributes("Invoke", invokeAction, invokeAttrs, this.err);
            String scope = invokeAction.getTextAttribute("scope");
            JspUtil.checkScope(scope, invokeAction, this.err);
            String var = invokeAction.getTextAttribute("var");
            String varReader = invokeAction.getTextAttribute("varReader");
            if (scope != null && var == null && varReader == null) {
                this.err.jspError(invokeAction, "jsp.error.missing_var_or_varReader");
            }
            if (var != null && varReader != null) {
                this.err.jspError(invokeAction, "jsp.error.var_and_varReader");
            }
        }

        @Override
        public void visit(Node.DoBodyAction doBodyAction) throws WaspException {
            JspUtil.checkAttributes("DoBody", doBodyAction, doBodyAttrs, this.err);
            String scope = doBodyAction.getTextAttribute("scope");
            JspUtil.checkScope(scope, doBodyAction, this.err);
            String var = doBodyAction.getTextAttribute("var");
            String varReader = doBodyAction.getTextAttribute("varReader");
            if (scope != null && var == null && varReader == null) {
                this.err.jspError(doBodyAction, "jsp.error.missing_var_or_varReader");
            }
            if (var != null && varReader != null) {
                this.err.jspError(doBodyAction, "jsp.error.var_and_varReader");
            }
        }

        private void checkSetter(Node.CustomTag customTag, TagAttributeInfo tldattr) throws WaspException {
            Class<?> handler = customTag.getTagHandlerClass();
            if (handler == null) {
                return;
            }
            String handlerName = handler.getName();
            String property = tldattr.getName();
            Method setter = null;
            try {
                setter = JspRuntimeLibrary.getWriteMethod(handler, property);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (setter == null) {
                this.err.jspError((Node)customTag, "jsp.error.setter.none", handlerName, property);
            }
            Class<?> setterType = setter.getParameterTypes()[0];
            String typeName = setterType.getName();
            if (tldattr.isDeferredValue()) {
                if (tldattr.canBeRequestTime()) {
                    if (!"java.lang.Object".equals(typeName)) {
                        this.err.jspError((Node)customTag, "jsp.error.setter.notobject", handlerName, property);
                    }
                    return;
                }
                if (!"jakarta.el.ValueExpression".equals(typeName)) {
                    this.err.jspError((Node)customTag, "jsp.error.setter.notvalueexpression", handlerName, property);
                }
                return;
            }
            if (tldattr.isDeferredMethod() && !"jakarta.el.MethodExpression".equals(typeName)) {
                this.err.jspError((Node)customTag, "jsp.error.setter.notmethodexpression", handlerName, property);
            }
        }

        private void checkXmlAttributes(Node.CustomTag customTag, Node.JspAttribute[] jspAttrs, Hashtable<String, Object> tagDataAttrs) throws WaspException {
            TagInfo tagInfo = customTag.getTagInfo();
            if (tagInfo == null) {
                this.err.jspError((Node)customTag, "jsp.error.missing.tagInfo", customTag.getQName());
            }
            TagAttributeInfo[] tldAttrs = tagInfo.getAttributes();
            Attributes attrs = customTag.getAttributes();
            for (int i = 0; attrs != null && i < attrs.getLength(); ++i) {
                boolean found = false;
                for (int j = 0; tldAttrs != null && j < tldAttrs.length; ++j) {
                    if (!attrs.getLocalName(i).equals(tldAttrs[j].getName()) || attrs.getURI(i) != null && attrs.getURI(i).length() != 0 && !attrs.getURI(i).equals(customTag.getURI())) continue;
                    this.checkSetter(customTag, tldAttrs[j]);
                    if (tldAttrs[j].canBeRequestTime() || tldAttrs[j].isDeferredValue() || tldAttrs[j].isDeferredMethod()) {
                        jspAttrs[i] = this.getJspAttribute(attrs.getQName(i), attrs.getURI(i), attrs.getLocalName(i), attrs.getValue(i), customTag, false, tldAttrs[j]);
                        ELNode.Nodes el = jspAttrs[i].getEL();
                        if (el != null) {
                            if (el.hasDollarExpression()) {
                                if (!tldAttrs[j].canBeRequestTime()) {
                                    this.err.jspError((Node)customTag, "jsp.error.el.deferred.dollar", tldAttrs[j].getName());
                                }
                            } else if (el.hasPoundExpression()) {
                                boolean isLiteral = this.pageInfo.isDeferredSyntaxAllowedAsLiteral();
                                if (!tldAttrs[j].isDeferredValue() && !tldAttrs[j].isDeferredMethod()) {
                                    if (customTag.getJspVersion() >= 2.1 && !isLiteral) {
                                        this.err.jspError((Node)customTag, "jsp.error.el.nondeferred.pound", tldAttrs[j].getName());
                                    } else {
                                        isLiteral = true;
                                    }
                                }
                                if (isLiteral) {
                                    jspAttrs[i].setValue(this.escapePound(jspAttrs[i].getValue()));
                                }
                            } else if (this.pageInfo.isDeferredSyntaxAllowedAsLiteral()) {
                                jspAttrs[i].setValue(this.escapePound(jspAttrs[i].getValue()));
                            }
                        }
                    } else {
                        String litAttr = this.getLiteral(customTag, attrs.getValue(i));
                        if (litAttr == null) {
                            this.err.jspError((Node)customTag, "jsp.error.attribute.custom.non_rt_with_expr", tldAttrs[j].getName());
                        }
                        jspAttrs[i] = new Node.JspAttribute(attrs.getQName(i), attrs.getURI(i), attrs.getLocalName(i), litAttr, false, null, false);
                    }
                    if (jspAttrs[i].isExpression()) {
                        tagDataAttrs.put(attrs.getQName(i), TagData.REQUEST_TIME_VALUE);
                    } else {
                        tagDataAttrs.put(attrs.getQName(i), attrs.getValue(i));
                    }
                    found = true;
                    break;
                }
                if (found) continue;
                if (tagInfo.hasDynamicAttributes()) {
                    jspAttrs[i] = this.getJspAttribute(attrs.getQName(i), attrs.getURI(i), attrs.getLocalName(i), attrs.getValue(i), customTag, true, null);
                    continue;
                }
                this.err.jspError((Node)customTag, "jsp.error.bad_attribute", attrs.getQName(i), customTag.getLocalName());
            }
        }

        private void checkNamedAttributes(Node.CustomTag customTag, Node.JspAttribute[] jspAttrs, int start, Hashtable<String, Object> tagDataAttrs) throws WaspException {
            TagInfo tagInfo = customTag.getTagInfo();
            if (tagInfo == null) {
                this.err.jspError((Node)customTag, "jsp.error.missing.tagInfo", customTag.getQName());
            }
            TagAttributeInfo[] tldAttrs = tagInfo.getAttributes();
            Node.Nodes naNodes = customTag.getNamedAttributeNodes();
            for (int i = 0; i < naNodes.size(); ++i) {
                Node.NamedAttribute na = (Node.NamedAttribute)naNodes.getNode(i);
                boolean found = false;
                for (int j = 0; j < tldAttrs.length; ++j) {
                    String attrPrefix = na.getPrefix();
                    if (!na.getLocalName().equals(tldAttrs[j].getName()) || attrPrefix != null && attrPrefix.length() != 0 && !attrPrefix.equals(customTag.getPrefix())) continue;
                    jspAttrs[start + i] = new Node.JspAttribute(na, false);
                    NamedAttributeVisitor nav = null;
                    if (na.getBody() != null) {
                        nav = new NamedAttributeVisitor();
                        na.getBody().visit(nav);
                    }
                    if (nav != null && nav.hasDynamicContent()) {
                        tagDataAttrs.put(na.getName(), TagData.REQUEST_TIME_VALUE);
                    } else {
                        tagDataAttrs.put(na.getName(), na.getText());
                    }
                    found = true;
                    break;
                }
                if (found) continue;
                if (tagInfo.hasDynamicAttributes()) {
                    jspAttrs[start + i] = new Node.JspAttribute(na, true);
                    continue;
                }
                this.err.jspError((Node)customTag, "jsp.error.bad_attribute", na.getName(), customTag.getLocalName());
            }
        }

        private Node.JspAttribute getJspAttribute(String qName, String uri, String localName, String value, Node n, boolean dynamic, TagAttributeInfo tagAttr) throws WaspException {
            Node.JspAttribute result = null;
            if (value != null) {
                if (n.getRoot().isXmlSyntax() && value.startsWith("%=")) {
                    result = new Node.JspAttribute(qName, uri, localName, value.substring(2, value.length() - 1), true, null, dynamic);
                } else if (!n.getRoot().isXmlSyntax() && value.startsWith("<%=")) {
                    result = new Node.JspAttribute(qName, uri, localName, value.substring(3, value.length() - 2), true, null, dynamic);
                } else {
                    ELNode.Nodes el = ELParser.parse(value);
                    if (el.hasPoundExpression() && tagAttr == null && !dynamic) {
                        if (this.pageInfo.isELIgnored() || this.pageInfo.isDeferredSyntaxAllowedAsLiteral()) {
                            result = new Node.JspAttribute(qName, uri, localName, this.getLiteral(n, value), false, null, false);
                        } else {
                            this.err.jspError(n, "jsp.error.el.action.pound");
                        }
                    } else if (el.containsEL() && !this.pageInfo.isELIgnored() || tagAttr != null && (tagAttr.isDeferredValue() && !tagAttr.canBeRequestTime() || tagAttr.isDeferredMethod())) {
                        this.validateFunctions(el, n);
                        JspUtil.validateExpressions(n.getStart(), value, this.getFunctionMapper(el), this.err);
                        if (tagAttr != null && tagAttr.isDeferredValue()) {
                            String expectedType = tagAttr.getExpectedTypeName();
                            result = new Node.JspAttribute(qName, uri, localName, value, el, expectedType, null, null);
                        } else if (tagAttr != null && tagAttr.isDeferredMethod()) {
                            String methodSignature = tagAttr.getMethodSignature();
                            String returnType = this.getReturnType(methodSignature);
                            if (!el.containsEL()) {
                                try {
                                    Class<?> typeClass = JspUtil.toClass(returnType, this.loader);
                                    JspUtil.coerce(typeClass, value);
                                }
                                catch (ClassNotFoundException ex) {
                                    this.err.jspError(n, "jsp.error.el.method.type", qName, returnType);
                                }
                                catch (Exception ex) {
                                    this.err.jspError(n, "jsp.error.el.method.literal", qName);
                                }
                            }
                            result = new Node.JspAttribute(qName, uri, localName, value, el, null, this.getReturnType(methodSignature), this.getParameters(methodSignature));
                        } else {
                            result = new Node.JspAttribute(qName, uri, localName, value, false, el, dynamic);
                        }
                    } else {
                        result = new Node.JspAttribute(qName, uri, localName, this.getLiteral(n, value), false, null, dynamic);
                    }
                }
            } else {
                Node.NamedAttribute namedAttributeNode = n.getNamedAttributeNode(qName);
                if (namedAttributeNode != null) {
                    result = new Node.JspAttribute(namedAttributeNode, dynamic);
                }
            }
            return result;
        }

        private String getLiteral(Node node, String value) {
            if (node.getRoot().isXmlSyntax() && value.startsWith("%=")) {
                return null;
            }
            if (!node.getRoot().isXmlSyntax() && value.startsWith("<%=")) {
                return null;
            }
            if (this.pageInfo.isELIgnored()) {
                return value;
            }
            boolean poundExpressionIgnored = node instanceof Node.CustomTag && (((Node.CustomTag)node).getJspVersion() < 2.1 || this.pageInfo.isDeferredSyntaxAllowedAsLiteral());
            int size = value.length();
            StringBuilder buf = new StringBuilder(size);
            char p = ' ';
            for (int i = 0; i < size; ++i) {
                char c = value.charAt(i);
                if (p == '$' && c == '{') {
                    return null;
                }
                if (p == '#' && c == '{' && !poundExpressionIgnored) {
                    return null;
                }
                if (p == '\\') {
                    if (c == '\\' || c == '$' || c == '#' && !poundExpressionIgnored) {
                        buf.append(c);
                        p = ' ';
                        continue;
                    }
                    buf.append(p).append(c);
                    p = c;
                    continue;
                }
                p = c;
                if (p == 92) continue;
                buf.append(c);
            }
            return buf.toString();
        }

        private void throwErrorIfExpression(Node node, String attrName, String actionName) throws WaspException {
            if (node.getAttributes() != null && node.getAttributes().getValue(attrName) != null && this.getLiteral(node, node.getAttributes().getValue(attrName)) == null) {
                this.err.jspError(node, "jsp.error.attribute.standard.non_rt_with_expr", attrName, actionName);
            }
        }

        private String escapePound(String value) {
            if (value.indexOf("#{") < 0) {
                return value;
            }
            StringBuilder buf = new StringBuilder(value.length() + 2);
            for (int i = 0; i < value.length(); ++i) {
                if (value.charAt(i) == '#' && i + 1 < value.length() && value.charAt(i + 1) == '{') {
                    if (i - 1 >= 0 && value.charAt(i - 1) == '\\') {
                        buf.append('\\');
                    }
                    buf.append('\\');
                }
                buf.append(value.charAt(i));
            }
            return buf.toString();
        }

        private String findUri(String prefix, Node node) {
            for (Node parentNode = node; parentNode != null; parentNode = parentNode.getParent()) {
                Attributes attrs = parentNode.getTaglibAttributes();
                if (attrs == null) continue;
                for (int i = 0; i < attrs.getLength(); ++i) {
                    String name = attrs.getQName(i);
                    int k = name.indexOf(58);
                    if (prefix == null && k < 0) {
                        return attrs.getValue(i);
                    }
                    if (prefix == null || k < 0 || !prefix.equals(name.substring(k + 1))) continue;
                    return attrs.getValue(i);
                }
            }
            return null;
        }

        private void validateFunctions(ELNode.Nodes el, Node n) throws WaspException {
            class FVVisitor
            extends ELNode.Visitor {
                Node n;

                FVVisitor(Node n) {
                    this.n = n;
                }

                @Override
                public void visit(ELNode.Function func) throws WaspException {
                    String prefix = func.getPrefix();
                    String function = func.getName();
                    String uri = null;
                    if (this.n.getRoot().isXmlSyntax()) {
                        uri = ValidateVisitor.this.findUri(prefix, this.n);
                    } else if (prefix != null) {
                        uri = ValidateVisitor.this.pageInfo.getURI(prefix);
                    }
                    if (uri == null) {
                        if (prefix == null) {
                            return;
                        }
                        ValidateVisitor.this.err.jspError(this.n, "jsp.error.attribute.invalidPrefix", prefix);
                    }
                    TagLibraryInfo taglib = ValidateVisitor.this.pageInfo.getTaglib(uri);
                    FunctionInfo funcInfo = null;
                    if (taglib != null) {
                        funcInfo = taglib.getFunction(function);
                    }
                    if (funcInfo == null) {
                        ValidateVisitor.this.err.jspError(this.n, "jsp.error.noFunction", function);
                    }
                    func.setUri(uri);
                    func.setFunctionInfo(funcInfo);
                    ValidateVisitor.this.processSignature(func);
                }
            }
            el.visit(new FVVisitor(n));
        }

        private void processSignature(ELNode.Function function) throws WaspException {
            FunctionInfo funcInfo = function.getFunctionInfo();
            String signature = funcInfo.getFunctionSignature();
            function.setMethodName(this.getMethod(signature));
            function.setParameters(this.getParameters(signature));
        }

        private String getReturnType(String signature) throws WaspException {
            int start = signature.indexOf(32);
            if (start < 0) {
                this.err.jspError("jsp.error.tld.invalid.signature", signature);
            }
            return signature.substring(0, start);
        }

        private String getMethod(String signature) throws WaspException {
            int end;
            int start = signature.indexOf(32);
            if (start < 0) {
                this.err.jspError("jsp.error.tld.invalid.signature", signature);
            }
            if ((end = signature.indexOf(40)) < 0) {
                this.err.jspError("jsp.error.tld.invalid.signature", signature);
            }
            return signature.substring(start + 1, end).trim();
        }

        private String[] getParameters(String signature) throws WaspException {
            ArrayList<String> params = new ArrayList<String>();
            int start = signature.indexOf(40) + 1;
            boolean lastArg = false;
            while (true) {
                String arg;
                int p;
                if ((p = signature.indexOf(44, start)) < 0) {
                    p = signature.indexOf(41, start);
                    if (p < 0) {
                        this.err.jspError("jsp.error.tld.invalid.signature", signature);
                    }
                    lastArg = true;
                }
                if (!"".equals(arg = signature.substring(start, p).trim())) {
                    params.add(arg);
                }
                if (lastArg) break;
                start = p + 1;
            }
            return params.toArray(new String[params.size()]);
        }

        private FunctionMapper getFunctionMapper(ELNode.Nodes el) throws WaspException {
            class ValidateFunctionMapper
            extends FunctionMapper {
                private HashMap<String, Method> fnmap = new HashMap();

                ValidateFunctionMapper() {
                }

                public void mapFunction(String fnQName, Method method) {
                    this.fnmap.put(fnQName, method);
                }

                @Override
                public Method resolveFunction(String prefix, String localName) {
                    return this.fnmap.get(prefix + ":" + localName);
                }
            }
            ValidateFunctionMapper fmapper = new ValidateFunctionMapper();
            class MapperELVisitor
            extends ELNode.Visitor {
                ValidateFunctionMapper fmapper;

                MapperELVisitor(ValidateFunctionMapper fmapper) {
                    this.fmapper = fmapper;
                }

                @Override
                public void visit(ELNode.Function n) throws WaspException {
                    if (n.getUri() == null) {
                        return;
                    }
                    Class<?> c = null;
                    Method method = null;
                    try {
                        c = ValidateVisitor.this.loader.loadClass(n.getFunctionInfo().getFunctionClass());
                    }
                    catch (ClassNotFoundException e) {
                        ValidateVisitor.this.err.jspError("jsp.error.function.classnotfound", n.getFunctionInfo().getFunctionClass(), n.getPrefix() + ":" + n.getName(), e.getMessage());
                    }
                    String[] paramTypes = n.getParameters();
                    int size = paramTypes.length;
                    Class[] params = new Class[size];
                    int i = 0;
                    try {
                        for (i = 0; i < size; ++i) {
                            params[i] = JspUtil.toClass(paramTypes[i], ValidateVisitor.this.loader);
                        }
                        method = c.getDeclaredMethod(n.getMethodName(), params);
                    }
                    catch (ClassNotFoundException e) {
                        ValidateVisitor.this.err.jspError("jsp.error.signature.classnotfound", paramTypes[i], n.getPrefix() + ":" + n.getName(), e.getMessage());
                    }
                    catch (NoSuchMethodException e) {
                        ValidateVisitor.this.err.jspError("jsp.error.noFunctionMethod", n.getMethodName(), n.getName(), c.getName());
                    }
                    if (!Modifier.isPublic(method.getModifiers())) {
                        ValidateVisitor.this.err.jspError("jsp.error.nonPublicFunction", c.getName() + "." + method.getName());
                    }
                    if (!Modifier.isStatic(method.getModifiers())) {
                        ValidateVisitor.this.err.jspError("jsp.error.nonStaticFunction", c.getName() + "." + method.getName());
                    }
                    this.fmapper.mapFunction(n.getPrefix() + ":" + n.getName(), method);
                }
            }
            el.visit(new MapperELVisitor(fmapper));
            return fmapper;
        }

        private static class NamedAttributeVisitor
        extends Node.Visitor {
            private boolean hasDynamicContent;

            private NamedAttributeVisitor() {
            }

            @Override
            public void doVisit(Node n) throws WaspException {
                if (!(n instanceof Node.JspText) && !(n instanceof Node.TemplateText)) {
                    this.hasDynamicContent = true;
                }
                this.visitBody(n);
            }

            public boolean hasDynamicContent() {
                return this.hasDynamicContent;
            }
        }
    }

    static class TagExtraInfoVisitor
    extends Node.Visitor {
        private ErrorDispatcher err;

        TagExtraInfoVisitor(Compiler compiler) {
            this.err = compiler.getErrorDispatcher();
        }

        @Override
        public void visit(Node.CustomTag n) throws WaspException {
            ValidationMessage[] errors;
            TagInfo tagInfo = n.getTagInfo();
            if (tagInfo == null) {
                this.err.jspError((Node)n, "jsp.error.missing.tagInfo", n.getQName());
            }
            if ((errors = tagInfo.validate(n.getTagData())) != null && errors.length != 0) {
                StringBuilder errMsg = new StringBuilder();
                errMsg.append("<h3>");
                errMsg.append(Localizer.getMessage("jsp.error.tei.invalid.attributes", n.getQName()));
                errMsg.append("</h3>");
                for (int i = 0; i < errors.length; ++i) {
                    errMsg.append("<p>");
                    if (errors[i].getId() != null) {
                        errMsg.append(errors[i].getId());
                        errMsg.append(": ");
                    }
                    errMsg.append(errors[i].getMessage());
                    errMsg.append("</p>");
                }
                this.err.jspError(n, errMsg.toString());
            }
            this.visitBody(n);
        }
    }
}

