/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Objects;
import java.util.function.Predicate;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.websocket.api.Callback;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.UpgradeRequest;
import org.eclipse.jetty.websocket.api.UpgradeResponse;
import org.eclipse.jetty.websocket.api.WebSocketContainer;
import org.eclipse.jetty.websocket.common.JettyWebSocketFrameHandler;
import org.eclipse.jetty.websocket.core.CoreSession;
import org.eclipse.jetty.websocket.core.Frame;
import org.eclipse.jetty.websocket.core.OpCode;
import org.eclipse.jetty.websocket.core.exception.ProtocolException;
import org.eclipse.jetty.websocket.core.exception.WebSocketTimeoutException;

public class WebSocketSession
implements Session,
Dumpable {
    private final CoreSession coreSession;
    private final JettyWebSocketFrameHandler frameHandler;
    private final UpgradeRequest upgradeRequest;
    private final UpgradeResponse upgradeResponse;
    private byte messageType = (byte)-1;

    public WebSocketSession(WebSocketContainer container, CoreSession coreSession, JettyWebSocketFrameHandler frameHandler) {
        this.frameHandler = Objects.requireNonNull(frameHandler);
        this.coreSession = Objects.requireNonNull(coreSession);
        this.upgradeRequest = frameHandler.getUpgradeRequest();
        this.upgradeResponse = frameHandler.getUpgradeResponse();
        container.notifySessionListeners(listener -> listener.onWebSocketSessionCreated(this));
    }

    @Override
    public void demand() {
        if (this.frameHandler.isAutoDemand()) {
            throw new IllegalStateException("auto-demanding endpoint cannot explicitly demand");
        }
        this.coreSession.demand();
    }

    @Override
    public void sendBinary(ByteBuffer buffer, Callback callback) {
        callback = Objects.requireNonNullElse(callback, Callback.NOOP);
        this.coreSession.sendFrame(new Frame(2).setPayload(buffer), org.eclipse.jetty.util.Callback.from(callback::succeed, callback::fail), false);
    }

    @Override
    public void sendPartialBinary(ByteBuffer buffer, boolean last, Callback callback) {
        Frame frame;
        callback = Objects.requireNonNullElse(callback, Callback.NOOP);
        switch (this.messageType) {
            case -1: {
                this.messageType = (byte)2;
                Frame frame2 = new Frame(2);
                break;
            }
            case 2: {
                Frame frame2 = new Frame(0);
                break;
            }
            default: {
                callback.fail(new ProtocolException("Attempt to send partial BINARY during " + OpCode.name(this.messageType)));
                Frame frame2 = frame = null;
            }
        }
        if (frame != null) {
            frame.setPayload(buffer);
            frame.setFin(last);
            org.eclipse.jetty.util.Callback cb = org.eclipse.jetty.util.Callback.from(callback::succeed, callback::fail);
            this.coreSession.sendFrame(frame, cb, false);
            if (last) {
                this.messageType = (byte)-1;
            }
        }
    }

    @Override
    public void sendText(String text, Callback callback) {
        callback = Objects.requireNonNullElse(callback, Callback.NOOP);
        org.eclipse.jetty.util.Callback cb = org.eclipse.jetty.util.Callback.from(callback::succeed, callback::fail);
        this.coreSession.sendFrame(new Frame(1).setPayload(text), cb, false);
    }

    @Override
    public void sendPartialText(String text, boolean last, Callback callback) {
        Frame frame;
        switch (this.messageType) {
            case -1: {
                this.messageType = 1;
                Frame frame2 = new Frame(1);
                break;
            }
            case 1: {
                Frame frame2 = new Frame(0);
                break;
            }
            default: {
                callback.fail(new ProtocolException("Attempt to send partial TEXT during " + OpCode.name(this.messageType)));
                Frame frame2 = frame = null;
            }
        }
        if (frame != null) {
            frame.setPayload(BufferUtil.toBuffer(text, StandardCharsets.UTF_8));
            frame.setFin(last);
            org.eclipse.jetty.util.Callback cb = org.eclipse.jetty.util.Callback.from(callback::succeed, callback::fail);
            this.coreSession.sendFrame(frame, cb, false);
            if (last) {
                this.messageType = (byte)-1;
            }
        }
    }

    @Override
    public void sendPing(ByteBuffer applicationData, Callback callback) {
        this.coreSession.sendFrame(new Frame(9).setPayload(applicationData), org.eclipse.jetty.util.Callback.from(callback::succeed, callback::fail), false);
    }

    @Override
    public void sendPong(ByteBuffer applicationData, Callback callback) {
        this.coreSession.sendFrame(new Frame(10).setPayload(applicationData), org.eclipse.jetty.util.Callback.from(callback::succeed, callback::fail), false);
    }

    @Override
    public void close(int statusCode, String reason, Callback callback) {
        this.coreSession.close(statusCode, reason, org.eclipse.jetty.util.Callback.from(callback::succeed, callback::fail));
    }

    @Override
    public Duration getIdleTimeout() {
        return this.coreSession.getIdleTimeout();
    }

    @Override
    public void setIdleTimeout(Duration duration) {
        this.coreSession.setIdleTimeout(duration);
    }

    @Override
    public int getInputBufferSize() {
        return this.coreSession.getInputBufferSize();
    }

    @Override
    public void setInputBufferSize(int size) {
        this.coreSession.setInputBufferSize(size);
    }

    @Override
    public int getOutputBufferSize() {
        return this.coreSession.getOutputBufferSize();
    }

    @Override
    public void setOutputBufferSize(int size) {
        this.coreSession.setOutputBufferSize(size);
    }

    @Override
    public long getMaxBinaryMessageSize() {
        return this.coreSession.getMaxBinaryMessageSize();
    }

    @Override
    public void setMaxBinaryMessageSize(long size) {
        this.coreSession.setMaxBinaryMessageSize(size);
    }

    @Override
    public long getMaxTextMessageSize() {
        return this.coreSession.getMaxTextMessageSize();
    }

    @Override
    public void setMaxTextMessageSize(long size) {
        this.coreSession.setMaxTextMessageSize(size);
    }

    @Override
    public long getMaxFrameSize() {
        return this.coreSession.getMaxFrameSize();
    }

    @Override
    public void setMaxFrameSize(long maxFrameSize) {
        this.coreSession.setMaxFrameSize(maxFrameSize);
    }

    @Override
    public boolean isAutoFragment() {
        return this.coreSession.isAutoFragment();
    }

    @Override
    public void setAutoFragment(boolean autoFragment) {
        this.coreSession.setAutoFragment(autoFragment);
    }

    @Override
    public int getMaxOutgoingFrames() {
        return this.coreSession.getMaxOutgoingFrames();
    }

    @Override
    public void setMaxOutgoingFrames(int maxOutgoingFrames) {
        this.coreSession.setMaxOutgoingFrames(maxOutgoingFrames);
    }

    @Override
    public String getProtocolVersion() {
        return this.upgradeRequest.getProtocolVersion();
    }

    @Override
    public boolean isOpen() {
        return this.coreSession.isOutputOpen();
    }

    @Override
    public boolean isSecure() {
        return this.upgradeRequest.isSecure();
    }

    @Override
    public void addIdleTimeoutListener(Predicate<org.eclipse.jetty.websocket.api.exceptions.WebSocketTimeoutException> onIdleTimeout) {
        this.coreSession.addIdleTimeoutListener((WebSocketTimeoutException t) -> onIdleTimeout.test(new org.eclipse.jetty.websocket.api.exceptions.WebSocketTimeoutException((Throwable)t)));
    }

    @Override
    public void disconnect() {
        this.coreSession.abort();
    }

    @Override
    public SocketAddress getLocalSocketAddress() {
        return this.coreSession.getLocalAddress();
    }

    @Override
    public SocketAddress getRemoteSocketAddress() {
        return this.coreSession.getRemoteAddress();
    }

    @Override
    public UpgradeRequest getUpgradeRequest() {
        return this.upgradeRequest;
    }

    @Override
    public UpgradeResponse getUpgradeResponse() {
        return this.upgradeResponse;
    }

    public CoreSession getCoreSession() {
        return this.coreSession;
    }

    @Override
    public void dump(Appendable out, String indent) throws IOException {
        Dumpable.dumpObjects(out, indent, this, this.upgradeRequest, this.coreSession, this.frameHandler);
    }

    @Override
    public String dumpSelf() {
        return String.format("%s@%x[idleTimeout=%dms]", this.getClass().getSimpleName(), this.hashCode(), this.getIdleTimeout().toMillis());
    }

    public String toString() {
        return String.format("WebSocketSession[to=%s,%s,%s]", this.getIdleTimeout(), this.coreSession, this.frameHandler);
    }
}

