/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee11.websocket.server;

import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import org.eclipse.jetty.ee11.servlet.ServletContextHandler;
import org.eclipse.jetty.ee11.servlet.ServletContextRequest;
import org.eclipse.jetty.ee11.servlet.ServletContextResponse;
import org.eclipse.jetty.ee11.websocket.server.JettyServerUpgradeRequest;
import org.eclipse.jetty.ee11.websocket.server.JettyServerUpgradeResponse;
import org.eclipse.jetty.ee11.websocket.server.JettyWebSocketCreator;
import org.eclipse.jetty.ee11.websocket.server.internal.DelegatedServerUpgradeRequest;
import org.eclipse.jetty.ee11.websocket.server.internal.DelegatedServerUpgradeResponse;
import org.eclipse.jetty.ee11.websocket.server.internal.JettyServerFrameHandlerFactory;
import org.eclipse.jetty.ee11.websocket.servlet.WebSocketUpgradeFilter;
import org.eclipse.jetty.http.pathmap.PathSpec;
import org.eclipse.jetty.util.Blocker;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.websocket.api.Configurable;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.WebSocketContainer;
import org.eclipse.jetty.websocket.api.WebSocketSessionListener;
import org.eclipse.jetty.websocket.common.SessionTracker;
import org.eclipse.jetty.websocket.core.Configuration;
import org.eclipse.jetty.websocket.core.WebSocketComponents;
import org.eclipse.jetty.websocket.core.exception.WebSocketException;
import org.eclipse.jetty.websocket.core.server.WebSocketCreator;
import org.eclipse.jetty.websocket.core.server.WebSocketMappings;
import org.eclipse.jetty.websocket.core.server.WebSocketNegotiator;
import org.eclipse.jetty.websocket.core.server.WebSocketServerComponents;
import org.eclipse.jetty.websocket.core.util.ReflectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JettyWebSocketServerContainer
extends ContainerLifeCycle
implements WebSocketContainer,
Configurable,
LifeCycle.Listener {
    public static final String JETTY_WEBSOCKET_CONTAINER_ATTRIBUTE = WebSocketContainer.class.getName();
    private static final Logger LOG = LoggerFactory.getLogger(JettyWebSocketServerContainer.class);
    private final ServletContextHandler contextHandler;
    private final WebSocketMappings webSocketMappings;
    private final WebSocketComponents components;
    private final JettyServerFrameHandlerFactory frameHandlerFactory;
    private final Executor executor;
    private final Configuration.ConfigurationCustomizer customizer = new Configuration.ConfigurationCustomizer();
    private final List<WebSocketSessionListener> sessionListeners = new ArrayList<WebSocketSessionListener>();
    private final SessionTracker sessionTracker = new SessionTracker();

    public static JettyWebSocketServerContainer getContainer(ServletContext servletContext) {
        return (JettyWebSocketServerContainer)servletContext.getAttribute(JETTY_WEBSOCKET_CONTAINER_ATTRIBUTE);
    }

    public static JettyWebSocketServerContainer ensureContainer(ServletContext servletContext) {
        final ServletContextHandler contextHandler = ServletContextHandler.getServletContextHandler(servletContext, "Jakarta Websocket");
        if (contextHandler.getServer() == null) {
            throw new IllegalStateException("Server has not been set on the ServletContextHandler");
        }
        JettyWebSocketServerContainer containerFromServletContext = JettyWebSocketServerContainer.getContainer(servletContext);
        if (containerFromServletContext != null) {
            return containerFromServletContext;
        }
        Executor executor = (Executor)servletContext.getAttribute("org.eclipse.jetty.server.Executor");
        if (executor == null) {
            executor = contextHandler.getServer().getThreadPool();
        }
        WebSocketMappings mappings = WebSocketMappings.ensureMappings(contextHandler);
        WebSocketComponents components = WebSocketServerComponents.getWebSocketComponents(contextHandler);
        final JettyWebSocketServerContainer container = new JettyWebSocketServerContainer(contextHandler, mappings, components, executor);
        contextHandler.addManaged(container);
        contextHandler.addEventListener(container);
        contextHandler.addEventListener(new LifeCycle.Listener(){

            @Override
            public void lifeCycleStopping(LifeCycle event) {
                contextHandler.getServletContext().removeAttribute(JETTY_WEBSOCKET_CONTAINER_ATTRIBUTE);
                contextHandler.removeBean(container);
                contextHandler.removeEventListener(container);
                contextHandler.removeEventListener(this);
            }

            public String toString() {
                return String.format("%sCleanupListener", JettyWebSocketServerContainer.class.getSimpleName());
            }
        });
        servletContext.setAttribute(JETTY_WEBSOCKET_CONTAINER_ATTRIBUTE, container);
        return container;
    }

    JettyWebSocketServerContainer(ServletContextHandler contextHandler, WebSocketMappings webSocketMappings, WebSocketComponents components, Executor executor) {
        this.contextHandler = contextHandler;
        this.webSocketMappings = webSocketMappings;
        this.components = components;
        this.executor = executor;
        this.frameHandlerFactory = new JettyServerFrameHandlerFactory(this, components);
        this.installBean(this.frameHandlerFactory);
        this.addSessionListener(this.sessionTracker);
        this.installBean(this.sessionTracker);
    }

    public void addMapping(String pathSpec, JettyWebSocketCreator creator) {
        PathSpec ps = WebSocketMappings.parsePathSpec(pathSpec);
        if (this.webSocketMappings.getWebSocketNegotiator(ps) != null) {
            throw new WebSocketException("Duplicate WebSocket Mapping for PathSpec");
        }
        WebSocketUpgradeFilter.ensureFilter(this.contextHandler.getServletContext());
        WebSocketCreator coreCreator = (req, resp, cb) -> {
            try {
                Object webSocket = creator.createWebSocket(new DelegatedServerUpgradeRequest(req), new DelegatedServerUpgradeResponse(resp));
                if (webSocket == null) {
                    cb.succeeded();
                }
                return webSocket;
            }
            catch (Throwable t) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Could not create WebSocket endpoint", t);
                }
                cb.failed(t);
                return null;
            }
        };
        this.webSocketMappings.addMapping(ps, coreCreator, this.frameHandlerFactory, this.customizer);
    }

    public void addMapping(String pathSpec, Class<?> endpointClass) {
        if (!ReflectUtils.isDefaultConstructable(endpointClass)) {
            throw new IllegalArgumentException("Cannot access default constructor for the class: " + endpointClass.getName());
        }
        this.addMapping(pathSpec, (JettyServerUpgradeRequest req, JettyServerUpgradeResponse resp) -> {
            try {
                return endpointClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new org.eclipse.jetty.websocket.api.exceptions.WebSocketException("Unable to create instance of " + endpointClass.getName(), e);
            }
        });
    }

    public boolean upgrade(JettyWebSocketCreator creator, HttpServletRequest request, HttpServletResponse response) throws IOException {
        WebSocketCreator coreCreator = (req, resp, cb) -> {
            try {
                Object webSocket = creator.createWebSocket(new DelegatedServerUpgradeRequest(req), new DelegatedServerUpgradeResponse(resp));
                if (webSocket == null) {
                    cb.succeeded();
                }
                return webSocket;
            }
            catch (Throwable t) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Could not create WebSocket endpoint", t);
                }
                cb.failed(t);
                return null;
            }
        };
        ServletContextRequest servletContextRequest = ServletContextRequest.getServletContextRequest(request);
        ServletContextResponse servletContextResponse = servletContextRequest.getServletContextResponse();
        WebSocketNegotiator negotiator = WebSocketNegotiator.from(coreCreator, this.frameHandlerFactory);
        servletContextRequest.setAttribute("org.eclipse.jetty.websocket.wrappedRequest", request);
        servletContextRequest.setAttribute("org.eclipse.jetty.websocket.wrappedResponse", response);
        try {
            Blocker.Callback callback = Blocker.callback();
            try {
                boolean upgraded = this.webSocketMappings.upgrade(negotiator, servletContextRequest, servletContextResponse, callback, this.customizer);
                if (upgraded) {
                    callback.block();
                }
                boolean bl = upgraded;
                if (callback != null) {
                    callback.close();
                }
                return bl;
            }
            catch (Throwable throwable) {
                if (callback != null) {
                    try {
                        callback.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        finally {
            servletContextRequest.removeAttribute("org.eclipse.jetty.websocket.wrappedRequest");
            servletContextRequest.removeAttribute("org.eclipse.jetty.websocket.wrappedResponse");
        }
    }

    @Override
    public Executor getExecutor() {
        return this.executor;
    }

    @Override
    public void addSessionListener(WebSocketSessionListener listener) {
        this.sessionListeners.add(listener);
    }

    @Override
    public boolean removeSessionListener(WebSocketSessionListener listener) {
        return this.sessionListeners.remove(listener);
    }

    @Override
    public void notifySessionListeners(Consumer<WebSocketSessionListener> consumer) {
        for (WebSocketSessionListener listener : this.sessionListeners) {
            try {
                consumer.accept(listener);
            }
            catch (Throwable x) {
                LOG.info("Exception while invoking listener {}", (Object)listener, (Object)x);
            }
        }
    }

    @Override
    public Collection<Session> getOpenSessions() {
        return this.sessionTracker.getSessions();
    }

    @Override
    public Duration getIdleTimeout() {
        return this.customizer.getIdleTimeout();
    }

    @Override
    public void setIdleTimeout(Duration duration) {
        this.customizer.setIdleTimeout(duration);
    }

    @Override
    public int getInputBufferSize() {
        return this.customizer.getInputBufferSize();
    }

    @Override
    public void setInputBufferSize(int size) {
        this.customizer.setInputBufferSize(size);
    }

    @Override
    public int getOutputBufferSize() {
        return this.customizer.getOutputBufferSize();
    }

    @Override
    public void setOutputBufferSize(int size) {
        this.customizer.setOutputBufferSize(size);
    }

    @Override
    public long getMaxBinaryMessageSize() {
        return this.customizer.getMaxBinaryMessageSize();
    }

    @Override
    public void setMaxBinaryMessageSize(long size) {
        this.customizer.setMaxBinaryMessageSize(size);
    }

    @Override
    public long getMaxTextMessageSize() {
        return this.customizer.getMaxTextMessageSize();
    }

    @Override
    public void setMaxTextMessageSize(long size) {
        this.customizer.setMaxTextMessageSize(size);
    }

    @Override
    public long getMaxFrameSize() {
        return this.customizer.getMaxFrameSize();
    }

    @Override
    public void setMaxFrameSize(long maxFrameSize) {
        this.customizer.setMaxFrameSize(maxFrameSize);
    }

    @Override
    public boolean isAutoFragment() {
        return this.customizer.isAutoFragment();
    }

    @Override
    public void setAutoFragment(boolean autoFragment) {
        this.customizer.setAutoFragment(autoFragment);
    }

    @Override
    public int getMaxOutgoingFrames() {
        return this.customizer.getMaxOutgoingFrames();
    }

    @Override
    public void setMaxOutgoingFrames(int maxOutgoingFrames) {
        this.customizer.setMaxOutgoingFrames(maxOutgoingFrames);
    }

    @Override
    public void dump(Appendable out, String indent) throws IOException {
        Dumpable.dumpObjects(out, indent, this, this.customizer);
    }
}

