/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee11.servlet;

import org.eclipse.jetty.ee11.servlet.AsyncContentProducer;
import org.eclipse.jetty.ee11.servlet.ContentProducer;
import org.eclipse.jetty.io.Content;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BlockingContentProducer
implements ContentProducer {
    private static final Logger LOG = LoggerFactory.getLogger(BlockingContentProducer.class);
    private final AsyncContentProducer _asyncContentProducer;
    private final AsyncContentProducer.LockedSemaphore _semaphore;

    BlockingContentProducer(AsyncContentProducer asyncContentProducer) {
        this._asyncContentProducer = asyncContentProducer;
        this._semaphore = this._asyncContentProducer.newLockedSemaphore();
    }

    @Override
    public void recycle() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("recycling {}", (Object)this);
        }
        this._asyncContentProducer.recycle();
    }

    @Override
    public void reopen() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("reopening {}", (Object)this);
        }
        this._asyncContentProducer.reopen();
        this._semaphore.drainPermits();
    }

    @Override
    public int available() {
        return this._asyncContentProducer.available();
    }

    @Override
    public boolean hasChunk() {
        return this._asyncContentProducer.hasChunk();
    }

    @Override
    public boolean isError() {
        return this._asyncContentProducer.isError();
    }

    @Override
    public void checkMinDataRate() {
        this._asyncContentProducer.checkMinDataRate();
    }

    @Override
    public long getBytesArrived() {
        return this._asyncContentProducer.getBytesArrived();
    }

    @Override
    public boolean consumeAvailable() {
        boolean eof = this._asyncContentProducer.consumeAvailable();
        this._semaphore.release();
        return eof;
    }

    @Override
    public Content.Chunk nextChunk() {
        while (true) {
            Content.Chunk chunk = this._asyncContentProducer.nextChunk();
            if (LOG.isDebugEnabled()) {
                LOG.debug("nextContent async producer returned {}", (Object)chunk);
            }
            if (chunk != null) {
                return chunk;
            }
            if (this._asyncContentProducer.isReady()) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("nextContent async producer is ready, retrying");
                continue;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("nextContent async producer is not ready, waiting on semaphore {}", (Object)this._semaphore);
            }
            try {
                this._semaphore.acquire();
            }
            catch (InterruptedException e) {
                return Content.Chunk.from(e);
            }
        }
    }

    @Override
    public void reclaim(Content.Chunk chunk) {
        this._asyncContentProducer.reclaim(chunk);
    }

    @Override
    public boolean isReady() {
        boolean ready;
        boolean bl = ready = this.available() > 0;
        if (LOG.isDebugEnabled()) {
            LOG.debug("isReady = {}", (Object)ready);
        }
        return ready;
    }

    @Override
    public boolean onContentProducible() {
        this._semaphore.assertLocked();
        boolean unready = this._asyncContentProducer.isUnready();
        boolean error = this._asyncContentProducer.isError();
        if (LOG.isDebugEnabled()) {
            LOG.debug("onContentProducible releasing semaphore {} unready={} error={}", this._semaphore, unready, error);
        }
        if (unready) {
            this._asyncContentProducer.getServletChannel().getServletRequestState().onReadIdle();
            this._semaphore.release();
        }
        if (error) {
            this._semaphore.fail();
        }
        return false;
    }
}

