/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee11.annotations;

import jakarta.annotation.PreDestroy;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.eclipse.jetty.ee11.annotations.AnnotationIntrospector;
import org.eclipse.jetty.ee11.webapp.Origin;
import org.eclipse.jetty.ee11.webapp.WebAppContext;
import org.eclipse.jetty.plus.annotation.LifeCycleCallbackCollection;
import org.eclipse.jetty.plus.annotation.PreDestroyCallback;

public class PreDestroyAnnotationHandler
extends AnnotationIntrospector.AbstractIntrospectableAnnotationHandler {
    public PreDestroyAnnotationHandler(WebAppContext wac) {
        super(true, wac);
    }

    @Override
    public void doHandle(Class<?> clazz) {
        if (this.supportsPreDestroy(clazz)) {
            Method[] methods;
            for (Method method : methods = clazz.getDeclaredMethods()) {
                if (!method.isAnnotationPresent(PreDestroy.class)) continue;
                if (method.getParameterCount() != 0) {
                    throw new IllegalStateException(String.valueOf(method) + " has parameters");
                }
                if (method.getReturnType() != Void.TYPE) {
                    throw new IllegalStateException(String.valueOf(method) + " is not void");
                }
                if (method.getExceptionTypes().length != 0) {
                    throw new IllegalStateException(String.valueOf(method) + " throws checked exceptions");
                }
                if (Modifier.isStatic(method.getModifiers())) {
                    throw new IllegalStateException(String.valueOf(method) + " is static");
                }
                Origin origin = this._context.getMetaData().getOrigin("pre-destroy");
                if (origin == Origin.WebXml || origin == Origin.WebDefaults || origin == Origin.WebOverride) {
                    return;
                }
                PreDestroyCallback callback = new PreDestroyCallback(clazz, method.getName());
                LifeCycleCallbackCollection lifecycles = (LifeCycleCallbackCollection)this._context.getAttribute("org.eclipse.jetty.lifecyleCallbackCollection");
                if (lifecycles == null) {
                    lifecycles = new LifeCycleCallbackCollection();
                    this._context.setAttribute("org.eclipse.jetty.lifecyleCallbackCollection", lifecycles);
                }
                lifecycles.add(callback);
            }
        }
    }

    public boolean supportsPreDestroy(Class<?> c) {
        return PreDestroyAnnotationHandler.isAnnotatableServletClass(c);
    }
}

