/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee11.proxy;

import jakarta.servlet.AsyncContext;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.client.AsyncRequestContent;
import org.eclipse.jetty.client.InputStreamRequestContent;
import org.eclipse.jetty.client.Request;
import org.eclipse.jetty.client.Response;
import org.eclipse.jetty.client.Result;
import org.eclipse.jetty.ee11.proxy.AbstractProxyServlet;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.util.Callback;

public class ProxyServlet
extends AbstractProxyServlet {
    private static final String CONTINUE_ACTION_ATTRIBUTE = ProxyServlet.class.getName() + ".continueAction";

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        int requestId = this.getRequestId(request);
        String rewrittenTarget = this.rewriteTarget(request);
        if (this._log.isDebugEnabled()) {
            StringBuffer uri = request.getRequestURL();
            if (request.getQueryString() != null) {
                uri.append("?").append(request.getQueryString());
            }
            if (this._log.isDebugEnabled()) {
                this._log.debug("{} rewriting: {} -> {}", new Object[]{requestId, uri, rewrittenTarget});
            }
        }
        if (rewrittenTarget == null) {
            this.onProxyRewriteFailed(request, response);
            return;
        }
        Request proxyRequest = this.newProxyRequest(request, rewrittenTarget);
        this.copyRequestHeaders(request, proxyRequest);
        this.addProxyHeaders(request, proxyRequest);
        AsyncContext asyncContext = request.startAsync();
        asyncContext.setTimeout(0L);
        proxyRequest.timeout(this.getTimeout(), TimeUnit.MILLISECONDS);
        if (this.hasContent(request)) {
            if (this.expects100Continue(request)) {
                AsyncRequestContent delegate = new AsyncRequestContent(new ByteBuffer[0]);
                proxyRequest.body((Request.Content)delegate);
                proxyRequest.attribute(CONTINUE_ACTION_ATTRIBUTE, () -> {
                    try {
                        Request.Content content = this.proxyRequestContent(request, response, proxyRequest);
                        Content.copy((Content.Source)content, (Content.Sink)delegate, (Callback)Callback.from(() -> ((AsyncRequestContent)delegate).close(), x -> this.onClientRequestFailure(request, proxyRequest, response, (Throwable)x)));
                    }
                    catch (Throwable failure) {
                        this.onClientRequestFailure(request, proxyRequest, response, failure);
                    }
                });
            } else {
                proxyRequest.body(this.proxyRequestContent(request, response, proxyRequest));
            }
        }
        this.sendProxyRequest(request, response, proxyRequest);
    }

    protected Request.Content proxyRequestContent(HttpServletRequest request, HttpServletResponse response, Request proxyRequest) throws IOException {
        return new ProxyInputStreamRequestContent(request, response, proxyRequest, (InputStream)request.getInputStream());
    }

    protected Response.Listener newProxyResponseListener(HttpServletRequest request, HttpServletResponse response) {
        return new ProxyResponseListener(request, response);
    }

    protected void onResponseContent(HttpServletRequest request, HttpServletResponse response, Response proxyResponse, byte[] buffer, int offset, int length, Callback callback) {
        try {
            if (this._log.isDebugEnabled()) {
                this._log.debug("{} proxying content to downstream: {} bytes", (Object)this.getRequestId(request), (Object)length);
            }
            response.getOutputStream().write(buffer, offset, length);
            callback.succeeded();
        }
        catch (Throwable x) {
            callback.failed(x);
        }
    }

    @Override
    protected Runnable onContinue(HttpServletRequest clientRequest, Request proxyRequest) {
        if (this._log.isDebugEnabled()) {
            this._log.debug("{} handling 100 Continue", (Object)this.getRequestId(clientRequest));
        }
        return (Runnable)proxyRequest.getAttributes().get(CONTINUE_ACTION_ATTRIBUTE);
    }

    protected class ProxyInputStreamRequestContent
    extends InputStreamRequestContent {
        private final HttpServletResponse response;
        private final Request proxyRequest;
        private final HttpServletRequest request;

        protected ProxyInputStreamRequestContent(HttpServletRequest request, HttpServletResponse response, Request proxyRequest, InputStream input) {
            super(input);
            this.request = request;
            this.response = response;
            this.proxyRequest = proxyRequest;
        }

        public long getLength() {
            return this.request.getContentLength();
        }

        public Content.Chunk read() {
            Content.Chunk chunk = super.read();
            if (Content.Chunk.isFailure((Content.Chunk)chunk)) {
                if (!chunk.isLast()) {
                    this.fail(chunk.getFailure());
                }
                ProxyServlet.this.onClientRequestFailure(this.request, this.proxyRequest, this.response, chunk.getFailure());
            } else if (ProxyServlet.this._log.isDebugEnabled()) {
                ProxyServlet.this._log.debug("{} proxying content to upstream: {} bytes", (Object)ProxyServlet.this.getRequestId(this.request), (Object)chunk.remaining());
            }
            return chunk;
        }
    }

    protected class ProxyResponseListener
    implements Response.Listener {
        private final HttpServletRequest request;
        private final HttpServletResponse response;

        protected ProxyResponseListener(HttpServletRequest request, HttpServletResponse response) {
            this.request = request;
            this.response = response;
        }

        public void onBegin(Response proxyResponse) {
            this.response.setStatus(proxyResponse.getStatus());
        }

        public void onHeaders(Response proxyResponse) {
            ProxyServlet.this.onServerResponseHeaders(this.request, this.response, proxyResponse);
        }

        public void onContent(Response proxyResponse, Content.Chunk chunk, Runnable demander) {
            int offset;
            byte[] buffer;
            ByteBuffer content = chunk.getByteBuffer();
            int length = content.remaining();
            if (content.hasArray()) {
                buffer = content.array();
                offset = content.arrayOffset();
            } else {
                buffer = new byte[length];
                content.get(buffer);
                offset = 0;
            }
            chunk.retain();
            Callback callback = Callback.from(() -> ((Content.Chunk)chunk).release(), (Callback)Callback.from((Runnable)demander, arg_0 -> ((Response)proxyResponse).abort(arg_0)));
            ProxyServlet.this.onResponseContent(this.request, this.response, proxyResponse, buffer, offset, length, callback);
        }

        public void onComplete(Result result) {
            if (result.isSucceeded()) {
                ProxyServlet.this.onProxyResponseSuccess(this.request, this.response, result.getResponse());
            } else {
                ProxyServlet.this.onProxyResponseFailure(this.request, this.response, result.getResponse(), result.getFailure());
            }
            if (ProxyServlet.this._log.isDebugEnabled()) {
                ProxyServlet.this._log.debug("{} proxying complete", (Object)ProxyServlet.this.getRequestId(this.request));
            }
        }
    }

    public static class Transparent
    extends ProxyServlet {
        private final AbstractProxyServlet.TransparentDelegate delegate = new AbstractProxyServlet.TransparentDelegate(this);

        public void init(ServletConfig config) throws ServletException {
            super.init(config);
            this.delegate.init(config);
        }

        @Override
        protected String rewriteTarget(HttpServletRequest request) {
            return this.delegate.rewriteTarget(request);
        }
    }
}

