/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee10.annotations;

import jakarta.annotation.Resource;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Locale;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.eclipse.jetty.ee10.annotations.AnnotationIntrospector;
import org.eclipse.jetty.ee10.servlet.ServletContextHandler;
import org.eclipse.jetty.ee10.webapp.MetaData;
import org.eclipse.jetty.ee10.webapp.WebAppContext;
import org.eclipse.jetty.plus.annotation.Injection;
import org.eclipse.jetty.plus.annotation.InjectionCollection;
import org.eclipse.jetty.plus.jndi.NamingEntryUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceAnnotationHandler
extends AnnotationIntrospector.AbstractIntrospectableAnnotationHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceAnnotationHandler.class);
    protected static final List<Class<?>> ENV_ENTRY_TYPES = List.of(String.class, Character.class, Integer.class, Boolean.class, Double.class, Byte.class, Short.class, Long.class, Float.class);

    public ResourceAnnotationHandler(WebAppContext wac) {
        super(true, wac);
    }

    @Override
    public void doHandle(Class<?> clazz) {
        if (this.supportsResourceInjection(clazz)) {
            Field[] fields;
            Method[] methods;
            this.handleClass(clazz);
            for (Method method : methods = clazz.getDeclaredMethods()) {
                this.handleMethod(clazz, method);
            }
            for (Field field : fields = clazz.getDeclaredFields()) {
                this.handleField(clazz, field);
            }
        }
    }

    public void handleClass(Class<?> clazz) {
        Resource resource = clazz.getAnnotation(Resource.class);
        if (resource != null) {
            String name = resource.name();
            String mappedName = resource.mappedName();
            if (name == null || name.trim().isEmpty()) {
                throw new IllegalStateException("Class level Resource annotations must contain a name (Common Annotations Spec Section 2.3)");
            }
            try {
                if (!NamingEntryUtil.bindToENC(this._context, name, mappedName) && !NamingEntryUtil.bindToENC(this._context.getServer(), name, mappedName)) {
                    throw new IllegalStateException("No resource at " + (mappedName == null ? name : mappedName));
                }
            }
            catch (NamingException e) {
                LOG.warn("Unable to bind name {} to {} from class {}", name, mappedName, clazz, e);
            }
        }
    }

    public void handleField(Class<?> clazz, Field field) {
        block18: {
            Resource resource = field.getAnnotation(Resource.class);
            if (resource != null) {
                Injection injection;
                if (Modifier.isStatic(field.getModifiers())) {
                    LOG.warn("Skipping Resource annotation on {}.{}: cannot be static", (Object)clazz.getName(), (Object)field.getName());
                    return;
                }
                if (Modifier.isFinal(field.getModifiers())) {
                    LOG.warn("Skipping Resource annotation on {}.{}: cannot be final", (Object)clazz.getName(), (Object)field.getName());
                    return;
                }
                String name = clazz.getName() + "/" + field.getName();
                name = resource.name() != null && !resource.name().trim().isEmpty() ? resource.name() : name;
                String mappedName = resource.mappedName() != null && !resource.mappedName().trim().isEmpty() ? resource.mappedName() : null;
                Class<?> type = field.getType();
                MetaData metaData = this._context.getMetaData();
                if (metaData.getOriginDescriptor("resource-ref." + name + ".injection") != null) {
                    return;
                }
                InjectionCollection injections = (InjectionCollection)this._context.getAttribute("org.eclipse.jetty.injectionCollection");
                if (injections == null) {
                    injections = new InjectionCollection();
                    this._context.setAttribute("org.eclipse.jetty.injectionCollection", injections);
                }
                if ((injection = injections.getInjection(name, clazz, field)) == null) {
                    try {
                        boolean bound;
                        block17: {
                            bound = NamingEntryUtil.bindToENC(this._context, name, mappedName);
                            if (!bound) {
                                bound = NamingEntryUtil.bindToENC(ServletContextHandler.ENVIRONMENT.getName(), name, mappedName);
                            }
                            if (!bound) {
                                bound = NamingEntryUtil.bindToENC(this._context.getServer(), name, mappedName);
                            }
                            if (!bound) {
                                bound = NamingEntryUtil.bindToENC(null, name, mappedName);
                            }
                            if (!bound) {
                                try {
                                    InitialContext ic = new InitialContext();
                                    Object nameInEnvironment = mappedName != null ? mappedName : name;
                                    ic.lookup("java:comp/env/" + (String)nameInEnvironment);
                                    bound = true;
                                }
                                catch (NameNotFoundException e) {
                                    if (!LOG.isTraceEnabled()) break block17;
                                    LOG.trace("ignored", e);
                                }
                            }
                        }
                        if (bound) {
                            LOG.debug("Bound {} as {}", mappedName == null ? name : mappedName, (Object)name);
                            injection = new Injection(clazz, field, type, name, mappedName);
                            injections.add(injection);
                            metaData.setOrigin("resource-ref." + name + ".injection", resource, clazz);
                        } else if (!this.isEnvEntryType(type)) {
                            throw new IllegalStateException("No resource at " + (String)(mappedName == null ? name : mappedName));
                        }
                    }
                    catch (NamingException e) {
                        if (this.isEnvEntryType(type)) break block18;
                        throw new IllegalStateException(e);
                    }
                }
            }
        }
    }

    public void handleMethod(Class<?> clazz, Method method) {
        block20: {
            Resource resource = method.getAnnotation(Resource.class);
            if (resource != null) {
                Injection injection;
                if (Modifier.isStatic(method.getModifiers())) {
                    LOG.warn("Skipping Resource annotation on {}.{}: cannot be static", (Object)clazz.getName(), (Object)method.getName());
                    return;
                }
                if (!method.getName().startsWith("set")) {
                    LOG.warn("Skipping Resource annotation on {}.{}: invalid java bean, does not start with 'set'", (Object)clazz.getName(), (Object)method.getName());
                    return;
                }
                if (method.getParameterCount() != 1) {
                    LOG.warn("Skipping Resource annotation on {}.{}: invalid java bean, not single argument to method", (Object)clazz.getName(), (Object)method.getName());
                    return;
                }
                if (Void.TYPE != method.getReturnType()) {
                    LOG.warn("Skipping Resource annotation on {}.{}: invalid java bean, not void", (Object)clazz.getName(), (Object)method.getName());
                    return;
                }
                Object name = method.getName().substring(3);
                name = ((String)name).substring(0, 1).toLowerCase(Locale.ENGLISH) + ((String)name).substring(1);
                name = clazz.getName() + "/" + (String)name;
                name = resource.name() != null && !resource.name().trim().isEmpty() ? resource.name() : name;
                String mappedName = resource.mappedName() != null && !resource.mappedName().trim().isEmpty() ? resource.mappedName() : null;
                Class<?> paramType = method.getParameterTypes()[0];
                Class<?> resourceType = resource.type();
                MetaData metaData = this._context.getMetaData();
                if (metaData.getOriginDescriptor("resource-ref." + (String)name + ".injection") != null) {
                    return;
                }
                InjectionCollection injections = (InjectionCollection)this._context.getAttribute("org.eclipse.jetty.injectionCollection");
                if (injections == null) {
                    injections = new InjectionCollection();
                    this._context.setAttribute("org.eclipse.jetty.injectionCollection", injections);
                }
                if ((injection = injections.getInjection((String)name, clazz, method, paramType)) == null) {
                    try {
                        boolean bound;
                        block19: {
                            bound = NamingEntryUtil.bindToENC(this._context, (String)name, mappedName);
                            if (!bound) {
                                bound = NamingEntryUtil.bindToENC(ServletContextHandler.ENVIRONMENT.getName(), (String)name, mappedName);
                            }
                            if (!bound) {
                                bound = NamingEntryUtil.bindToENC(this._context.getServer(), (String)name, mappedName);
                            }
                            if (!bound) {
                                bound = NamingEntryUtil.bindToENC(null, (String)name, mappedName);
                            }
                            if (!bound) {
                                try {
                                    InitialContext ic = new InitialContext();
                                    Object nameInEnvironment = mappedName != null ? mappedName : name;
                                    ic.lookup("java:comp/env/" + (String)nameInEnvironment);
                                    bound = true;
                                }
                                catch (NameNotFoundException e) {
                                    if (!LOG.isTraceEnabled()) break block19;
                                    LOG.trace("ignored", e);
                                }
                            }
                        }
                        if (bound) {
                            LOG.debug("Bound {} as {}", mappedName == null ? name : mappedName, name);
                            injection = new Injection(clazz, method, paramType, resourceType, (String)name, mappedName);
                            injections.add(injection);
                            metaData.setOrigin("resource-ref." + (String)name + ".injection", resource, clazz);
                        } else if (!this.isEnvEntryType(paramType)) {
                            throw new IllegalStateException("No resource at " + (String)(mappedName == null ? name : mappedName));
                        }
                    }
                    catch (NamingException e) {
                        if (this.isEnvEntryType(paramType)) break block20;
                        throw new IllegalStateException(e);
                    }
                }
            }
        }
    }

    public boolean supportsResourceInjection(Class<?> c) {
        return ResourceAnnotationHandler.isAnnotatableServletClass(c);
    }

    public boolean isEnvEntryType(Class<?> clazz) {
        return ENV_ENTRY_TYPES.contains(clazz);
    }
}

