/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee10.annotations;

import jakarta.annotation.security.DeclareRoles;
import jakarta.servlet.Servlet;
import org.eclipse.jetty.ee10.annotations.AnnotationIntrospector;
import org.eclipse.jetty.ee10.servlet.security.ConstraintAware;
import org.eclipse.jetty.ee10.servlet.security.ConstraintSecurityHandler;
import org.eclipse.jetty.ee10.webapp.WebAppContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeclareRolesAnnotationHandler
extends AnnotationIntrospector.AbstractIntrospectableAnnotationHandler {
    private static final Logger LOG = LoggerFactory.getLogger(DeclareRolesAnnotationHandler.class);

    public DeclareRolesAnnotationHandler(WebAppContext context) {
        super(false, context);
    }

    @Override
    public void doHandle(Class<?> clazz) {
        if (!Servlet.class.isAssignableFrom(clazz)) {
            return;
        }
        if (!(this._context.getSecurityHandler() instanceof ConstraintAware)) {
            LOG.warn("SecurityHandler not ConstraintAware, skipping security annotation processing");
            return;
        }
        DeclareRoles declareRoles = clazz.getAnnotation(DeclareRoles.class);
        if (declareRoles == null) {
            return;
        }
        String[] roles = declareRoles.value();
        if (roles != null) {
            for (String r : roles) {
                ((ConstraintSecurityHandler)this._context.getSecurityHandler()).addKnownRole(r);
                this._context.getMetaData().setOrigin("security-role." + r, declareRoles, clazz);
            }
        }
    }
}

