/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee10.quickstart;

import java.io.Closeable;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jetty.ee10.servlet.ServletContainerInitializerHolder;
import org.eclipse.jetty.ee10.servlet.ServletMapping;
import org.eclipse.jetty.ee10.webapp.DefaultsDescriptor;
import org.eclipse.jetty.ee10.webapp.Descriptor;
import org.eclipse.jetty.ee10.webapp.IterativeDescriptorProcessor;
import org.eclipse.jetty.ee10.webapp.WebAppContext;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.QuotedStringTokenizer;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.resource.AttributeNormalizer;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceFactory;
import org.eclipse.jetty.util.resource.Resources;
import org.eclipse.jetty.xml.XmlParser;

public class QuickStartDescriptorProcessor
extends IterativeDescriptorProcessor
implements Closeable {
    private String _originAttributeName = null;
    private ResourceFactory.Closeable _resourceFactory = ResourceFactory.closeable();

    public QuickStartDescriptorProcessor() {
        try {
            this.registerVisitor("context-param", this.getClass().getMethod("visitContextParam", __signature));
            this.registerVisitor("servlet-mapping", this.getClass().getMethod("visitServletMapping", __signature));
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public void start(WebAppContext context, Descriptor descriptor) {
        this._originAttributeName = context.getInitParameter("org.eclipse.jetty.originAttribute");
    }

    public void end(WebAppContext context, Descriptor descriptor) {
        this._originAttributeName = null;
    }

    @Override
    public void close() {
        IO.close((Closeable)this._resourceFactory);
        this._resourceFactory = null;
    }

    public void visitServletMapping(WebAppContext context, Descriptor descriptor, XmlParser.Node node) {
        String origin;
        String servletName = node.getString("servlet-name", false, true);
        ServletMapping mapping = null;
        ServletMapping[] mappings = context.getServletHandler().getServletMappings();
        if (mappings != null) {
            for (ServletMapping m : mappings) {
                if (!servletName.equals(m.getServletName())) continue;
                mapping = m;
                break;
            }
        }
        if (mapping != null && this._originAttributeName != null && !StringUtil.isBlank((String)(origin = node.getAttribute(this._originAttributeName))) && origin.startsWith(DefaultsDescriptor.class.getSimpleName())) {
            mapping.setFromDefaultDescriptor(true);
        }
    }

    public void visitContextParam(WebAppContext context, Descriptor descriptor, XmlParser.Node node) throws Exception {
        String name = node.getString("param-name", false, true);
        String value = node.getString("param-value", false, true);
        ArrayList<String> values = new ArrayList<String>();
        switch (name) {
            case "org.eclipse.jetty.originAttribute": {
                break;
            }
            case "jakarta.servlet.context.orderedLibs": 
            case "org.eclipse.jetty.containerInitializers": 
            case "org.eclipse.jetty.tlds": 
            case "org.eclipse.jetty.resources": {
                context.removeAttribute(name);
                Iterator i = QuotedStringTokenizer.CSV.tokenize(value);
                while (i.hasNext()) {
                    String token = (String)i.next();
                    values.add(token);
                }
                break;
            }
            default: {
                values.add(value);
            }
        }
        AttributeNormalizer normalizer = new AttributeNormalizer(context.getBaseResource());
        switch (name) {
            case "org.eclipse.jetty.originAttribute": {
                context.setAttribute("org.eclipse.jetty.originAttribute", (Object)value);
                break;
            }
            case "jakarta.servlet.context.orderedLibs": {
                ArrayList libs = new ArrayList();
                Object o = context.getAttribute("jakarta.servlet.context.orderedLibs");
                if (o instanceof Collection) {
                    libs.addAll((Collection)o);
                }
                libs.addAll(values);
                if (libs.isEmpty()) break;
                context.setAttribute("jakarta.servlet.context.orderedLibs", (Object)libs);
                break;
            }
            case "org.eclipse.jetty.containerInitializers": {
                for (String s : values) {
                    this.visitServletContainerInitializerHolder(context, ServletContainerInitializerHolder.fromString((ClassLoader)Thread.currentThread().getContextClassLoader(), (String)s));
                }
                break;
            }
            case "org.eclipse.jetty.tlds": {
                ArrayList<URL> tlds = new ArrayList<URL>();
                Object o = context.getAttribute("org.eclipse.jetty.tlds");
                if (o instanceof Collection) {
                    tlds.addAll((Collection)o);
                }
                for (String i : values) {
                    String entry = normalizer.expand(i);
                    tlds.add(context.getResourceFactory().newResource(entry).getURI().toURL());
                }
                context.setAttribute("org.eclipse.jetty.tlds", tlds);
                break;
            }
            case "org.eclipse.jetty.resources": {
                List<URI> uris = values.stream().map(arg_0 -> ((AttributeNormalizer)normalizer).expand(arg_0)).map(arg_0 -> ((ResourceFactory)context.getResourceFactory()).newResource(arg_0)).map(Resource::getURI).toList();
                for (URI uri : uris) {
                    Resource r = this._resourceFactory.newResource(uri);
                    if (Resources.missing((Resource)r)) {
                        throw new IllegalArgumentException("Resource not found: " + String.valueOf(r));
                    }
                    this.visitMetaInfResource(context, r);
                }
                break;
            }
        }
    }

    public void visitServletContainerInitializerHolder(WebAppContext context, ServletContainerInitializerHolder sciHolder) {
        if (sciHolder == null) {
            return;
        }
        context.addServletContainerInitializer(new ServletContainerInitializerHolder[]{sciHolder});
    }

    public void visitMetaInfResource(WebAppContext context, Resource dir) {
        HashSet<Resource> metaInfResources = (HashSet<Resource>)context.getAttribute("org.eclipse.jetty.resources");
        if (metaInfResources == null) {
            metaInfResources = new HashSet<Resource>();
            context.setAttribute("org.eclipse.jetty.resources", metaInfResources);
        }
        metaInfResources.add(dir);
        ArrayList<Resource> collection = new ArrayList<Resource>();
        collection.add(context.getBaseResource());
        collection.addAll(metaInfResources);
        context.setBaseResource(ResourceFactory.combine(collection));
    }
}

