/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee10.maven.plugin;

import java.io.File;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Stream;
import org.eclipse.jetty.ee10.plus.webapp.EnvConfiguration;
import org.eclipse.jetty.ee10.servlet.FilterHolder;
import org.eclipse.jetty.ee10.servlet.FilterMapping;
import org.eclipse.jetty.ee10.servlet.ServletHolder;
import org.eclipse.jetty.ee10.servlet.ServletMapping;
import org.eclipse.jetty.ee10.webapp.Configuration;
import org.eclipse.jetty.ee10.webapp.Configurations;
import org.eclipse.jetty.ee10.webapp.WebAppContext;
import org.eclipse.jetty.maven.Overlay;
import org.eclipse.jetty.util.FileID;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.component.Container;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceFactory;
import org.eclipse.jetty.util.resource.Resources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenWebAppContext
extends WebAppContext {
    private static final Logger LOG = LoggerFactory.getLogger(MavenWebAppContext.class);
    private static final String DEFAULT_CONTAINER_INCLUDE_JAR_PATTERN = ".*/jakarta.servlet-[^/]*\\.jar$|.*/jetty-jakarta-servlet-api-[^/]*\\.jar$|.*jakarta.servlet.jsp.jstl-[^/]*\\.jar|.*taglibs-standard-[^/]*\\.jar$";
    private static final String WEB_INF_CLASSES_PREFIX = "/WEB-INF/classes";
    private static final String WEB_INF_LIB_PREFIX = "/WEB-INF/lib";
    private File _classes = null;
    private File _testClasses = null;
    private final List<File> _webInfClasses = new ArrayList<File>();
    private final List<File> _webInfJars = new ArrayList<File>();
    private final Map<String, File> _webInfJarMap = new HashMap<String, File>();
    private List<URI> _classpathUris;
    private String _jettyEnvXml;
    private List<Overlay> _overlays;
    private String _containerIncludeJarPattern = null;
    private String _webInfIncludeJarPattern = null;
    private boolean _baseAppFirst = true;

    public MavenWebAppContext() {
        super.setCopyWebInf(false);
    }

    public void setContainerIncludeJarPattern(String pattern) {
        this._containerIncludeJarPattern = pattern;
    }

    public String getContainerIncludeJarPattern() {
        return this._containerIncludeJarPattern;
    }

    public String getWebInfIncludeJarPattern() {
        return this._webInfIncludeJarPattern;
    }

    public void setWebInfIncludeJarPattern(String pattern) {
        this._webInfIncludeJarPattern = pattern;
    }

    public List<URI> getClassPathUris() {
        return this._classpathUris;
    }

    public void setJettyEnvXml(String jettyEnvXml) {
        this._jettyEnvXml = jettyEnvXml;
    }

    public String getJettyEnvXml() {
        return this._jettyEnvXml;
    }

    public void setClasses(File dir) {
        this._classes = dir;
    }

    public File getClasses() {
        return this._classes;
    }

    public void setWebInfLib(List<File> jars) {
        this._webInfJars.addAll(jars);
    }

    public void setTestClasses(File dir) {
        this._testClasses = dir;
    }

    public File getTestClasses() {
        return this._testClasses;
    }

    public void setOverlays(List<Overlay> overlays) {
        this._overlays = overlays;
    }

    public void setOriginAttribute(String name) {
        this.setAttribute("org.eclipse.jetty.quickstart.origin", name);
    }

    public String getOriginAttribute() {
        Object attr = this.getAttribute("org.eclipse.jetty.quickstart.origin");
        return attr == null ? null : attr.toString();
    }

    public List<Overlay> getOverlays() {
        return this._overlays;
    }

    public void setBaseAppFirst(boolean value) {
        this._baseAppFirst = value;
    }

    public boolean getBaseAppFirst() {
        return this._baseAppFirst;
    }

    public void setResourceBases(String[] resourceBases) {
        try {
            List<Resource> resources = Stream.of(resourceBases).map(s -> ResourceFactory.of((Container)this).newResource(s)).toList();
            this.setBaseResource(ResourceFactory.combine(resources));
        }
        catch (Throwable t) {
            throw new IllegalArgumentException("Bad resourceBases: [" + String.join((CharSequence)", ", resourceBases) + "]", t);
        }
    }

    public List<File> getWebInfLib() {
        return this._webInfJars;
    }

    public List<File> getWebInfClasses() {
        return this._webInfClasses;
    }

    public void doStart() throws Exception {
        String tmp = this._containerIncludeJarPattern;
        if (tmp == null || "".equals(tmp)) {
            tmp = (String)this.getAttribute("org.eclipse.jetty.server.webapp.ContainerIncludeJarPattern");
        }
        tmp = this.addPattern(tmp, DEFAULT_CONTAINER_INCLUDE_JAR_PATTERN);
        this.setAttribute("org.eclipse.jetty.server.webapp.ContainerIncludeJarPattern", tmp);
        if (this._webInfIncludeJarPattern != null) {
            this.setAttribute("org.eclipse.jetty.server.webapp.WebInfIncludeJarPattern", this._webInfIncludeJarPattern);
        }
        if (this._testClasses != null && this._testClasses.exists()) {
            this._webInfClasses.add(this._testClasses);
        }
        if (this._classes != null && this._classes.exists()) {
            this._webInfClasses.add(this._classes);
        }
        this._classpathUris = new ArrayList<URI>();
        this._webInfClasses.forEach(f -> this._classpathUris.add(f.toURI()));
        this._webInfJars.forEach(f -> {
            URI jarFileUri = URIUtil.toJarFileUri((URI)f.toURI());
            this._classpathUris.add(Objects.requireNonNullElseGet(jarFileUri, f::toURI));
        });
        this._webInfJarMap.clear();
        for (File file : this._webInfJars) {
            String fileName = file.getName();
            if (!FileID.isJavaArchive((String)fileName)) continue;
            this._webInfJarMap.put(fileName, file);
        }
        this.initCDI();
        super.doStart();
    }

    protected Configurations newConfigurations() {
        Configurations configurations = super.newConfigurations();
        if (this.getJettyEnvXml() != null) {
            for (Configuration c : configurations) {
                if (!(c instanceof EnvConfiguration)) continue;
                EnvConfiguration envConfiguration = (EnvConfiguration)c;
                this.setAttribute("org.eclipse.jetty.jndi.JettyEnvXml", this.getResourceFactory().newResource(this.getJettyEnvXml()));
            }
        }
        return configurations;
    }

    public void doStop() throws Exception {
        if (this._classpathUris != null) {
            this._classpathUris.clear();
        }
        this._classpathUris = null;
        this._classes = null;
        this._testClasses = null;
        if (this._webInfJarMap != null) {
            this._webInfJarMap.clear();
        }
        this._webInfClasses.clear();
        this._webInfJars.clear();
        Thread.sleep(500L);
        super.doStop();
        this.getServletHandler().setFilters(new FilterHolder[0]);
        this.getServletHandler().setFilterMappings(new FilterMapping[0]);
        this.getServletHandler().setServlets(new ServletHolder[0]);
        this.getServletHandler().setServletMappings(new ServletMapping[0]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Resource getResource(String pathInContext) throws MalformedURLException {
        Resource resource = super.getResource(pathInContext);
        if (resource != null && resource.exists() || pathInContext == null || this._classes == null) return resource;
        String uri = URIUtil.normalizePath((String)pathInContext);
        if (uri == null) {
            return null;
        }
        if (uri.startsWith(WEB_INF_CLASSES_PREFIX)) {
            if (uri.equalsIgnoreCase(WEB_INF_CLASSES_PREFIX) || uri.equalsIgnoreCase("/WEB-INF/classes/")) {
                if (this._classes != null) {
                    return this.getResourceFactory().newResource(this._classes.toPath());
                }
                if (this._testClasses == null) return resource;
                return this.getResourceFactory().newResource(this._testClasses.toPath());
            }
            Resource res = null;
            int i = 0;
            while (Resources.missing(res) && i < this._webInfClasses.size()) {
                String newPath = StringUtil.replace((String)uri, (String)WEB_INF_CLASSES_PREFIX, (String)this._webInfClasses.get(i).getPath());
                res = this.getResourceFactory().newResource(newPath);
                if (!Resources.missing((Resource)res)) continue;
                res = null;
                ++i;
            }
            return res;
        }
        if (!uri.startsWith(WEB_INF_LIB_PREFIX)) return resource;
        String jarName = StringUtil.strip((String)uri, (String)WEB_INF_LIB_PREFIX);
        if (jarName.startsWith("/") || jarName.startsWith("\\")) {
            jarName = jarName.substring(1);
        }
        if (jarName.length() == 0) {
            return null;
        }
        File jarFile = this._webInfJarMap.get(jarName);
        if (jarFile == null) return null;
        return this.getResourceFactory().newResource(jarFile.getPath());
    }

    public Set<String> getResourcePaths(String path) {
        Set paths = super.getResourcePaths(path);
        if (path != null) {
            TreeSet<String> allPaths = new TreeSet<String>(paths);
            if (path.startsWith(WEB_INF_LIB_PREFIX)) {
                for (String fileName : this._webInfJarMap.keySet()) {
                    allPaths.add("/WEB-INF/lib/" + fileName);
                }
            } else if (path.startsWith(WEB_INF_CLASSES_PREFIX)) {
                for (int i = 0; i < this._webInfClasses.size(); ++i) {
                    String newPath = StringUtil.replace((String)path, (String)WEB_INF_CLASSES_PREFIX, (String)this._webInfClasses.get(i).getPath());
                    allPaths.addAll(super.getResourcePaths(newPath));
                }
            }
            return allPaths;
        }
        return paths;
    }

    public String addPattern(String s, String pattern) {
        if (!((String)(s = s == null ? "" : ((String)s).trim())).contains(pattern)) {
            if (((String)s).length() != 0) {
                s = (String)s + "|";
            }
            s = (String)s + pattern;
        }
        return s;
    }

    public void initCDI() {
        try {
            Class<?> cdiInitializer = Thread.currentThread().getContextClassLoader().loadClass("org.eclipse.jetty.ee10.cdi.servlet.JettyWeldInitializer");
            Method initWebAppMethod = cdiInitializer.getMethod("initWebApp", WebAppContext.class);
            initWebAppMethod.invoke(null, new Object[]{this});
        }
        catch (ClassNotFoundException e) {
            LOG.debug("o.e.j.cdi.servlet.JettyWeldInitializer not found, no cdi integration available");
        }
        catch (NoSuchMethodException e) {
            LOG.warn("o.e.j.cdi.servlet.JettyWeldInitializer.initWebApp() not found, no cdi integration available");
        }
        catch (Exception e) {
            LOG.warn("Problem initializing cdi", (Throwable)e);
        }
    }
}

