/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.compression.zstandard.internal;

import com.github.luben.zstd.ZstdDecompressCtx;
import java.lang.ref.Cleaner;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.eclipse.jetty.compression.DecoderSource;
import org.eclipse.jetty.compression.zstandard.ZstandardCompression;
import org.eclipse.jetty.compression.zstandard.ZstandardDecoderConfig;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.io.Retainable;
import org.eclipse.jetty.io.RetainableByteBuffer;

public class ZstandardDecoderSource
extends DecoderSource {
    private final ZstandardCompression compression;
    private final ZstdDecompressCtx decompressCtx;
    private final int bufferSize;
    private final Cleaner.Cleanable cleanable;

    public ZstandardDecoderSource(Content.Source source, ZstandardCompression compression, ZstandardDecoderConfig config) {
        super(source);
        this.compression = compression;
        this.decompressCtx = new ZstdDecompressCtx();
        this.decompressCtx.setMagicless(config.isMagicless());
        this.bufferSize = config.getBufferSize();
        Cleaner cleaner = compression.getCleaner();
        ZstdDecompressCtx zstdDecompressCtx = this.decompressCtx;
        Objects.requireNonNull(zstdDecompressCtx);
        ZstdDecompressCtx zstdDecompressCtx2 = zstdDecompressCtx;
        this.cleanable = cleaner.register((Object)this, () -> zstdDecompressCtx2.close());
    }

    protected Content.Chunk transform(Content.Chunk inputChunk) {
        ByteBuffer input = inputChunk.getByteBuffer();
        if (!inputChunk.hasRemaining()) {
            return inputChunk;
        }
        if (!input.isDirect()) {
            throw new IllegalArgumentException("Read Chunk is not a Direct ByteBuffer");
        }
        RetainableByteBuffer.Mutable dst = this.compression.acquireByteBuffer(this.bufferSize);
        boolean last = inputChunk.isLast();
        dst.getByteBuffer().clear();
        boolean fullyFlushed = this.decompressCtx.decompressDirectByteBufferStream(dst.getByteBuffer(), input);
        if (!fullyFlushed) {
            last = false;
        }
        dst.getByteBuffer().flip();
        return Content.Chunk.asChunk((ByteBuffer)dst.getByteBuffer(), (boolean)last, (Retainable)dst);
    }

    public void release() {
        this.cleanable.clean();
    }
}

