/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.compression.zstandard;

import com.github.luben.zstd.ZstdInputStreamNoFinalizer;
import org.eclipse.jetty.compression.DecoderConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZstandardDecoderConfig
implements DecoderConfig {
    private static final Logger LOG = LoggerFactory.getLogger(ZstandardDecoderConfig.class);
    private int bufferSize = 8192;
    private boolean magicless = false;

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int size) {
        if ((long)size < ZstdInputStreamNoFinalizer.recommendedDOutSize()) {
            LOG.warn("decoder buffer size ({}) below zstd recommended value of {}", (Object)size, (Object)ZstdInputStreamNoFinalizer.recommendedDOutSize());
        }
        this.bufferSize = size;
    }

    public boolean isMagicless() {
        return this.magicless;
    }

    public void setMagicless(boolean flag) {
        this.magicless = flag;
    }
}

