/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.compression.zstandard;

import com.github.luben.zstd.Zstd;
import com.github.luben.zstd.ZstdOutputStreamNoFinalizer;
import org.eclipse.jetty.compression.EncoderConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZstandardEncoderConfig
implements EncoderConfig {
    private static final int DEFAULT_BUFFER_SIZE;
    private static final int MIN_BUFFER_SIZE = 32;
    private static final Logger LOG;
    private int bufferSize = DEFAULT_BUFFER_SIZE;
    private int level = Zstd.defaultCompressionLevel();
    private int strategy = -1;
    private boolean magicless = false;
    private boolean checksum = false;

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int size) {
        this.bufferSize = Math.max(32, size);
    }

    public int getCompressionLevel() {
        return this.level;
    }

    public void setCompressionLevel(int level) {
        if (level < 1 || level > 19) {
            throw new IllegalArgumentException("Compression Level should be in range [1, 19]");
        }
        this.level = level;
    }

    public int getStrategy() {
        return this.strategy;
    }

    public void setStrategy(int strategy) {
        if (strategy != -1 && (strategy < 1 || strategy > 9)) {
            throw new IllegalArgumentException("Strategy should be in range [1, 9] (or -1 to use default behavior)");
        }
        this.strategy = strategy;
    }

    public boolean isChecksum() {
        return this.checksum;
    }

    public void setChecksum(boolean flag) {
        this.checksum = flag;
    }

    public boolean isMagicless() {
        return this.magicless;
    }

    public void setMagicless(boolean flag) {
        this.magicless = flag;
    }

    static {
        LOG = LoggerFactory.getLogger(ZstandardEncoderConfig.class);
        long bufferSizeCeiling = 256000L;
        long bufferSize = ZstdOutputStreamNoFinalizer.recommendedCOutSize();
        if (bufferSize > bufferSizeCeiling) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Lowering zstd-jni recommended/default encoder buffer size of: {} to {}", (Object)bufferSize, (Object)bufferSizeCeiling);
            }
            bufferSize = bufferSizeCeiling;
        }
        DEFAULT_BUFFER_SIZE = (int)bufferSize;
    }
}

