/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.compression.zstandard;

import com.github.luben.zstd.ZstdDecompressCtx;
import java.nio.ByteBuffer;
import org.eclipse.jetty.compression.DecoderSource;
import org.eclipse.jetty.compression.zstandard.ZstandardCompression;
import org.eclipse.jetty.compression.zstandard.ZstandardDecoderConfig;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.io.Retainable;
import org.eclipse.jetty.io.RetainableByteBuffer;

public class ZstandardDecoderSource
extends DecoderSource {
    private final ZstandardCompression compression;
    private final ZstdDecompressCtx decompressCtx;
    private final int bufferSize;

    public ZstandardDecoderSource(ZstandardCompression compression, Content.Source src, ZstandardDecoderConfig config) {
        super(src);
        this.compression = compression;
        this.decompressCtx = new ZstdDecompressCtx();
        this.decompressCtx.setMagicless(config.isMagicless());
        this.bufferSize = config.getBufferSize();
    }

    protected Content.Chunk nextChunk(Content.Chunk readChunk) {
        ByteBuffer input = readChunk.getByteBuffer();
        if (!readChunk.hasRemaining()) {
            return readChunk;
        }
        if (!input.isDirect()) {
            throw new IllegalArgumentException("Read Chunk is not a Direct ByteBuffer");
        }
        RetainableByteBuffer dst = this.compression.acquireByteBuffer();
        boolean last = readChunk.isLast();
        dst.getByteBuffer().clear();
        boolean fullyFlushed = this.decompressCtx.decompressDirectByteBufferStream(dst.getByteBuffer(), input);
        if (!fullyFlushed) {
            last = false;
        }
        dst.getByteBuffer().flip();
        return Content.Chunk.asChunk((ByteBuffer)dst.getByteBuffer(), (boolean)last, (Retainable)dst);
    }
}

