/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.compression.brotli;

import com.aayushatharva.brotli4j.Brotli4jLoader;
import com.aayushatharva.brotli4j.decoder.BrotliInputStream;
import com.aayushatharva.brotli4j.encoder.BrotliOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteOrder;
import java.util.List;
import java.util.Objects;
import org.eclipse.jetty.compression.Compression;
import org.eclipse.jetty.compression.DecoderConfig;
import org.eclipse.jetty.compression.DecoderSource;
import org.eclipse.jetty.compression.EncoderConfig;
import org.eclipse.jetty.compression.EncoderSink;
import org.eclipse.jetty.compression.brotli.BrotliDecoderConfig;
import org.eclipse.jetty.compression.brotli.BrotliEncoderConfig;
import org.eclipse.jetty.compression.brotli.internal.BrotliDecoderSource;
import org.eclipse.jetty.compression.brotli.internal.BrotliEncoderSink;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.PreEncodedHttpField;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.io.RetainableByteBuffer;

public class BrotliCompression
extends Compression {
    private static final List<String> EXTENSIONS = List.of("br");
    private static final String ENCODING_NAME = "br";
    private static final HttpField X_CONTENT_ENCODING = new PreEncodedHttpField("X-Content-Encoding", "br");
    private static final HttpField CONTENT_ENCODING = new PreEncodedHttpField(HttpHeader.CONTENT_ENCODING, "br");
    private static final int DEFAULT_MIN_BROTLI_SIZE = 48;
    private BrotliEncoderConfig defaultEncoderConfig = new BrotliEncoderConfig();
    private BrotliDecoderConfig defaultDecoderConfig = new BrotliDecoderConfig();

    public BrotliCompression() {
        super(ENCODING_NAME);
        Brotli4jLoader.ensureAvailability();
        this.setMinCompressSize(48);
    }

    public RetainableByteBuffer.Mutable acquireByteBuffer(int length) {
        RetainableByteBuffer.Mutable buffer = this.getByteBufferPool().acquire(length, true);
        buffer.getByteBuffer().order(this.getByteOrder());
        return buffer;
    }

    public HttpField getContentEncodingField() {
        return CONTENT_ENCODING;
    }

    public DecoderConfig getDefaultDecoderConfig() {
        return this.defaultDecoderConfig;
    }

    public InputStream newDecoderInputStream(InputStream in, DecoderConfig config) throws IOException {
        BrotliDecoderConfig brotliDecoderConfig = (BrotliDecoderConfig)config;
        return new BrotliInputStream(in, brotliDecoderConfig.getBufferSize());
    }

    public EncoderConfig getDefaultEncoderConfig() {
        return this.defaultEncoderConfig;
    }

    public DecoderSource newDecoderSource(Content.Source source, DecoderConfig config) {
        BrotliDecoderConfig brotliDecoderConfig = (BrotliDecoderConfig)config;
        return new BrotliDecoderSource(source, this, brotliDecoderConfig);
    }

    public List<String> getFileExtensionNames() {
        return EXTENSIONS;
    }

    public void setMinCompressSize(int minCompressSize) {
        super.setMinCompressSize(Math.max(minCompressSize, 48));
    }

    public String getName() {
        return "brotli";
    }

    public HttpField getXContentEncodingField() {
        return X_CONTENT_ENCODING;
    }

    public OutputStream newEncoderOutputStream(OutputStream out, EncoderConfig config) throws IOException {
        BrotliEncoderConfig brotliEncoderConfig = (BrotliEncoderConfig)config;
        return new BrotliOutputStream(out, brotliEncoderConfig.asEncoderParams());
    }

    public EncoderSink newEncoderSink(Content.Sink sink, EncoderConfig config) {
        BrotliEncoderConfig brotliEncoderConfig = (BrotliEncoderConfig)config;
        return new BrotliEncoderSink(sink, brotliEncoderConfig);
    }

    public void setDefaultDecoderConfig(DecoderConfig config) {
        this.defaultDecoderConfig = (BrotliDecoderConfig)config;
    }

    public void setDefaultEncoderConfig(EncoderConfig config) {
        BrotliEncoderConfig brotliEncoderConfig = (BrotliEncoderConfig)config;
        this.defaultEncoderConfig = Objects.requireNonNull(brotliEncoderConfig);
    }

    private ByteOrder getByteOrder() {
        return ByteOrder.LITTLE_ENDIAN;
    }
}

