/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.compression.brotli.internal;

import com.aayushatharva.brotli4j.decoder.DecoderJNI;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.eclipse.jetty.compression.DecoderSource;
import org.eclipse.jetty.compression.brotli.BrotliDecoderConfig;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.util.BufferUtil;

public class BrotliDecoderSource
extends DecoderSource {
    private final DecoderJNI.Wrapper decoder;

    public BrotliDecoderSource(Content.Source source, BrotliDecoderConfig config) {
        super(source);
        try {
            this.decoder = new DecoderJNI.Wrapper(config.getBufferSize());
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to initialize Brotli Decoder", e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Content.Chunk transform(Content.Chunk inputChunk) {
        ByteBuffer compressed = inputChunk.getByteBuffer();
        if (inputChunk.isLast() && !inputChunk.hasRemaining()) {
            return Content.Chunk.EOF;
        }
        boolean last = inputChunk.isLast();
        block6: while (true) {
            switch (this.decoder.getStatus()) {
                case DONE: {
                    return last ? Content.Chunk.EOF : Content.Chunk.EMPTY;
                }
                case OK: {
                    this.decoder.push(0);
                    continue block6;
                }
                case NEEDS_MORE_INPUT: {
                    ByteBuffer input = this.decoder.getInputBuffer();
                    BufferUtil.clearToFill((ByteBuffer)input);
                    int len = BufferUtil.put((ByteBuffer)compressed, (ByteBuffer)input);
                    this.decoder.push(len);
                    if (len == 0) return Content.Chunk.EMPTY;
                    continue block6;
                }
                case NEEDS_MORE_OUTPUT: {
                    ByteBuffer output = this.decoder.pull();
                    return Content.Chunk.from((ByteBuffer)output, (boolean)false);
                }
            }
            break;
        }
        return Content.Chunk.from((Throwable)new IOException("Decoder failure: Corrupted input buffer"));
    }

    protected void release() {
        this.decoder.destroy();
    }
}

