/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.compression.brotli;

import com.aayushatharva.brotli4j.encoder.Encoder;
import org.eclipse.jetty.compression.EncoderConfig;

public class BrotliEncoderConfig
implements EncoderConfig {
    public static final int DEFAULT_QUALITY = 11;
    public static final Encoder.Mode DEFAULT_MODE = Encoder.Mode.GENERIC;
    public static final int DEFAULT_WINDOW = 22;
    public static final int MIN_BUFFER_SIZE = 32;
    private int bufferSize = 4096;
    private int quality = 11;
    private Encoder.Mode mode = DEFAULT_MODE;
    private int lgWindow = 22;

    public Encoder.Parameters asEncoderParams() {
        Encoder.Parameters params = new Encoder.Parameters();
        params.setQuality(this.getCompressionLevel());
        params.setMode(this.getMode());
        params.setWindow(this.getLgWindow());
        return params;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int size) {
        this.bufferSize = Math.max(32, size);
    }

    public int getCompressionLevel() {
        return this.quality;
    }

    public void setCompressionLevel(int level) {
        if (level < 0 || level > 11) {
            throw new IllegalArgumentException("Compression Level should be in range [0, 11]");
        }
        this.quality = level;
    }

    public int getLgWindow() {
        return this.lgWindow;
    }

    public void setLgWindow(int window) {
        if (window < 10 || window > 24) {
            throw new IllegalArgumentException("LG Window Size should be in range [10, 24]");
        }
        this.lgWindow = window;
    }

    public Encoder.Mode getMode() {
        return this.mode;
    }

    public int getStrategy() {
        return this.mode.ordinal();
    }

    public void setStrategy(int strategy) {
        if (strategy < 0 || strategy > Encoder.Mode.values().length) {
            throw new IllegalArgumentException("Unsupported brotli strategy mode: " + strategy);
        }
        this.mode = Encoder.Mode.of((int)strategy);
    }
}

