/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.compression.brotli;

import com.aayushatharva.brotli4j.decoder.DecoderJNI;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.eclipse.jetty.compression.DecoderSource;
import org.eclipse.jetty.compression.brotli.BrotliCompression;
import org.eclipse.jetty.compression.brotli.BrotliDecoderConfig;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.util.BufferUtil;

public class BrotliDecoderSource
extends DecoderSource {
    private static final ByteBuffer EMPTY_BUFFER = BufferUtil.EMPTY_BUFFER;
    private final BrotliCompression compression;
    private final DecoderJNI.Wrapper decoder;

    public BrotliDecoderSource(BrotliCompression compression, Content.Source source, BrotliDecoderConfig config) {
        super(source);
        this.compression = compression;
        try {
            this.decoder = new DecoderJNI.Wrapper(compression.getBufferSize());
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to initialize Brotli Decoder", e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Content.Chunk nextChunk(Content.Chunk readChunk) throws IOException {
        ByteBuffer compressed = readChunk.getByteBuffer();
        if (readChunk.isLast() && !readChunk.hasRemaining()) {
            return Content.Chunk.EOF;
        }
        boolean last = readChunk.isLast();
        block6: while (true) {
            switch (this.decoder.getStatus()) {
                case DONE: {
                    return last ? Content.Chunk.EOF : Content.Chunk.EMPTY;
                }
                case OK: {
                    this.decoder.push(0);
                    continue block6;
                }
                case NEEDS_MORE_INPUT: {
                    ByteBuffer input = this.decoder.getInputBuffer();
                    BufferUtil.clearToFill((ByteBuffer)input);
                    int len = BufferUtil.put((ByteBuffer)compressed, (ByteBuffer)input);
                    this.decoder.push(len);
                    if (len == 0) return Content.Chunk.EMPTY;
                    continue block6;
                }
                case NEEDS_MORE_OUTPUT: {
                    ByteBuffer output = this.decoder.pull();
                    return Content.Chunk.from((ByteBuffer)output, (boolean)false);
                }
            }
            break;
        }
        throw new IOException("Decoder failure: Corrupted input buffer");
    }

    protected void release() {
        this.decoder.destroy();
    }
}

