/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.compression.brotli;

import com.aayushatharva.brotli4j.Brotli4jLoader;
import com.aayushatharva.brotli4j.decoder.BrotliInputStream;
import com.aayushatharva.brotli4j.encoder.BrotliOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteOrder;
import java.util.List;
import java.util.Objects;
import org.eclipse.jetty.compression.Compression;
import org.eclipse.jetty.compression.DecoderConfig;
import org.eclipse.jetty.compression.DecoderSource;
import org.eclipse.jetty.compression.EncoderConfig;
import org.eclipse.jetty.compression.EncoderSink;
import org.eclipse.jetty.compression.brotli.BrotliDecoderConfig;
import org.eclipse.jetty.compression.brotli.BrotliDecoderSource;
import org.eclipse.jetty.compression.brotli.BrotliEncoderConfig;
import org.eclipse.jetty.compression.brotli.BrotliEncoderSink;
import org.eclipse.jetty.http.CompressedContentFormat;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.PreEncodedHttpField;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.io.RetainableByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrotliCompression
extends Compression {
    private static final List<String> EXTENSIONS = List.of("br");
    private static final Logger LOG = LoggerFactory.getLogger(BrotliCompression.class);
    private static final CompressedContentFormat BR = new CompressedContentFormat("br", ".br");
    private static final String ENCODING_NAME = "br";
    private static final HttpField X_CONTENT_ENCODING = new PreEncodedHttpField("X-Content-Encoding", "br");
    private static final HttpField CONTENT_ENCODING = new PreEncodedHttpField(HttpHeader.CONTENT_ENCODING, "br");
    private static final int DEFAULT_MIN_BROTLI_SIZE = 48;
    private BrotliEncoderConfig defaultEncoderConfig = new BrotliEncoderConfig();
    private BrotliDecoderConfig defaultDecoderConfig = new BrotliDecoderConfig();
    private int minCompressSize = 48;

    public BrotliCompression() {
        super(ENCODING_NAME);
    }

    public RetainableByteBuffer acquireByteBuffer() {
        return this.acquireByteBuffer(this.getBufferSize());
    }

    public RetainableByteBuffer acquireByteBuffer(int length) {
        if (length == 0) {
            return RetainableByteBuffer.EMPTY;
        }
        RetainableByteBuffer.Mutable buffer = this.getByteBufferPool().acquire(length, false);
        buffer.getByteBuffer().order(this.getByteOrder());
        return buffer;
    }

    public HttpField getContentEncodingField() {
        return CONTENT_ENCODING;
    }

    public DecoderConfig getDefaultDecoderConfig() {
        return this.defaultDecoderConfig;
    }

    public void setDefaultDecoderConfig(DecoderConfig config) {
        BrotliDecoderConfig brotliDecoderConfig;
        this.defaultDecoderConfig = brotliDecoderConfig = (BrotliDecoderConfig)BrotliDecoderConfig.class.cast(config);
    }

    public EncoderConfig getDefaultEncoderConfig() {
        return this.defaultEncoderConfig;
    }

    public void setDefaultEncoderConfig(EncoderConfig config) {
        BrotliEncoderConfig brotliEncoderConfig = (BrotliEncoderConfig)BrotliEncoderConfig.class.cast(config);
        this.defaultEncoderConfig = Objects.requireNonNull(brotliEncoderConfig);
    }

    public List<String> getFileExtensionNames() {
        return EXTENSIONS;
    }

    public int getMinCompressSize() {
        return this.minCompressSize;
    }

    public void setMinCompressSize(int minCompressSize) {
        this.minCompressSize = Math.max(minCompressSize, 48);
    }

    public String getName() {
        return "brotli";
    }

    public HttpField getXContentEncodingField() {
        return X_CONTENT_ENCODING;
    }

    public InputStream newDecoderInputStream(InputStream in, DecoderConfig config) throws IOException {
        BrotliDecoderConfig brotliDecoderConfig = (BrotliDecoderConfig)BrotliDecoderConfig.class.cast(config);
        return new BrotliInputStream(in, config.getBufferSize());
    }

    public DecoderSource newDecoderSource(Content.Source source, DecoderConfig config) {
        BrotliDecoderConfig brotliDecoderConfig = (BrotliDecoderConfig)BrotliDecoderConfig.class.cast(config);
        return new BrotliDecoderSource(this, source, brotliDecoderConfig);
    }

    public OutputStream newEncoderOutputStream(OutputStream out, EncoderConfig config) throws IOException {
        BrotliEncoderConfig brotliEncoderConfig = (BrotliEncoderConfig)BrotliEncoderConfig.class.cast(config);
        return new BrotliOutputStream(out, brotliEncoderConfig.asEncoderParams());
    }

    public EncoderSink newEncoderSink(Content.Sink sink, EncoderConfig config) {
        BrotliEncoderConfig brotliEncoderConfig = (BrotliEncoderConfig)BrotliEncoderConfig.class.cast(config);
        return new BrotliEncoderSink(this, sink, brotliEncoderConfig);
    }

    private ByteOrder getByteOrder() {
        return ByteOrder.LITTLE_ENDIAN;
    }

    static {
        Brotli4jLoader.ensureAvailability();
    }
}

