/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.compression;

import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.IteratingCallback;
import org.eclipse.jetty.util.IteratingNestedCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EncoderSink
implements Content.Sink {
    private final Content.Sink sink;

    protected EncoderSink(Content.Sink sink) {
        this.sink = sink;
    }

    public void write(boolean last, ByteBuffer content, Callback callback) {
        try {
            if (!this.canEncode(last, content)) {
                callback.succeeded();
                return;
            }
        }
        catch (Throwable t) {
            callback.failed(t);
            return;
        }
        if (content != null || last) {
            new EncodeBufferCallback(last, content, callback).iterate();
        } else {
            callback.succeeded();
        }
    }

    protected boolean canEncode(boolean last, ByteBuffer content) {
        return true;
    }

    protected abstract WriteRecord encode(boolean var1, ByteBuffer var2);

    protected void release() {
    }

    private class EncodeBufferCallback
    extends IteratingNestedCallback {
        private static final Logger LOG = LoggerFactory.getLogger(EncodeBufferCallback.class);
        private final AtomicReference<State> state;
        private final ByteBuffer content;
        private final boolean last;

        public EncodeBufferCallback(boolean last, ByteBuffer content, Callback callback) {
            super(callback);
            this.state = new AtomicReference<State>(State.INITIAL);
            this.content = content;
            this.last = last;
        }

        public String toString() {
            return String.format("%s[content=%s last=%b]", super.toString(), BufferUtil.toDetailString((ByteBuffer)this.content), this.last);
        }

        protected void finished() {
            this.state.set(State.FINISHED);
            EncoderSink.this.release();
        }

        protected void onCompleteFailure(Throwable x) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("On Complete Failure", x);
            }
            EncoderSink.this.release();
            super.onCompleteFailure(x);
        }

        protected IteratingCallback.Action process() throws Throwable {
            boolean hasRemaining;
            if (this.state.get() == State.FINISHED) {
                return IteratingCallback.Action.SUCCEEDED;
            }
            WriteRecord writeRecord = EncoderSink.this.encode(this.last, this.content);
            if (writeRecord != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("process() - write() {}", (Object)writeRecord);
                }
                this.state.compareAndSet(State.INITIAL, State.COMPRESSING);
                this.write(writeRecord);
                return IteratingCallback.Action.SCHEDULED;
            }
            boolean bl = hasRemaining = this.content != null && this.content.hasRemaining();
            if (LOG.isDebugEnabled()) {
                LOG.debug("process() - hasRemaining={}", (Object)hasRemaining);
            }
            return hasRemaining ? IteratingCallback.Action.SCHEDULED : IteratingCallback.Action.SUCCEEDED;
        }

        private void write(WriteRecord writeRecord) {
            EncodeBufferCallback callback = this;
            if (writeRecord.last) {
                this.state.set(State.FINISHING);
                callback = Callback.combine((Callback)Callback.from(this::finished), (Callback)callback);
            }
            if (writeRecord.callback != null) {
                callback = Callback.combine((Callback)callback, (Callback)writeRecord.callback);
            }
            EncoderSink.this.sink.write(writeRecord.last, writeRecord.output, (Callback)callback);
        }

        private static enum State {
            INITIAL,
            COMPRESSING,
            FINISHING,
            FINISHED;

        }
    }

    public record WriteRecord(boolean last, ByteBuffer output, Callback callback) {
    }
}

