/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.compression;

import java.io.IOException;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.util.ExceptionUtil;

public abstract class DecoderSource
implements Content.Source {
    private final Content.Source source;
    private Content.Chunk activeChunk;
    private Throwable failed;
    private boolean terminated = false;

    protected DecoderSource(Content.Source source) {
        this.source = source;
    }

    public void demand(Runnable demandCallback) {
        if (this.activeChunk != null && this.activeChunk.hasRemaining()) {
            demandCallback.run();
        } else {
            this.source.demand(demandCallback);
        }
    }

    public void fail(Throwable failure) {
        this.failed = ExceptionUtil.combine((Throwable)this.failed, (Throwable)failure);
        this.source.fail(failure);
    }

    public Content.Chunk read() {
        if (this.failed != null) {
            return Content.Chunk.from((Throwable)this.failed, (boolean)true);
        }
        if (this.terminated) {
            return Content.Chunk.EOF;
        }
        Content.Chunk readChunk = this.readChunk();
        if (readChunk == null) {
            return null;
        }
        if (Content.Chunk.isFailure((Content.Chunk)readChunk)) {
            this.failed = ExceptionUtil.combine((Throwable)this.failed, (Throwable)readChunk.getFailure());
            return readChunk;
        }
        try {
            Content.Chunk chunk = this.nextChunk(readChunk);
            if (chunk != null && chunk.isLast()) {
                this.terminate();
            }
            return chunk;
        }
        catch (Throwable x) {
            this.fail(x);
            return Content.Chunk.from((Throwable)this.failed, (boolean)true);
        }
    }

    protected abstract Content.Chunk nextChunk(Content.Chunk var1) throws IOException;

    protected void release() {
    }

    private void freeActiveChunk() {
        if (this.activeChunk != null) {
            this.activeChunk.release();
        }
        this.activeChunk = null;
    }

    private Content.Chunk readChunk() {
        if (this.activeChunk != null) {
            if (this.activeChunk.hasRemaining()) {
                return this.activeChunk;
            }
            this.activeChunk.release();
            this.activeChunk = null;
        }
        this.activeChunk = this.source.read();
        return this.activeChunk;
    }

    private void terminate() {
        if (!this.terminated) {
            this.terminated = true;
            this.freeActiveChunk();
            this.release();
        }
    }
}

