/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.cdi.websocket;

import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.InjectionPoint;
import org.eclipse.jetty.cdi.websocket.WebSocketScopeContext;
import org.eclipse.jetty.cdi.websocket.annotation.WebSocketScope;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.api.Session;

public class JettyWebSocketSessionProducer {
    private static final Logger LOG = Log.getLogger(JettyWebSocketSessionProducer.class);

    @Produces
    public Session getSession(InjectionPoint injectionPoint) {
        WebSocketScopeContext ctx;
        if (LOG.isDebugEnabled()) {
            LOG.debug("getSession({})", new Object[]{injectionPoint});
        }
        if ((ctx = WebSocketScopeContext.current()) == null) {
            throw new IllegalStateException("Not in a " + WebSocketScope.class.getName());
        }
        Session sess = ctx.getSession();
        if (sess == null) {
            throw new IllegalStateException("No Session Available");
        }
        return sess;
    }
}

