/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.cdi.websocket;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.spi.Context;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import org.eclipse.jetty.cdi.core.AnyLiteral;
import org.eclipse.jetty.cdi.core.ScopedInstance;
import org.eclipse.jetty.cdi.core.SimpleBeanStore;
import org.eclipse.jetty.cdi.websocket.annotation.WebSocketScope;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.api.Session;

@Deprecated
public class WebSocketScopeContext
implements Context {
    private static final Logger LOG = Log.getLogger(WebSocketScopeContext.class);
    private static ThreadLocal<WebSocketScopeContext> current = new ThreadLocal();
    private SimpleBeanStore beanStore;
    @Inject
    private BeanManager beanManager;
    private ThreadLocal<Session> session = new ThreadLocal();

    public static WebSocketScopeContext current() {
        return current.get();
    }

    public void begin() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} begin()", new Object[]{this});
        }
        current.set(this);
    }

    public void create() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} create()", new Object[]{this});
        }
        current.set(this);
        this.beanStore = new SimpleBeanStore();
    }

    public void destroy() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} destroy()", new Object[]{this});
        }
        this.beanStore.destroy();
    }

    public void end() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} end()", new Object[]{this});
        }
        this.beanStore.clear();
    }

    public <T> T get(Contextual<T> contextual) {
        Bean bean;
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} get({})", new Object[]{this, contextual});
        }
        if ((bean = (Bean)contextual).getBeanClass().isAssignableFrom(Session.class)) {
            return (T)this.session;
        }
        if (this.beanStore == null) {
            return null;
        }
        List beans = this.beanStore.getBeans(contextual);
        if (beans != null && !beans.isEmpty()) {
            return (T)((ScopedInstance)beans.get((int)0)).instance;
        }
        return null;
    }

    public <T> T get(Contextual<T> contextual, CreationalContext<T> creationalContext) {
        List beans;
        Bean bean;
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} get({},{})", new Object[]{this, contextual, creationalContext});
        }
        if ((bean = (Bean)contextual).getBeanClass().isAssignableFrom(Session.class)) {
            return (T)this.session;
        }
        if (this.beanStore == null) {
            this.beanStore = new SimpleBeanStore();
        }
        if ((beans = this.beanStore.getBeans(contextual)) != null && !beans.isEmpty()) {
            for (ScopedInstance instance : beans) {
                if (!instance.bean.equals(bean)) continue;
                return (T)instance.instance;
            }
        }
        Object t = bean.create(creationalContext);
        ScopedInstance customInstance = new ScopedInstance();
        customInstance.bean = bean;
        customInstance.creationalContext = creationalContext;
        customInstance.instance = t;
        this.beanStore.addBean(customInstance);
        return (T)t;
    }

    public Class<? extends Annotation> getScope() {
        return WebSocketScope.class;
    }

    public boolean isActive() {
        return true;
    }

    public <T> T newInstance(Class<T> clazz) {
        Set beans;
        if (LOG.isDebugEnabled()) {
            LOG.debug("newInstance({})", new Object[]{clazz});
        }
        if ((beans = this.beanManager.getBeans(clazz, new Annotation[]{AnyLiteral.INSTANCE})).isEmpty()) {
            return null;
        }
        Bean bean = (Bean)beans.iterator().next();
        CreationalContext cc = this.beanManager.createCreationalContext((Contextual)bean);
        return (T)this.beanManager.getReference(bean, clazz, cc);
    }

    public void setSession(Session sess) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} setSession({})", new Object[]{this, sess});
        }
        current.set(this);
        this.session.set(sess);
    }

    public Session getSession() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} getSession()", new Object[]{this});
        }
        return this.session.get();
    }

    public String toString() {
        return String.format("%s@%X[%s]", this.getClass().getSimpleName(), this.hashCode(), this.beanStore);
    }
}

