/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.cdi.websocket;

import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.websocket.Session;
import org.eclipse.jetty.cdi.websocket.WebSocketScopeContext;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class JavaWebSocketSessionProducer {
    private static final Logger LOG = Log.getLogger(JavaWebSocketSessionProducer.class);

    @Produces
    public Session getSession(InjectionPoint injectionPoint) {
        org.eclipse.jetty.websocket.api.Session sess;
        if (LOG.isDebugEnabled()) {
            LOG.debug("getSession({})", new Object[]{injectionPoint});
        }
        if ((sess = WebSocketScopeContext.current().getSession()) == null) {
            throw new IllegalStateException("No Session Available");
        }
        if (sess instanceof Session) {
            return (Session)sess;
        }
        throw new IllegalStateException("Incompatible Session, expected <" + Session.class.getName() + ">, but got <" + sess.getClass().getName() + "> instead");
    }
}

