/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.HttpParser;
import org.eclipse.jetty.io.AsyncEndPoint;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.ConnectedEndPoint;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.nio.AsyncConnection;
import org.eclipse.jetty.io.nio.IndirectNIOBuffer;
import org.eclipse.jetty.io.nio.SelectChannelEndPoint;
import org.eclipse.jetty.io.nio.SelectorManager;
import org.eclipse.jetty.server.AbstractHttpConnection;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.util.HostMap;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.ThreadPool;

public class ConnectHandler
extends HandlerWrapper {
    private static final Logger LOG = Log.getLogger(ConnectHandler.class);
    private final Logger _logger = Log.getLogger(this.getClass().getName());
    private final SelectorManager _selectorManager = new Manager();
    private volatile int _connectTimeout = 5000;
    private volatile int _writeTimeout = 30000;
    private volatile ThreadPool _threadPool;
    private volatile boolean _privateThreadPool;
    private HostMap<String> _white = new HostMap();
    private HostMap<String> _black = new HostMap();

    public ConnectHandler() {
        this(null);
    }

    public ConnectHandler(String[] white, String[] black) {
        this(null, white, black);
    }

    public ConnectHandler(Handler handler) {
        this.setHandler(handler);
    }

    public ConnectHandler(Handler handler, String[] white, String[] black) {
        this.setHandler(handler);
        this.set(white, this._white);
        this.set(black, this._black);
    }

    public int getConnectTimeout() {
        return this._connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this._connectTimeout = connectTimeout;
    }

    public int getWriteTimeout() {
        return this._writeTimeout;
    }

    public void setWriteTimeout(int writeTimeout) {
        this._writeTimeout = writeTimeout;
    }

    @Override
    public void setServer(Server server) {
        super.setServer(server);
        server.getContainer().update((Object)this, null, this._selectorManager, "selectManager");
        if (this._privateThreadPool) {
            server.getContainer().update((Object)this, null, this._privateThreadPool, "threadpool", true);
        } else {
            this._threadPool = server.getThreadPool();
        }
    }

    public ThreadPool getThreadPool() {
        return this._threadPool;
    }

    public void setThreadPool(ThreadPool threadPool) {
        if (this.getServer() != null) {
            this.getServer().getContainer().update((Object)this, this._privateThreadPool ? this._threadPool : null, threadPool, "threadpool", true);
        }
        this._privateThreadPool = threadPool != null;
        this._threadPool = threadPool;
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        if (this._threadPool == null) {
            this._threadPool = this.getServer().getThreadPool();
            this._privateThreadPool = false;
        }
        if (this._threadPool instanceof LifeCycle && !((LifeCycle)((Object)this._threadPool)).isRunning()) {
            ((LifeCycle)((Object)this._threadPool)).start();
        }
        this._selectorManager.start();
    }

    @Override
    protected void doStop() throws Exception {
        this._selectorManager.stop();
        ThreadPool threadPool = this._threadPool;
        if (this._privateThreadPool && this._threadPool != null && threadPool instanceof LifeCycle) {
            ((LifeCycle)((Object)threadPool)).stop();
        }
        super.doStop();
    }

    @Override
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if ("CONNECT".equalsIgnoreCase(request.getMethod())) {
            this._logger.debug("CONNECT request for {}", request.getRequestURI());
            try {
                this.handleConnect(baseRequest, request, response, request.getRequestURI());
            }
            catch (Exception e) {
                this._logger.warn("ConnectHandler " + baseRequest.getUri() + " " + e, new Object[0]);
                this._logger.debug(e);
            }
        } else {
            super.handle(target, baseRequest, request, response);
        }
    }

    protected void handleConnect(Request baseRequest, HttpServletRequest request, HttpServletResponse response, String serverAddress) throws ServletException, IOException {
        boolean proceed = this.handleAuthentication(request, response, serverAddress);
        if (!proceed) {
            return;
        }
        String host = serverAddress;
        int port = 80;
        int colon = serverAddress.indexOf(58);
        if (colon > 0) {
            host = serverAddress.substring(0, colon);
            port = Integer.parseInt(serverAddress.substring(colon + 1));
        }
        if (!this.validateDestination(host)) {
            LOG.info("ProxyHandler: Forbidden destination " + host, new Object[0]);
            response.setStatus(403);
            baseRequest.setHandled(true);
            return;
        }
        SocketChannel channel = this.connectToServer(request, host, port);
        AbstractHttpConnection httpConnection = AbstractHttpConnection.getCurrentConnection();
        Buffer headerBuffer = ((HttpParser)httpConnection.getParser()).getHeaderBuffer();
        Buffer bodyBuffer = ((HttpParser)httpConnection.getParser()).getBodyBuffer();
        int length = headerBuffer == null ? 0 : headerBuffer.length();
        int n = bodyBuffer == null ? 0 : bodyBuffer.length();
        IndirectNIOBuffer buffer = null;
        if ((length += n) > 0) {
            buffer = new IndirectNIOBuffer(length);
            if (headerBuffer != null) {
                buffer.put(headerBuffer);
                headerBuffer.clear();
            }
            if (bodyBuffer != null) {
                buffer.put(bodyBuffer);
                bodyBuffer.clear();
            }
        }
        ConcurrentHashMap<String, Object> context = new ConcurrentHashMap<String, Object>();
        this.prepareContext(request, context);
        ClientToProxyConnection clientToProxy = this.prepareConnections(context, channel, buffer);
        response.setStatus(200);
        baseRequest.getConnection().getGenerator().setPersistent(true);
        response.getOutputStream().close();
        this.upgradeConnection(request, response, clientToProxy);
    }

    private ClientToProxyConnection prepareConnections(ConcurrentMap<String, Object> context, SocketChannel channel, Buffer buffer) {
        AbstractHttpConnection httpConnection = AbstractHttpConnection.getCurrentConnection();
        ProxyToServerConnection proxyToServer = this.newProxyToServerConnection(context, buffer);
        ClientToProxyConnection clientToProxy = this.newClientToProxyConnection(context, channel, httpConnection.getEndPoint(), httpConnection.getTimeStamp());
        clientToProxy.setConnection(proxyToServer);
        proxyToServer.setConnection(clientToProxy);
        return clientToProxy;
    }

    protected boolean handleAuthentication(HttpServletRequest request, HttpServletResponse response, String address) throws ServletException, IOException {
        return true;
    }

    protected ClientToProxyConnection newClientToProxyConnection(ConcurrentMap<String, Object> context, SocketChannel channel, EndPoint endPoint, long timeStamp) {
        return new ClientToProxyConnection(context, channel, endPoint, timeStamp);
    }

    protected ProxyToServerConnection newProxyToServerConnection(ConcurrentMap<String, Object> context, Buffer buffer) {
        return new ProxyToServerConnection(context, buffer);
    }

    private SocketChannel connectToServer(HttpServletRequest request, String host, int port) throws IOException {
        SocketChannel channel = this.connect(request, host, port);
        channel.configureBlocking(false);
        return channel;
    }

    protected SocketChannel connect(HttpServletRequest request, String host, int port) throws IOException {
        SocketChannel channel = SocketChannel.open();
        try {
            this._logger.debug("Establishing connection to {}:{}", host, port);
            channel.socket().setTcpNoDelay(true);
            channel.socket().connect(new InetSocketAddress(host, port), this.getConnectTimeout());
            this._logger.debug("Established connection to {}:{}", host, port);
            return channel;
        }
        catch (IOException x) {
            this._logger.debug("Failed to establish connection to " + host + ":" + port, x);
            try {
                channel.close();
            }
            catch (IOException xx) {
                LOG.ignore(xx);
            }
            throw x;
        }
    }

    protected void prepareContext(HttpServletRequest request, ConcurrentMap<String, Object> context) {
    }

    private void upgradeConnection(HttpServletRequest request, HttpServletResponse response, Connection connection) throws IOException {
        request.setAttribute("org.eclipse.jetty.io.Connection", (Object)connection);
        response.setStatus(101);
        this._logger.debug("Upgraded connection to {}", connection);
    }

    private void register(SocketChannel channel, ProxyToServerConnection proxyToServer) throws IOException {
        this._selectorManager.register(channel, proxyToServer);
        proxyToServer.waitReady(this._connectTimeout);
    }

    protected int read(EndPoint endPoint, Buffer buffer, ConcurrentMap<String, Object> context) throws IOException {
        return endPoint.fill(buffer);
    }

    protected int write(EndPoint endPoint, Buffer buffer, ConcurrentMap<String, Object> context) throws IOException {
        if (buffer == null) {
            return 0;
        }
        int length = buffer.length();
        StringBuilder builder = new StringBuilder();
        int written = endPoint.flush(buffer);
        builder.append(written);
        buffer.compact();
        if (!endPoint.isBlocking()) {
            while (buffer.space() == 0) {
                boolean ready = endPoint.blockWritable(this.getWriteTimeout());
                if (!ready) {
                    throw new IOException("Write timeout");
                }
                written = endPoint.flush(buffer);
                builder.append("+").append(written);
                buffer.compact();
            }
        }
        this._logger.debug("Written {}/{} bytes {}", builder, length, endPoint);
        return length;
    }

    public void addWhite(String entry) {
        this.add(entry, this._white);
    }

    public void addBlack(String entry) {
        this.add(entry, this._black);
    }

    public void setWhite(String[] entries) {
        this.set(entries, this._white);
    }

    public void setBlack(String[] entries) {
        this.set(entries, this._black);
    }

    protected void set(String[] entries, HostMap<String> hostMap) {
        hostMap.clear();
        if (entries != null && entries.length > 0) {
            for (String addrPath : entries) {
                this.add(addrPath, hostMap);
            }
        }
    }

    private void add(String entry, HostMap<String> hostMap) {
        if (entry != null && entry.length() > 0 && hostMap.get(entry = entry.trim()) == null) {
            hostMap.put(entry, entry);
        }
    }

    public boolean validateDestination(String host) {
        Object blackObj;
        Object whiteObj;
        if (this._white.size() > 0 && (whiteObj = this._white.getLazyMatches(host)) == null) {
            return false;
        }
        return this._black.size() <= 0 || (blackObj = this._black.getLazyMatches(host)) == null;
    }

    @Override
    public void dump(Appendable out, String indent) throws IOException {
        this.dumpThis(out);
        if (this._privateThreadPool) {
            ConnectHandler.dump(out, indent, Arrays.asList(this._threadPool, this._selectorManager), TypeUtil.asList(this.getHandlers()), this.getBeans());
        } else {
            ConnectHandler.dump(out, indent, Arrays.asList(this._selectorManager), TypeUtil.asList(this.getHandlers()), this.getBeans());
        }
    }

    public class ClientToProxyConnection
    implements AsyncConnection {
        private final Buffer _buffer = new IndirectNIOBuffer(1024);
        private final ConcurrentMap<String, Object> _context;
        private final SocketChannel _channel;
        private final EndPoint _endPoint;
        private final long _timestamp;
        private volatile ProxyToServerConnection _toServer;
        private boolean _firstTime = true;

        public ClientToProxyConnection(ConcurrentMap<String, Object> context, SocketChannel channel, EndPoint endPoint, long timestamp) {
            this._context = context;
            this._channel = channel;
            this._endPoint = endPoint;
            this._timestamp = timestamp;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("ClientToProxy");
            builder.append("(:").append(this._endPoint.getLocalPort());
            builder.append("<=>:").append(this._endPoint.getRemotePort());
            return builder.append(")").toString();
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Connection handle() throws IOException {
            ClientToProxyConnection read2222222;
            ConnectHandler.this._logger.debug("{}: begin reading from client", this);
            try {
                if (this._firstTime) {
                    this._firstTime = false;
                    ConnectHandler.this.register(this._channel, this._toServer);
                    ConnectHandler.this._logger.debug("{}: registered channel {} with connection {}", this, this._channel, this._toServer);
                }
                while (true) {
                    int read2222222;
                    if ((read2222222 = ConnectHandler.this.read(this._endPoint, this._buffer, this._context)) == -1) {
                        ConnectHandler.this._logger.debug("{}: client closed connection {}", this, this._endPoint);
                        if (this._endPoint.isOutputShutdown() || !this._endPoint.isOpen()) {
                            this.closeServer();
                            break;
                        }
                        this._toServer.shutdownOutput();
                        break;
                    }
                    if (read2222222 == 0) break;
                    ConnectHandler.this._logger.debug("{}: read from client {} bytes {}", this, read2222222, this._endPoint);
                    int written = ConnectHandler.this.write(this._toServer._endPoint, this._buffer, this._context);
                    ConnectHandler.this._logger.debug("{}: written to {} {} bytes", this, this._toServer, written);
                }
                read2222222 = this;
            }
            catch (ClosedChannelException x) {
                try {
                    ConnectHandler.this._logger.debug(x);
                    this.closeServer();
                    throw x;
                    catch (IOException x2) {
                        ConnectHandler.this._logger.warn(this + ": unexpected exception", x2);
                        this.close();
                        throw x2;
                    }
                    catch (RuntimeException x3) {
                        ConnectHandler.this._logger.warn(this + ": unexpected exception", x3);
                        this.close();
                        throw x3;
                    }
                }
                catch (Throwable throwable) {
                    ConnectHandler.this._logger.debug("{}: end reading from client", this);
                    throw throwable;
                }
            }
            ConnectHandler.this._logger.debug("{}: end reading from client", this);
            return read2222222;
        }

        @Override
        public void onInputShutdown() throws IOException {
        }

        @Override
        public long getTimeStamp() {
            return this._timestamp;
        }

        @Override
        public boolean isIdle() {
            return false;
        }

        @Override
        public boolean isSuspended() {
            return false;
        }

        @Override
        public void onClose() {
        }

        public void setConnection(ProxyToServerConnection connection) {
            this._toServer = connection;
        }

        public void closeClient() throws IOException {
            this._endPoint.close();
        }

        public void closeServer() throws IOException {
            this._toServer.closeServer();
        }

        public void close() {
            try {
                this.closeClient();
            }
            catch (IOException x) {
                ConnectHandler.this._logger.debug(this + ": unexpected exception closing the client", x);
            }
            try {
                this.closeServer();
            }
            catch (IOException x) {
                ConnectHandler.this._logger.debug(this + ": unexpected exception closing the server", x);
            }
        }

        public void shutdownOutput() throws IOException {
            this._endPoint.shutdownOutput();
        }

        @Override
        public void onIdleExpired(long idleForMs) {
            try {
                this.shutdownOutput();
            }
            catch (Exception e) {
                LOG.debug(e);
                this.close();
            }
        }
    }

    public class ProxyToServerConnection
    implements AsyncConnection {
        private final CountDownLatch _ready = new CountDownLatch(1);
        private final Buffer _buffer = new IndirectNIOBuffer(1024);
        private final ConcurrentMap<String, Object> _context;
        private volatile Buffer _data;
        private volatile ClientToProxyConnection _toClient;
        private volatile long _timestamp;
        private volatile AsyncEndPoint _endPoint;

        public ProxyToServerConnection(ConcurrentMap<String, Object> context, Buffer data) {
            this._context = context;
            this._data = data;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("ProxyToServer");
            builder.append("(:").append(this._endPoint.getLocalPort());
            builder.append("<=>:").append(this._endPoint.getRemotePort());
            return builder.append(")").toString();
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Connection handle() throws IOException {
            ProxyToServerConnection read2222222;
            ConnectHandler.this._logger.debug("{}: begin reading from server", this);
            try {
                this.writeData();
                while (true) {
                    int read2222222;
                    if ((read2222222 = ConnectHandler.this.read(this._endPoint, this._buffer, this._context)) == -1) {
                        ConnectHandler.this._logger.debug("{}: server closed connection {}", this, this._endPoint);
                        if (this._endPoint.isOutputShutdown() || !this._endPoint.isOpen()) {
                            this.closeClient();
                            break;
                        }
                        this._toClient.shutdownOutput();
                        break;
                    }
                    if (read2222222 == 0) break;
                    ConnectHandler.this._logger.debug("{}: read from server {} bytes {}", this, read2222222, this._endPoint);
                    int written = ConnectHandler.this.write(this._toClient._endPoint, this._buffer, this._context);
                    ConnectHandler.this._logger.debug("{}: written to {} {} bytes", this, this._toClient, written);
                }
                read2222222 = this;
            }
            catch (ClosedChannelException x) {
                try {
                    ConnectHandler.this._logger.debug(x);
                    throw x;
                    catch (IOException x2) {
                        ConnectHandler.this._logger.warn(this + ": unexpected exception", x2);
                        this.close();
                        throw x2;
                    }
                    catch (RuntimeException x3) {
                        ConnectHandler.this._logger.warn(this + ": unexpected exception", x3);
                        this.close();
                        throw x3;
                    }
                }
                catch (Throwable throwable) {
                    ConnectHandler.this._logger.debug("{}: end reading from server", this);
                    throw throwable;
                }
            }
            ConnectHandler.this._logger.debug("{}: end reading from server", this);
            return read2222222;
        }

        @Override
        public void onInputShutdown() throws IOException {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeData() throws IOException {
            ProxyToServerConnection proxyToServerConnection = this;
            synchronized (proxyToServerConnection) {
                if (this._data != null) {
                    try {
                        int written = ConnectHandler.this.write(this._endPoint, this._data, this._context);
                        ConnectHandler.this._logger.debug("{}: written to server {} bytes", this, written);
                    }
                    finally {
                        this._data = null;
                    }
                }
            }
        }

        public void setConnection(ClientToProxyConnection connection) {
            this._toClient = connection;
        }

        @Override
        public long getTimeStamp() {
            return this._timestamp;
        }

        public void setTimeStamp(long timestamp) {
            this._timestamp = timestamp;
        }

        public void setEndPoint(AsyncEndPoint endpoint) {
            this._endPoint = endpoint;
        }

        @Override
        public boolean isIdle() {
            return false;
        }

        @Override
        public boolean isSuspended() {
            return false;
        }

        @Override
        public void onClose() {
        }

        public void ready() {
            this._ready.countDown();
        }

        public void waitReady(long timeout) throws IOException {
            try {
                this._ready.await(timeout, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException x) {
                throw new IOException(){
                    {
                        this.initCause(x);
                    }
                };
            }
        }

        public void closeClient() throws IOException {
            this._toClient.closeClient();
        }

        public void closeServer() throws IOException {
            this._endPoint.close();
        }

        public void close() {
            try {
                this.closeClient();
            }
            catch (IOException x) {
                ConnectHandler.this._logger.debug(this + ": unexpected exception closing the client", x);
            }
            try {
                this.closeServer();
            }
            catch (IOException x) {
                ConnectHandler.this._logger.debug(this + ": unexpected exception closing the server", x);
            }
        }

        public void shutdownOutput() throws IOException {
            this.writeData();
            this._endPoint.shutdownOutput();
        }

        @Override
        public void onIdleExpired(long idleForMs) {
            try {
                this.shutdownOutput();
            }
            catch (Exception e) {
                LOG.debug(e);
                this.close();
            }
        }
    }

    private class Manager
    extends SelectorManager {
        private Manager() {
        }

        @Override
        protected SelectChannelEndPoint newEndPoint(SocketChannel channel, SelectorManager.SelectSet selectSet, SelectionKey key) throws IOException {
            SelectChannelEndPoint endp = new SelectChannelEndPoint(channel, selectSet, key, channel.socket().getSoTimeout());
            endp.setConnection(selectSet.getManager().newConnection(channel, endp, key.attachment()));
            endp.setMaxIdleTime(ConnectHandler.this._writeTimeout);
            return endp;
        }

        @Override
        public AsyncConnection newConnection(SocketChannel channel, AsyncEndPoint endpoint, Object attachment) {
            ProxyToServerConnection proxyToServer = (ProxyToServerConnection)attachment;
            proxyToServer.setTimeStamp(System.currentTimeMillis());
            proxyToServer.setEndPoint(endpoint);
            return proxyToServer;
        }

        @Override
        protected void endPointOpened(SelectChannelEndPoint endpoint) {
            ProxyToServerConnection proxyToServer = (ProxyToServerConnection)endpoint.getSelectionKey().attachment();
            proxyToServer.ready();
        }

        @Override
        public boolean dispatch(Runnable task) {
            return ConnectHandler.this._threadPool.dispatch(task);
        }

        @Override
        protected void endPointClosed(SelectChannelEndPoint endpoint) {
        }

        @Override
        protected void endPointUpgraded(ConnectedEndPoint endpoint, Connection oldConnection) {
        }
    }
}

