/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.webapp;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.DispatcherType;
import javax.servlet.MultipartConfigElement;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import javax.servlet.SessionTrackingMode;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.http.PathMap;
import org.eclipse.jetty.http.security.Constraint;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.security.ConstraintAware;
import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.servlet.ErrorPageErrorHandler;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.FilterMapping;
import org.eclipse.jetty.servlet.Holder;
import org.eclipse.jetty.servlet.ServletHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.servlet.ServletMapping;
import org.eclipse.jetty.util.LazyList;
import org.eclipse.jetty.util.Loader;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.webapp.DefaultsDescriptor;
import org.eclipse.jetty.webapp.Descriptor;
import org.eclipse.jetty.webapp.Fragment;
import org.eclipse.jetty.webapp.IterativeDescriptorProcessor;
import org.eclipse.jetty.webapp.OverrideDescriptor;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.webapp.WebXmlProcessor;
import org.eclipse.jetty.xml.XmlParser;

public class StandardDescriptorProcessor
extends IterativeDescriptorProcessor {
    protected WebAppContext _context;
    protected ServletHandler _servletHandler;
    protected SecurityHandler _securityHandler;
    protected Object _filters;
    protected Object _filterMappings;
    protected Object _servlets;
    protected Object _servletMappings;
    protected Object _listeners;
    protected Object _listenerClassNames;
    protected Object _welcomeFiles;
    protected Set<String> _roles = new HashSet<String>();
    protected Object _constraintMappings;
    protected Map _errorPages;
    protected boolean _hasJSP;
    protected String _jspServletName;
    protected String _jspServletClass;
    protected boolean _defaultWelcomeFileList;
    protected WebXmlProcessor _processor;

    public StandardDescriptorProcessor(WebXmlProcessor processor) {
        this._processor = processor;
        this._context = this._processor.getContext();
        try {
            this.registerVisitor("context-param", this.getClass().getDeclaredMethod("visitContextParam", __signature));
            this.registerVisitor("display-name", this.getClass().getDeclaredMethod("visitDisplayName", __signature));
            this.registerVisitor("servlet", this.getClass().getDeclaredMethod("visitServlet", __signature));
            this.registerVisitor("servlet-mapping", this.getClass().getDeclaredMethod("visitServletMapping", __signature));
            this.registerVisitor("session-config", this.getClass().getDeclaredMethod("visitSessionConfig", __signature));
            this.registerVisitor("mime-mapping", this.getClass().getDeclaredMethod("visitMimeMapping", __signature));
            this.registerVisitor("welcome-file-list", this.getClass().getDeclaredMethod("visitWelcomeFileList", __signature));
            this.registerVisitor("locale-encoding-mapping-list", this.getClass().getDeclaredMethod("visitLocaleEncodingList", __signature));
            this.registerVisitor("error-page", this.getClass().getDeclaredMethod("visitErrorPage", __signature));
            this.registerVisitor("taglib", this.getClass().getDeclaredMethod("visitTagLib", __signature));
            this.registerVisitor("jsp-config", this.getClass().getDeclaredMethod("visitJspConfig", __signature));
            this.registerVisitor("security-constraint", this.getClass().getDeclaredMethod("visitSecurityConstraint", __signature));
            this.registerVisitor("login-config", this.getClass().getDeclaredMethod("visitLoginConfig", __signature));
            this.registerVisitor("security-role", this.getClass().getDeclaredMethod("visitSecurityRole", __signature));
            this.registerVisitor("filter", this.getClass().getDeclaredMethod("visitFilter", __signature));
            this.registerVisitor("filter-mapping", this.getClass().getDeclaredMethod("visitFilterMapping", __signature));
            this.registerVisitor("listener", this.getClass().getDeclaredMethod("visitListener", __signature));
            this.registerVisitor("distributable", this.getClass().getDeclaredMethod("visitDistributable", __signature));
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void start() {
        this._servletHandler = this._context.getServletHandler();
        this._securityHandler = this._context.getSecurityHandler();
        this._filters = LazyList.array2List(this._servletHandler.getFilters());
        this._filterMappings = LazyList.array2List(this._servletHandler.getFilterMappings());
        this._servlets = LazyList.array2List(this._servletHandler.getServlets());
        this._servletMappings = LazyList.array2List(this._servletHandler.getServletMappings());
        this._listeners = LazyList.array2List(this._context.getEventListeners());
        this._welcomeFiles = LazyList.array2List(this._context.getWelcomeFiles());
        if (this._securityHandler instanceof ConstraintAware) {
            this._constraintMappings = LazyList.array2List(((ConstraintAware)((Object)this._securityHandler)).getConstraintMappings());
            if (((ConstraintAware)((Object)this._securityHandler)).getRoles() != null) {
                this._roles.addAll(((ConstraintAware)((Object)this._securityHandler)).getRoles());
            }
        }
        this._errorPages = this._context.getErrorHandler() instanceof ErrorPageErrorHandler ? ((ErrorPageErrorHandler)this._context.getErrorHandler()).getErrorPages() : null;
    }

    @Override
    public void end() {
        this._servletHandler.setFilters((FilterHolder[])LazyList.toArray(this._filters, FilterHolder.class));
        this._servletHandler.setFilterMappings((FilterMapping[])LazyList.toArray(this._filterMappings, FilterMapping.class));
        this._servletHandler.setServlets((ServletHolder[])LazyList.toArray(this._servlets, ServletHolder.class));
        this._servletHandler.setServletMappings((ServletMapping[])LazyList.toArray(this._servletMappings, ServletMapping.class));
        this._context.setEventListeners((EventListener[])LazyList.toArray(this._listeners, EventListener.class));
        this._context.setWelcomeFiles((String[])LazyList.toArray(this._welcomeFiles, String.class));
        if (this._securityHandler instanceof ConstraintAware) {
            ((ConstraintAware)((Object)this._securityHandler)).setConstraintMappings((ConstraintMapping[])LazyList.toArray(this._constraintMappings, ConstraintMapping.class), this._roles);
        }
        if (this._errorPages != null && this._context.getErrorHandler() instanceof ErrorPageErrorHandler) {
            ((ErrorPageErrorHandler)this._context.getErrorHandler()).setErrorPages(this._errorPages);
        }
    }

    public void visitContextParam(Descriptor descriptor, XmlParser.Node node) {
        String name = node.getString("param-name", false, true);
        String value = node.getString("param-value", false, true);
        WebXmlProcessor.Origin o = this._processor.getOrigin("context-param." + name);
        switch (o) {
            case NotSet: {
                this._context.getInitParams().put(name, value);
                this._processor.setOrigin("context-param." + name, descriptor);
                break;
            }
            case WebXml: 
            case WebDefaults: 
            case WebOverride: {
                if (descriptor instanceof Fragment) break;
                this._context.getInitParams().put(name, value);
                this._processor.setOrigin("context-param." + name, descriptor);
                break;
            }
            case WebFragment: {
                if (!(descriptor instanceof Fragment) || this._context.getInitParams().get(name).equals(value)) break;
                throw new IllegalStateException("Conflicting context-param " + name + "=" + value + " in " + descriptor.getResource());
            }
        }
        if (Log.isDebugEnabled()) {
            Log.debug("ContextParam: " + name + "=" + value);
        }
    }

    protected void visitDisplayName(Descriptor descriptor, XmlParser.Node node) {
        if (!(descriptor instanceof Fragment)) {
            this._context.setDisplayName(node.toString(false, true));
            this._processor.setOrigin("display-name", descriptor);
        }
    }

    protected void visitServlet(Descriptor descriptor, XmlParser.Node node) {
        XmlParser.Node multipart;
        String enabled;
        String async;
        WebXmlProcessor.Origin o;
        String roleName;
        XmlParser.Node startup;
        String jsp_file;
        String id = node.getAttribute("id");
        String servlet_name = node.getString("servlet-name", false, true);
        ServletHolder holder = this._servletHandler.getServlet(servlet_name);
        if (holder == null) {
            holder = this._servletHandler.newServletHolder(Holder.Source.DESCRIPTOR);
            holder.setName(servlet_name);
            this._servlets = LazyList.add(this._servlets, holder);
        }
        ServletRegistration.Dynamic registration = holder.getRegistration();
        Iterator iParamsIter = node.iterator("init-param");
        while (iParamsIter.hasNext()) {
            XmlParser.Node paramNode = (XmlParser.Node)iParamsIter.next();
            String pname = paramNode.getString("param-name", false, true);
            String pvalue = paramNode.getString("param-value", false, true);
            WebXmlProcessor.Origin origin = this._processor.getOrigin(servlet_name + "servlet.init-param." + pname);
            switch (origin) {
                case NotSet: {
                    registration.setInitParameter(pname, pvalue);
                    this._processor.setOrigin(servlet_name + "servlet.init-param." + pname, descriptor);
                    break;
                }
                case WebXml: 
                case WebDefaults: 
                case WebOverride: {
                    if (descriptor instanceof Fragment) break;
                    registration.setInitParameter(pname, pvalue);
                    this._processor.setOrigin(servlet_name + "servlet.init-param." + pname, descriptor);
                    break;
                }
                case WebFragment: {
                    if (registration.getInitParameter(pname).equals(pvalue)) break;
                    throw new IllegalStateException("Mismatching init-param " + pname + "=" + pvalue + " in " + descriptor.getResource());
                }
            }
        }
        String servlet_class = node.getString("servlet-class", false, true);
        if (id != null && id.equals("jsp")) {
            this._jspServletName = servlet_name;
            this._jspServletClass = servlet_class;
            try {
                Loader.loadClass(this.getClass(), servlet_class);
                this._hasJSP = true;
            }
            catch (ClassNotFoundException e) {
                Log.info("NO JSP Support for {}, did not find {}", this._context.getContextPath(), servlet_class);
                this._hasJSP = false;
                servlet_class = "org.eclipse.jetty.servlet.NoJspServlet";
                this._jspServletClass = "org.eclipse.jetty.servlet.NoJspServlet";
            }
            if (registration.getInitParameter("scratchdir") == null) {
                File tmp = this._context.getTempDirectory();
                File scratch = new File(tmp, "jsp");
                if (!scratch.exists()) {
                    scratch.mkdir();
                }
                registration.setInitParameter("scratchdir", scratch.getAbsolutePath());
                if ("?".equals(registration.getInitParameter("classpath"))) {
                    String classpath = this._context.getClassPath();
                    Log.debug("classpath=" + classpath);
                    if (classpath != null) {
                        registration.setInitParameter("classpath", classpath);
                    }
                }
            }
            this._context.setAttribute("org.apache.catalina.jsp_classpath", this._context.getClassPath());
            registration.setInitParameter("com.sun.appserv.jsp.classpath", this.getSystemClassPath());
        }
        if (servlet_class != null) {
            WebXmlProcessor.Origin o2 = this._processor.getOrigin(servlet_name + ".servlet-class");
            switch (o2) {
                case NotSet: {
                    holder.setClassName(servlet_class);
                    this._processor.setOrigin(servlet_name + ".servlet-class", descriptor);
                    break;
                }
                case WebXml: 
                case WebDefaults: 
                case WebOverride: {
                    if (descriptor instanceof Fragment) break;
                    holder.setClassName(servlet_class);
                    this._processor.setOrigin(servlet_name + ".servlet-class", descriptor);
                    break;
                }
                case WebFragment: {
                    if (servlet_class.equals(holder.getClassName())) break;
                    throw new IllegalStateException("Conflicting servlet-class " + servlet_class + " in " + descriptor.getResource());
                }
            }
        }
        if ((jsp_file = node.getString("jsp-file", false, true)) != null) {
            holder.setForcedPath(jsp_file);
            holder.setClassName(this._jspServletClass);
        }
        if ((startup = node.get("load-on-startup")) != null) {
            String s = startup.toString(false, true).toLowerCase();
            int order = 0;
            if (s.startsWith("t")) {
                Log.warn("Deprecated boolean load-on-startup.  Please use integer");
                order = 1;
            } else {
                try {
                    if (s != null && s.trim().length() > 0) {
                        order = Integer.parseInt(s);
                    }
                }
                catch (Exception e) {
                    Log.warn("Cannot parse load-on-startup " + s + ". Please use integer");
                    Log.ignore(e);
                }
            }
            WebXmlProcessor.Origin o3 = this._processor.getOrigin(servlet_name + ".load-on-startup");
            switch (o3) {
                case NotSet: {
                    registration.setLoadOnStartup(order);
                    this._processor.setOrigin(servlet_name + ".load-on-startup", descriptor);
                    break;
                }
                case WebXml: 
                case WebDefaults: 
                case WebOverride: {
                    if (descriptor instanceof Fragment) break;
                    registration.setLoadOnStartup(order);
                    this._processor.setOrigin(servlet_name + ".load-on-startup", descriptor);
                    break;
                }
                case WebFragment: {
                    if (order == holder.getInitOrder()) break;
                    throw new IllegalStateException("Conflicting load-on-startup value in " + descriptor.getResource());
                }
            }
        }
        Iterator sRefsIter = node.iterator("security-role-ref");
        while (sRefsIter.hasNext()) {
            XmlParser.Node securityRef = (XmlParser.Node)sRefsIter.next();
            roleName = securityRef.getString("role-name", false, true);
            String roleLink = securityRef.getString("role-link", false, true);
            if (roleName != null && roleName.length() > 0 && roleLink != null && roleLink.length() > 0) {
                if (Log.isDebugEnabled()) {
                    Log.debug("link role " + roleName + " to " + roleLink + " for " + this);
                }
                o = this._processor.getOrigin(servlet_name + ".role-name." + roleName);
                switch (o) {
                    case NotSet: {
                        holder.setUserRoleLink(roleName, roleLink);
                        this._processor.setOrigin(servlet_name + ".role-name." + roleName, descriptor);
                        break;
                    }
                    case WebXml: 
                    case WebDefaults: 
                    case WebOverride: {
                        if (descriptor instanceof Fragment) break;
                        holder.setUserRoleLink(roleName, roleLink);
                        this._processor.setOrigin(servlet_name + ".role-name." + roleName, descriptor);
                        break;
                    }
                    case WebFragment: {
                        if (holder.getUserRoleLink(roleName).equals(roleLink)) break;
                        throw new IllegalStateException("Conflicting role-link for role-name " + roleName + " for servlet " + servlet_name + " in " + descriptor.getResource());
                    }
                }
                continue;
            }
            Log.warn("Ignored invalid security-role-ref element: servlet-name=" + holder.getName() + ", " + securityRef);
        }
        XmlParser.Node run_as = node.get("run-as");
        if (run_as != null && (roleName = run_as.getString("role-name", false, true)) != null) {
            WebXmlProcessor.Origin o4 = this._processor.getOrigin(servlet_name + ".run-as");
            switch (o4) {
                case NotSet: {
                    registration.setRunAsRole(roleName);
                    this._processor.setOrigin(servlet_name + ".run-as", descriptor);
                    break;
                }
                case WebXml: 
                case WebDefaults: 
                case WebOverride: {
                    if (descriptor instanceof Fragment) break;
                    registration.setRunAsRole(roleName);
                    this._processor.setOrigin(servlet_name + ".run-as", descriptor);
                    break;
                }
                case WebFragment: {
                    if (registration.getRunAsRole().equals(roleName)) break;
                    throw new IllegalStateException("Conflicting run-as role " + roleName + " for servlet " + servlet_name + " in " + descriptor.getResource());
                }
            }
        }
        if ((async = node.getString("async-supported", false, true)) != null) {
            boolean val = async.length() == 0 || Boolean.valueOf(async) != false;
            o = this._processor.getOrigin(servlet_name + "servlet.async-supported");
            switch (o) {
                case NotSet: {
                    registration.setAsyncSupported(val);
                    this._processor.setOrigin(servlet_name + "servlet.async-supported", descriptor);
                    break;
                }
                case WebXml: 
                case WebDefaults: 
                case WebOverride: {
                    if (descriptor instanceof Fragment) break;
                    registration.setAsyncSupported(val);
                    this._processor.setOrigin(servlet_name + "servlet.async-supported", descriptor);
                    break;
                }
                case WebFragment: {
                    if (holder.isAsyncSupported() == val) break;
                    throw new IllegalStateException("Conflicting async-supported=" + async + " for servlet " + servlet_name + " in " + descriptor.getResource());
                }
            }
        }
        if ((enabled = node.getString("enabled", false, true)) != null) {
            boolean val = enabled.length() == 0 || Boolean.valueOf(enabled) != false;
            WebXmlProcessor.Origin o5 = this._processor.getOrigin(servlet_name + ".enabled");
            switch (o5) {
                case NotSet: {
                    this._processor.setOrigin(servlet_name + ".enabled", descriptor);
                    break;
                }
                case WebXml: 
                case WebDefaults: 
                case WebOverride: {
                    if (descriptor instanceof Fragment) break;
                    this._processor.setOrigin(servlet_name + ".enabled", descriptor);
                    break;
                }
            }
        }
        if ((multipart = node.get("multipart-config")) != null) {
            String location = node.getString("location", false, true);
            String maxFile = node.getString("max-file-size", false, true);
            String maxRequest = node.getString("max-request-size", false, true);
            String threshold = node.getString("file-size-threshold", false, true);
            MultipartConfigElement element = new MultipartConfigElement(location, maxFile == null || "".equals(maxFile) ? -1L : Long.parseLong(maxFile), maxRequest == null || "".equals(maxRequest) ? -1L : Long.parseLong(maxRequest), threshold == null || "".equals(threshold) ? 0 : Integer.parseInt(threshold));
            WebXmlProcessor.Origin o6 = this._processor.getOrigin(servlet_name + ".multipart-config");
            switch (o6) {
                case NotSet: {
                    registration.setMultipartConfig(element);
                    this._processor.setOrigin(servlet_name + ".multipart-config", descriptor);
                    break;
                }
                case WebXml: 
                case WebDefaults: 
                case WebOverride: {
                    if (descriptor instanceof Fragment) break;
                    registration.setMultipartConfig(element);
                    this._processor.setOrigin(servlet_name + ".multipart-config", descriptor);
                    break;
                }
                case WebFragment: {
                    MultipartConfigElement cfg = ((ServletHolder.Registration)registration).getMultipartConfig();
                    if (cfg.getMaxFileSize() != element.getMaxFileSize()) {
                        throw new IllegalStateException("Conflicting multipart-config max-file-size for servlet " + servlet_name + " in " + descriptor.getResource());
                    }
                    if (cfg.getMaxRequestSize() != element.getMaxRequestSize()) {
                        throw new IllegalStateException("Conflicting multipart-config max-request-size for servlet " + servlet_name + " in " + descriptor.getResource());
                    }
                    if (cfg.getFileSizeThreshold() != element.getFileSizeThreshold()) {
                        throw new IllegalStateException("Conflicting multipart-config file-size-threshold for servlet " + servlet_name + " in " + descriptor.getResource());
                    }
                    if ((cfg.getLocation() == null || element.getLocation() != null && element.getLocation().length() != 0) && (cfg.getLocation() != null || element.getLocation() == null && element.getLocation().length() <= 0)) break;
                    throw new IllegalStateException("Conflicting multipart-config location for servlet " + servlet_name + " in " + descriptor.getResource());
                }
            }
        }
    }

    protected void visitServletMapping(Descriptor descriptor, XmlParser.Node node) {
        String servlet_name = node.getString("servlet-name", false, true);
        ServletMapping mapping = new ServletMapping();
        mapping.setServletName(servlet_name);
        ArrayList<String> paths = new ArrayList<String>();
        Iterator iter = node.iterator("url-pattern");
        while (iter.hasNext()) {
            String p = ((XmlParser.Node)iter.next()).toString(false, true);
            p = this.normalizePattern(p);
            paths.add(p);
        }
        mapping.setPathSpecs(paths.toArray(new String[paths.size()]));
        this._servletMappings = LazyList.add(this._servletMappings, mapping);
    }

    protected void visitSessionConfig(Descriptor descriptor, XmlParser.Node node) {
        XmlParser.Node tNode = node.get("session-timeout");
        if (tNode != null) {
            int timeout = Integer.parseInt(tNode.toString(false, true));
            this._context.getSessionHandler().getSessionManager().setMaxInactiveInterval(timeout * 60);
        }
        Iterator iter = node.iterator("tracking-mode");
        HashSet<SessionTrackingMode> modes = new HashSet<SessionTrackingMode>();
        modes.addAll(this._context.getSessionHandler().getSessionManager().getEffectiveSessionTrackingModes());
        while (iter.hasNext()) {
            XmlParser.Node mNode = (XmlParser.Node)iter.next();
            String trackMode = mNode.toString(false, true);
            modes.add(SessionTrackingMode.valueOf((String)trackMode));
        }
        this._context.getSessionHandler().getSessionManager().setSessionTrackingModes(modes);
        XmlParser.Node cookieConfig = node.get("cookie-config");
        if (cookieConfig != null) {
            WebXmlProcessor.Origin o;
            String comment;
            String path;
            String domain;
            String name = cookieConfig.getString("name", false, true);
            if (name != null) {
                WebXmlProcessor.Origin o2 = this._processor.getOrigin("cookie-config.name");
                switch (o2) {
                    case NotSet: {
                        this._context.getSessionHandler().getSessionManager().getSessionCookieConfig().setName(name);
                        this._processor.setOrigin("cookie-config.name", descriptor);
                        break;
                    }
                    case WebXml: 
                    case WebDefaults: 
                    case WebOverride: {
                        if (descriptor instanceof Fragment) break;
                        this._context.getSessionHandler().getSessionManager().getSessionCookieConfig().setName(name);
                        this._processor.setOrigin("cookie-config.name", descriptor);
                        break;
                    }
                    case WebFragment: {
                        if (this._context.getSessionHandler().getSessionManager().getSessionCookieConfig().getName().equals(name)) break;
                        throw new IllegalStateException("Conflicting cookie-config name " + name + " in " + descriptor.getResource());
                    }
                }
            }
            if ((domain = cookieConfig.getString("domain", false, true)) != null) {
                WebXmlProcessor.Origin o3 = this._processor.getOrigin("cookie-config.domain");
                switch (o3) {
                    case NotSet: {
                        this._context.getSessionHandler().getSessionManager().getSessionCookieConfig().setDomain(domain);
                        this._processor.setOrigin("cookie-config.domain", descriptor);
                        break;
                    }
                    case WebXml: 
                    case WebDefaults: 
                    case WebOverride: {
                        if (descriptor instanceof Fragment) break;
                        this._context.getSessionHandler().getSessionManager().getSessionCookieConfig().setDomain(domain);
                        this._processor.setOrigin("cookie-config.domain", descriptor);
                        break;
                    }
                    case WebFragment: {
                        if (this._context.getSessionHandler().getSessionManager().getSessionCookieConfig().getDomain().equals(domain)) break;
                        throw new IllegalStateException("Conflicting cookie-config domain " + domain + " in " + descriptor.getResource());
                    }
                }
            }
            if ((path = cookieConfig.getString("path", false, true)) != null) {
                WebXmlProcessor.Origin o4 = this._processor.getOrigin("cookie-config.path");
                switch (o4) {
                    case NotSet: {
                        this._context.getSessionHandler().getSessionManager().getSessionCookieConfig().setPath(path);
                        this._processor.setOrigin("cookie-config.path", descriptor);
                        break;
                    }
                    case WebXml: 
                    case WebDefaults: 
                    case WebOverride: {
                        if (descriptor instanceof Fragment) break;
                        this._context.getSessionHandler().getSessionManager().getSessionCookieConfig().setPath(path);
                        this._processor.setOrigin("cookie-config.path", descriptor);
                        break;
                    }
                    case WebFragment: {
                        if (this._context.getSessionHandler().getSessionManager().getSessionCookieConfig().getPath().equals(path)) break;
                        throw new IllegalStateException("Conflicting cookie-config path " + path + " in " + descriptor.getResource());
                    }
                }
            }
            if ((comment = cookieConfig.getString("comment", false, true)) != null) {
                WebXmlProcessor.Origin o5 = this._processor.getOrigin("cookie-config.comment");
                switch (o5) {
                    case NotSet: {
                        this._context.getSessionHandler().getSessionManager().getSessionCookieConfig().setComment(comment);
                        this._processor.setOrigin("cookie-config.comment", descriptor);
                        break;
                    }
                    case WebXml: 
                    case WebDefaults: 
                    case WebOverride: {
                        if (descriptor instanceof Fragment) break;
                        this._context.getSessionHandler().getSessionManager().getSessionCookieConfig().setComment(comment);
                        this._processor.setOrigin("cookie-config.comment", descriptor);
                        break;
                    }
                    case WebFragment: {
                        if (this._context.getSessionHandler().getSessionManager().getSessionCookieConfig().getComment().equals(comment)) break;
                        throw new IllegalStateException("Conflicting cookie-config comment " + comment + " in " + descriptor.getResource());
                    }
                }
            }
            if ((tNode = cookieConfig.get("http-only")) != null) {
                boolean httpOnly = Boolean.parseBoolean(tNode.toString(false, true));
                o = this._processor.getOrigin("cookie-config.http-only");
                switch (o) {
                    case NotSet: {
                        this._context.getSessionHandler().getSessionManager().getSessionCookieConfig().setHttpOnly(httpOnly);
                        this._processor.setOrigin("cookie-config.http-only", descriptor);
                        break;
                    }
                    case WebXml: 
                    case WebDefaults: 
                    case WebOverride: {
                        if (descriptor instanceof Fragment) break;
                        this._context.getSessionHandler().getSessionManager().getSessionCookieConfig().setHttpOnly(httpOnly);
                        this._processor.setOrigin("cookie-config.http-only", descriptor);
                        break;
                    }
                    case WebFragment: {
                        if (this._context.getSessionHandler().getSessionManager().getSessionCookieConfig().isHttpOnly() == httpOnly) break;
                        throw new IllegalStateException("Conflicting cookie-config http-only " + httpOnly + " in " + descriptor.getResource());
                    }
                }
            }
            if ((tNode = cookieConfig.get("secure")) != null) {
                boolean secure = Boolean.parseBoolean(tNode.toString(false, true));
                o = this._processor.getOrigin("cookie-config.secure");
                switch (o) {
                    case NotSet: {
                        this._context.getSessionHandler().getSessionManager().getSessionCookieConfig().setSecure(secure);
                        this._processor.setOrigin("cookie-config.secure", descriptor);
                        break;
                    }
                    case WebXml: 
                    case WebDefaults: 
                    case WebOverride: {
                        if (descriptor instanceof Fragment) break;
                        this._context.getSessionHandler().getSessionManager().getSessionCookieConfig().setSecure(secure);
                        this._processor.setOrigin("cookie-config.secure", descriptor);
                        break;
                    }
                    case WebFragment: {
                        if (this._context.getSessionHandler().getSessionManager().getSessionCookieConfig().isSecure() == secure) break;
                        throw new IllegalStateException("Conflicting cookie-config secure " + secure + " in " + descriptor.getResource());
                    }
                }
            }
            if ((tNode = cookieConfig.get("max-age")) != null) {
                int maxAge = Integer.parseInt(tNode.toString(false, true));
                o = this._processor.getOrigin("cookie-config.max-age");
                switch (o) {
                    case NotSet: {
                        this._context.getSessionHandler().getSessionManager().getSessionCookieConfig().setMaxAge(maxAge);
                        this._processor.setOrigin("cookie-config.max-age", descriptor);
                        break;
                    }
                    case WebXml: 
                    case WebDefaults: 
                    case WebOverride: {
                        if (descriptor instanceof Fragment) break;
                        this._context.getSessionHandler().getSessionManager().getSessionCookieConfig().setMaxAge(maxAge);
                        this._processor.setOrigin("cookie-config.max-age", descriptor);
                        break;
                    }
                    case WebFragment: {
                        if (this._context.getSessionHandler().getSessionManager().getSessionCookieConfig().getMaxAge() == maxAge) break;
                        throw new IllegalStateException("Conflicting cookie-config max-age " + maxAge + " in " + descriptor.getResource());
                    }
                }
            }
        }
    }

    protected void visitMimeMapping(Descriptor descriptor, XmlParser.Node node) {
        String extension = node.getString("extension", false, true);
        if (extension != null && extension.startsWith(".")) {
            extension = extension.substring(1);
        }
        String mimeType = node.getString("mime-type", false, true);
        if (extension != null) {
            WebXmlProcessor.Origin o = this._processor.getOrigin("extension." + extension);
            switch (o) {
                case NotSet: {
                    this._context.getMimeTypes().addMimeMapping(extension, mimeType);
                    this._processor.setOrigin("extension." + extension, descriptor);
                    break;
                }
                case WebXml: 
                case WebDefaults: 
                case WebOverride: {
                    if (descriptor instanceof Fragment) break;
                    this._context.getMimeTypes().addMimeMapping(extension, mimeType);
                    this._processor.setOrigin("extension." + extension, descriptor);
                    break;
                }
                case WebFragment: {
                    Buffer buffer = this._context.getMimeTypes().getMimeByExtension("." + extension);
                    this._context.getMimeTypes();
                    if (buffer.equals(MimeTypes.CACHE.lookup(mimeType))) break;
                    throw new IllegalStateException("Conflicting mime-type " + mimeType + " for extension " + extension + " in " + descriptor.getResource());
                }
            }
        }
    }

    protected void visitWelcomeFileList(Descriptor descriptor, XmlParser.Node node) {
        WebXmlProcessor.Origin o = this._processor.getOrigin("welcome-file-list");
        switch (o) {
            case NotSet: {
                this._processor.setOrigin("weclome-file-list", descriptor);
                this.addWelcomeFiles(node);
                break;
            }
            case WebXml: {
                this.addWelcomeFiles(node);
                break;
            }
            case WebDefaults: {
                Descriptor d = this._processor.getOriginDescriptor("welcome-file-list");
                if (!(descriptor instanceof DefaultsDescriptor || descriptor instanceof OverrideDescriptor || descriptor instanceof Fragment)) {
                    this._welcomeFiles = null;
                }
                this.addWelcomeFiles(node);
                break;
            }
            case WebOverride: {
                this.addWelcomeFiles(node);
                break;
            }
            case WebFragment: {
                this.addWelcomeFiles(node);
            }
        }
    }

    protected void visitLocaleEncodingList(Descriptor descriptor, XmlParser.Node node) {
        Iterator iter = node.iterator("locale-encoding-mapping");
        while (iter.hasNext()) {
            XmlParser.Node mapping = (XmlParser.Node)iter.next();
            String locale = mapping.getString("locale", false, true);
            String encoding = mapping.getString("encoding", false, true);
            if (encoding == null) continue;
            WebXmlProcessor.Origin o = this._processor.getOrigin("locale-encoding." + locale);
            switch (o) {
                case NotSet: {
                    this._context.addLocaleEncoding(locale, encoding);
                    this._processor.setOrigin("locale-encoding." + locale, descriptor);
                    break;
                }
                case WebXml: 
                case WebDefaults: 
                case WebOverride: {
                    if (descriptor instanceof Fragment) break;
                    this._context.addLocaleEncoding(locale, encoding);
                    this._processor.setOrigin("locale-encoding." + locale, descriptor);
                    break;
                }
                case WebFragment: {
                    if (encoding.equals(this._context.getLocaleEncoding(locale))) break;
                    throw new IllegalStateException("Conflicting loacle-encoding mapping for locale " + locale + " in " + descriptor.getResource());
                }
            }
        }
    }

    protected void visitErrorPage(Descriptor descriptor, XmlParser.Node node) {
        String error = node.getString("error-code", false, true);
        if (error == null || error.length() == 0) {
            error = node.getString("exception-type", false, true);
        }
        String location = node.getString("location", false, true);
        if (this._errorPages == null) {
            this._errorPages = new HashMap();
        }
        WebXmlProcessor.Origin o = this._processor.getOrigin("error." + error);
        switch (o) {
            case NotSet: {
                this._errorPages.put(error, location);
                this._processor.setOrigin("error." + error, descriptor);
                break;
            }
            case WebXml: 
            case WebDefaults: 
            case WebOverride: {
                if (descriptor instanceof Fragment) break;
                this._errorPages.put(error, location);
                this._processor.setOrigin("error." + error, descriptor);
                break;
            }
            case WebFragment: {
                if (this._errorPages.get(error).equals(location)) break;
                throw new IllegalStateException("Conflicting error-code or exception-type " + error + " in " + descriptor.getResource());
            }
        }
    }

    protected void addWelcomeFiles(XmlParser.Node node) {
        Iterator iter = node.iterator("welcome-file");
        while (iter.hasNext()) {
            XmlParser.Node indexNode = (XmlParser.Node)iter.next();
            String welcome = indexNode.toString(false, true);
            this._welcomeFiles = LazyList.add(this._welcomeFiles, welcome);
        }
    }

    protected void visitTagLib(Descriptor descriptor, XmlParser.Node node) {
        String uri = node.getString("taglib-uri", false, true);
        String location = node.getString("taglib-location", false, true);
        this._context.setResourceAlias(uri, location);
    }

    protected void visitJspConfig(Descriptor descriptor, XmlParser.Node node) {
        String jspName;
        for (int i = 0; i < node.size(); ++i) {
            Object o = node.get(i);
            if (!(o instanceof XmlParser.Node) || !"taglib".equals(((XmlParser.Node)o).getTag())) continue;
            this.visitTagLib(descriptor, (XmlParser.Node)o);
        }
        Iterator iter = node.iterator("jsp-property-group");
        Object paths = null;
        while (iter.hasNext()) {
            XmlParser.Node group = (XmlParser.Node)iter.next();
            Iterator iter2 = group.iterator("url-pattern");
            while (iter2.hasNext()) {
                String url = ((XmlParser.Node)iter2.next()).toString(false, true);
                url = this.normalizePattern(url);
                paths = LazyList.add(paths, url);
            }
        }
        if (LazyList.size(paths) > 0 && (jspName = this.getJSPServletName()) != null) {
            ServletMapping mapping = new ServletMapping();
            mapping.setServletName(jspName);
            mapping.setPathSpecs(LazyList.toStringArray(paths));
            this._servletMappings = LazyList.add(this._servletMappings, mapping);
        }
    }

    protected void visitSecurityConstraint(Descriptor descriptor, XmlParser.Node node) {
        Constraint scBase = new Constraint();
        try {
            XmlParser.Node data;
            XmlParser.Node auths = node.get("auth-constraint");
            if (auths != null) {
                scBase.setAuthenticate(true);
                Iterator iter = auths.iterator("role-name");
                Object roles = null;
                while (iter.hasNext()) {
                    String role = ((XmlParser.Node)iter.next()).toString(false, true);
                    roles = LazyList.add(roles, role);
                }
                scBase.setRoles(LazyList.toStringArray(roles));
            }
            if ((data = node.get("user-data-constraint")) != null) {
                String guarantee = (data = data.get("transport-guarantee")).toString(false, true).toUpperCase();
                if (guarantee == null || guarantee.length() == 0 || "NONE".equals(guarantee)) {
                    scBase.setDataConstraint(0);
                } else if ("INTEGRAL".equals(guarantee)) {
                    scBase.setDataConstraint(1);
                } else if ("CONFIDENTIAL".equals(guarantee)) {
                    scBase.setDataConstraint(2);
                } else {
                    Log.warn("Unknown user-data-constraint:" + guarantee);
                    scBase.setDataConstraint(2);
                }
            }
            Iterator iter = node.iterator("web-resource-collection");
            while (iter.hasNext()) {
                XmlParser.Node collection = (XmlParser.Node)iter.next();
                String name = collection.getString("web-resource-name", false, true);
                Constraint sc = (Constraint)scBase.clone();
                sc.setName(name);
                Iterator iter2 = collection.iterator("url-pattern");
                while (iter2.hasNext()) {
                    String url = ((XmlParser.Node)iter2.next()).toString(false, true);
                    url = this.normalizePattern(url);
                    Iterator iter3 = collection.iterator("http-method");
                    if (iter3.hasNext()) {
                        while (iter3.hasNext()) {
                            String method = ((XmlParser.Node)iter3.next()).toString(false, true);
                            ConstraintMapping mapping = new ConstraintMapping();
                            mapping.setMethod(method);
                            mapping.setPathSpec(url);
                            mapping.setConstraint(sc);
                            this._constraintMappings = LazyList.add(this._constraintMappings, mapping);
                        }
                        continue;
                    }
                    ConstraintMapping mapping = new ConstraintMapping();
                    mapping.setPathSpec(url);
                    mapping.setConstraint(sc);
                    this._constraintMappings = LazyList.add(this._constraintMappings, mapping);
                }
            }
        }
        catch (CloneNotSupportedException e) {
            Log.warn(e);
        }
    }

    protected void visitLoginConfig(Descriptor descriptor, XmlParser.Node node) throws Exception {
        XmlParser.Node method = node.get("auth-method");
        if (method != null) {
            WebXmlProcessor.Origin o = this._processor.getOrigin("auth-method");
            switch (o) {
                case NotSet: {
                    this._securityHandler.setAuthMethod(method.toString(false, true));
                    this._processor.setOrigin("auth-method", descriptor);
                    break;
                }
                case WebXml: 
                case WebDefaults: 
                case WebOverride: {
                    if (descriptor instanceof Fragment) break;
                    this._securityHandler.setAuthMethod(method.toString(false, true));
                    this._processor.setOrigin("auth-method", descriptor);
                    break;
                }
                case WebFragment: {
                    if (this._securityHandler.getAuthMethod().equals(method.toString(false, true))) break;
                    throw new IllegalStateException("Conflicting auth-method value in " + descriptor.getResource());
                }
            }
            XmlParser.Node name = node.get("realm-name");
            String nameStr = name == null ? "default" : name.toString(false, true);
            o = this._processor.getOrigin("realm-name");
            switch (o) {
                case NotSet: {
                    this._securityHandler.setRealmName(nameStr);
                    this._processor.setOrigin("realm-name", descriptor);
                    break;
                }
                case WebXml: 
                case WebDefaults: 
                case WebOverride: {
                    if (descriptor instanceof Fragment) break;
                    this._securityHandler.setRealmName(nameStr);
                    this._processor.setOrigin("realm-name", descriptor);
                    break;
                }
                case WebFragment: {
                    if (this._securityHandler.getRealmName().equals(nameStr)) break;
                    throw new IllegalStateException("Conflicting realm-name value in " + descriptor.getResource());
                }
            }
            if ("FORM".equals(this._securityHandler.getAuthMethod())) {
                XmlParser.Node formConfig = node.get("form-login-config");
                if (formConfig != null) {
                    String loginPageName = null;
                    XmlParser.Node loginPage = formConfig.get("form-login-page");
                    if (loginPage != null) {
                        loginPageName = loginPage.toString(false, true);
                    }
                    String errorPageName = null;
                    XmlParser.Node errorPage = formConfig.get("form-error-page");
                    if (errorPage != null) {
                        errorPageName = errorPage.toString(false, true);
                    }
                    o = this._processor.getOrigin("form-login-page");
                    switch (o) {
                        case NotSet: {
                            this._securityHandler.setInitParameter("org.eclipse.jetty.security.form_login_page", loginPageName);
                            this._processor.setOrigin("form-login-page", descriptor);
                            break;
                        }
                        case WebXml: 
                        case WebDefaults: 
                        case WebOverride: {
                            if (descriptor instanceof Fragment) break;
                            this._securityHandler.setInitParameter("org.eclipse.jetty.security.form_login_page", loginPageName);
                            this._processor.setOrigin("form-login-page", descriptor);
                            break;
                        }
                        case WebFragment: {
                            if (this._securityHandler.getInitParameter("org.eclipse.jetty.security.form_login_page").equals(loginPageName)) break;
                            throw new IllegalStateException("Conflicting form-login-page value in " + descriptor.getResource());
                        }
                    }
                    o = this._processor.getOrigin("form-error-page");
                    switch (o) {
                        case NotSet: {
                            this._securityHandler.setInitParameter("org.eclipse.jetty.security.form_error_page", errorPageName);
                            this._processor.setOrigin("form-error-page", descriptor);
                            break;
                        }
                        case WebXml: 
                        case WebDefaults: 
                        case WebOverride: {
                            if (descriptor instanceof Fragment) break;
                            this._securityHandler.setInitParameter("org.eclipse.jetty.security.form_error_page", errorPageName);
                            this._processor.setOrigin("form-error-page", descriptor);
                            break;
                        }
                        case WebFragment: {
                            if (this._securityHandler.getInitParameter("org.eclipse.jetty.security.form_error_page").equals(errorPageName)) break;
                            throw new IllegalStateException("Conflicting form-error-page value in " + descriptor.getResource());
                        }
                    }
                } else {
                    throw new IllegalStateException("!form-login-config");
                }
            }
        }
    }

    protected void visitSecurityRole(Descriptor descriptor, XmlParser.Node node) {
        XmlParser.Node roleNode = node.get("role-name");
        String role = roleNode.toString(false, true);
        this._roles.add(role);
    }

    protected void visitFilter(Descriptor descriptor, XmlParser.Node node) {
        String filter_class;
        String name = node.getString("filter-name", false, true);
        FilterHolder holder = this._servletHandler.getFilter(name);
        if (holder == null) {
            holder = this._servletHandler.newFilterHolder(Holder.Source.DESCRIPTOR);
            holder.setName(name);
            this._filters = LazyList.add(this._filters, holder);
        }
        if ((filter_class = node.getString("filter-class", false, true)) != null) {
            WebXmlProcessor.Origin o = this._processor.getOrigin(name + ".filter-class");
            switch (o) {
                case NotSet: {
                    holder.setClassName(filter_class);
                    this._processor.setOrigin(name + ".filter-class", descriptor);
                    break;
                }
                case WebXml: 
                case WebDefaults: 
                case WebOverride: {
                    if (descriptor instanceof Fragment) break;
                    holder.setClassName(filter_class);
                    this._processor.setOrigin(name + ".filter-class", descriptor);
                    break;
                }
                case WebFragment: {
                    if (holder.getClassName().equals(filter_class)) break;
                    throw new IllegalStateException("Conflicting filter-class for filter " + name + " in " + descriptor.getResource());
                }
            }
        }
        Iterator iter = node.iterator("init-param");
        while (iter.hasNext()) {
            XmlParser.Node paramNode = (XmlParser.Node)iter.next();
            String pname = paramNode.getString("param-name", false, true);
            String pvalue = paramNode.getString("param-value", false, true);
            WebXmlProcessor.Origin origin = this._processor.getOrigin(name + "filter.init-param." + pname);
            switch (origin) {
                case NotSet: {
                    holder.setInitParameter(pname, pvalue);
                    this._processor.setOrigin(name + "filter.init-param." + pname, descriptor);
                    break;
                }
                case WebXml: 
                case WebDefaults: 
                case WebOverride: {
                    if (descriptor instanceof Fragment) break;
                    holder.setInitParameter(pname, pvalue);
                    this._processor.setOrigin(name + "filter.init-param." + pname, descriptor);
                    break;
                }
                case WebFragment: {
                    if (holder.getInitParameter(pname).equals(pvalue)) break;
                    throw new IllegalStateException("Mismatching init-param " + pname + "=" + pvalue + " in " + descriptor.getResource());
                }
            }
        }
        String async = node.getString("async-supported", false, true);
        if (async != null) {
            holder.setAsyncSupported(async.length() == 0 || Boolean.valueOf(async) != false);
        }
        if (async != null) {
            boolean val = async.length() == 0 || Boolean.valueOf(async) != false;
            WebXmlProcessor.Origin o = this._processor.getOrigin(name + "filter.async-supported");
            switch (o) {
                case NotSet: {
                    holder.setAsyncSupported(val);
                    this._processor.setOrigin(name + "filter.async-supported", descriptor);
                    break;
                }
                case WebXml: 
                case WebDefaults: 
                case WebOverride: {
                    if (descriptor instanceof Fragment) break;
                    holder.setAsyncSupported(val);
                    this._processor.setOrigin(name + "filter.async-supported", descriptor);
                    break;
                }
                case WebFragment: {
                    if (holder.isAsyncSupported() == val) break;
                    throw new IllegalStateException("Conflicting async-supported=" + async + " for filter " + name + " in " + descriptor.getResource());
                }
            }
        }
    }

    protected void visitFilterMapping(Descriptor descriptor, XmlParser.Node node) {
        String filter_name = node.getString("filter-name", false, true);
        FilterMapping mapping = new FilterMapping();
        mapping.setFilterName(filter_name);
        ArrayList<String> paths = new ArrayList<String>();
        Iterator iter = node.iterator("url-pattern");
        while (iter.hasNext()) {
            String p = ((XmlParser.Node)iter.next()).toString(false, true);
            p = this.normalizePattern(p);
            paths.add(p);
        }
        mapping.setPathSpecs(paths.toArray(new String[paths.size()]));
        ArrayList<String> names = new ArrayList<String>();
        iter = node.iterator("servlet-name");
        while (iter.hasNext()) {
            String n = ((XmlParser.Node)iter.next()).toString(false, true);
            names.add(n);
        }
        mapping.setServletNames(names.toArray(new String[names.size()]));
        ArrayList<DispatcherType> dispatches = new ArrayList<DispatcherType>();
        iter = node.iterator("dispatcher");
        while (iter.hasNext()) {
            String d = ((XmlParser.Node)iter.next()).toString(false, true);
            dispatches.add(FilterMapping.dispatch(d));
        }
        if (dispatches.size() > 0) {
            mapping.setDispatcherTypes(EnumSet.copyOf(dispatches));
        }
        this._filterMappings = LazyList.add(this._filterMappings, mapping);
    }

    protected void visitListener(Descriptor descriptor, XmlParser.Node node) {
        String className = node.getString("listener-class", false, true);
        Object listener = null;
        try {
            if (className != null && className.length() > 0 && !LazyList.contains(this._listenerClassNames, className)) {
                LazyList.add(this._listenerClassNames, className);
                Class<?> listenerClass = this._context.loadClass(className);
                listener = this.newListenerInstance(listenerClass);
                if (!(listener instanceof EventListener)) {
                    Log.warn("Not an EventListener: " + listener);
                    return;
                }
                this._listeners = LazyList.add(this._listeners, listener);
            }
        }
        catch (Exception e) {
            Log.warn("Could not instantiate listener " + className, e);
            return;
        }
    }

    protected void visitDistributable(Descriptor descriptor, XmlParser.Node node) {
        descriptor.setDistributable(true);
    }

    protected Object newListenerInstance(Class<? extends EventListener> clazz) throws ServletException, InstantiationException, IllegalAccessException {
        try {
            return this._context.getServletContext().createListener(clazz);
        }
        catch (ServletException se) {
            Throwable cause = se.getRootCause();
            if (cause instanceof InstantiationException) {
                throw (InstantiationException)cause;
            }
            if (cause instanceof IllegalAccessException) {
                throw (IllegalAccessException)cause;
            }
            throw se;
        }
    }

    protected String getJSPServletName() {
        PathMap.Entry entry;
        if (this._jspServletName == null && (entry = this._context.getServletHandler().getHolderEntry("test.jsp")) != null) {
            ServletHolder holder = (ServletHolder)entry.getValue();
            this._jspServletName = holder.getName();
        }
        return this._jspServletName;
    }

    protected String normalizePattern(String p) {
        if (p != null && p.length() > 0 && !p.startsWith("/") && !p.startsWith("*")) {
            return "/" + p;
        }
        return p;
    }

    protected String getSystemClassPath() {
        ClassLoader loader = this._context.getClassLoader();
        if (loader.getParent() != null) {
            loader = loader.getParent();
        }
        StringBuilder classpath = new StringBuilder();
        while (loader != null && loader instanceof URLClassLoader) {
            URL[] urls = ((URLClassLoader)loader).getURLs();
            if (urls != null) {
                for (int i = 0; i < urls.length; ++i) {
                    try {
                        Resource resource = this._context.newResource(urls[i]);
                        File file = resource.getFile();
                        if (file == null || !file.exists()) continue;
                        if (classpath.length() > 0) {
                            classpath.append(File.pathSeparatorChar);
                        }
                        classpath.append(file.getAbsolutePath());
                        continue;
                    }
                    catch (IOException e) {
                        Log.debug(e);
                    }
                }
            }
            loader = loader.getParent();
        }
        return classpath.toString();
    }
}

