/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.session;

import java.util.Collections;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionContext;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.eclipse.jetty.http.HttpCookie;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.SessionIdManager;
import org.eclipse.jetty.server.SessionManager;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.session.AbstractSession;
import org.eclipse.jetty.server.session.HashSessionIdManager;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.statistic.CounterStatistic;
import org.eclipse.jetty.util.statistic.SampleStatistic;

public abstract class AbstractSessionManager
extends AbstractLifeCycle
implements SessionManager {
    static final Logger __log = SessionHandler.__log;
    public static final int __distantFuture = 628992000;
    static final HttpSessionContext __nullSessionContext = new HttpSessionContext(){

        public HttpSession getSession(String sessionId) {
            return null;
        }

        public Enumeration getIds() {
            return Collections.enumeration(Collections.EMPTY_LIST);
        }
    };
    private boolean _usingCookies = true;
    protected int _dftMaxIdleSecs = -1;
    protected SessionHandler _sessionHandler;
    protected boolean _httpOnly = false;
    protected SessionIdManager _sessionIdManager;
    protected boolean _secureCookies = false;
    protected final List<HttpSessionAttributeListener> _sessionAttributeListeners = new CopyOnWriteArrayList<HttpSessionAttributeListener>();
    protected final List<HttpSessionListener> _sessionListeners = new CopyOnWriteArrayList<HttpSessionListener>();
    protected ClassLoader _loader;
    protected ContextHandler.Context _context;
    protected String _sessionCookie = "JSESSIONID";
    protected String _sessionIdPathParameterName = "jsessionid";
    protected String _sessionIdPathParameterNamePrefix = ";" + this._sessionIdPathParameterName + "=";
    protected String _sessionDomain;
    protected String _sessionPath;
    protected int _maxCookieAge = -1;
    protected int _refreshCookieAge;
    protected boolean _nodeIdInSessionId;
    protected boolean _checkingRemoteSessionIdEncoding;
    protected final CounterStatistic _sessionsStats = new CounterStatistic();
    protected final SampleStatistic _sessionTimeStats = new SampleStatistic();

    public ContextHandler.Context getContext() {
        return this._context;
    }

    public ContextHandler getContextHandler() {
        return this._context.getContextHandler();
    }

    public HttpCookie access(HttpSession session, boolean secure) {
        long now = System.currentTimeMillis();
        AbstractSession s = ((SessionIf)session).getSession();
        if (s.access(now) && this.isUsingCookies() && (s.isIdChanged() || this.getMaxCookieAge() > 0 && this.getRefreshCookieAge() > 0 && (now - s.getCookieSetTime()) / 1000L > (long)this.getRefreshCookieAge())) {
            HttpCookie cookie = this.getSessionCookie(session, this._context == null ? "/" : this._context.getContextPath(), secure);
            s.cookieSet();
            s.setIdChanged(false);
            return cookie;
        }
        return null;
    }

    public void addEventListener(EventListener listener) {
        if (listener instanceof HttpSessionAttributeListener) {
            this._sessionAttributeListeners.add((HttpSessionAttributeListener)listener);
        }
        if (listener instanceof HttpSessionListener) {
            this._sessionListeners.add((HttpSessionListener)listener);
        }
    }

    public void clearEventListeners() {
        this._sessionAttributeListeners.clear();
        this._sessionListeners.clear();
    }

    public void complete(HttpSession session) {
        AbstractSession s = ((SessionIf)session).getSession();
        s.complete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doStart() throws Exception {
        this._context = ContextHandler.getCurrentContext();
        this._loader = Thread.currentThread().getContextClassLoader();
        if (this._sessionIdManager == null) {
            Server server;
            Server server2 = server = this.getSessionHandler().getServer();
            synchronized (server2) {
                this._sessionIdManager = server.getSessionIdManager();
                if (this._sessionIdManager == null) {
                    this._sessionIdManager = new HashSessionIdManager();
                    server.setSessionIdManager(this._sessionIdManager);
                }
            }
        }
        if (!this._sessionIdManager.isStarted()) {
            this._sessionIdManager.start();
        }
        if (this._context != null) {
            String tmp = this._context.getInitParameter("org.eclipse.jetty.servlet.SessionCookie");
            if (tmp != null) {
                this._sessionCookie = tmp;
            }
            if ((tmp = this._context.getInitParameter("org.eclipse.jetty.servlet.SessionIdPathParameterName")) != null) {
                this.setSessionIdPathParameterName(tmp);
            }
            if (this._maxCookieAge == -1 && (tmp = this._context.getInitParameter("org.eclipse.jetty.servlet.MaxAge")) != null) {
                this._maxCookieAge = Integer.parseInt(tmp.trim());
            }
            if (this._sessionDomain == null) {
                this._sessionDomain = this._context.getInitParameter("org.eclipse.jetty.servlet.SessionDomain");
            }
            if (this._sessionPath == null) {
                this._sessionPath = this._context.getInitParameter("org.eclipse.jetty.servlet.SessionPath");
            }
            if ((tmp = this._context.getInitParameter("org.eclipse.jetty.servlet.CheckingRemoteSessionIdEncoding")) != null) {
                this._checkingRemoteSessionIdEncoding = Boolean.parseBoolean(tmp);
            }
        }
        super.doStart();
    }

    public void doStop() throws Exception {
        super.doStop();
        this.invalidateSessions();
        this._loader = null;
    }

    public boolean getHttpOnly() {
        return this._httpOnly;
    }

    public HttpSession getHttpSession(String nodeId) {
        String cluster_id = this.getSessionIdManager().getClusterId(nodeId);
        AbstractSession session = this.getSession(cluster_id);
        if (session != null && !session.getNodeId().equals(nodeId)) {
            session.setIdChanged(true);
        }
        return session;
    }

    public SessionIdManager getIdManager() {
        return this.getSessionIdManager();
    }

    public SessionIdManager getSessionIdManager() {
        return this._sessionIdManager;
    }

    public int getMaxCookieAge() {
        return this._maxCookieAge;
    }

    public int getMaxInactiveInterval() {
        return this._dftMaxIdleSecs;
    }

    @Deprecated
    public int getMaxSessions() {
        return this.getSessionsMax();
    }

    public int getSessionsMax() {
        return (int)this._sessionsStats.getMax();
    }

    public int getSessionsTotal() {
        return (int)this._sessionsStats.getTotal();
    }

    @Deprecated
    public SessionIdManager getMetaManager() {
        return this.getSessionIdManager();
    }

    @Deprecated
    public int getMinSessions() {
        return 0;
    }

    public int getRefreshCookieAge() {
        return this._refreshCookieAge;
    }

    public boolean getSecureCookies() {
        return this._secureCookies;
    }

    public String getSessionCookie() {
        return this._sessionCookie;
    }

    public HttpCookie getSessionCookie(HttpSession session, String contextPath, boolean requestIsSecure) {
        if (this.isUsingCookies()) {
            String sessionPath = this._sessionPath == null ? contextPath : this._sessionPath;
            sessionPath = sessionPath == null || sessionPath.length() == 0 ? "/" : sessionPath;
            String id = this.getNodeId(session);
            HttpCookie cookie = new HttpCookie(this._sessionCookie, id, this._sessionDomain, sessionPath, this.getMaxCookieAge(), this.getHttpOnly(), requestIsSecure && this.getSecureCookies());
            return cookie;
        }
        return null;
    }

    public String getSessionDomain() {
        return this._sessionDomain;
    }

    public SessionHandler getSessionHandler() {
        return this._sessionHandler;
    }

    public Map getSessionMap() {
        throw new UnsupportedOperationException();
    }

    public String getSessionPath() {
        return this._sessionPath;
    }

    public int getSessions() {
        return (int)this._sessionsStats.getCurrent();
    }

    public String getSessionIdPathParameterName() {
        return this._sessionIdPathParameterName;
    }

    public String getSessionIdPathParameterNamePrefix() {
        return this._sessionIdPathParameterNamePrefix;
    }

    public boolean isUsingCookies() {
        return this._usingCookies;
    }

    public boolean isValid(HttpSession session) {
        AbstractSession s = ((SessionIf)session).getSession();
        return s.isValid();
    }

    public String getClusterId(HttpSession session) {
        AbstractSession s = ((SessionIf)session).getSession();
        return s.getClusterId();
    }

    public String getNodeId(HttpSession session) {
        AbstractSession s = ((SessionIf)session).getSession();
        return s.getNodeId();
    }

    public HttpSession newHttpSession(HttpServletRequest request) {
        AbstractSession session = this.newSession(request);
        session.setMaxInactiveInterval(this._dftMaxIdleSecs);
        this.addSession(session, true);
        return session;
    }

    public void removeEventListener(EventListener listener) {
        if (listener instanceof HttpSessionAttributeListener) {
            this._sessionAttributeListeners.remove(listener);
        }
        if (listener instanceof HttpSessionListener) {
            this._sessionListeners.remove(listener);
        }
    }

    @Deprecated
    public void resetStats() {
        this.statsReset();
    }

    public void statsReset() {
        this._sessionsStats.reset(this.getSessions());
        this._sessionTimeStats.reset();
    }

    public void setHttpOnly(boolean httpOnly) {
        this._httpOnly = httpOnly;
    }

    public void setIdManager(SessionIdManager metaManager) {
        this.setSessionIdManager(metaManager);
    }

    public void setSessionIdManager(SessionIdManager metaManager) {
        this._sessionIdManager = metaManager;
    }

    public void setMaxCookieAge(int maxCookieAgeInSeconds) {
        this._maxCookieAge = maxCookieAgeInSeconds;
        if (this._maxCookieAge > 0 && this._refreshCookieAge == 0) {
            this._refreshCookieAge = this._maxCookieAge / 3;
        }
    }

    public void setMaxInactiveInterval(int seconds) {
        this._dftMaxIdleSecs = seconds;
    }

    @Deprecated
    public void setMetaManager(SessionIdManager metaManager) {
        this.setSessionIdManager(metaManager);
    }

    public void setRefreshCookieAge(int ageInSeconds) {
        this._refreshCookieAge = ageInSeconds;
    }

    public void setSecureCookies(boolean secureCookies) {
        this._secureCookies = secureCookies;
    }

    public void setSessionCookie(String cookieName) {
        this._sessionCookie = cookieName;
    }

    public void setSessionDomain(String domain) {
        this._sessionDomain = domain;
    }

    public void setSessionHandler(SessionHandler sessionHandler) {
        this._sessionHandler = sessionHandler;
    }

    public void setSessionPath(String path) {
        this._sessionPath = path;
    }

    public void setSessionIdPathParameterName(String param) {
        this._sessionIdPathParameterName = param == null || "none".equals(param) ? null : param;
        this._sessionIdPathParameterNamePrefix = param == null || "none".equals(param) ? null : ";" + this._sessionIdPathParameterName + "=";
    }

    public void setUsingCookies(boolean usingCookies) {
        this._usingCookies = usingCookies;
    }

    protected abstract void addSession(AbstractSession var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addSession(AbstractSession session, boolean created) {
        SessionIdManager sessionIdManager = this._sessionIdManager;
        synchronized (sessionIdManager) {
            this._sessionIdManager.addSession(session);
            this.addSession(session);
        }
        if (created) {
            this._sessionsStats.increment();
            if (this._sessionListeners != null) {
                HttpSessionEvent event = new HttpSessionEvent((HttpSession)session);
                for (HttpSessionListener listener : this._sessionListeners) {
                    listener.sessionCreated(event);
                }
            }
        }
    }

    public abstract AbstractSession getSession(String var1);

    protected abstract void invalidateSessions() throws Exception;

    protected abstract AbstractSession newSession(HttpServletRequest var1);

    public boolean isNodeIdInSessionId() {
        return this._nodeIdInSessionId;
    }

    public void setNodeIdInSessionId(boolean nodeIdInSessionId) {
        this._nodeIdInSessionId = nodeIdInSessionId;
    }

    public void removeSession(HttpSession session, boolean invalidate) {
        AbstractSession s = ((SessionIf)session).getSession();
        this.removeSession(s, invalidate);
    }

    public void removeSession(AbstractSession session, boolean invalidate) {
        boolean removed = this.removeSession(session.getClusterId());
        if (removed) {
            this._sessionsStats.decrement();
            this._sessionTimeStats.set(Math.round((double)(System.currentTimeMillis() - session.getCreationTime()) / 1000.0));
            this._sessionIdManager.removeSession(session);
            if (invalidate) {
                this._sessionIdManager.invalidateAll(session.getClusterId());
            }
            if (invalidate && this._sessionListeners != null) {
                HttpSessionEvent event = new HttpSessionEvent((HttpSession)session);
                for (HttpSessionListener listener : this._sessionListeners) {
                    listener.sessionDestroyed(event);
                }
            }
        }
    }

    protected abstract boolean removeSession(String var1);

    public long getSessionTimeMax() {
        return this._sessionTimeStats.getMax();
    }

    public long getSessionTimeTotal() {
        return this._sessionTimeStats.getTotal();
    }

    public double getSessionTimeMean() {
        return this._sessionTimeStats.getMean();
    }

    public double getSessionTimeStdDev() {
        return this._sessionTimeStats.getStdDev();
    }

    public boolean isCheckingRemoteSessionIdEncoding() {
        return this._checkingRemoteSessionIdEncoding;
    }

    public void setCheckingRemoteSessionIdEncoding(boolean remote) {
        this._checkingRemoteSessionIdEncoding = remote;
    }

    public void doSessionAttributeListeners(AbstractSession session, String name, Object old, Object value) {
        if (!this._sessionAttributeListeners.isEmpty()) {
            HttpSessionBindingEvent event = new HttpSessionBindingEvent((HttpSession)session, name, old == null ? value : old);
            for (HttpSessionAttributeListener l : this._sessionAttributeListeners) {
                if (old == null) {
                    l.attributeAdded(event);
                    continue;
                }
                if (value == null) {
                    l.attributeRemoved(event);
                    continue;
                }
                l.attributeReplaced(event);
            }
        }
    }

    public static interface SessionIf
    extends HttpSession {
        public AbstractSession getSession();
    }
}

