/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http.gzip;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Set;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.eclipse.jetty.http.gzip.GzipStream;
import org.eclipse.jetty.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GzipResponseWrapper
extends HttpServletResponseWrapper {
    private HttpServletRequest _request;
    private Set<String> _mimeTypes;
    private int _bufferSize = 8192;
    private int _minGzipSize = 256;
    private PrintWriter _writer;
    private GzipStream _gzStream;
    private long _contentLength = -1L;
    private boolean _noGzip;

    public GzipResponseWrapper(HttpServletRequest request, HttpServletResponse response) {
        super(response);
        this._request = request;
    }

    public void setMimeTypes(Set<String> mimeTypes) {
        this._mimeTypes = mimeTypes;
    }

    public void setBufferSize(int bufferSize) {
        this._bufferSize = bufferSize;
    }

    public void setMinGzipSize(int minGzipSize) {
        this._minGzipSize = minGzipSize;
    }

    public void setContentType(String ct) {
        int colon;
        super.setContentType(ct);
        if (ct != null && (colon = ct.indexOf(";")) > 0) {
            ct = ct.substring(0, colon);
        }
        if ((this._gzStream == null || this._gzStream._out == null) && (this._mimeTypes == null && "application/gzip".equalsIgnoreCase(ct) || this._mimeTypes != null && (ct == null || !this._mimeTypes.contains(StringUtil.asciiToLowerCase(ct))))) {
            this.noGzip();
        }
    }

    public void setStatus(int sc, String sm) {
        super.setStatus(sc, sm);
        if (sc < 200 || sc >= 300) {
            this.noGzip();
        }
    }

    public void setStatus(int sc) {
        super.setStatus(sc);
        if (sc < 200 || sc >= 300) {
            this.noGzip();
        }
    }

    public void setContentLength(int length) {
        this._contentLength = length;
        if (this._gzStream != null) {
            this._gzStream.setContentLength(length);
        }
    }

    public void addHeader(String name, String value) {
        if ("content-length".equalsIgnoreCase(name)) {
            this._contentLength = Long.parseLong(value);
            if (this._gzStream != null) {
                this._gzStream.setContentLength(this._contentLength);
            }
        } else if ("content-type".equalsIgnoreCase(name)) {
            this.setContentType(value);
        } else if ("content-encoding".equalsIgnoreCase(name)) {
            super.addHeader(name, value);
            if (!this.isCommitted()) {
                this.noGzip();
            }
        } else {
            super.addHeader(name, value);
        }
    }

    public void setHeader(String name, String value) {
        if ("content-length".equalsIgnoreCase(name)) {
            this._contentLength = Long.parseLong(value);
            if (this._gzStream != null) {
                this._gzStream.setContentLength(this._contentLength);
            }
        } else if ("content-type".equalsIgnoreCase(name)) {
            this.setContentType(value);
        } else if ("content-encoding".equalsIgnoreCase(name)) {
            super.setHeader(name, value);
            if (!this.isCommitted()) {
                this.noGzip();
            }
        } else {
            super.setHeader(name, value);
        }
    }

    public void setIntHeader(String name, int value) {
        if ("content-length".equalsIgnoreCase(name)) {
            this._contentLength = value;
            if (this._gzStream != null) {
                this._gzStream.setContentLength(this._contentLength);
            }
        } else {
            super.setIntHeader(name, value);
        }
    }

    public void flushBuffer() throws IOException {
        if (this._writer != null) {
            this._writer.flush();
        }
        if (this._gzStream != null) {
            this._gzStream.finish();
        } else {
            this.getResponse().flushBuffer();
        }
    }

    public void reset() {
        super.reset();
        if (this._gzStream != null) {
            this._gzStream.resetBuffer();
        }
        this._writer = null;
        this._gzStream = null;
        this._noGzip = false;
        this._contentLength = -1L;
    }

    public void resetBuffer() {
        super.resetBuffer();
        if (this._gzStream != null) {
            this._gzStream.resetBuffer();
        }
        this._writer = null;
        this._gzStream = null;
    }

    public void sendError(int sc, String msg) throws IOException {
        this.resetBuffer();
        super.sendError(sc, msg);
    }

    public void sendError(int sc) throws IOException {
        this.resetBuffer();
        super.sendError(sc);
    }

    public void sendRedirect(String location) throws IOException {
        this.resetBuffer();
        super.sendRedirect(location);
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this._gzStream == null) {
            if (this.getResponse().isCommitted() || this._noGzip) {
                return this.getResponse().getOutputStream();
            }
            this._gzStream = this.newGzipStream(this._request, (HttpServletResponse)this.getResponse(), this._contentLength, this._bufferSize, this._minGzipSize);
        } else if (this._writer != null) {
            throw new IllegalStateException("getWriter() called");
        }
        return this._gzStream;
    }

    public PrintWriter getWriter() throws IOException {
        if (this._writer == null) {
            if (this._gzStream != null) {
                throw new IllegalStateException("getOutputStream() called");
            }
            if (this.getResponse().isCommitted() || this._noGzip) {
                return this.getResponse().getWriter();
            }
            this._gzStream = this.newGzipStream(this._request, (HttpServletResponse)this.getResponse(), this._contentLength, this._bufferSize, this._minGzipSize);
            this._writer = this.newWriter((OutputStream)((Object)this._gzStream), this.getCharacterEncoding());
        }
        return this._writer;
    }

    public void noGzip() {
        this._noGzip = true;
        if (this._gzStream != null) {
            try {
                this._gzStream.doNotGzip();
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    public void finish() throws IOException {
        if (this._writer != null && !this._gzStream._closed) {
            this._writer.flush();
        }
        if (this._gzStream != null) {
            this._gzStream.finish();
        }
    }

    protected GzipStream newGzipStream(HttpServletRequest request, HttpServletResponse response, long contentLength, int bufferSize, int minGzipSize) throws IOException {
        return new GzipStream(request, response, contentLength, bufferSize, minGzipSize);
    }

    protected PrintWriter newWriter(OutputStream out, String encoding) throws UnsupportedEncodingException {
        return encoding == null ? new PrintWriter(out) : new PrintWriter(new OutputStreamWriter(out, encoding));
    }
}

