/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.xml;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jetty.util.LazyList;
import org.eclipse.jetty.util.Loader;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.xml.ConfigurationProcessor;
import org.eclipse.jetty.xml.ConfigurationProcessorFactory;
import org.eclipse.jetty.xml.XmlParser;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlConfiguration {
    private static final Class<?>[] __primitives = new Class[]{Boolean.TYPE, Character.TYPE, Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE, Void.TYPE};
    private static final Class<?>[] __primitiveHolders = new Class[]{Boolean.class, Character.class, Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, Void.class};
    private static final Integer ZERO = new Integer(0);
    private static final Iterable<?> __factoryLoader;
    private static XmlParser __parser;
    private URL _url;
    private XmlParser.Node _config;
    private String _dtd;
    private ConfigurationProcessor _processor;
    private final Map<String, Object> _idMap = new HashMap<String, Object>();
    private final Map<String, String> _propertyMap = new HashMap<String, String>();

    private static synchronized void initParser() throws IOException {
        if (__parser != null) {
            return;
        }
        __parser = new XmlParser();
        try {
            URL configURL = Loader.getResource(XmlConfiguration.class, "org/eclipse/jetty/xml/configure_6_0.dtd", true);
            __parser.redirectEntity("configure.dtd", configURL);
            __parser.redirectEntity("configure_1_0.dtd", configURL);
            __parser.redirectEntity("configure_1_1.dtd", configURL);
            __parser.redirectEntity("configure_1_2.dtd", configURL);
            __parser.redirectEntity("configure_1_3.dtd", configURL);
            __parser.redirectEntity("configure_6_0.dtd", configURL);
            __parser.redirectEntity("http://jetty.mortbay.org/configure.dtd", configURL);
            __parser.redirectEntity("http://jetty.eclipse.org/configure.dtd", configURL);
            __parser.redirectEntity("http://www.eclipse.org/jetty/configure.dtd", configURL);
            __parser.redirectEntity("-//Mort Bay Consulting//DTD Configure//EN", configURL);
            __parser.redirectEntity("-//Jetty//Configure//EN", configURL);
        }
        catch (ClassNotFoundException e) {
            Log.warn(e.toString());
            Log.debug(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XmlConfiguration(URL configuration) throws SAXException, IOException {
        XmlConfiguration.initParser();
        XmlParser xmlParser = __parser;
        synchronized (xmlParser) {
            this._url = configuration;
            this.setConfig(__parser.parse(configuration.toString()));
            this._dtd = __parser.getDTD();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XmlConfiguration(String configuration) throws SAXException, IOException {
        XmlConfiguration.initParser();
        configuration = "<?xml version=\"1.0\"  encoding=\"ISO-8859-1\"?>\n<!DOCTYPE Configure PUBLIC \"-//Mort Bay Consulting//DTD Configure 1.2//EN\" \"http://jetty.eclipse.org/configure_1_2.dtd\">" + configuration;
        InputSource source = new InputSource(new StringReader(configuration));
        XmlParser xmlParser = __parser;
        synchronized (xmlParser) {
            this.setConfig(__parser.parse(source));
            this._dtd = __parser.getDTD();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XmlConfiguration(InputStream configuration) throws SAXException, IOException {
        XmlConfiguration.initParser();
        InputSource source = new InputSource(configuration);
        XmlParser xmlParser = __parser;
        synchronized (xmlParser) {
            this.setConfig(__parser.parse(source));
            this._dtd = __parser.getDTD();
        }
    }

    private void setConfig(XmlParser.Node config) {
        this._config = config;
        if ("Configure".equals(config.getTag())) {
            this._processor = new JettyXmlConfiguration();
        } else if (__factoryLoader != null) {
            for (Object factory : __factoryLoader) {
                try {
                    Method gcp = factory.getClass().getMethod("getConfigurationProcessor", String.class, String.class);
                    this._processor = (ConfigurationProcessor)gcp.invoke(factory, this._dtd, config.getTag());
                }
                catch (Exception e) {
                    Log.ignore(e);
                }
                if (this._processor == null) continue;
                break;
            }
            if (this._processor == null) {
                throw new IllegalStateException("Unknown configuration type: " + config.getTag() + " in " + this);
            }
        } else {
            throw new IllegalArgumentException("Unknown XML tag:" + config.getTag());
        }
        this._processor.init(this._url, this._config, this._idMap, this._propertyMap);
    }

    public Map<String, Object> getIdMap() {
        return this._idMap;
    }

    public void setIdMap(Map<String, Object> map) {
        this._idMap.clear();
        this._idMap.putAll(map);
    }

    public void setProperties(Map<String, String> map) {
        this._propertyMap.clear();
        this._propertyMap.putAll(map);
    }

    public Map<String, String> getProperties() {
        return this._propertyMap;
    }

    public Object configure(Object obj) throws Exception {
        return this._processor.configure(obj);
    }

    public Object configure() throws Exception {
        return this._processor.configure();
    }

    public static void main(final String[] args) throws Exception {
        final AtomicReference exception = new AtomicReference();
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    int i;
                    Properties properties = null;
                    try {
                        Class<?> config = XmlConfiguration.class.getClassLoader().loadClass("org.eclipse.jetty.start.Config");
                        properties = (Properties)config.getMethod("getProperties", new Class[0]).invoke(null, new Object[0]);
                        Log.debug("org.eclipse.jetty.start.Config properties = {}", properties);
                    }
                    catch (NoClassDefFoundError e) {
                        Log.ignore(e);
                    }
                    catch (ClassNotFoundException e) {
                        Log.ignore(e);
                    }
                    catch (Exception e) {
                        Log.warn(e);
                    }
                    if (properties == null) {
                        properties = new Properties();
                        Enumeration<?> ensysprop = System.getProperties().propertyNames();
                        while (ensysprop.hasMoreElements()) {
                            String name = (String)ensysprop.nextElement();
                            properties.put(name, System.getProperty(name));
                        }
                    }
                    XmlConfiguration last = null;
                    Object[] obj = new Object[args.length];
                    for (i = 0; i < args.length; ++i) {
                        if (args[i].toLowerCase().endsWith(".properties")) {
                            properties.load(Resource.newResource(args[i]).getInputStream());
                            continue;
                        }
                        XmlConfiguration configuration = new XmlConfiguration(Resource.newResource(args[i]).getURL());
                        if (last != null) {
                            configuration.getIdMap().putAll(last.getIdMap());
                        }
                        if (properties.size() > 0) {
                            HashMap<String, String> props = new HashMap<String, String>();
                            for (Object key : properties.keySet()) {
                                props.put(key.toString(), String.valueOf(properties.get(key)));
                            }
                            configuration.setProperties(props);
                        }
                        obj[i] = configuration.configure();
                        last = configuration;
                    }
                    for (i = 0; i < args.length; ++i) {
                        LifeCycle lc;
                        if (!(obj[i] instanceof LifeCycle) || (lc = (LifeCycle)obj[i]).isRunning()) continue;
                        lc.start();
                    }
                }
                catch (AccessControlException ace) {
                    ace.printStackTrace(System.err);
                    exception.set(ace);
                }
                catch (Exception e) {
                    Log.debug("EXCEPTION ", e);
                    exception.set(e);
                }
                return null;
            }
        });
        Throwable th = (Throwable)exception.get();
        if (th != null) {
            if (th instanceof Exception) {
                throw (Exception)th;
            }
            if (th instanceof Error) {
                throw (Error)th;
            }
            if (th instanceof RuntimeException) {
                throw (RuntimeException)th;
            }
            if (th instanceof ThreadDeath) {
                throw (ThreadDeath)th;
            }
            throw new Error(th);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Iterable loader = null;
        try {
            Class<?> slc = ClassLoader.getSystemClassLoader().loadClass("java.util.ServiceLoader");
            Method load = slc.getMethod("load", Class.class);
            loader = (Iterable)load.invoke(null, ConfigurationProcessorFactory.class);
        }
        catch (Exception e) {
            Log.ignore(e);
        }
        finally {
            __factoryLoader = loader;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class JettyXmlConfiguration
    implements ConfigurationProcessor {
        XmlParser.Node _config;
        Map<String, Object> _idMap;
        Map<String, String> _propertyMap;

        private JettyXmlConfiguration() {
        }

        @Override
        public void init(URL url, XmlParser.Node config, Map<String, Object> idMap, Map<String, String> properties) {
            this._config = config;
            this._idMap = idMap;
            this._propertyMap = properties;
        }

        @Override
        public Object configure(Object obj) throws Exception {
            Class<?> oClass = this.nodeClass(this._config);
            if (oClass != null && !oClass.isInstance(obj)) {
                throw new IllegalArgumentException("Object is not of type " + oClass);
            }
            this.configure(obj, this._config, 0);
            return obj;
        }

        @Override
        public Object configure() throws Exception {
            Object obj;
            Class<?> oClass = this.nodeClass(this._config);
            String id = this._config.getAttribute("id");
            Object object = obj = id == null ? null : this._idMap.get(id);
            if (obj == null && oClass != null) {
                obj = oClass.newInstance();
            }
            if (oClass != null && !oClass.isInstance(obj)) {
                throw new ClassCastException(oClass.toString());
            }
            this.configure(obj, this._config, 0);
            return obj;
        }

        private Class<?> nodeClass(XmlParser.Node node) throws ClassNotFoundException {
            String className = node.getAttribute("class");
            if (className == null) {
                return null;
            }
            return Loader.loadClass(XmlConfiguration.class, className, true);
        }

        public void configure(Object obj, XmlParser.Node cfg, int i) throws Exception {
            String id = cfg.getAttribute("id");
            if (id != null) {
                this._idMap.put(id, obj);
            }
            while (i < cfg.size()) {
                block13: {
                    Object o = cfg.get(i);
                    if (!(o instanceof String)) {
                        XmlParser.Node node = (XmlParser.Node)o;
                        try {
                            String tag = node.getTag();
                            if ("Set".equals(tag)) {
                                this.set(obj, node);
                                break block13;
                            }
                            if ("Put".equals(tag)) {
                                this.put(obj, node);
                                break block13;
                            }
                            if ("Call".equals(tag)) {
                                this.call(obj, node);
                                break block13;
                            }
                            if ("Get".equals(tag)) {
                                this.get(obj, node);
                                break block13;
                            }
                            if ("New".equals(tag)) {
                                this.newObj(obj, node);
                                break block13;
                            }
                            if ("Array".equals(tag)) {
                                this.newArray(obj, node);
                                break block13;
                            }
                            if ("Ref".equals(tag)) {
                                this.refObj(obj, node);
                                break block13;
                            }
                            if ("Property".equals(tag)) {
                                this.propertyObj(obj, node);
                                break block13;
                            }
                            throw new IllegalStateException("Unknown tag: " + tag);
                        }
                        catch (Exception e) {
                            Log.warn("Config error at " + node, e.toString());
                            throw e;
                        }
                    }
                }
                ++i;
            }
        }

        private void set(Object obj, XmlParser.Node node) throws Exception {
            String attr = node.getAttribute("name");
            String name = "set" + attr.substring(0, 1).toUpperCase() + attr.substring(1);
            Object value = this.value(obj, node);
            Object[] arg = new Object[]{value};
            Class<?> oClass = this.nodeClass(node);
            if (oClass != null) {
                obj = null;
            } else {
                oClass = obj.getClass();
            }
            Class[] vClass = new Class[]{Object.class};
            if (value != null) {
                vClass[0] = value.getClass();
            }
            if (Log.isDebugEnabled()) {
                Log.debug("XML " + (obj != null ? obj.toString() : oClass.getName()) + "." + name + "(" + value + ")");
            }
            try {
                Method set = oClass.getMethod(name, vClass);
                set.invoke(obj, arg);
                return;
            }
            catch (IllegalArgumentException e) {
                Log.ignore(e);
            }
            catch (IllegalAccessException e) {
                Log.ignore(e);
            }
            catch (NoSuchMethodException e) {
                Log.ignore(e);
            }
            try {
                Field type = vClass[0].getField("TYPE");
                vClass[0] = (Class)type.get(null);
                Method set = oClass.getMethod(name, vClass);
                set.invoke(obj, arg);
                return;
            }
            catch (NoSuchFieldException e) {
                Log.ignore(e);
            }
            catch (IllegalArgumentException e) {
                Log.ignore(e);
            }
            catch (IllegalAccessException e) {
                Log.ignore(e);
            }
            catch (NoSuchMethodException e) {
                Log.ignore(e);
            }
            try {
                Field field = oClass.getField(attr);
                if (Modifier.isPublic(field.getModifiers())) {
                    field.set(obj, value);
                    return;
                }
            }
            catch (NoSuchFieldException e) {
                Log.ignore(e);
            }
            Method[] sets = oClass.getMethods();
            Method set = null;
            for (int s = 0; sets != null && s < sets.length; ++s) {
                Class<?>[] paramTypes = sets[s].getParameterTypes();
                if (!name.equals(sets[s].getName()) || paramTypes.length != 1) continue;
                try {
                    set = sets[s];
                    sets[s].invoke(obj, arg);
                    return;
                }
                catch (IllegalArgumentException e) {
                    Log.ignore(e);
                }
                catch (IllegalAccessException e) {
                    Log.ignore(e);
                }
                if (!paramTypes[0].isAssignableFrom(Collection.class) || !value.getClass().isArray()) continue;
                try {
                    if (paramTypes[0].isAssignableFrom(Set.class)) {
                        sets[s].invoke(obj, new HashSet<Object>(Arrays.asList((Object[])value)));
                    } else {
                        sets[s].invoke(obj, Arrays.asList((Object[])value));
                    }
                    return;
                }
                catch (IllegalArgumentException e) {
                    Log.ignore(e);
                    continue;
                }
                catch (IllegalAccessException e) {
                    Log.ignore(e);
                }
            }
            if (set != null) {
                try {
                    Class sClass = set.getParameterTypes()[0];
                    if (sClass.isPrimitive()) {
                        for (int t = 0; t < __primitives.length; ++t) {
                            if (!sClass.equals(__primitives[t])) continue;
                            sClass = __primitiveHolders[t];
                            break;
                        }
                    }
                    Constructor<?> cons = sClass.getConstructor(vClass);
                    arg[0] = cons.newInstance(arg);
                    set.invoke(obj, arg);
                    return;
                }
                catch (NoSuchMethodException e) {
                    Log.ignore(e);
                }
                catch (IllegalAccessException e) {
                    Log.ignore(e);
                }
                catch (InstantiationException e) {
                    Log.ignore(e);
                }
            }
            throw new NoSuchMethodException(oClass + "." + name + "(" + vClass[0] + ")");
        }

        private void put(Object obj, XmlParser.Node node) throws Exception {
            if (!(obj instanceof Map)) {
                throw new IllegalArgumentException("Object for put is not a Map: " + obj);
            }
            Map map = (Map)obj;
            String name = node.getAttribute("name");
            Object value = this.value(obj, node);
            map.put(name, value);
            if (Log.isDebugEnabled()) {
                Log.debug("XML " + obj + ".put(" + name + "," + value + ")");
            }
        }

        private Object get(Object obj, XmlParser.Node node) throws Exception {
            Class<?> oClass = this.nodeClass(node);
            if (oClass != null) {
                obj = null;
            } else {
                oClass = obj.getClass();
            }
            String name = node.getAttribute("name");
            String id = node.getAttribute("id");
            if (Log.isDebugEnabled()) {
                Log.debug("XML get " + name);
            }
            try {
                Method method = oClass.getMethod("get" + name.substring(0, 1).toUpperCase() + name.substring(1), null);
                obj = method.invoke(obj, (Object[])null);
                this.configure(obj, node, 0);
            }
            catch (NoSuchMethodException nsme) {
                try {
                    Field field = oClass.getField(name);
                    obj = field.get(obj);
                    this.configure(obj, node, 0);
                }
                catch (NoSuchFieldException nsfe) {
                    throw nsme;
                }
            }
            if (id != null) {
                this._idMap.put(id, obj);
            }
            return obj;
        }

        private Object call(Object obj, XmlParser.Node node) throws Exception {
            String id = node.getAttribute("id");
            Class<?> oClass = this.nodeClass(node);
            if (oClass != null) {
                obj = null;
            } else if (obj != null) {
                oClass = obj.getClass();
            }
            if (oClass == null) {
                throw new IllegalArgumentException(node.toString());
            }
            int size = 0;
            int argi = node.size();
            for (int i = 0; i < node.size(); ++i) {
                Object o = node.get(i);
                if (o instanceof String) continue;
                if (!((XmlParser.Node)o).getTag().equals("Arg")) {
                    argi = i;
                    break;
                }
                ++size;
            }
            Object[] arg = new Object[size];
            int i = 0;
            int j = 0;
            while (j < size) {
                Object o = node.get(i);
                if (!(o instanceof String)) {
                    arg[j++] = this.value(obj, (XmlParser.Node)o);
                }
                ++i;
            }
            String method = node.getAttribute("name");
            if (Log.isDebugEnabled()) {
                Log.debug("XML call " + method);
            }
            Method[] methods = oClass.getMethods();
            for (int c = 0; methods != null && c < methods.length; ++c) {
                if (!methods[c].getName().equals(method) || methods[c].getParameterTypes().length != size || Modifier.isStatic(methods[c].getModifiers()) != (obj == null) || obj == null && methods[c].getDeclaringClass() != oClass) continue;
                Object n = null;
                boolean called = false;
                try {
                    n = methods[c].invoke(obj, arg);
                    called = true;
                }
                catch (IllegalAccessException e) {
                    Log.ignore(e);
                }
                catch (IllegalArgumentException e) {
                    Log.ignore(e);
                }
                if (!called) continue;
                if (id != null) {
                    this._idMap.put(id, n);
                }
                this.configure(n, node, argi);
                return n;
            }
            throw new IllegalStateException("No Method: " + node + " on " + oClass);
        }

        private Object newObj(Object obj, XmlParser.Node node) throws Exception {
            Class<?> oClass = this.nodeClass(node);
            String id = node.getAttribute("id");
            int size = 0;
            int argi = node.size();
            for (int i = 0; i < node.size(); ++i) {
                Object o = node.get(i);
                if (o instanceof String) continue;
                if (!((XmlParser.Node)o).getTag().equals("Arg")) {
                    argi = i;
                    break;
                }
                ++size;
            }
            Object[] arg = new Object[size];
            int i = 0;
            int j = 0;
            while (j < size) {
                Object o = node.get(i);
                if (!(o instanceof String)) {
                    arg[j++] = this.value(obj, (XmlParser.Node)o);
                }
                ++i;
            }
            if (Log.isDebugEnabled()) {
                Log.debug("XML new " + oClass);
            }
            Constructor<?>[] constructors = oClass.getConstructors();
            for (int c = 0; constructors != null && c < constructors.length; ++c) {
                if (constructors[c].getParameterTypes().length != size) continue;
                Object n = null;
                boolean called = false;
                try {
                    n = constructors[c].newInstance(arg);
                    called = true;
                }
                catch (IllegalAccessException e) {
                    Log.ignore(e);
                }
                catch (InstantiationException e) {
                    Log.ignore(e);
                }
                catch (IllegalArgumentException e) {
                    Log.ignore(e);
                }
                if (!called) continue;
                if (id != null) {
                    this._idMap.put(id, n);
                }
                this.configure(n, node, argi);
                return n;
            }
            throw new IllegalStateException("No Constructor: " + node + " on " + obj);
        }

        private Object refObj(Object obj, XmlParser.Node node) throws Exception {
            String id = node.getAttribute("id");
            obj = this._idMap.get(id);
            if (obj == null) {
                throw new IllegalStateException("No object for id=" + id);
            }
            this.configure(obj, node, 0);
            return obj;
        }

        private Object newArray(Object obj, XmlParser.Node node) throws Exception {
            Class aClass = Object.class;
            String type = node.getAttribute("type");
            String id = node.getAttribute("id");
            if (type != null && (aClass = TypeUtil.fromName(type)) == null) {
                aClass = "String".equals(type) ? String.class : ("URL".equals(type) ? URL.class : ("InetAddress".equals(type) ? InetAddress.class : Loader.loadClass(XmlConfiguration.class, type, true)));
            }
            Object al = null;
            Iterator<XmlParser.Node> iter = node.iterator("Item");
            while (iter.hasNext()) {
                XmlParser.Node item = iter.next();
                String nid = item.getAttribute("id");
                Object v = this.value(obj, item);
                al = LazyList.add(al, v == null && aClass.isPrimitive() ? ZERO : v);
                if (nid == null) continue;
                this._idMap.put(nid, v);
            }
            Object array = LazyList.toArray(al, aClass);
            if (id != null) {
                this._idMap.put(id, array);
            }
            return array;
        }

        private Object newMap(Object obj, XmlParser.Node node) throws Exception {
            String id = node.getAttribute("id");
            HashMap<Object, Object> map = new HashMap<Object, Object>();
            if (id != null) {
                this._idMap.put(id, map);
            }
            for (int i = 0; i < node.size(); ++i) {
                Object o = node.get(i);
                if (o instanceof String) continue;
                XmlParser.Node entry = (XmlParser.Node)o;
                if (!entry.getTag().equals("Entry")) {
                    throw new IllegalStateException("Not an Entry");
                }
                XmlParser.Node key = null;
                XmlParser.Node value = null;
                for (int j = 0; j < entry.size(); ++j) {
                    o = entry.get(j);
                    if (o instanceof String) continue;
                    XmlParser.Node item = (XmlParser.Node)o;
                    if (!item.getTag().equals("Item")) {
                        throw new IllegalStateException("Not an Item");
                    }
                    if (key == null) {
                        key = item;
                        continue;
                    }
                    value = item;
                }
                if (key == null || value == null) {
                    throw new IllegalStateException("Missing Item in Entry");
                }
                String kid = key.getAttribute("id");
                String vid = value.getAttribute("id");
                Object k = this.value(obj, key);
                Object v = this.value(obj, value);
                map.put(k, v);
                if (kid != null) {
                    this._idMap.put(kid, k);
                }
                if (vid == null) continue;
                this._idMap.put(vid, v);
            }
            return map;
        }

        private Object propertyObj(Object obj, XmlParser.Node node) throws Exception {
            String id = node.getAttribute("id");
            String name = node.getAttribute("name");
            String defval = node.getAttribute("default");
            String prop = null;
            prop = this._propertyMap != null && this._propertyMap.containsKey(name) ? this._propertyMap.get(name) : defval;
            if (id != null) {
                this._idMap.put(id, prop);
            }
            if (prop != null) {
                this.configure(prop, node, 0);
            }
            return prop;
        }

        private Object value(Object obj, XmlParser.Node node) throws Exception {
            Object value = null;
            String type = node.getAttribute("type");
            String ref = node.getAttribute("ref");
            if (ref != null) {
                value = this._idMap.get(ref);
            } else {
                int first;
                if (node.size() == 0) {
                    if ("String".equals(type)) {
                        return "";
                    }
                    return null;
                }
                int last = node.size() - 1;
                if (type == null || !"String".equals(type)) {
                    Object item = null;
                    for (first = 0; first <= last && (item = node.get(first)) instanceof String && ((String)(item = ((String)item).trim())).length() <= 0; ++first) {
                    }
                    while (first < last && (item = node.get(last)) instanceof String && ((String)(item = ((String)item).trim())).length() <= 0) {
                        --last;
                    }
                    if (first > last) {
                        return null;
                    }
                }
                if (first == last) {
                    value = this.itemValue(obj, node.get(first));
                } else {
                    StringBuilder buf = new StringBuilder();
                    for (int i = first; i <= last; ++i) {
                        Object item = node.get(i);
                        buf.append(this.itemValue(obj, item));
                    }
                    value = buf.toString();
                }
            }
            if (value == null) {
                if ("String".equals(type)) {
                    return "";
                }
                return null;
            }
            if (type == null) {
                if (value != null && value instanceof String) {
                    return ((String)value).trim();
                }
                return value;
            }
            if ("String".equals(type) || "java.lang.String".equals(type)) {
                return value.toString();
            }
            Class pClass = TypeUtil.fromName(type);
            if (pClass != null) {
                return TypeUtil.valueOf(pClass, value.toString());
            }
            if ("URL".equals(type) || "java.net.URL".equals(type)) {
                if (value instanceof URL) {
                    return value;
                }
                try {
                    return new URL(value.toString());
                }
                catch (MalformedURLException e) {
                    throw new InvocationTargetException(e);
                }
            }
            if ("InetAddress".equals(type) || "java.net.InetAddress".equals(type)) {
                if (value instanceof InetAddress) {
                    return value;
                }
                try {
                    return InetAddress.getByName(value.toString());
                }
                catch (UnknownHostException e) {
                    throw new InvocationTargetException(e);
                }
            }
            throw new IllegalStateException("Unknown type " + type);
        }

        private Object itemValue(Object obj, Object item) throws Exception {
            if (item instanceof String) {
                return item;
            }
            XmlParser.Node node = (XmlParser.Node)item;
            String tag = node.getTag();
            if ("Call".equals(tag)) {
                return this.call(obj, node);
            }
            if ("Get".equals(tag)) {
                return this.get(obj, node);
            }
            if ("New".equals(tag)) {
                return this.newObj(obj, node);
            }
            if ("Ref".equals(tag)) {
                return this.refObj(obj, node);
            }
            if ("Array".equals(tag)) {
                return this.newArray(obj, node);
            }
            if ("Map".equals(tag)) {
                return this.newMap(obj, node);
            }
            if ("Property".equals(tag)) {
                return this.propertyObj(obj, node);
            }
            if ("SystemProperty".equals(tag)) {
                String name = node.getAttribute("name");
                String defaultValue = node.getAttribute("default");
                return System.getProperty(name, defaultValue);
            }
            Log.warn("Unknown value tag: " + node, new Throwable());
            return null;
        }
    }
}

