/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

public class Utf8StringBuilder {
    StringBuilder _buffer;
    int _more;
    int _bits;

    public Utf8StringBuilder() {
        this._buffer = new StringBuilder();
    }

    public Utf8StringBuilder(int capacity) {
        this._buffer = new StringBuilder(capacity);
    }

    public void append(byte[] b, int offset, int length) {
        int end = offset + length;
        for (int i = offset; i < end; ++i) {
            this.append(b[i]);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void append(byte b) {
        if (b >= 0) {
            if (this._more > 0) {
                this._buffer.append('?');
                this._more = 0;
                this._bits = 0;
                return;
            } else {
                this._buffer.append((char)(0x7F & b));
            }
            return;
        } else if (this._more == 0) {
            if ((b & 0xC0) != 192) {
                this._buffer.append('?');
                this._more = 0;
                this._bits = 0;
                return;
            } else if ((b & 0xE0) == 192) {
                this._more = 1;
                this._bits = b & 0x1F;
                return;
            } else if ((b & 0xF0) == 224) {
                this._more = 2;
                this._bits = b & 0xF;
                return;
            } else if ((b & 0xF8) == 240) {
                this._more = 3;
                this._bits = b & 7;
                return;
            } else if ((b & 0xFC) == 248) {
                this._more = 4;
                this._bits = b & 3;
                return;
            } else {
                if ((b & 0xFE) != 252) throw new IllegalArgumentException("!utf8");
                this._more = 5;
                this._bits = b & 1;
            }
            return;
        } else {
            if ((b & 0xC0) == 192) {
                this._buffer.append('?');
                this._more = 0;
                this._bits = 0;
                throw new IllegalArgumentException("!utf8");
            }
            this._bits = this._bits << 6 | b & 0x3F;
            if (--this._more != 0) return;
            this._buffer.append(Character.toChars(this._bits));
        }
    }

    public int length() {
        return this._buffer.length();
    }

    public void reset() {
        this._buffer.setLength(0);
        this._more = 0;
        this._bits = 0;
    }

    public StringBuilder getStringBuilder() {
        if (this._more != 0) {
            throw new IllegalStateException("!utf8");
        }
        return this._buffer;
    }

    public String toString() {
        if (this._more != 0) {
            throw new IllegalStateException("!utf8");
        }
        return this._buffer.toString();
    }
}

