/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.nio;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.channels.SelectionKey;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Arrays;
import org.eclipse.jetty.io.AsyncEndPoint;
import org.eclipse.jetty.io.ConnectedEndPoint;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.nio.AsyncConnection;
import org.eclipse.jetty.io.nio.SelectChannelEndPoint;
import org.eclipse.jetty.io.nio.SelectorManager;
import org.eclipse.jetty.server.AsyncHttpConnection;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.nio.AbstractNIOConnector;
import org.eclipse.jetty.util.component.AggregateLifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.ThreadPool;

public class SelectChannelConnector
extends AbstractNIOConnector {
    private static final Logger LOG = Log.getLogger(SelectChannelConnector.class);
    protected ServerSocketChannel _acceptChannel;
    private int _lowResourcesConnections;
    private int _lowResourcesMaxIdleTime;
    private int _localPort = -1;
    private final SelectorManager _manager = new ConnectorSelectorManager();

    public SelectChannelConnector() {
        this._manager.setMaxIdleTime(this.getMaxIdleTime());
        this.setAcceptors(Math.max(1, (Runtime.getRuntime().availableProcessors() + 3) / 4));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void accept(int acceptorID) throws IOException {
        ServerSocketChannel server;
        SelectChannelConnector selectChannelConnector = this;
        synchronized (selectChannelConnector) {
            server = this._acceptChannel;
        }
        if (server != null && server.isOpen() && this._manager.isStarted()) {
            SocketChannel channel = server.accept();
            channel.configureBlocking(false);
            Socket socket = channel.socket();
            this.configure(socket);
            this._manager.register(channel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        SelectChannelConnector selectChannelConnector = this;
        synchronized (selectChannelConnector) {
            if (this._acceptChannel != null) {
                this._acceptChannel.close();
            }
            this._acceptChannel = null;
            this._localPort = -2;
        }
    }

    public void customize(EndPoint endpoint, Request request) throws IOException {
        AsyncEndPoint aEndp = (AsyncEndPoint)endpoint;
        request.setTimeStamp(System.currentTimeMillis());
        endpoint.setMaxIdleTime(this._maxIdleTime);
        super.customize(endpoint, request);
    }

    public void persist(EndPoint endpoint) throws IOException {
        AsyncEndPoint aEndp = (AsyncEndPoint)endpoint;
        aEndp.setCheckForIdle(true);
        super.persist(endpoint);
    }

    public SelectorManager getSelectorManager() {
        return this._manager;
    }

    public synchronized Object getConnection() {
        return this._acceptChannel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLocalPort() {
        SelectChannelConnector selectChannelConnector = this;
        synchronized (selectChannelConnector) {
            return this._localPort;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() throws IOException {
        SelectChannelConnector selectChannelConnector = this;
        synchronized (selectChannelConnector) {
            if (this._acceptChannel == null) {
                this._acceptChannel = ServerSocketChannel.open();
                this._acceptChannel.configureBlocking(true);
                this._acceptChannel.socket().setReuseAddress(this.getReuseAddress());
                InetSocketAddress addr = this.getHost() == null ? new InetSocketAddress(this.getPort()) : new InetSocketAddress(this.getHost(), this.getPort());
                this._acceptChannel.socket().bind(addr, this.getAcceptQueueSize());
                this._localPort = this._acceptChannel.socket().getLocalPort();
                if (this._localPort <= 0) {
                    throw new IOException("Server channel not bound");
                }
            }
        }
    }

    public void setMaxIdleTime(int maxIdleTime) {
        this._manager.setMaxIdleTime(maxIdleTime);
        super.setMaxIdleTime(maxIdleTime);
    }

    public int getLowResourcesConnections() {
        return this._lowResourcesConnections;
    }

    public void setLowResourcesConnections(int lowResourcesConnections) {
        this._lowResourcesConnections = lowResourcesConnections;
    }

    public int getLowResourcesMaxIdleTime() {
        return this._lowResourcesMaxIdleTime;
    }

    public void setLowResourcesMaxIdleTime(int lowResourcesMaxIdleTime) {
        this._lowResourcesMaxIdleTime = lowResourcesMaxIdleTime;
        super.setLowResourcesMaxIdleTime(lowResourcesMaxIdleTime);
    }

    protected void doStart() throws Exception {
        this._manager.setSelectSets(this.getAcceptors());
        this._manager.setMaxIdleTime(this.getMaxIdleTime());
        this._manager.setLowResourcesConnections(this.getLowResourcesConnections());
        this._manager.setLowResourcesMaxIdleTime(this.getLowResourcesMaxIdleTime());
        super.doStart();
        this._manager.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStop() throws Exception {
        SelectChannelConnector selectChannelConnector = this;
        synchronized (selectChannelConnector) {
            if (this._manager.isRunning()) {
                try {
                    this._manager.stop();
                }
                catch (Exception e) {
                    LOG.warn(e);
                }
            }
        }
        super.doStop();
    }

    protected SelectChannelEndPoint newEndPoint(SocketChannel channel, SelectorManager.SelectSet selectSet, SelectionKey key) throws IOException {
        SelectChannelEndPoint endp = new SelectChannelEndPoint(channel, selectSet, key, this._maxIdleTime);
        endp.setConnection(selectSet.getManager().newConnection(channel, endp, key.attachment()));
        return endp;
    }

    protected void endPointClosed(SelectChannelEndPoint endpoint) {
        this.connectionClosed(endpoint.getConnection());
    }

    protected AsyncConnection newConnection(SocketChannel channel, AsyncEndPoint endpoint) {
        return new AsyncHttpConnection(this, endpoint, this.getServer());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(Appendable out, String indent) throws IOException {
        ServerSocketChannel channel;
        super.dump(out, indent);
        SelectChannelConnector selectChannelConnector = this;
        synchronized (selectChannelConnector) {
            channel = this._acceptChannel;
        }
        if (channel == null) {
            AggregateLifeCycle.dump(out, indent, Arrays.asList(null, "CLOSED", this._manager));
        } else {
            AggregateLifeCycle.dump(out, indent, Arrays.asList(channel, channel.isOpen() ? "OPEN" : "CLOSED", this._manager));
        }
    }

    private final class ConnectorSelectorManager
    extends SelectorManager {
        private ConnectorSelectorManager() {
        }

        public boolean dispatch(Runnable task) {
            ThreadPool pool = SelectChannelConnector.this.getThreadPool();
            if (pool == null) {
                pool = SelectChannelConnector.this.getServer().getThreadPool();
            }
            return pool.dispatch(task);
        }

        protected void endPointClosed(SelectChannelEndPoint endpoint) {
            SelectChannelConnector.this.endPointClosed(endpoint);
        }

        protected void endPointOpened(SelectChannelEndPoint endpoint) {
            SelectChannelConnector.this.connectionOpened(endpoint.getConnection());
        }

        protected void endPointUpgraded(ConnectedEndPoint endpoint, Connection oldConnection) {
            SelectChannelConnector.this.connectionUpgraded(oldConnection, endpoint.getConnection());
        }

        public AsyncConnection newConnection(SocketChannel channel, AsyncEndPoint endpoint, Object attachment) {
            return SelectChannelConnector.this.newConnection(channel, endpoint);
        }

        protected SelectChannelEndPoint newEndPoint(SocketChannel channel, SelectorManager.SelectSet selectSet, SelectionKey sKey) throws IOException {
            return SelectChannelConnector.this.newEndPoint(channel, selectSet, sKey);
        }
    }
}

