/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.session;

import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.servlet.SessionCookieConfig;
import javax.servlet.SessionTrackingMode;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionContext;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.eclipse.jetty.http.HttpCookie;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.SessionIdManager;
import org.eclipse.jetty.server.SessionManager;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.session.AbstractSession;
import org.eclipse.jetty.server.session.HashSessionIdManager;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.statistic.CounterStatistic;
import org.eclipse.jetty.util.statistic.SampleStatistic;

public abstract class AbstractSessionManager
extends AbstractLifeCycle
implements SessionManager {
    static final Logger __log = SessionHandler.__log;
    public Set<SessionTrackingMode> __defaultSessionTrackingModes = Collections.unmodifiableSet(new HashSet<SessionTrackingMode>(Arrays.asList(SessionTrackingMode.COOKIE, SessionTrackingMode.URL)));
    public static final int __distantFuture = 628992000;
    static final HttpSessionContext __nullSessionContext = new HttpSessionContext(){

        public HttpSession getSession(String sessionId) {
            return null;
        }

        public Enumeration getIds() {
            return Collections.enumeration(Collections.EMPTY_LIST);
        }
    };
    private boolean _usingCookies = true;
    protected int _dftMaxIdleSecs = -1;
    protected SessionHandler _sessionHandler;
    protected boolean _httpOnly = false;
    protected SessionIdManager _sessionIdManager;
    protected boolean _secureCookies = false;
    protected final List<HttpSessionAttributeListener> _sessionAttributeListeners = new CopyOnWriteArrayList<HttpSessionAttributeListener>();
    protected final List<HttpSessionListener> _sessionListeners = new CopyOnWriteArrayList<HttpSessionListener>();
    protected ClassLoader _loader;
    protected ContextHandler.Context _context;
    protected String _sessionCookie = "JSESSIONID";
    protected String _sessionIdPathParameterName = "jsessionid";
    protected String _sessionIdPathParameterNamePrefix = ";" + this._sessionIdPathParameterName + "=";
    protected String _sessionDomain;
    protected String _sessionPath;
    protected int _maxCookieAge = -1;
    protected int _refreshCookieAge;
    protected boolean _nodeIdInSessionId;
    protected boolean _checkingRemoteSessionIdEncoding;
    protected String _sessionComment;
    public Set<SessionTrackingMode> _sessionTrackingModes;
    private boolean _usingURLs;
    protected final CounterStatistic _sessionsStats = new CounterStatistic();
    protected final SampleStatistic _sessionTimeStats = new SampleStatistic();
    private SessionCookieConfig _cookieConfig = new SessionCookieConfig(){

        public String getComment() {
            return AbstractSessionManager.this._sessionComment;
        }

        public String getDomain() {
            return AbstractSessionManager.this._sessionDomain;
        }

        public int getMaxAge() {
            return AbstractSessionManager.this._maxCookieAge;
        }

        public String getName() {
            return AbstractSessionManager.this._sessionCookie;
        }

        public String getPath() {
            return AbstractSessionManager.this._sessionPath;
        }

        public boolean isHttpOnly() {
            return AbstractSessionManager.this._httpOnly;
        }

        public boolean isSecure() {
            return AbstractSessionManager.this._secureCookies;
        }

        public void setComment(String comment) {
            AbstractSessionManager.this._sessionComment = comment;
        }

        public void setDomain(String domain) {
            AbstractSessionManager.this._sessionDomain = domain;
        }

        public void setHttpOnly(boolean httpOnly) {
            AbstractSessionManager.this._httpOnly = httpOnly;
        }

        public void setMaxAge(int maxAge) {
            AbstractSessionManager.this._maxCookieAge = maxAge;
        }

        public void setName(String name) {
            AbstractSessionManager.this._sessionCookie = name;
        }

        public void setPath(String path) {
            AbstractSessionManager.this._sessionPath = path;
        }

        public void setSecure(boolean secure) {
            AbstractSessionManager.this._secureCookies = secure;
        }
    };

    public AbstractSessionManager() {
        this.setSessionTrackingModes(this.__defaultSessionTrackingModes);
    }

    public ContextHandler.Context getContext() {
        return this._context;
    }

    public ContextHandler getContextHandler() {
        return this._context.getContextHandler();
    }

    @Override
    public HttpCookie access(HttpSession session, boolean secure) {
        long now = System.currentTimeMillis();
        AbstractSession s = ((SessionIf)session).getSession();
        if (s.access(now) && this.isUsingCookies() && (s.isIdChanged() || this.getSessionCookieConfig().getMaxAge() > 0 && this.getRefreshCookieAge() > 0 && (now - s.getCookieSetTime()) / 1000L > (long)this.getRefreshCookieAge())) {
            HttpCookie cookie = this.getSessionCookie(session, this._context == null ? "/" : this._context.getContextPath(), secure);
            s.cookieSet();
            s.setIdChanged(false);
            return cookie;
        }
        return null;
    }

    @Override
    public void addEventListener(EventListener listener) {
        if (listener instanceof HttpSessionAttributeListener) {
            this._sessionAttributeListeners.add((HttpSessionAttributeListener)listener);
        }
        if (listener instanceof HttpSessionListener) {
            this._sessionListeners.add((HttpSessionListener)listener);
        }
    }

    @Override
    public void clearEventListeners() {
        this._sessionAttributeListeners.clear();
        this._sessionListeners.clear();
    }

    @Override
    public void complete(HttpSession session) {
        AbstractSession s = ((SessionIf)session).getSession();
        s.complete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doStart() throws Exception {
        this._context = ContextHandler.getCurrentContext();
        this._loader = Thread.currentThread().getContextClassLoader();
        if (this._sessionIdManager == null) {
            Server server;
            Server server2 = server = this.getSessionHandler().getServer();
            synchronized (server2) {
                this._sessionIdManager = server.getSessionIdManager();
                if (this._sessionIdManager == null) {
                    this._sessionIdManager = new HashSessionIdManager();
                    server.setSessionIdManager(this._sessionIdManager);
                }
            }
        }
        if (!this._sessionIdManager.isStarted()) {
            this._sessionIdManager.start();
        }
        if (this._context != null) {
            String tmp = this._context.getInitParameter("org.eclipse.jetty.servlet.SessionCookie");
            if (tmp != null) {
                this._sessionCookie = tmp;
            }
            if ((tmp = this._context.getInitParameter("org.eclipse.jetty.servlet.SessionIdPathParameterName")) != null) {
                this.setSessionIdPathParameterName(tmp);
            }
            if (this._maxCookieAge == -1 && (tmp = this._context.getInitParameter("org.eclipse.jetty.servlet.MaxAge")) != null) {
                this._maxCookieAge = Integer.parseInt(tmp.trim());
            }
            if (this._sessionDomain == null) {
                this._sessionDomain = this._context.getInitParameter("org.eclipse.jetty.servlet.SessionDomain");
            }
            if (this._sessionPath == null) {
                this._sessionPath = this._context.getInitParameter("org.eclipse.jetty.servlet.SessionPath");
            }
            if ((tmp = this._context.getInitParameter("org.eclipse.jetty.servlet.CheckingRemoteSessionIdEncoding")) != null) {
                this._checkingRemoteSessionIdEncoding = Boolean.parseBoolean(tmp);
            }
        }
        super.doStart();
    }

    @Override
    public void doStop() throws Exception {
        super.doStop();
        this.invalidateSessions();
        this._loader = null;
    }

    @Override
    public boolean getHttpOnly() {
        return this._httpOnly;
    }

    @Override
    public HttpSession getHttpSession(String nodeId) {
        String cluster_id = this.getSessionIdManager().getClusterId(nodeId);
        AbstractSession session = this.getSession(cluster_id);
        if (session != null && !session.getNodeId().equals(nodeId)) {
            session.setIdChanged(true);
        }
        return session;
    }

    public SessionIdManager getIdManager() {
        return this.getSessionIdManager();
    }

    @Override
    public SessionIdManager getSessionIdManager() {
        return this._sessionIdManager;
    }

    @Override
    public int getMaxInactiveInterval() {
        return this._dftMaxIdleSecs;
    }

    @Deprecated
    public int getMaxSessions() {
        return this.getSessionsMax();
    }

    public int getSessionsMax() {
        return (int)this._sessionsStats.getMax();
    }

    public int getSessionsTotal() {
        return (int)this._sessionsStats.getTotal();
    }

    @Override
    @Deprecated
    public SessionIdManager getMetaManager() {
        return this.getSessionIdManager();
    }

    @Deprecated
    public int getMinSessions() {
        return 0;
    }

    public int getRefreshCookieAge() {
        return this._refreshCookieAge;
    }

    @Override
    public HttpCookie getSessionCookie(HttpSession session, String contextPath, boolean requestIsSecure) {
        if (this.isUsingCookies()) {
            String sessionPath = this._sessionPath == null ? contextPath : this._sessionPath;
            sessionPath = sessionPath == null || sessionPath.length() == 0 ? "/" : sessionPath;
            String id = this.getNodeId(session);
            HttpCookie cookie = null;
            cookie = this._sessionComment == null ? new HttpCookie(this._sessionCookie, id, this._sessionDomain, sessionPath, this._cookieConfig.getMaxAge(), this._cookieConfig.isHttpOnly(), this._cookieConfig.isSecure()) : new HttpCookie(this._sessionCookie, id, this._sessionDomain, sessionPath, this._cookieConfig.getMaxAge(), this._cookieConfig.isHttpOnly(), this._cookieConfig.isSecure(), this._sessionComment, 1);
            return cookie;
        }
        return null;
    }

    public SessionHandler getSessionHandler() {
        return this._sessionHandler;
    }

    public Map getSessionMap() {
        throw new UnsupportedOperationException();
    }

    public int getSessions() {
        return (int)this._sessionsStats.getCurrent();
    }

    @Override
    public String getSessionIdPathParameterName() {
        return this._sessionIdPathParameterName;
    }

    @Override
    public String getSessionIdPathParameterNamePrefix() {
        return this._sessionIdPathParameterNamePrefix;
    }

    @Override
    public boolean isValid(HttpSession session) {
        AbstractSession s = ((SessionIf)session).getSession();
        return s.isValid();
    }

    @Override
    public String getClusterId(HttpSession session) {
        AbstractSession s = ((SessionIf)session).getSession();
        return s.getClusterId();
    }

    @Override
    public String getNodeId(HttpSession session) {
        AbstractSession s = ((SessionIf)session).getSession();
        return s.getNodeId();
    }

    @Override
    public HttpSession newHttpSession(HttpServletRequest request) {
        AbstractSession session = this.newSession(request);
        session.setMaxInactiveInterval(this._dftMaxIdleSecs);
        this.addSession(session, true);
        return session;
    }

    @Override
    public void removeEventListener(EventListener listener) {
        if (listener instanceof HttpSessionAttributeListener) {
            this._sessionAttributeListeners.remove(listener);
        }
        if (listener instanceof HttpSessionListener) {
            this._sessionListeners.remove(listener);
        }
    }

    @Deprecated
    public void resetStats() {
        this.statsReset();
    }

    public void statsReset() {
        this._sessionsStats.reset(this.getSessions());
        this._sessionTimeStats.reset();
    }

    public void setHttpOnly(boolean httpOnly) {
        this._httpOnly = httpOnly;
    }

    public void setIdManager(SessionIdManager metaManager) {
        this.setSessionIdManager(metaManager);
    }

    @Override
    public void setSessionIdManager(SessionIdManager metaManager) {
        this._sessionIdManager = metaManager;
    }

    @Override
    public void setMaxInactiveInterval(int seconds) {
        this._dftMaxIdleSecs = seconds;
    }

    public void setRefreshCookieAge(int ageInSeconds) {
        this._refreshCookieAge = ageInSeconds;
    }

    public void setSecureCookies(boolean secureCookies) {
        this._secureCookies = secureCookies;
    }

    public void setSessionCookie(String cookieName) {
        this._sessionCookie = cookieName;
    }

    public void setSessionDomain(String domain) {
        this._sessionDomain = domain;
    }

    @Override
    public void setSessionHandler(SessionHandler sessionHandler) {
        this._sessionHandler = sessionHandler;
    }

    public void setSessionPath(String path) {
        this._sessionPath = path;
    }

    @Override
    public void setSessionIdPathParameterName(String param) {
        this._sessionIdPathParameterName = param == null || "none".equals(param) ? null : param;
        this._sessionIdPathParameterNamePrefix = param == null || "none".equals(param) ? null : ";" + this._sessionIdPathParameterName + "=";
    }

    protected abstract void addSession(AbstractSession var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addSession(AbstractSession session, boolean created) {
        SessionIdManager sessionIdManager = this._sessionIdManager;
        synchronized (sessionIdManager) {
            this._sessionIdManager.addSession(session);
            this.addSession(session);
        }
        if (created) {
            this._sessionsStats.increment();
            if (this._sessionListeners != null) {
                HttpSessionEvent event = new HttpSessionEvent((HttpSession)session);
                for (HttpSessionListener listener : this._sessionListeners) {
                    listener.sessionCreated(event);
                }
            }
        }
    }

    public abstract AbstractSession getSession(String var1);

    protected abstract void invalidateSessions() throws Exception;

    protected abstract AbstractSession newSession(HttpServletRequest var1);

    public boolean isNodeIdInSessionId() {
        return this._nodeIdInSessionId;
    }

    public void setNodeIdInSessionId(boolean nodeIdInSessionId) {
        this._nodeIdInSessionId = nodeIdInSessionId;
    }

    public void removeSession(HttpSession session, boolean invalidate) {
        AbstractSession s = ((SessionIf)session).getSession();
        this.removeSession(s, invalidate);
    }

    public void removeSession(AbstractSession session, boolean invalidate) {
        boolean removed = this.removeSession(session.getClusterId());
        if (removed) {
            this._sessionsStats.decrement();
            this._sessionTimeStats.set(Math.round((double)(System.currentTimeMillis() - session.getCreationTime()) / 1000.0));
            this._sessionIdManager.removeSession(session);
            if (invalidate) {
                this._sessionIdManager.invalidateAll(session.getClusterId());
            }
            if (invalidate && this._sessionListeners != null) {
                HttpSessionEvent event = new HttpSessionEvent((HttpSession)session);
                for (HttpSessionListener listener : this._sessionListeners) {
                    listener.sessionDestroyed(event);
                }
            }
        }
    }

    protected abstract boolean removeSession(String var1);

    public long getSessionTimeMax() {
        return this._sessionTimeStats.getMax();
    }

    @Override
    public Set<SessionTrackingMode> getDefaultSessionTrackingModes() {
        return this.__defaultSessionTrackingModes;
    }

    @Override
    public Set<SessionTrackingMode> getEffectiveSessionTrackingModes() {
        return Collections.unmodifiableSet(this._sessionTrackingModes);
    }

    @Override
    public void setSessionTrackingModes(Set<SessionTrackingMode> sessionTrackingModes) {
        this._sessionTrackingModes = new HashSet<SessionTrackingMode>(sessionTrackingModes);
        this._usingCookies = this._sessionTrackingModes.contains(SessionTrackingMode.COOKIE);
        this._usingURLs = this._sessionTrackingModes.contains(SessionTrackingMode.URL);
    }

    @Override
    public boolean isUsingCookies() {
        return this._usingCookies;
    }

    @Override
    public boolean isUsingURLs() {
        return this._usingURLs;
    }

    @Override
    public SessionCookieConfig getSessionCookieConfig() {
        return this._cookieConfig;
    }

    public long getSessionTimeTotal() {
        return this._sessionTimeStats.getTotal();
    }

    public double getSessionTimeMean() {
        return this._sessionTimeStats.getMean();
    }

    public double getSessionTimeStdDev() {
        return this._sessionTimeStats.getStdDev();
    }

    @Override
    public boolean isCheckingRemoteSessionIdEncoding() {
        return this._checkingRemoteSessionIdEncoding;
    }

    @Override
    public void setCheckingRemoteSessionIdEncoding(boolean remote) {
        this._checkingRemoteSessionIdEncoding = remote;
    }

    public void doSessionAttributeListeners(AbstractSession session, String name, Object old, Object value) {
        if (!this._sessionAttributeListeners.isEmpty()) {
            HttpSessionBindingEvent event = new HttpSessionBindingEvent((HttpSession)session, name, old == null ? value : old);
            for (HttpSessionAttributeListener l : this._sessionAttributeListeners) {
                if (old == null) {
                    l.attributeAdded(event);
                    continue;
                }
                if (value == null) {
                    l.attributeRemoved(event);
                    continue;
                }
                l.attributeReplaced(event);
            }
        }
    }

    public static interface SessionIf
    extends HttpSession {
        public AbstractSession getSession();
    }
}

