/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ProtocolException;
import java.net.SocketAddress;
import java.net.URI;
import java.nio.channels.ByteChannel;
import java.nio.channels.SocketChannel;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.MaskGen;
import org.eclipse.jetty.websocket.WebSocket;
import org.eclipse.jetty.websocket.WebSocketClientFactory;
import org.eclipse.jetty.websocket.WebSocketConnection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebSocketClient {
    private static final Logger __log = Log.getLogger(WebSocketClient.class.getName());
    private final WebSocketClientFactory _factory;
    private final Map<String, String> _cookies = new ConcurrentHashMap<String, String>();
    private final List<String> _extensions = new CopyOnWriteArrayList<String>();
    private String _origin;
    private String _protocol;
    private int _maxIdleTime = -1;
    private int _maxTextMessageSize = 16384;
    private int _maxBinaryMessageSize = -1;
    private MaskGen _maskGen;
    private SocketAddress _bindAddress;

    @Deprecated
    public WebSocketClient() throws Exception {
        this._factory = new WebSocketClientFactory();
        this._factory.start();
        this._maskGen = this._factory.getMaskGen();
    }

    public WebSocketClient(WebSocketClientFactory factory) {
        this._factory = factory;
        this._maskGen = this._factory.getMaskGen();
    }

    public WebSocketClientFactory getFactory() {
        return this._factory;
    }

    public SocketAddress getBindAddress() {
        return this._bindAddress;
    }

    public void setBindAddress(SocketAddress bindAddress) {
        this._bindAddress = bindAddress;
    }

    public int getMaxIdleTime() {
        return this._maxIdleTime;
    }

    public void setMaxIdleTime(int maxIdleTime) {
        this._maxIdleTime = maxIdleTime;
    }

    public String getProtocol() {
        return this._protocol;
    }

    public void setProtocol(String protocol) {
        this._protocol = protocol;
    }

    public String getOrigin() {
        return this._origin;
    }

    public void setOrigin(String origin) {
        this._origin = origin;
    }

    public Map<String, String> getCookies() {
        return this._cookies;
    }

    public List<String> getExtensions() {
        return this._extensions;
    }

    public MaskGen getMaskGen() {
        return this._maskGen;
    }

    public void setMaskGen(MaskGen maskGen) {
        this._maskGen = maskGen;
    }

    public int getMaxTextMessageSize() {
        return this._maxTextMessageSize;
    }

    public void setMaxTextMessageSize(int maxTextMessageSize) {
        this._maxTextMessageSize = maxTextMessageSize;
    }

    public int getMaxBinaryMessageSize() {
        return this._maxBinaryMessageSize;
    }

    public void setMaxBinaryMessageSize(int maxBinaryMessageSize) {
        this._maxBinaryMessageSize = maxBinaryMessageSize;
    }

    public WebSocket.Connection open(URI uri, WebSocket websocket, long maxConnectTime, TimeUnit units) throws IOException, InterruptedException, TimeoutException {
        try {
            return this.open(uri, websocket).get(maxConnectTime, units);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(cause);
        }
    }

    public Future<WebSocket.Connection> open(URI uri, WebSocket websocket) throws IOException {
        if (!this._factory.isStarted()) {
            throw new IllegalStateException("Factory !started");
        }
        String scheme = uri.getScheme();
        if (!"ws".equalsIgnoreCase(scheme) && !"wss".equalsIgnoreCase(scheme)) {
            throw new IllegalArgumentException("Bad WebSocket scheme '" + scheme + "'");
        }
        if ("wss".equalsIgnoreCase(scheme)) {
            throw new IOException("wss not supported");
        }
        SocketChannel channel = SocketChannel.open();
        if (this._bindAddress != null) {
            channel.socket().bind(this._bindAddress);
        }
        channel.socket().setTcpNoDelay(true);
        InetSocketAddress address = new InetSocketAddress(uri.getHost(), uri.getPort());
        WebSocketFuture holder = new WebSocketFuture(websocket, uri, this, channel);
        channel.configureBlocking(false);
        channel.connect(address);
        this._factory.getSelectorManager().register(channel, holder);
        return holder;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class WebSocketFuture
    implements Future<WebSocket.Connection> {
        final WebSocket _websocket;
        final URI _uri;
        final String _protocol;
        final String _origin;
        final MaskGen _maskGen;
        final int _maxIdleTime;
        final int _maxTextMessageSize;
        final int _maxBinaryMessageSize;
        final Map<String, String> _cookies;
        final List<String> _extensions;
        final CountDownLatch _done = new CountDownLatch(1);
        ByteChannel _channel;
        WebSocketConnection _connection;
        Throwable _exception;

        private WebSocketFuture(WebSocket websocket, URI uri, WebSocketClient client, ByteChannel channel) {
            this._websocket = websocket;
            this._uri = uri;
            this._protocol = client._protocol;
            this._origin = client._origin;
            this._maskGen = client._maskGen;
            this._maxIdleTime = client._maxIdleTime;
            this._maxTextMessageSize = client._maxTextMessageSize;
            this._maxBinaryMessageSize = client._maxBinaryMessageSize;
            this._cookies = client._cookies;
            this._extensions = client._extensions;
            this._channel = channel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onConnection(WebSocketConnection connection) {
            try {
                WebSocketConnection con;
                connection.getConnection().setMaxTextMessageSize(this._maxTextMessageSize);
                connection.getConnection().setMaxBinaryMessageSize(this._maxBinaryMessageSize);
                WebSocketFuture webSocketFuture = this;
                synchronized (webSocketFuture) {
                    if (this._channel != null) {
                        this._connection = connection;
                    }
                    con = this._connection;
                }
                if (con != null) {
                    if (this._websocket instanceof WebSocket.OnFrame) {
                        ((WebSocket.OnFrame)this._websocket).onHandshake((WebSocket.FrameConnection)con.getConnection());
                    }
                    this._websocket.onOpen(con.getConnection());
                }
                Object var6_5 = null;
                this._done.countDown();
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                this._done.countDown();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handshakeFailed(Throwable ex) {
            try {
                ByteChannel channel = null;
                WebSocketFuture webSocketFuture = this;
                synchronized (webSocketFuture) {
                    if (this._channel != null) {
                        channel = this._channel;
                        this._channel = null;
                        this._exception = ex;
                    }
                }
                if (channel != null) {
                    if (ex instanceof ProtocolException) {
                        this.closeChannel(channel, 1002, ex.getMessage());
                    } else {
                        this.closeChannel(channel, 1006, ex.getMessage());
                    }
                }
                Object var6_5 = null;
                this._done.countDown();
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                this._done.countDown();
                throw throwable;
            }
        }

        public Map<String, String> getCookies() {
            return this._cookies;
        }

        public String getProtocol() {
            return this._protocol;
        }

        public WebSocket getWebSocket() {
            return this._websocket;
        }

        public URI getURI() {
            return this._uri;
        }

        public int getMaxIdleTime() {
            return this._maxIdleTime;
        }

        public String getOrigin() {
            return this._origin;
        }

        public MaskGen getMaskGen() {
            return this._maskGen;
        }

        public String toString() {
            return "[" + this._uri + "," + this._websocket + "]@" + this.hashCode();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            block7: {
                try {
                    ByteChannel channel = null;
                    WebSocketFuture webSocketFuture = this;
                    synchronized (webSocketFuture) {
                        if (this._connection == null && this._exception == null && this._channel != null) {
                            channel = this._channel;
                            this._channel = null;
                        }
                    }
                    if (channel == null) break block7;
                    this.closeChannel(channel, 1006, "cancelled");
                    boolean bl = true;
                    Object var6_7 = null;
                    this._done.countDown();
                    return bl;
                }
                catch (Throwable throwable) {
                    Object var6_9 = null;
                    this._done.countDown();
                    throw throwable;
                }
            }
            boolean bl = false;
            Object var6_8 = null;
            this._done.countDown();
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isCancelled() {
            WebSocketFuture webSocketFuture = this;
            synchronized (webSocketFuture) {
                return this._channel == null && this._connection == null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isDone() {
            WebSocketFuture webSocketFuture = this;
            synchronized (webSocketFuture) {
                return this._connection != null && this._exception == null;
            }
        }

        @Override
        public WebSocket.Connection get() throws InterruptedException, ExecutionException {
            try {
                return this.get(Long.MAX_VALUE, TimeUnit.SECONDS);
            }
            catch (TimeoutException e) {
                throw new IllegalStateException("The universe has ended", e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public WebSocket.Connection get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            Throwable exception;
            this._done.await(timeout, unit);
            ByteChannel channel = null;
            WebSocket.Connection connection = null;
            WebSocketFuture webSocketFuture = this;
            synchronized (webSocketFuture) {
                exception = this._exception;
                if (this._connection == null) {
                    exception = this._exception;
                    channel = this._channel;
                    this._channel = null;
                } else {
                    connection = this._connection.getConnection();
                }
            }
            if (channel != null) {
                this.closeChannel(channel, 1006, "timeout");
            }
            if (exception != null) {
                throw new ExecutionException(exception);
            }
            if (connection != null) {
                return connection;
            }
            throw new TimeoutException();
        }

        private void closeChannel(ByteChannel channel, int code, String message) {
            try {
                this._websocket.onClose(code, message);
            }
            catch (Exception e) {
                __log.warn(e);
            }
            try {
                channel.close();
            }
            catch (IOException e) {
                __log.debug(e);
            }
        }
    }
}

