/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.session;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import javax.naming.InitialContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.sql.DataSource;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.SessionManager;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.session.AbstractSessionIdManager;
import org.eclipse.jetty.server.session.JDBCSessionManager;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.util.log.Log;

public class JDBCSessionIdManager
extends AbstractSessionIdManager {
    protected final HashSet<String> _sessionIds = new HashSet();
    protected Server _server;
    protected String _driverClassName;
    protected String _connectionUrl;
    protected DataSource _datasource;
    protected String _jndiName;
    protected String _sessionIdTable = "JettySessionIds";
    protected String _sessionTable = "JettySessions";
    protected String _sessionTableRowId = "rowId";
    protected Timer _timer;
    protected TimerTask _task;
    protected long _lastScavengeTime;
    protected long _scavengeIntervalMs = 600000L;
    protected String _blobType;
    protected String _createSessionIdTable;
    protected String _createSessionTable;
    protected String _selectExpiredSessions;
    protected String _deleteOldExpiredSessions;
    protected String _insertId;
    protected String _deleteId;
    protected String _queryId;
    protected DatabaseAdaptor _dbAdaptor;

    public JDBCSessionIdManager(Server server) {
        this._server = server;
    }

    public JDBCSessionIdManager(Server server, Random random) {
        super(random);
        this._server = server;
    }

    public void setDriverInfo(String driverClassName, String connectionUrl) {
        this._driverClassName = driverClassName;
        this._connectionUrl = connectionUrl;
    }

    public String getDriverClassName() {
        return this._driverClassName;
    }

    public String getConnectionUrl() {
        return this._connectionUrl;
    }

    public void setDatasourceName(String jndi) {
        this._jndiName = jndi;
    }

    public String getDatasourceName() {
        return this._jndiName;
    }

    public void setBlobType(String name) {
        this._blobType = name;
    }

    public String getBlobType() {
        return this._blobType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setScavengeInterval(long sec) {
        long period;
        if (sec <= 0L) {
            sec = 60L;
        }
        long old_period = this._scavengeIntervalMs;
        this._scavengeIntervalMs = period = sec * 1000L;
        long tenPercent = this._scavengeIntervalMs / 10L;
        if (System.currentTimeMillis() % 2L == 0L) {
            this._scavengeIntervalMs += tenPercent;
        }
        if (Log.isDebugEnabled()) {
            Log.debug("Scavenging every " + this._scavengeIntervalMs + " ms");
        }
        if (this._timer != null && (period != old_period || this._task == null)) {
            JDBCSessionIdManager jDBCSessionIdManager = this;
            synchronized (jDBCSessionIdManager) {
                if (this._task != null) {
                    this._task.cancel();
                }
                this._task = new TimerTask(){

                    public void run() {
                        JDBCSessionIdManager.this.scavenge();
                    }
                };
                this._timer.schedule(this._task, this._scavengeIntervalMs, this._scavengeIntervalMs);
            }
        }
    }

    public long getScavengeInterval() {
        return this._scavengeIntervalMs / 1000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSession(HttpSession session) {
        if (session == null) {
            return;
        }
        HashSet<String> hashSet = this._sessionIds;
        synchronized (hashSet) {
            String id = ((JDBCSessionManager.Session)session).getClusterId();
            try {
                this.insert(id);
                this._sessionIds.add(id);
            }
            catch (Exception e) {
                Log.warn("Problem storing session id=" + id, e);
            }
        }
    }

    public void removeSession(HttpSession session) {
        if (session == null) {
            return;
        }
        this.removeSession(((JDBCSessionManager.Session)session).getClusterId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSession(String id) {
        if (id == null) {
            return;
        }
        HashSet<String> hashSet = this._sessionIds;
        synchronized (hashSet) {
            if (Log.isDebugEnabled()) {
                Log.debug("Removing session id=" + id);
            }
            try {
                this._sessionIds.remove(id);
                this.delete(id);
            }
            catch (Exception e) {
                Log.warn("Problem removing session id=" + id, e);
            }
        }
    }

    public String getClusterId(String nodeId) {
        int dot = nodeId.lastIndexOf(46);
        return dot > 0 ? nodeId.substring(0, dot) : nodeId;
    }

    public String getNodeId(String clusterId, HttpServletRequest request) {
        if (this._workerName != null) {
            return clusterId + '.' + this._workerName;
        }
        return clusterId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean idInUse(String id) {
        if (id == null) {
            return false;
        }
        String clusterId = this.getClusterId(id);
        boolean inUse = false;
        HashSet<String> hashSet = this._sessionIds;
        synchronized (hashSet) {
            inUse = this._sessionIds.contains(clusterId);
        }
        if (inUse) {
            return true;
        }
        try {
            return this.exists(clusterId);
        }
        catch (Exception e) {
            Log.warn("Problem checking inUse for id=" + clusterId, e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateAll(String id) {
        this.removeSession(id);
        HashSet<String> hashSet = this._sessionIds;
        synchronized (hashSet) {
            Handler[] contexts = this._server.getChildHandlersByClass(ContextHandler.class);
            for (int i = 0; contexts != null && i < contexts.length; ++i) {
                SessionManager manager;
                SessionHandler sessionHandler = ((ContextHandler)contexts[i]).getChildHandlerByClass(SessionHandler.class);
                if (sessionHandler == null || (manager = sessionHandler.getSessionManager()) == null || !(manager instanceof JDBCSessionManager)) continue;
                ((JDBCSessionManager)manager).invalidateSession(id);
            }
        }
    }

    public void doStart() {
        try {
            this.initializeDatabase();
            this.prepareTables();
            super.doStart();
            if (Log.isDebugEnabled()) {
                Log.debug("Scavenging interval = " + this.getScavengeInterval() + " sec");
            }
            this._timer = new Timer("JDBCSessionScavenger", true);
            this.setScavengeInterval(this.getScavengeInterval());
        }
        catch (Exception e) {
            Log.warn("Problem initialising JettySessionIds table", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doStop() throws Exception {
        JDBCSessionIdManager jDBCSessionIdManager = this;
        synchronized (jDBCSessionIdManager) {
            if (this._task != null) {
                this._task.cancel();
            }
            if (this._timer != null) {
                this._timer.cancel();
            }
            this._timer = null;
        }
        super.doStop();
    }

    protected Connection getConnection() throws SQLException {
        if (this._datasource != null) {
            return this._datasource.getConnection();
        }
        return DriverManager.getConnection(this._connectionUrl);
    }

    private void initializeDatabase() throws Exception {
        if (this._jndiName != null) {
            InitialContext ic = new InitialContext();
            this._datasource = (DataSource)ic.lookup(this._jndiName);
        } else if (this._driverClassName != null && this._connectionUrl != null) {
            Class.forName(this._driverClassName);
        } else {
            throw new IllegalStateException("No database configured for sessions");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void prepareTables() throws SQLException {
        this._createSessionIdTable = "create table " + this._sessionIdTable + " (id varchar(120), primary key(id))";
        this._selectExpiredSessions = "select * from " + this._sessionTable + " where expiryTime >= ? and expiryTime <= ?";
        this._deleteOldExpiredSessions = "delete from " + this._sessionTable + " where expiryTime >0 and expiryTime <= ?";
        this._insertId = "insert into " + this._sessionIdTable + " (id)  values (?)";
        this._deleteId = "delete from " + this._sessionIdTable + " where id = ?";
        this._queryId = "select * from " + this._sessionIdTable + " where id = ?";
        Connection connection = null;
        try {
            connection = this.getConnection();
            connection.setAutoCommit(true);
            DatabaseMetaData metaData = connection.getMetaData();
            this._dbAdaptor = new DatabaseAdaptor(metaData);
            this._sessionTableRowId = this._dbAdaptor.getDBName() != null && this._dbAdaptor.getDBName().contains("oracle") ? "srowId" : this._sessionTableRowId;
            String tableName = this._dbAdaptor.convertIdentifier(this._sessionIdTable);
            ResultSet result = metaData.getTables(null, null, tableName, null);
            if (!result.next()) {
                connection.createStatement().executeUpdate(this._createSessionIdTable);
            }
            if (!(result = metaData.getTables(null, null, tableName = this._dbAdaptor.convertIdentifier(this._sessionTable), null)).next()) {
                String blobType = this._dbAdaptor.getBlobType();
                this._createSessionTable = "create table " + this._sessionTable + " (" + this._sessionTableRowId + " varchar(120), sessionId varchar(120), " + " contextPath varchar(60), virtualHost varchar(60), lastNode varchar(60), accessTime bigint, " + " lastAccessTime bigint, createTime bigint, cookieTime bigint, " + " lastSavedTime bigint, expiryTime bigint, map " + blobType + ", primary key(" + this._sessionTableRowId + "))";
                connection.createStatement().executeUpdate(this._createSessionTable);
            }
            String index1 = "idx_" + this._sessionTable + "_expiry";
            String index2 = "idx_" + this._sessionTable + "_session";
            result = metaData.getIndexInfo(null, null, tableName, false, false);
            boolean index1Exists = false;
            boolean index2Exists = false;
            while (result.next()) {
                String idxName = result.getString("INDEX_NAME");
                if (index1.equalsIgnoreCase(idxName)) {
                    index1Exists = true;
                    continue;
                }
                if (!index2.equalsIgnoreCase(idxName)) continue;
                index2Exists = true;
            }
            if (!index1Exists || !index2Exists) {
                Statement statement = connection.createStatement();
                if (!index1Exists) {
                    statement.executeUpdate("create index " + index1 + " on " + this._sessionTable + " (expiryTime)");
                }
                if (!index2Exists) {
                    statement.executeUpdate("create index " + index2 + " on " + this._sessionTable + " (sessionId, contextPath)");
                }
            }
            Object var11_10 = null;
            if (connection == null) return;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            if (connection == null) throw throwable;
            connection.close();
            throw throwable;
        }
        connection.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void insert(String id) throws SQLException {
        Connection connection = null;
        try {
            connection = this.getConnection();
            connection.setAutoCommit(true);
            PreparedStatement query = connection.prepareStatement(this._queryId);
            query.setString(1, id);
            ResultSet result = query.executeQuery();
            if (!result.next()) {
                PreparedStatement statement = connection.prepareStatement(this._insertId);
                statement.setString(1, id);
                statement.executeUpdate();
            }
            Object var7_6 = null;
            if (connection == null) return;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (connection == null) throw throwable;
            connection.close();
            throw throwable;
        }
        connection.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void delete(String id) throws SQLException {
        Connection connection = null;
        try {
            connection = this.getConnection();
            connection.setAutoCommit(true);
            PreparedStatement statement = connection.prepareStatement(this._deleteId);
            statement.setString(1, id);
            statement.executeUpdate();
            Object var5_4 = null;
            if (connection == null) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (connection == null) throw throwable;
            connection.close();
            throw throwable;
        }
        connection.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean exists(String id) throws SQLException {
        boolean bl;
        block2: {
            Connection connection = null;
            try {
                connection = this.getConnection();
                connection.setAutoCommit(true);
                PreparedStatement statement = connection.prepareStatement(this._queryId);
                statement.setString(1, id);
                ResultSet result = statement.executeQuery();
                bl = result.next();
                Object var7_6 = null;
                if (connection == null) break block2;
            }
            catch (Throwable throwable) {
                block3: {
                    Object var7_7 = null;
                    if (connection == null) break block3;
                    connection.close();
                }
                throw throwable;
            }
            connection.close();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void scavenge() {
        block20: {
            Connection connection = null;
            ArrayList<String> expiredSessionIds = new ArrayList<String>();
            try {
                block19: {
                    if (Log.isDebugEnabled()) {
                        Log.debug("Scavenge sweep started at " + System.currentTimeMillis());
                    }
                    if (this._lastScavengeTime <= 0L) break block19;
                    connection = this.getConnection();
                    connection.setAutoCommit(true);
                    PreparedStatement statement = connection.prepareStatement(this._selectExpiredSessions);
                    long lowerBound = this._lastScavengeTime - this._scavengeIntervalMs;
                    long upperBound = this._lastScavengeTime;
                    if (Log.isDebugEnabled()) {
                        Log.debug(" Searching for sessions expired between " + lowerBound + " and " + upperBound);
                    }
                    statement.setLong(1, lowerBound);
                    statement.setLong(2, upperBound);
                    ResultSet result = statement.executeQuery();
                    while (result.next()) {
                        String sessionId = result.getString("sessionId");
                        expiredSessionIds.add(sessionId);
                        if (!Log.isDebugEnabled()) continue;
                        Log.debug(" Found expired sessionId=" + sessionId);
                    }
                    Handler[] contexts = this._server.getChildHandlersByClass(ContextHandler.class);
                    for (int i = 0; contexts != null && i < contexts.length; ++i) {
                        SessionManager manager;
                        SessionHandler sessionHandler = ((ContextHandler)contexts[i]).getChildHandlerByClass(SessionHandler.class);
                        if (sessionHandler == null || (manager = sessionHandler.getSessionManager()) == null || !(manager instanceof JDBCSessionManager)) continue;
                        ((JDBCSessionManager)manager).expire(expiredSessionIds);
                    }
                    upperBound = this._lastScavengeTime - 2L * this._scavengeIntervalMs;
                    if (upperBound <= 0L) break block19;
                    if (Log.isDebugEnabled()) {
                        Log.debug("Deleting old expired sessions expired before " + upperBound);
                    }
                    statement = connection.prepareStatement(this._deleteOldExpiredSessions);
                    statement.setLong(1, upperBound);
                    statement.executeUpdate();
                }
                Object var14_12 = null;
            }
            catch (Throwable throwable) {
                Object var14_14 = null;
                this._lastScavengeTime = System.currentTimeMillis();
                if (Log.isDebugEnabled()) {
                    Log.debug("Scavenge sweep ended at " + this._lastScavengeTime);
                }
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (SQLException e2) {
                        Log.warn(e2);
                    }
                }
                throw throwable;
            }
            this._lastScavengeTime = System.currentTimeMillis();
            if (Log.isDebugEnabled()) {
                Log.debug("Scavenge sweep ended at " + this._lastScavengeTime);
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e2) {
                    Log.warn(e2);
                }
            }
            break block20;
            {
                catch (Exception e) {
                    Log.warn("Problem selecting expired sessions", e);
                    Object var14_13 = null;
                    this._lastScavengeTime = System.currentTimeMillis();
                    if (Log.isDebugEnabled()) {
                        Log.debug("Scavenge sweep ended at " + this._lastScavengeTime);
                    }
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (SQLException e2) {
                            Log.warn(e2);
                        }
                    }
                }
            }
        }
    }

    public class DatabaseAdaptor {
        String _dbName;
        boolean _isLower;
        boolean _isUpper;

        public DatabaseAdaptor(DatabaseMetaData dbMeta) throws SQLException {
            this._dbName = dbMeta.getDatabaseProductName().toLowerCase();
            Log.debug("Using database " + this._dbName);
            this._isLower = dbMeta.storesLowerCaseIdentifiers();
            this._isUpper = dbMeta.storesUpperCaseIdentifiers();
        }

        public String convertIdentifier(String identifier) {
            if (this._isLower) {
                return identifier.toLowerCase();
            }
            if (this._isUpper) {
                return identifier.toUpperCase();
            }
            return identifier;
        }

        public String getDBName() {
            return this._dbName;
        }

        public String getBlobType() {
            if (JDBCSessionIdManager.this._blobType != null) {
                return JDBCSessionIdManager.this._blobType;
            }
            if (this._dbName.startsWith("postgres")) {
                return "bytea";
            }
            return "blob";
        }

        public InputStream getBlobInputStream(ResultSet result, String columnName) throws SQLException {
            if (this._dbName.startsWith("postgres")) {
                byte[] bytes = result.getBytes(columnName);
                return new ByteArrayInputStream(bytes);
            }
            Blob blob = result.getBlob(columnName);
            return blob.getBinaryStream();
        }
    }
}

