/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.log;

import java.security.AccessControlException;
import org.eclipse.jetty.util.DateCache;
import org.eclipse.jetty.util.log.Logger;

public class StdErrLog
implements Logger {
    private static DateCache _dateCache;
    private static final String LN;
    private static final boolean __debug;
    private boolean _debug = __debug;
    private final String _name;
    private boolean _hideStacks = false;
    StringBuilder _buffer = new StringBuilder();

    public StdErrLog() {
        this(null);
    }

    public StdErrLog(String name) {
        this._name = name == null ? "" : name;
        try {
            this._debug = Boolean.parseBoolean(System.getProperty(this._name + ".DEBUG", Boolean.toString(__debug)));
        }
        catch (AccessControlException ace) {
            this._debug = __debug;
        }
    }

    public String getName() {
        return this._name;
    }

    public boolean isDebugEnabled() {
        return this._debug;
    }

    public void setDebugEnabled(boolean enabled) {
        this._debug = enabled;
    }

    public boolean isHideStacks() {
        return this._hideStacks;
    }

    public void setHideStacks(boolean hideStacks) {
        this._hideStacks = hideStacks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void info(String msg) {
        String d = _dateCache.now();
        int ms = _dateCache.lastMs();
        StringBuilder stringBuilder = this._buffer;
        synchronized (stringBuilder) {
            this.tag(d, ms, ":INFO:");
            this.format(msg);
            System.err.println(this._buffer.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void info(String msg, Object arg0, Object arg1) {
        String d = _dateCache.now();
        int ms = _dateCache.lastMs();
        StringBuilder stringBuilder = this._buffer;
        synchronized (stringBuilder) {
            this.tag(d, ms, ":INFO:");
            this.format(msg, arg0, arg1);
            System.err.println(this._buffer.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void debug(String msg, Throwable th) {
        if (this._debug) {
            String d = _dateCache.now();
            int ms = _dateCache.lastMs();
            StringBuilder stringBuilder = this._buffer;
            synchronized (stringBuilder) {
                this.tag(d, ms, ":DBUG:");
                this.format(msg);
                if (this._hideStacks) {
                    this.format(th.toString());
                } else {
                    this.format(th);
                }
                System.err.println(this._buffer.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void debug(String msg) {
        if (this._debug) {
            String d = _dateCache.now();
            int ms = _dateCache.lastMs();
            StringBuilder stringBuilder = this._buffer;
            synchronized (stringBuilder) {
                this.tag(d, ms, ":DBUG:");
                this.format(msg);
                System.err.println(this._buffer.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void debug(String msg, Object arg0, Object arg1) {
        if (this._debug) {
            String d = _dateCache.now();
            int ms = _dateCache.lastMs();
            StringBuilder stringBuilder = this._buffer;
            synchronized (stringBuilder) {
                this.tag(d, ms, ":DBUG:");
                this.format(msg, arg0, arg1);
                System.err.println(this._buffer.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void warn(String msg) {
        String d = _dateCache.now();
        int ms = _dateCache.lastMs();
        StringBuilder stringBuilder = this._buffer;
        synchronized (stringBuilder) {
            this.tag(d, ms, ":WARN:");
            this.format(msg);
            System.err.println(this._buffer.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void warn(String msg, Object arg0, Object arg1) {
        String d = _dateCache.now();
        int ms = _dateCache.lastMs();
        StringBuilder stringBuilder = this._buffer;
        synchronized (stringBuilder) {
            this.tag(d, ms, ":WARN:");
            this.format(msg, arg0, arg1);
            System.err.println(this._buffer.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void warn(String msg, Throwable th) {
        String d = _dateCache.now();
        int ms = _dateCache.lastMs();
        StringBuilder stringBuilder = this._buffer;
        synchronized (stringBuilder) {
            this.tag(d, ms, ":WARN:");
            this.format(msg);
            if (this._hideStacks) {
                this.format(th.toString());
            } else {
                this.format(th);
            }
            System.err.println(this._buffer.toString());
        }
    }

    private void tag(String d, int ms, String tag) {
        this._buffer.setLength(0);
        this._buffer.append(d);
        if (ms > 99) {
            this._buffer.append('.');
        } else if (ms > 9) {
            this._buffer.append(".0");
        } else {
            this._buffer.append(".00");
        }
        this._buffer.append(ms).append(tag).append(this._name).append(':');
    }

    private void format(String msg, Object arg0, Object arg1) {
        int i1;
        int i0 = msg == null ? -1 : msg.indexOf("{}");
        int n = i1 = i0 < 0 ? -1 : msg.indexOf("{}", i0 + 2);
        if (i0 >= 0) {
            this.format(msg.substring(0, i0));
            this.format(String.valueOf(arg0 == null ? "null" : arg0));
            if (i1 >= 0) {
                this.format(msg.substring(i0 + 2, i1));
                this.format(String.valueOf(arg1 == null ? "null" : arg1));
                this.format(msg.substring(i1 + 2));
            } else {
                this.format(msg.substring(i0 + 2));
                if (arg1 != null) {
                    this._buffer.append(' ');
                    this.format(String.valueOf(arg1));
                }
            }
        } else {
            this.format(msg);
            if (arg0 != null) {
                this._buffer.append(' ');
                this.format(String.valueOf(arg0));
            }
            if (arg1 != null) {
                this._buffer.append(' ');
                this.format(String.valueOf(arg1));
            }
        }
    }

    private void format(String msg) {
        if (msg == null) {
            this._buffer.append("null");
        } else {
            for (int i = 0; i < msg.length(); ++i) {
                char c = msg.charAt(i);
                if (Character.isISOControl(c)) {
                    if (c == '\n') {
                        this._buffer.append('|');
                        continue;
                    }
                    if (c == '\r') {
                        this._buffer.append('<');
                        continue;
                    }
                    this._buffer.append('?');
                    continue;
                }
                this._buffer.append(c);
            }
        }
    }

    private void format(Throwable th) {
        if (th == null) {
            this._buffer.append("null");
        } else {
            this._buffer.append('\n');
            this.format(th.toString());
            StackTraceElement[] elements = th.getStackTrace();
            for (int i = 0; elements != null && i < elements.length; ++i) {
                this._buffer.append("\n\tat ");
                this.format(elements[i].toString());
            }
        }
    }

    public Logger getLogger(String name) {
        if (name == null && this._name == null || name != null && name.equals(this._name)) {
            return this;
        }
        return new StdErrLog(this._name == null || this._name.length() == 0 ? name : this._name + "." + name);
    }

    public String toString() {
        return "StdErrLog:" + this._name + ":DEBUG=" + this._debug;
    }

    static {
        LN = System.getProperty("line.separator");
        __debug = Boolean.parseBoolean(System.getProperty("org.eclipse.jetty.util.log.DEBUG", System.getProperty("org.eclipse.jetty.util.log.stderr.DEBUG", "false")));
        try {
            _dateCache = new DateCache("yyyy-MM-dd HH:mm:ss");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

