/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.ssl;

import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSession;
import org.eclipse.jetty.http.HttpParser;
import org.eclipse.jetty.http.ssl.SslContextFactory;
import org.eclipse.jetty.io.Buffers;
import org.eclipse.jetty.io.BuffersFactory;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.nio.SelectChannelEndPoint;
import org.eclipse.jetty.io.nio.SelectorManager;
import org.eclipse.jetty.io.nio.SslSelectChannelEndPoint;
import org.eclipse.jetty.server.HttpConnection;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.eclipse.jetty.server.ssl.SslCertificates;
import org.eclipse.jetty.server.ssl.SslConnector;

public class SslSelectChannelConnector
extends SelectChannelConnector
implements SslConnector {
    private final SslContextFactory _sslContextFactory;
    private Buffers _sslBuffers;

    public SslSelectChannelConnector() {
        this(new SslContextFactory(SslContextFactory.DEFAULT_KEYSTORE_PATH));
    }

    public SslSelectChannelConnector(SslContextFactory sslContextFactory) {
        this._sslContextFactory = sslContextFactory;
        this.setUseDirectBuffers(false);
    }

    public void customize(EndPoint endpoint, Request request) throws IOException {
        request.setScheme("https");
        super.customize(endpoint, request);
        SslSelectChannelEndPoint sslHttpChannelEndpoint = (SslSelectChannelEndPoint)endpoint;
        SSLEngine sslEngine = sslHttpChannelEndpoint.getSSLEngine();
        SSLSession sslSession = sslEngine.getSession();
        SslCertificates.customize(sslSession, endpoint, request);
    }

    @Deprecated
    public boolean isAllowRenegotiate() {
        return this._sslContextFactory.isAllowRenegotiate();
    }

    @Deprecated
    public void setAllowRenegotiate(boolean allowRenegotiate) {
        this._sslContextFactory.setAllowRenegotiate(allowRenegotiate);
    }

    @Deprecated
    public String[] getExcludeCipherSuites() {
        return this._sslContextFactory.getExcludeCipherSuites();
    }

    @Deprecated
    public void setExcludeCipherSuites(String[] cipherSuites) {
        this._sslContextFactory.setExcludeCipherSuites(cipherSuites);
    }

    @Deprecated
    public String[] getIncludeCipherSuites() {
        return this._sslContextFactory.getIncludeCipherSuites();
    }

    @Deprecated
    public void setIncludeCipherSuites(String[] cipherSuites) {
        this._sslContextFactory.setIncludeCipherSuites(cipherSuites);
    }

    @Deprecated
    public void setPassword(String password) {
        this._sslContextFactory.setKeyStorePassword(password);
    }

    @Deprecated
    public void setTrustPassword(String password) {
        this._sslContextFactory.setTrustStorePassword(password);
    }

    @Deprecated
    public void setKeyPassword(String password) {
        this._sslContextFactory.setKeyManagerPassword(password);
    }

    @Deprecated
    public String getAlgorithm() {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public void setAlgorithm(String algorithm) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public String getProtocol() {
        return this._sslContextFactory.getProtocol();
    }

    @Deprecated
    public void setProtocol(String protocol) {
        this._sslContextFactory.setProtocol(protocol);
    }

    @Deprecated
    public void setKeystore(String keystore) {
        this._sslContextFactory.setKeyStore(keystore);
    }

    @Deprecated
    public String getKeystore() {
        return this._sslContextFactory.getKeyStore();
    }

    @Deprecated
    public String getKeystoreType() {
        return this._sslContextFactory.getKeyStoreType();
    }

    @Deprecated
    public boolean getNeedClientAuth() {
        return this._sslContextFactory.getNeedClientAuth();
    }

    @Deprecated
    public boolean getWantClientAuth() {
        return this._sslContextFactory.getWantClientAuth();
    }

    @Deprecated
    public void setNeedClientAuth(boolean needClientAuth) {
        this._sslContextFactory.setNeedClientAuth(needClientAuth);
    }

    @Deprecated
    public void setWantClientAuth(boolean wantClientAuth) {
        this._sslContextFactory.setWantClientAuth(wantClientAuth);
    }

    @Deprecated
    public void setKeystoreType(String keystoreType) {
        this._sslContextFactory.setKeyStoreType(keystoreType);
    }

    @Deprecated
    public String getProvider() {
        return this._sslContextFactory.getProvider();
    }

    @Deprecated
    public String getSecureRandomAlgorithm() {
        return this._sslContextFactory.getSecureRandomAlgorithm();
    }

    @Deprecated
    public String getSslKeyManagerFactoryAlgorithm() {
        return this._sslContextFactory.getSslKeyManagerFactoryAlgorithm();
    }

    @Deprecated
    public String getSslTrustManagerFactoryAlgorithm() {
        return this._sslContextFactory.getTrustManagerFactoryAlgorithm();
    }

    @Deprecated
    public String getTruststore() {
        return this._sslContextFactory.getTrustStore();
    }

    @Deprecated
    public String getTruststoreType() {
        return this._sslContextFactory.getTrustStoreType();
    }

    @Deprecated
    public void setProvider(String provider) {
        this._sslContextFactory.setProvider(provider);
    }

    @Deprecated
    public void setSecureRandomAlgorithm(String algorithm) {
        this._sslContextFactory.setSecureRandomAlgorithm(algorithm);
    }

    @Deprecated
    public void setSslKeyManagerFactoryAlgorithm(String algorithm) {
        this._sslContextFactory.setSslKeyManagerFactoryAlgorithm(algorithm);
    }

    @Deprecated
    public void setSslTrustManagerFactoryAlgorithm(String algorithm) {
        this._sslContextFactory.setTrustManagerFactoryAlgorithm(algorithm);
    }

    @Deprecated
    public void setTruststore(String truststore) {
        this._sslContextFactory.setTrustStore(truststore);
    }

    @Deprecated
    public void setTruststoreType(String truststoreType) {
        this._sslContextFactory.setTrustStoreType(truststoreType);
    }

    @Deprecated
    public void setSslContext(SSLContext sslContext) {
        this._sslContextFactory.setSslContext(sslContext);
    }

    @Deprecated
    public SSLContext getSslContext() {
        return this._sslContextFactory.getSslContext();
    }

    public SslContextFactory getSslContextFactory() {
        return this._sslContextFactory;
    }

    public boolean isConfidential(Request request) {
        int confidentialPort = this.getConfidentialPort();
        return confidentialPort == 0 || confidentialPort == request.getServerPort();
    }

    public boolean isIntegral(Request request) {
        int integralPort = this.getIntegralPort();
        return integralPort == 0 || integralPort == request.getServerPort();
    }

    protected SelectChannelEndPoint newEndPoint(SocketChannel channel, SelectorManager.SelectSet selectSet, SelectionKey key) throws IOException {
        SSLEngine engine = this.createSSLEngine(channel);
        SslSelectChannelEndPoint endp = new SslSelectChannelEndPoint(this._sslBuffers, channel, selectSet, key, engine, this._maxIdleTime);
        endp.setAllowRenegotiate(this._sslContextFactory.isAllowRenegotiate());
        return endp;
    }

    protected Connection newConnection(SocketChannel channel, SelectChannelEndPoint endpoint) {
        HttpConnection connection = (HttpConnection)super.newConnection(channel, endpoint);
        ((HttpParser)connection.getParser()).setForceContentBuffer(true);
        return connection;
    }

    protected SSLEngine createSSLEngine(SocketChannel channel) throws IOException {
        SSLEngine engine;
        if (channel != null) {
            String peerHost = channel.socket().getInetAddress().getHostAddress();
            int peerPort = channel.socket().getPort();
            engine = this._sslContextFactory.newSslEngine(peerHost, peerPort);
        } else {
            engine = this._sslContextFactory.newSslEngine();
        }
        engine.setUseClientMode(false);
        return engine;
    }

    protected void doStart() throws Exception {
        this._sslContextFactory.checkKeyStore();
        this._sslContextFactory.start();
        SSLEngine sslEngine = this._sslContextFactory.newSslEngine();
        sslEngine.setUseClientMode(false);
        SSLSession sslSession = sslEngine.getSession();
        this._sslBuffers = BuffersFactory.newBuffers(this.getUseDirectBuffers() ? Buffers.Type.DIRECT : Buffers.Type.INDIRECT, sslSession.getApplicationBufferSize(), this.getUseDirectBuffers() ? Buffers.Type.DIRECT : Buffers.Type.INDIRECT, sslSession.getApplicationBufferSize(), this.getUseDirectBuffers() ? Buffers.Type.DIRECT : Buffers.Type.INDIRECT, this.getMaxBuffers());
        if (this.getRequestHeaderSize() < sslSession.getApplicationBufferSize()) {
            this.setRequestHeaderSize(sslSession.getApplicationBufferSize());
        }
        if (this.getRequestBufferSize() < sslSession.getApplicationBufferSize()) {
            this.setRequestBufferSize(sslSession.getApplicationBufferSize());
        }
        super.doStart();
    }

    protected void doStop() throws Exception {
        this._sslContextFactory.stop();
        this._sslBuffers = null;
        super.doStop();
    }

    public Buffers getSslBuffers() {
        return this._sslBuffers;
    }
}

