/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.webapp;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.servlet.Servlet;
import org.eclipse.jetty.util.Loader;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.webapp.AbstractConfiguration;
import org.eclipse.jetty.webapp.Descriptor;
import org.eclipse.jetty.webapp.IterativeDescriptorProcessor;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.webapp.WebXmlConfiguration;
import org.eclipse.jetty.xml.XmlParser;

public class TagLibConfiguration
extends AbstractConfiguration {
    public static final String TLD_RESOURCES = "org.eclipse.jetty.tlds";
    private TldProcessor _processor;
    private List<TldDescriptor> _descriptors = new ArrayList<TldDescriptor>();

    public void preConfigure(WebAppContext context) throws Exception {
        Collection tld_resources;
        Resource web_inf;
        try {
            Class jsp_page = Loader.loadClass(WebXmlConfiguration.class, "javax.servlet.jsp.JspPage");
        }
        catch (Exception e) {
            return;
        }
        HashSet<Resource> tlds = new HashSet<Resource>();
        if (context.getResourceAliases() != null && context.getBaseResource() != null && context.getBaseResource().exists()) {
            for (String location : context.getResourceAliases().values()) {
                if (location == null || !location.toLowerCase().endsWith(".tld")) continue;
                if (!location.startsWith("/")) {
                    location = "/WEB-INF/" + location;
                }
                Resource l = context.getBaseResource().addPath(location);
                tlds.add(l);
            }
        }
        if ((web_inf = context.getWebInf()) != null) {
            String[] contents = web_inf.list();
            for (int i = 0; contents != null && i < contents.length; ++i) {
                if (contents[i] == null || !contents[i].toLowerCase().endsWith(".tld")) continue;
                Resource l = web_inf.addPath(contents[i]);
                tlds.add(l);
            }
        }
        if ((tld_resources = (Collection)context.getAttribute(TLD_RESOURCES)) != null) {
            tlds.addAll(tld_resources);
        }
        this._descriptors.clear();
        Resource tld = null;
        Iterator iter = tlds.iterator();
        while (iter.hasNext()) {
            try {
                tld = (Resource)iter.next();
                if (Log.isDebugEnabled()) {
                    Log.debug("TLD=" + tld);
                }
                TldDescriptor d = new TldDescriptor(tld);
                d.parse();
                this._descriptors.add(d);
            }
            catch (Exception e) {
                Log.warn("Unable to parse TLD: " + tld, e);
            }
        }
        this._processor = new TldProcessor();
    }

    public void configure(WebAppContext context) throws Exception {
        if (this._processor == null) {
            if (Log.isDebugEnabled()) {
                Log.debug("No TldProcessor configured, skipping tld processing");
            }
            return;
        }
        for (TldDescriptor d : this._descriptors) {
            this._processor.process(context, d);
        }
    }

    public void postConfigure(WebAppContext context) throws Exception {
    }

    public void cloneConfigure(WebAppContext template, WebAppContext context) throws Exception {
        if (this._processor == null) {
            Log.warn("No TldProcessor for cloneConfigure");
            return;
        }
        for (TldDescriptor d : this._descriptors) {
            this._processor.process(context, d);
        }
    }

    public void deconfigure(WebAppContext context) throws Exception {
        this._descriptors.clear();
        this._processor = null;
    }

    public class TldProcessor
    extends IterativeDescriptorProcessor {
        public static final String TAGLIB_PROCESSOR = "org.eclipse.jetty.tagLibProcessor";
        XmlParser _parser;
        List<XmlParser.Node> _roots = new ArrayList<XmlParser.Node>();

        public TldProcessor() throws Exception {
            this.registerVisitor("listener", this.getClass().getDeclaredMethod("visitListener", __signature));
        }

        public void visitListener(WebAppContext context, Descriptor descriptor, XmlParser.Node node) {
            String className = node.getString("listener-class", false, true);
            if (Log.isDebugEnabled()) {
                Log.debug("listener=" + className);
            }
            try {
                Class<?> listenerClass = context.loadClass(className);
                EventListener l = (EventListener)listenerClass.newInstance();
                context.addEventListener(l);
            }
            catch (Exception e) {
                Log.warn("Could not instantiate listener " + className + ": " + e);
                Log.debug(e);
            }
            catch (Error e) {
                Log.warn("Could not instantiate listener " + className + ": " + e);
                Log.debug(e);
            }
        }

        public void end(WebAppContext context, Descriptor descriptor) {
        }

        public void start(WebAppContext context, Descriptor descriptor) {
        }
    }

    public static class TldDescriptor
    extends Descriptor {
        protected static XmlParser __parserSingleton;

        public TldDescriptor(Resource xml) {
            super(xml);
        }

        public void ensureParser() throws ClassNotFoundException {
            if (__parserSingleton == null) {
                __parserSingleton = this.newParser();
            }
            this._parser = __parserSingleton;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public XmlParser newParser() throws ClassNotFoundException {
            XmlParser parser = new XmlParser(false);
            URL taglib11 = null;
            URL taglib12 = null;
            URL taglib20 = null;
            URL taglib21 = null;
            try {
                Class jsp_page = Loader.loadClass(WebXmlConfiguration.class, "javax.servlet.jsp.JspPage");
                taglib11 = jsp_page.getResource("javax/servlet/jsp/resources/web-jsptaglibrary_1_1.dtd");
                taglib12 = jsp_page.getResource("javax/servlet/jsp/resources/web-jsptaglibrary_1_2.dtd");
                taglib20 = jsp_page.getResource("javax/servlet/jsp/resources/web-jsptaglibrary_2_0.xsd");
                taglib21 = jsp_page.getResource("javax/servlet/jsp/resources/web-jsptaglibrary_2_1.xsd");
            }
            catch (Exception e) {
                Log.ignore(e);
            }
            finally {
                if (taglib11 == null) {
                    taglib11 = Loader.getResource(Servlet.class, "javax/servlet/jsp/resources/web-jsptaglibrary_1_1.dtd", true);
                }
                if (taglib12 == null) {
                    taglib12 = Loader.getResource(Servlet.class, "javax/servlet/jsp/resources/web-jsptaglibrary_1_2.dtd", true);
                }
                if (taglib20 == null) {
                    taglib20 = Loader.getResource(Servlet.class, "javax/servlet/jsp/resources/web-jsptaglibrary_2_0.xsd", true);
                }
                if (taglib21 == null) {
                    taglib21 = Loader.getResource(Servlet.class, "javax/servlet/jsp/resources/web-jsptaglibrary_2_1.xsd", true);
                }
            }
            if (taglib11 != null) {
                this.redirect(parser, "web-jsptaglib_1_1.dtd", taglib11);
                this.redirect(parser, "web-jsptaglibrary_1_1.dtd", taglib11);
            }
            if (taglib12 != null) {
                this.redirect(parser, "web-jsptaglib_1_2.dtd", taglib12);
                this.redirect(parser, "web-jsptaglibrary_1_2.dtd", taglib12);
            }
            if (taglib20 != null) {
                this.redirect(parser, "web-jsptaglib_2_0.xsd", taglib20);
                this.redirect(parser, "web-jsptaglibrary_2_0.xsd", taglib20);
            }
            if (taglib21 != null) {
                this.redirect(parser, "web-jsptaglib_2_1.xsd", taglib21);
                this.redirect(parser, "web-jsptaglibrary_2_1.xsd", taglib21);
            }
            parser.setXpath("/taglib/listener/listener-class");
            return parser;
        }

        public void parse() throws Exception {
            this.ensureParser();
            try {
                this._root = this._parser.parse(this._xml.getInputStream());
            }
            catch (Exception e) {
                this._root = this._parser.parse(this._xml.getURL().toString());
            }
            if (this._root == null) {
                Log.warn("No TLD root in {}", this._xml);
            }
        }
    }
}

