/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.spdy.server.http;

import java.nio.ByteBuffer;
import org.eclipse.jetty.http.HostPortHttpField;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpTransport;
import org.eclipse.jetty.spdy.api.DataInfo;
import org.eclipse.jetty.spdy.api.Stream;
import org.eclipse.jetty.spdy.http.HTTPSPDYHeader;
import org.eclipse.jetty.spdy.server.http.HttpInputOverSPDY;
import org.eclipse.jetty.util.Fields;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class HttpChannelOverSPDY
extends HttpChannel {
    private static final Logger LOG = Log.getLogger(HttpChannelOverSPDY.class);
    private final Stream stream;

    public HttpChannelOverSPDY(Connector connector, HttpConfiguration configuration, EndPoint endPoint, HttpTransport transport, HttpInputOverSPDY input, Stream stream) {
        super(connector, configuration, endPoint, transport, input);
        this.stream = stream;
    }

    @Override
    public long getIdleTimeout() {
        return this.stream.getIdleTimeout();
    }

    public void requestStart(Fields headers, boolean endRequest) {
        if (!headers.isEmpty()) {
            this.requestHeaders(headers, endRequest);
        }
    }

    public void requestHeaders(Fields headers, boolean endRequest) {
        boolean proceed = this.performRequest(headers);
        if (!proceed) {
            return;
        }
        if (endRequest) {
            this.onRequestComplete();
        }
        this.execute(this);
    }

    public void requestContent(DataInfo dataInfo, boolean endRequest) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("HTTP > {} bytes of content", dataInfo.length());
        }
        ByteBuffer copyByteBuffer = dataInfo.asByteBuffer(false);
        HttpInputOverSPDY.ContentOverSPDY content = new HttpInputOverSPDY.ContentOverSPDY(copyByteBuffer, dataInfo);
        this.onContent(content);
        if (endRequest) {
            this.onRequestComplete();
        }
    }

    private boolean performRequest(Fields headers) {
        short version = this.stream.getSession().getVersion();
        Fields.Field methodHeader = headers.get(HTTPSPDYHeader.METHOD.name(version));
        Fields.Field uriHeader = headers.get(HTTPSPDYHeader.URI.name(version));
        Fields.Field versionHeader = headers.get(HTTPSPDYHeader.VERSION.name(version));
        if (methodHeader == null || uriHeader == null || versionHeader == null) {
            this.onBadMessage(400, "Missing required request line elements");
            return false;
        }
        HttpMethod httpMethod = HttpMethod.fromString(methodHeader.getValue());
        HttpVersion httpVersion = HttpVersion.fromString(versionHeader.getValue());
        if (LOG.isDebugEnabled()) {
            LOG.debug("HTTP > {} {} {}", new Object[]{httpMethod, uriHeader.getValue(), httpVersion});
        }
        HostPortHttpField hostPort = null;
        HttpFields fields = new HttpFields();
        block11: for (Fields.Field header : headers) {
            String name = header.getName();
            HTTPSPDYHeader specialHeader = HTTPSPDYHeader.from(this.stream.getSession().getVersion(), name);
            if (specialHeader != null) {
                if (specialHeader != HTTPSPDYHeader.HOST) continue;
                name = "host";
            }
            switch (name) {
                case "connection": 
                case "keep-alive": 
                case "proxy-connection": 
                case "transfer-encoding": {
                    continue block11;
                }
                case "host": {
                    hostPort = new HostPortHttpField(header.getValue());
                    continue block11;
                }
            }
            String value = header.getValue();
            if (LOG.isDebugEnabled()) {
                LOG.debug("HTTP > {}: {}", name, value);
            }
            fields.add(new HttpField(name, value));
        }
        if (hostPort == null) {
            this.onBadMessage(400, "Missing Host header");
            return false;
        }
        if (hostPort != null) {
            fields.add(hostPort);
        }
        Fields.Field schemeHeader = headers.get(HTTPSPDYHeader.SCHEME.name(version));
        HttpURI uri = new HttpURI(uriHeader.getValue());
        if (uri.getScheme() == null && schemeHeader != null) {
            uri.setScheme(schemeHeader.getValue());
        }
        if (uri.getHost() == null && hostPort != null) {
            uri.setAuthority(hostPort.getHost(), hostPort.getPort());
        }
        MetaData.Request request = new MetaData.Request(httpMethod == null ? methodHeader.getValue() : httpMethod.asString(), uri, httpVersion, fields);
        this.onRequest(request);
        return true;
    }
}

