/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client.util;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.api.Result;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.util.BufferUtil;

public abstract class BufferingResponseListener
extends Response.Listener.Adapter {
    private final int maxLength;
    private volatile ByteBuffer buffer;
    private volatile String encoding;

    public BufferingResponseListener() {
        this(0x200000);
    }

    public BufferingResponseListener(int maxLength) {
        this.maxLength = maxLength;
    }

    @Override
    public void onHeaders(Response response) {
        super.onHeaders(response);
        HttpFields headers = response.getHeaders();
        long length = headers.getLongField(HttpHeader.CONTENT_LENGTH.asString());
        if (length > (long)this.maxLength) {
            response.abort(new IllegalArgumentException("Buffering capacity exceeded"));
            return;
        }
        this.buffer = BufferUtil.allocate(length > 0L ? (int)length : 1024);
        String contentType = headers.get(HttpHeader.CONTENT_TYPE);
        if (contentType != null) {
            String charset = "charset=";
            int index = contentType.toLowerCase(Locale.ENGLISH).indexOf(charset);
            if (index > 0) {
                String encoding = contentType.substring(index + charset.length());
                if ((index = encoding.indexOf(59)) > 0) {
                    encoding = encoding.substring(0, index);
                }
                this.encoding = encoding;
            }
        }
    }

    @Override
    public void onContent(Response response, ByteBuffer content) {
        int length = content.remaining();
        if (length > BufferUtil.space(this.buffer)) {
            int requiredCapacity;
            int n = requiredCapacity = this.buffer == null ? 0 : this.buffer.capacity() + length;
            if (requiredCapacity > this.maxLength) {
                response.abort(new IllegalArgumentException("Buffering capacity exceeded"));
            }
            int newCapacity = Math.min(Integer.highestOneBit(requiredCapacity) << 1, this.maxLength);
            this.buffer = BufferUtil.ensureCapacity(this.buffer, newCapacity);
        }
        BufferUtil.append(this.buffer, content);
    }

    @Override
    public abstract void onComplete(Result var1);

    public String getEncoding() {
        return this.encoding;
    }

    public byte[] getContent() {
        if (this.buffer == null) {
            return new byte[0];
        }
        return BufferUtil.toArray(this.buffer);
    }

    public String getContentAsString() {
        String encoding = this.encoding;
        if (encoding == null) {
            return this.getContentAsString(StandardCharsets.UTF_8);
        }
        return this.getContentAsString(encoding);
    }

    public String getContentAsString(String encoding) {
        if (this.buffer == null) {
            return null;
        }
        return BufferUtil.toString(this.buffer, Charset.forName(encoding));
    }

    public String getContentAsString(Charset encoding) {
        if (this.buffer == null) {
            return null;
        }
        return BufferUtil.toString(this.buffer, encoding);
    }

    public InputStream getContentAsInputStream() {
        if (this.buffer == null) {
            return new ByteArrayInputStream(new byte[0]);
        }
        return new ByteArrayInputStream(this.buffer.array(), this.buffer.arrayOffset(), this.buffer.remaining());
    }
}

