/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client.http;

import org.eclipse.jetty.client.HttpChannel;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.api.Result;
import org.eclipse.jetty.client.http.HttpConnectionOverHTTP;
import org.eclipse.jetty.client.http.HttpReceiverOverHTTP;
import org.eclipse.jetty.client.http.HttpSenderOverHTTP;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpHeaderValue;
import org.eclipse.jetty.http.HttpVersion;

public class HttpChannelOverHTTP
extends HttpChannel {
    private final HttpConnectionOverHTTP connection;
    private final HttpSenderOverHTTP sender;
    private final HttpReceiverOverHTTP receiver;

    public HttpChannelOverHTTP(HttpConnectionOverHTTP connection) {
        super(connection.getHttpDestination());
        this.connection = connection;
        this.sender = new HttpSenderOverHTTP(this);
        this.receiver = new HttpReceiverOverHTTP(this);
    }

    public HttpConnectionOverHTTP getHttpConnection() {
        return this.connection;
    }

    @Override
    public void send() {
        HttpExchange exchange = this.getHttpExchange();
        if (exchange != null) {
            this.sender.send(exchange);
        }
    }

    @Override
    public void proceed(HttpExchange exchange, Throwable failure) {
        this.sender.proceed(exchange, failure);
    }

    @Override
    public boolean abort(Throwable cause) {
        this.sender.abort(cause);
        return this.receiver.abort(cause);
    }

    public void receive() {
        this.receiver.receive();
    }

    @Override
    public void exchangeTerminated(Result result) {
        boolean close;
        super.exchangeTerminated(result);
        Response response = result.getResponse();
        HttpFields responseHeaders = response.getHeaders();
        boolean bl = close = result.isFailed() || this.receiver.isShutdown();
        if (!close) {
            close = response.getVersion().compareTo(HttpVersion.HTTP_1_1) < 0 ? !responseHeaders.contains(HttpHeader.CONNECTION, HttpHeaderValue.KEEP_ALIVE.asString()) : responseHeaders.contains(HttpHeader.CONNECTION, HttpHeaderValue.CLOSE.asString());
        }
        if (close) {
            this.connection.close();
        } else {
            this.connection.release();
        }
    }

    @Override
    public String toString() {
        return String.format("%s@%x", this.getClass().getSimpleName(), this.hashCode());
    }
}

