/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common.extensions;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.api.WebSocketException;
import org.eclipse.jetty.websocket.api.WriteCallback;
import org.eclipse.jetty.websocket.api.extensions.Extension;
import org.eclipse.jetty.websocket.api.extensions.ExtensionConfig;
import org.eclipse.jetty.websocket.api.extensions.ExtensionFactory;
import org.eclipse.jetty.websocket.api.extensions.Frame;
import org.eclipse.jetty.websocket.api.extensions.IncomingFrames;
import org.eclipse.jetty.websocket.api.extensions.OutgoingFrames;
import org.eclipse.jetty.websocket.common.Generator;
import org.eclipse.jetty.websocket.common.Parser;
import org.eclipse.jetty.websocket.common.extensions.AbstractExtension;

@ManagedObject(value="Extension Stack")
public class ExtensionStack
extends ContainerLifeCycle
implements IncomingFrames,
OutgoingFrames {
    private static final Logger LOG = Log.getLogger(ExtensionStack.class);
    private final ExtensionFactory factory;
    private List<Extension> extensions;
    private IncomingFrames nextIncoming;
    private OutgoingFrames nextOutgoing;

    public ExtensionStack(ExtensionFactory factory) {
        this.factory = factory;
    }

    public void configure(Generator generator) {
        generator.configureFromExtensions(this.extensions);
    }

    public void configure(Parser parser) {
        parser.configureFromExtensions(this.extensions);
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        LOG.debug("doStart", new Object[0]);
        if (this.extensions != null && this.extensions.size() > 0) {
            Extension ext;
            ListIterator<Extension> eiter = this.extensions.listIterator();
            while (eiter.hasNext()) {
                ext = eiter.next();
                ext.setNextOutgoingFrames(this.nextOutgoing);
                this.nextOutgoing = ext;
            }
            while (eiter.hasPrevious()) {
                ext = eiter.previous();
                ext.setNextIncomingFrames(this.nextIncoming);
                this.nextIncoming = ext;
            }
        }
    }

    @Override
    public void dump(Appendable out, String indent) throws IOException {
        super.dump(out, indent);
        IncomingFrames websocket = this.getLastIncoming();
        OutgoingFrames network = this.getLastOutgoing();
        out.append(indent).append(" +- Stack\n");
        out.append(indent).append("    +- Network  : ").append(network.toString()).append('\n');
        for (Extension ext : this.extensions) {
            out.append(indent).append("    +- Extension: ").append(ext.toString()).append('\n');
        }
        out.append(indent).append("    +- Websocket: ").append(websocket.toString()).append('\n');
    }

    @ManagedAttribute(name="Extension List", readonly=true)
    public List<Extension> getExtensions() {
        return this.extensions;
    }

    private IncomingFrames getLastIncoming() {
        IncomingFrames last = this.nextIncoming;
        boolean done = false;
        while (!done) {
            if (last instanceof AbstractExtension) {
                last = ((AbstractExtension)last).getNextIncoming();
                continue;
            }
            done = true;
        }
        return last;
    }

    private OutgoingFrames getLastOutgoing() {
        OutgoingFrames last = this.nextOutgoing;
        boolean done = false;
        while (!done) {
            if (last instanceof AbstractExtension) {
                last = ((AbstractExtension)last).getNextOutgoing();
                continue;
            }
            done = true;
        }
        return last;
    }

    public List<ExtensionConfig> getNegotiatedExtensions() {
        ArrayList<ExtensionConfig> ret = new ArrayList<ExtensionConfig>();
        if (this.extensions == null) {
            return ret;
        }
        for (Extension ext : this.extensions) {
            ret.add(ext.getConfig());
        }
        return ret;
    }

    @ManagedAttribute(name="Next Incoming Frames Handler", readonly=true)
    public IncomingFrames getNextIncoming() {
        return this.nextIncoming;
    }

    @ManagedAttribute(name="Next Outgoing Frames Handler", readonly=true)
    public OutgoingFrames getNextOutgoing() {
        return this.nextOutgoing;
    }

    public boolean hasNegotiatedExtensions() {
        return this.extensions != null && this.extensions.size() > 0;
    }

    @Override
    public void incomingError(WebSocketException e) {
        this.nextIncoming.incomingError(e);
    }

    @Override
    public void incomingFrame(Frame frame) {
        this.nextIncoming.incomingFrame(frame);
    }

    public void negotiate(List<ExtensionConfig> configs) {
        LOG.debug("Extension Configs={}", configs);
        this.extensions = new ArrayList<Extension>();
        for (ExtensionConfig config : configs) {
            Extension ext = this.factory.newInstance(config);
            if (ext == null) continue;
            this.extensions.add(ext);
            LOG.debug("Adding Extension: {}", ext);
        }
        this.addBean(this.extensions);
    }

    @Override
    public void outgoingFrame(Frame frame, WriteCallback callback) {
        this.nextOutgoing.outgoingFrame(frame, callback);
    }

    public void setNextIncoming(IncomingFrames nextIncoming) {
        this.nextIncoming = nextIncoming;
    }

    public void setNextOutgoing(OutgoingFrames nextOutgoing) {
        this.nextOutgoing = nextOutgoing;
    }

    public String toString() {
        return String.format("ExtensionStack[extensions=%s]", this.extensions);
    }
}

