/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.client;

import java.io.IOException;
import java.net.CookieStore;
import java.net.SocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.MappedByteBufferPool;
import org.eclipse.jetty.util.HttpCookieStore;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ScheduledExecutorScheduler;
import org.eclipse.jetty.util.thread.Scheduler;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.api.extensions.Extension;
import org.eclipse.jetty.websocket.api.extensions.ExtensionConfig;
import org.eclipse.jetty.websocket.api.extensions.ExtensionFactory;
import org.eclipse.jetty.websocket.client.ClientUpgradeRequest;
import org.eclipse.jetty.websocket.client.io.ConnectPromise;
import org.eclipse.jetty.websocket.client.io.ConnectionManager;
import org.eclipse.jetty.websocket.client.masks.Masker;
import org.eclipse.jetty.websocket.client.masks.RandomMasker;
import org.eclipse.jetty.websocket.common.events.EventDriver;
import org.eclipse.jetty.websocket.common.events.EventDriverFactory;
import org.eclipse.jetty.websocket.common.extensions.WebSocketExtensionFactory;

public class WebSocketClient
extends ContainerLifeCycle {
    private static final Logger LOG = Log.getLogger(WebSocketClient.class);
    private final WebSocketPolicy policy;
    private final SslContextFactory sslContextFactory;
    private final WebSocketExtensionFactory extensionRegistry;
    private final EventDriverFactory eventDriverFactory;
    private ByteBufferPool bufferPool;
    private Executor executor;
    private Scheduler scheduler;
    private CookieStore cookieStore;
    private ConnectionManager connectionManager;
    private Masker masker;
    private SocketAddress bindAddress;
    private long connectTimeout = 15000L;

    public WebSocketClient() {
        this(null);
    }

    public WebSocketClient(SslContextFactory sslContextFactory) {
        this.sslContextFactory = sslContextFactory;
        this.policy = WebSocketPolicy.newClientPolicy();
        this.extensionRegistry = new WebSocketExtensionFactory(this.policy, this.bufferPool);
        this.masker = new RandomMasker();
        this.eventDriverFactory = new EventDriverFactory(this.policy);
    }

    public Future<Session> connect(Object websocket, URI toUri) throws IOException {
        ClientUpgradeRequest request = new ClientUpgradeRequest(toUri);
        request.setRequestURI(toUri);
        request.setCookiesFrom(this.cookieStore);
        return this.connect(websocket, toUri, request);
    }

    public Future<Session> connect(Object websocket, URI toUri, ClientUpgradeRequest request) throws IOException {
        if (!this.isStarted()) {
            throw new IllegalStateException(WebSocketClient.class.getSimpleName() + "@" + this.hashCode() + " is not started");
        }
        if (!toUri.isAbsolute()) {
            throw new IllegalArgumentException("WebSocket URI must be absolute");
        }
        if (StringUtil.isBlank(toUri.getScheme())) {
            throw new IllegalArgumentException("WebSocket URI must include a scheme");
        }
        String scheme = toUri.getScheme().toLowerCase(Locale.ENGLISH);
        if (!"ws".equals(scheme) && !"wss".equals(scheme)) {
            throw new IllegalArgumentException("WebSocket URI scheme only supports [ws] and [wss], not [" + scheme + "]");
        }
        request.setRequestURI(toUri);
        request.setCookiesFrom(this.cookieStore);
        for (ExtensionConfig reqExt : request.getExtensions()) {
            if (this.extensionRegistry.isAvailable(reqExt.getName())) continue;
            throw new IllegalArgumentException("Requested extension [" + reqExt.getName() + "] is not installed");
        }
        LOG.debug("connect websocket:{} to:{}", websocket, toUri);
        ConnectionManager manager = this.getConnectionManager();
        EventDriver driver = this.eventDriverFactory.wrap(websocket);
        ConnectPromise promise = manager.connect(this, driver, request);
        this.executor.execute(promise);
        return promise;
    }

    @Override
    protected void doStart() throws Exception {
        LOG.debug("Starting {}", this);
        if (this.sslContextFactory != null) {
            this.addBean(this.sslContextFactory);
        }
        String name = WebSocketClient.class.getSimpleName() + "@" + this.hashCode();
        if (this.executor == null) {
            QueuedThreadPool threadPool = new QueuedThreadPool();
            threadPool.setName(name);
            this.executor = threadPool;
        }
        this.addBean(this.executor);
        if (this.bufferPool == null) {
            this.bufferPool = new MappedByteBufferPool();
        }
        this.addBean(this.bufferPool);
        if (this.scheduler == null) {
            this.scheduler = new ScheduledExecutorScheduler(name + "-scheduler", false);
        }
        this.addBean(this.scheduler);
        if (this.cookieStore == null) {
            this.cookieStore = new HttpCookieStore.Empty();
        }
        this.connectionManager = new ConnectionManager(this);
        this.addBean(this.connectionManager);
        super.doStart();
        LOG.info("Started {}", this);
    }

    @Override
    protected void doStop() throws Exception {
        LOG.debug("Stopping {}", this);
        if (this.cookieStore != null) {
            this.cookieStore.removeAll();
            this.cookieStore = null;
        }
        super.doStop();
        LOG.info("Stopped {}", this);
    }

    public SocketAddress getBindAddress() {
        return this.bindAddress;
    }

    public ByteBufferPool getBufferPool() {
        return this.bufferPool;
    }

    public ConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    public long getConnectTimeout() {
        return this.connectTimeout;
    }

    public CookieStore getCookieStore() {
        return this.cookieStore;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public ExtensionFactory getExtensionFactory() {
        return this.extensionRegistry;
    }

    public Masker getMasker() {
        return this.masker;
    }

    public long getMaxIdleTimeout() {
        return this.policy.getIdleTimeout();
    }

    public WebSocketPolicy getPolicy() {
        return this.policy;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public SslContextFactory getSslContextFactory() {
        return this.sslContextFactory;
    }

    public List<Extension> initExtensions(List<ExtensionConfig> requested) {
        ArrayList<Extension> extensions = new ArrayList<Extension>();
        for (ExtensionConfig cfg : requested) {
            Extension extension = this.extensionRegistry.newInstance(cfg);
            if (extension == null) continue;
            LOG.debug("added {}", extension);
            extensions.add(extension);
        }
        LOG.debug("extensions={}", extensions);
        return extensions;
    }

    public void setBindAdddress(SocketAddress bindAddress) {
        this.bindAddress = bindAddress;
    }

    public void setBufferPool(ByteBufferPool bufferPool) {
        this.bufferPool = bufferPool;
    }

    public void setConnectTimeout(long timeoutMilliseconds) {
        if (timeoutMilliseconds < 0L) {
            throw new IllegalStateException("Connect Timeout cannot be negative");
        }
        this.connectTimeout = timeoutMilliseconds;
    }

    public void setCookieStore(CookieStore cookieStore) {
        this.cookieStore = cookieStore;
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    public void setMasker(Masker masker) {
        this.masker = masker;
    }

    public void setMaxIdleTimeout(long milliseconds) {
        this.policy.setIdleTimeout(milliseconds);
    }
}

