/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.Scheduler;

public class HttpChannelState
implements AsyncContext {
    private static final Logger LOG = Log.getLogger(HttpChannelState.class);
    private static final long DEFAULT_TIMEOUT = 30000L;
    private final HttpChannel<?> _channel;
    private List<AsyncListener> _lastAsyncListeners;
    private List<AsyncListener> _asyncListeners;
    private State _state;
    private boolean _initial;
    private boolean _dispatched;
    private boolean _expired;
    private volatile boolean _responseWrapped;
    private long _timeoutMs = 30000L;
    private AsyncEventState _event;

    protected HttpChannelState(HttpChannel<?> channel) {
        this._channel = channel;
        this._state = State.IDLE;
        this._initial = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public State getState() {
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            return this._state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(AsyncListener listener) {
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            if (this._asyncListeners == null) {
                this._asyncListeners = new ArrayList<AsyncListener>();
            }
            this._asyncListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(AsyncListener listener, ServletRequest request, ServletResponse response) {
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            if (this._asyncListeners == null) {
                this._asyncListeners = new ArrayList<AsyncListener>();
            }
            this._asyncListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTimeout(long ms) {
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            this._timeoutMs = ms;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTimeout() {
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            return this._timeoutMs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AsyncEventState getAsyncEventState() {
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            return this._event;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            return super.toString() + "@" + this.getStatusString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getStatusString() {
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            return (Object)((Object)this._state) + (this._initial ? ",initial" : "") + (this._dispatched ? ",resumed" : "") + (this._expired ? ",expired" : "");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean handling() {
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            switch (this._state) {
                case IDLE: {
                    this._initial = true;
                    this._state = State.DISPATCHED;
                    if (this._lastAsyncListeners != null) {
                        this._lastAsyncListeners.clear();
                    }
                    if (this._asyncListeners != null) {
                        this._asyncListeners.clear();
                        break;
                    }
                    this._asyncListeners = this._lastAsyncListeners;
                    this._lastAsyncListeners = null;
                    break;
                }
                case COMPLETECALLED: {
                    this._state = State.COMPLETING;
                    return false;
                }
                case ASYNCWAIT: 
                case COMPLETING: 
                case COMPLETED: {
                    return false;
                }
                case REDISPATCH: {
                    this._state = State.REDISPATCHED;
                    break;
                }
                default: {
                    throw new IllegalStateException(this.getStatusString());
                }
            }
            this._responseWrapped = false;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startAsync() {
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            switch (this._state) {
                case DISPATCHED: 
                case REDISPATCHED: {
                    this._dispatched = false;
                    this._expired = false;
                    this._responseWrapped = false;
                    this._event = new AsyncEventState(this._channel.getRequest().getServletContext(), (ServletRequest)this._channel.getRequest(), (ServletResponse)this._channel.getResponse());
                    this._state = State.ASYNCSTARTED;
                    List<AsyncListener> listeners = this._lastAsyncListeners;
                    this._lastAsyncListeners = this._asyncListeners;
                    this._asyncListeners = listeners;
                    if (this._asyncListeners == null) break;
                    this._asyncListeners.clear();
                    break;
                }
                default: {
                    throw new IllegalStateException(this.getStatusString());
                }
            }
        }
        if (this._lastAsyncListeners != null) {
            for (AsyncListener listener : this._lastAsyncListeners) {
                try {
                    listener.onStartAsync((AsyncEvent)this._event);
                }
                catch (Exception e) {
                    LOG.warn(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startAsync(ServletContext context, ServletRequest request, ServletResponse response) {
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            switch (this._state) {
                case DISPATCHED: 
                case REDISPATCHED: {
                    this._dispatched = false;
                    this._expired = false;
                    this._responseWrapped = response != this._channel.getResponse();
                    this._event = new AsyncEventState(context, request, response);
                    this._event._pathInContext = request instanceof HttpServletRequest ? URIUtil.addPaths(((HttpServletRequest)request).getServletPath(), ((HttpServletRequest)request).getPathInfo()) : null;
                    this._state = State.ASYNCSTARTED;
                    List<AsyncListener> listeners = this._lastAsyncListeners;
                    this._lastAsyncListeners = this._asyncListeners;
                    this._asyncListeners = listeners;
                    if (this._asyncListeners == null) break;
                    this._asyncListeners.clear();
                    break;
                }
                default: {
                    throw new IllegalStateException(this.getStatusString());
                }
            }
        }
        if (this._lastAsyncListeners != null) {
            for (AsyncListener listener : this._lastAsyncListeners) {
                try {
                    listener.onStartAsync((AsyncEvent)this._event);
                }
                catch (Exception e) {
                    LOG.warn(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void error(Throwable th) {
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            if (this._event != null) {
                this._event._cause = th;
            }
        }
    }

    protected boolean unhandle() {
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            switch (this._state) {
                case DISPATCHED: 
                case REDISPATCHED: {
                    this._state = State.COMPLETING;
                    return true;
                }
                case IDLE: {
                    throw new IllegalStateException(this.getStatusString());
                }
                case ASYNCSTARTED: {
                    this._initial = false;
                    this._state = State.ASYNCWAIT;
                    this.scheduleTimeout();
                    if (this._state == State.ASYNCWAIT) {
                        return true;
                    }
                    if (this._state == State.COMPLETECALLED) {
                        this._state = State.COMPLETING;
                        return true;
                    }
                    this._initial = false;
                    this._state = State.REDISPATCHED;
                    return false;
                }
                case REDISPATCHING: {
                    this._initial = false;
                    this._state = State.REDISPATCHED;
                    return false;
                }
                case COMPLETECALLED: {
                    this._initial = false;
                    this._state = State.COMPLETING;
                    return true;
                }
            }
            throw new IllegalStateException(this.getStatusString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatch() {
        boolean dispatch;
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            switch (this._state) {
                case ASYNCSTARTED: {
                    this._state = State.REDISPATCHING;
                    this._dispatched = true;
                    return;
                }
                case ASYNCWAIT: {
                    dispatch = !this._expired;
                    this._state = State.REDISPATCH;
                    this._dispatched = true;
                    break;
                }
                case REDISPATCH: {
                    return;
                }
                default: {
                    throw new IllegalStateException(this.getStatusString());
                }
            }
        }
        if (dispatch) {
            this.cancelTimeout();
            this.scheduleDispatch();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDispatched() {
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            return this._dispatched;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void expired() {
        boolean complete;
        List<AsyncListener> aListeners;
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            switch (this._state) {
                case ASYNCWAIT: 
                case ASYNCSTARTED: {
                    aListeners = this._asyncListeners;
                    break;
                }
                default: {
                    return;
                }
            }
            this._expired = true;
        }
        if (aListeners != null) {
            for (AsyncListener listener : aListeners) {
                try {
                    listener.onTimeout((AsyncEvent)this._event);
                }
                catch (Exception e) {
                    LOG.warn(e);
                }
            }
        }
        HttpChannelState httpChannelState2 = this;
        synchronized (httpChannelState2) {
            switch (this._state) {
                case ASYNCWAIT: 
                case ASYNCSTARTED: {
                    complete = true;
                    break;
                }
                default: {
                    complete = false;
                }
            }
        }
        if (complete) {
            this.complete();
        }
        this.scheduleDispatch();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void complete() {
        boolean dispatch;
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            switch (this._state) {
                case DISPATCHED: 
                case REDISPATCHED: {
                    throw new IllegalStateException(this.getStatusString());
                }
                case IDLE: 
                case ASYNCSTARTED: {
                    this._state = State.COMPLETECALLED;
                    return;
                }
                case ASYNCWAIT: {
                    this._state = State.COMPLETECALLED;
                    dispatch = !this._expired;
                    break;
                }
                default: {
                    throw new IllegalStateException(this.getStatusString());
                }
            }
        }
        if (dispatch) {
            this.cancelTimeout();
            this.scheduleDispatch();
        }
    }

    public <T extends AsyncListener> T createListener(Class<T> clazz) throws ServletException {
        try {
            return (T)((AsyncListener)clazz.newInstance());
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void completed() {
        List<AsyncListener> aListeners;
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            switch (this._state) {
                case COMPLETING: {
                    this._state = State.COMPLETED;
                    aListeners = this._asyncListeners;
                    break;
                }
                default: {
                    throw new IllegalStateException(this.getStatusString());
                }
            }
        }
        if (aListeners != null) {
            for (AsyncListener listener : aListeners) {
                try {
                    if (this._event != null && this._event._cause != null) {
                        this._event.getSuppliedRequest().setAttribute("javax.servlet.error.exception", (Object)this._event._cause);
                        this._event.getSuppliedRequest().setAttribute("javax.servlet.error.message", (Object)this._event._cause.getMessage());
                        listener.onError((AsyncEvent)this._event);
                        continue;
                    }
                    listener.onComplete((AsyncEvent)this._event);
                }
                catch (Exception e) {
                    LOG.warn(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void recycle() {
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            switch (this._state) {
                case DISPATCHED: 
                case REDISPATCHED: {
                    throw new IllegalStateException(this.getStatusString());
                }
            }
            this._state = State.IDLE;
            this._initial = true;
            this._dispatched = false;
            this._expired = false;
            this._responseWrapped = false;
            this.cancelTimeout();
            this._timeoutMs = 30000L;
            this._event = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            this.cancelTimeout();
        }
    }

    protected void scheduleDispatch() {
        this._channel.execute(this._channel);
    }

    protected void scheduleTimeout() {
        Scheduler scheduler = this._channel.getScheduler();
        if (scheduler != null && this._timeoutMs > 0L) {
            this._event._timeout = scheduler.schedule(new AsyncTimeout(), this._timeoutMs, TimeUnit.MILLISECONDS);
        }
    }

    protected void cancelTimeout() {
        Scheduler.Task task;
        AsyncEventState event = this._event;
        if (event != null && (task = event._timeout) != null) {
            task.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInitial() {
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            return this._initial;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSuspended() {
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            switch (this._state) {
                case COMPLETECALLED: 
                case ASYNCWAIT: 
                case ASYNCSTARTED: 
                case REDISPATCHING: {
                    return true;
                }
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isCompleting() {
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            return this._state == State.COMPLETING;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAsync() {
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            switch (this._state) {
                case COMPLETECALLED: 
                case ASYNCWAIT: 
                case REDISPATCH: 
                case REDISPATCHED: 
                case ASYNCSTARTED: 
                case REDISPATCHING: {
                    return true;
                }
            }
            return false;
        }
    }

    public void dispatch(ServletContext context, String path) {
        this._event._dispatchContext = context;
        this._event._pathInContext = path;
        this.dispatch();
    }

    public void dispatch(String path) {
        this._event._pathInContext = path;
        this.dispatch();
    }

    public Request getBaseRequest() {
        return this._channel.getRequest();
    }

    public ServletRequest getRequest() {
        if (this._event != null) {
            return this._event.getSuppliedRequest();
        }
        return this._channel.getRequest();
    }

    public ServletResponse getResponse() {
        if (this._responseWrapped && this._event != null && this._event.getSuppliedResponse() != null) {
            return this._event.getSuppliedResponse();
        }
        return this._channel.getResponse();
    }

    public void start(final Runnable run) {
        final AsyncEventState event = this._event;
        if (event != null) {
            this._channel.execute(new Runnable(){

                @Override
                public void run() {
                    ((ContextHandler.Context)event.getServletContext()).getContextHandler().handle(run);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasOriginalRequestAndResponse() {
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            return this._event != null && this._event.getSuppliedRequest() == this._channel.getRequest() && this._event.getSuppliedResponse() == this._channel.getResponse();
        }
    }

    public ContextHandler getContextHandler() {
        AsyncEventState event = this._event;
        if (event != null) {
            return ((ContextHandler.Context)event.getServletContext()).getContextHandler();
        }
        return null;
    }

    public ServletResponse getServletResponse() {
        if (this._responseWrapped && this._event != null && this._event.getSuppliedResponse() != null) {
            return this._event.getSuppliedResponse();
        }
        return this._channel.getResponse();
    }

    public Object getAttribute(String name) {
        return this._channel.getRequest().getAttribute(name);
    }

    public void removeAttribute(String name) {
        this._channel.getRequest().removeAttribute(name);
    }

    public void setAttribute(String name, Object attribute) {
        this._channel.getRequest().setAttribute(name, attribute);
    }

    public class AsyncEventState
    extends AsyncEvent {
        private final ServletContext _suspendedContext;
        private String _pathInContext;
        private Scheduler.Task _timeout;
        private ServletContext _dispatchContext;
        private Throwable _cause;

        public AsyncEventState(ServletContext context, ServletRequest request, ServletResponse response) {
            super((AsyncContext)HttpChannelState.this, request, response);
            this._suspendedContext = context;
            Request r = HttpChannelState.this._channel.getRequest();
            if (r.getAttribute("javax.servlet.async.request_uri") == null) {
                String uri = (String)r.getAttribute("javax.servlet.forward.request_uri");
                if (uri != null) {
                    r.setAttribute("javax.servlet.async.request_uri", uri);
                    r.setAttribute("javax.servlet.async.context_path", r.getAttribute("javax.servlet.forward.context_path"));
                    r.setAttribute("javax.servlet.async.servlet_path", r.getAttribute("javax.servlet.forward.servlet_path"));
                    r.setAttribute("javax.servlet.async.path_info", r.getAttribute("javax.servlet.forward.path_info"));
                    r.setAttribute("javax.servlet.async.query_string", r.getAttribute("javax.servlet.forward.query_string"));
                } else {
                    r.setAttribute("javax.servlet.async.request_uri", r.getRequestURI());
                    r.setAttribute("javax.servlet.async.context_path", r.getContextPath());
                    r.setAttribute("javax.servlet.async.servlet_path", r.getServletPath());
                    r.setAttribute("javax.servlet.async.path_info", r.getPathInfo());
                    r.setAttribute("javax.servlet.async.query_string", r.getQueryString());
                }
            }
        }

        public ServletContext getSuspendedContext() {
            return this._suspendedContext;
        }

        public ServletContext getDispatchContext() {
            return this._dispatchContext;
        }

        public ServletContext getServletContext() {
            return this._dispatchContext == null ? this._suspendedContext : this._dispatchContext;
        }

        public String getPath() {
            return this._pathInContext;
        }
    }

    public class AsyncTimeout
    implements Runnable {
        @Override
        public void run() {
            HttpChannelState.this.expired();
        }
    }

    public static enum State {
        IDLE,
        DISPATCHED,
        ASYNCSTARTED,
        REDISPATCHING,
        ASYNCWAIT,
        REDISPATCH,
        REDISPATCHED,
        COMPLETECALLED,
        COMPLETING,
        COMPLETED;

    }
}

