/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.io.AsyncEndPoint;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.ByteArrayBuffer;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.nio.SelectChannelEndPoint;
import org.eclipse.jetty.util.B64Code;
import org.eclipse.jetty.util.Utf8StringBuilder;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.websocket.Extension;
import org.eclipse.jetty.websocket.WebSocket;
import org.eclipse.jetty.websocket.WebSocketBuffers;
import org.eclipse.jetty.websocket.WebSocketConnection;
import org.eclipse.jetty.websocket.WebSocketGenerator;
import org.eclipse.jetty.websocket.WebSocketGeneratorD06;
import org.eclipse.jetty.websocket.WebSocketParser;
import org.eclipse.jetty.websocket.WebSocketParserD06;

public class WebSocketConnectionD06
extends AbstractConnection
implements WebSocketConnection {
    static final byte OP_CONTINUATION = 0;
    static final byte OP_CLOSE = 1;
    static final byte OP_PING = 2;
    static final byte OP_PONG = 3;
    static final byte OP_TEXT = 4;
    static final byte OP_BINARY = 5;
    static final int CLOSE_NORMAL = 1000;
    static final int CLOSE_SHUTDOWN = 1001;
    static final int CLOSE_PROTOCOL = 1002;
    static final int CLOSE_BADDATA = 1003;
    static final int CLOSE_LARGE = 1004;
    private static final byte[] MAGIC;
    private final IdleCheck _idle;
    private final WebSocketParser _parser;
    private final WebSocketGenerator _generator;
    private final WebSocket _webSocket;
    private final WebSocket.OnFrame _onFrame;
    private final WebSocket.OnBinaryMessage _onBinaryMessage;
    private final WebSocket.OnTextMessage _onTextMessage;
    private final WebSocket.OnControl _onControl;
    private final String _protocol;
    private boolean _closedIn;
    private boolean _closedOut;
    private int _maxTextMessageSize;
    private int _maxBinaryMessageSize = -1;
    private final WebSocketParser.FrameHandler _frameHandler = new FrameHandlerD06();
    private final WebSocket.FrameConnection _connection = new FrameConnectionD06();

    static boolean isLastFrame(int flags) {
        return (flags & 8) != 0;
    }

    static boolean isControlFrame(int opcode) {
        switch (opcode) {
            case 1: 
            case 2: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    public WebSocketConnectionD06(WebSocket websocket, EndPoint endpoint, WebSocketBuffers buffers, long timestamp, int maxIdleTime, String protocol) throws IOException {
        super(endpoint, timestamp);
        if (endpoint instanceof AsyncEndPoint) {
            ((AsyncEndPoint)endpoint).cancelIdle();
        }
        this._endp.setMaxIdleTime(maxIdleTime);
        this._webSocket = websocket;
        this._onFrame = this._webSocket instanceof WebSocket.OnFrame ? (WebSocket.OnFrame)this._webSocket : null;
        this._onTextMessage = this._webSocket instanceof WebSocket.OnTextMessage ? (WebSocket.OnTextMessage)this._webSocket : null;
        this._onBinaryMessage = this._webSocket instanceof WebSocket.OnBinaryMessage ? (WebSocket.OnBinaryMessage)this._webSocket : null;
        this._onControl = this._webSocket instanceof WebSocket.OnControl ? (WebSocket.OnControl)this._webSocket : null;
        this._generator = new WebSocketGeneratorD06(buffers, this._endp, null);
        this._parser = new WebSocketParserD06(buffers, endpoint, this._frameHandler, true);
        this._protocol = protocol;
        if (this._endp instanceof SelectChannelEndPoint) {
            final SelectChannelEndPoint scep = (SelectChannelEndPoint)this._endp;
            scep.cancelIdle();
            this._idle = new IdleCheck(){

                @Override
                public void access(EndPoint endp) {
                    scep.scheduleIdle();
                }
            };
            scep.scheduleIdle();
        } else {
            this._idle = new IdleCheck(){

                @Override
                public void access(EndPoint endp) {
                }
            };
        }
        this._maxTextMessageSize = buffers.getBufferSize();
        this._maxBinaryMessageSize = -1;
    }

    @Override
    public WebSocket.Connection getConnection() {
        return this._connection;
    }

    @Override
    public Connection handle() throws IOException {
        try {
            boolean progress = true;
            while (progress) {
                int flushed = this._generator.flush();
                int filled = this._parser.parseNext();
                boolean bl = progress = flushed > 0 || filled > 0;
                if (filled >= 0 && flushed >= 0) continue;
                this._endp.close();
                break;
            }
        }
        catch (IOException e) {
            try {
                this._endp.close();
            }
            catch (IOException e2) {
                Log.ignore(e2);
            }
            throw e;
        }
        finally {
            if (this._endp.isOpen()) {
                this._idle.access(this._endp);
                if (this._closedIn && this._closedOut && this._generator.isBufferEmpty()) {
                    this._endp.close();
                } else if (this._endp.isInputShutdown() && !this._closedIn) {
                    this.closeIn(1002, null);
                } else {
                    this.checkWriteable();
                }
            }
        }
        return this;
    }

    @Override
    public boolean isIdle() {
        return this._parser.isBufferEmpty() && this._generator.isBufferEmpty();
    }

    @Override
    public void idleExpired() {
        this.closeOut(1000, "Idle");
    }

    @Override
    public boolean isSuspended() {
        return false;
    }

    @Override
    public void closed() {
        this._webSocket.onClose(1000, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void closeIn(int code, String message) {
        Log.debug("ClosedIn {} {}", this, message);
        try {
            if (this._closedOut) {
                this._endp.close();
            } else {
                this.closeOut(code, message);
            }
        }
        catch (IOException e) {
            Log.ignore(e);
        }
        finally {
            this._closedIn = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void closeOut(int code, String message) {
        Log.debug("ClosedOut {} {}", this, message);
        try {
            if (this._closedIn || this._closedOut) {
                this._endp.close();
            } else {
                if (code <= 0) {
                    code = 1000;
                }
                byte[] bytes = ("xx" + (message == null ? "" : message)).getBytes("ISO-8859-1");
                bytes[0] = (byte)(code / 256);
                bytes[1] = (byte)(code % 256);
                this._generator.addFrame((byte)8, (byte)1, bytes, 0, bytes.length);
            }
            this._generator.flush();
        }
        catch (IOException e) {
            Log.ignore(e);
        }
        finally {
            this._closedOut = true;
        }
    }

    @Override
    public void fillBuffersFrom(Buffer buffer) {
        this._parser.fill(buffer);
    }

    private void checkWriteable() {
        if (!this._generator.isBufferEmpty() && this._endp instanceof AsyncEndPoint) {
            ((AsyncEndPoint)this._endp).scheduleWrite();
        }
    }

    @Override
    public List<Extension> getExtensions() {
        return Collections.emptyList();
    }

    @Override
    public void handshake(HttpServletRequest request, HttpServletResponse response, String subprotocol) throws IOException {
        String uri = request.getRequestURI();
        String query = request.getQueryString();
        if (query != null && query.length() > 0) {
            uri = uri + "?" + query;
        }
        String key = request.getHeader("Sec-WebSocket-Key");
        response.setHeader("Upgrade", "WebSocket");
        response.addHeader("Connection", "Upgrade");
        response.addHeader("Sec-WebSocket-Accept", WebSocketConnectionD06.hashKey(key));
        if (subprotocol != null) {
            response.addHeader("Sec-WebSocket-Protocol", subprotocol);
        }
        response.sendError(101);
        if (this._onFrame != null) {
            this._onFrame.onHandshake(this._connection);
        }
        this._webSocket.onOpen(this._connection);
    }

    public static String hashKey(String key) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA1");
            md.update(key.getBytes("UTF-8"));
            md.update(MAGIC);
            return new String(B64Code.encode(md.digest()));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static {
        try {
            MAGIC = "258EAFA5-E914-47DA-95CA-C5AB0DC85B11".getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static interface IdleCheck {
        public void access(EndPoint var1);
    }

    private class FrameHandlerD06
    implements WebSocketParser.FrameHandler {
        private final Utf8StringBuilder _utf8 = new Utf8StringBuilder();
        private ByteArrayBuffer _aggregate;
        private byte _opcode = (byte)-1;

        private FrameHandlerD06() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void onFrame(byte flags, byte opcode, Buffer buffer) {
            boolean lastFrame = WebSocketConnectionD06.isLastFrame(flags);
            WebSocketConnectionD06 webSocketConnectionD06 = WebSocketConnectionD06.this;
            synchronized (webSocketConnectionD06) {
                if (WebSocketConnectionD06.this._closedIn) {
                    return;
                }
                try {
                    byte[] array = buffer.array();
                    if (WebSocketConnectionD06.this._onFrame != null && WebSocketConnectionD06.this._onFrame.onFrame(flags, opcode, array, buffer.getIndex(), buffer.length())) {
                        return;
                    }
                    if (WebSocketConnectionD06.this._onControl != null && WebSocketConnectionD06.isControlFrame(opcode) && WebSocketConnectionD06.this._onControl.onControl(opcode, array, buffer.getIndex(), buffer.length())) {
                        return;
                    }
                    switch (opcode) {
                        case 0: {
                            if (this._opcode == 4 && WebSocketConnectionD06.this._connection.getMaxTextMessageSize() >= 0) {
                                if (this._utf8.append(buffer.array(), buffer.getIndex(), buffer.length(), WebSocketConnectionD06.this._connection.getMaxTextMessageSize())) {
                                    if (!lastFrame) return;
                                    if (WebSocketConnectionD06.this._onTextMessage == null) return;
                                    this._opcode = (byte)-1;
                                    String msg = this._utf8.toString();
                                    this._utf8.reset();
                                    WebSocketConnectionD06.this._onTextMessage.onMessage(msg);
                                    break;
                                }
                                WebSocketConnectionD06.this._connection.close(1004, "Text message size > " + WebSocketConnectionD06.this._connection.getMaxTextMessageSize() + " chars");
                                this._utf8.reset();
                                this._opcode = (byte)-1;
                                break;
                            }
                            if (this._opcode < 0) return;
                            if (WebSocketConnectionD06.this._connection.getMaxBinaryMessageSize() < 0) return;
                            if (this._aggregate.space() < this._aggregate.length()) {
                                WebSocketConnectionD06.this._connection.close(1004, "Message size > " + WebSocketConnectionD06.this._connection.getMaxBinaryMessageSize());
                                this._aggregate.clear();
                                this._opcode = (byte)-1;
                                break;
                            }
                            this._aggregate.put(buffer);
                            if (!lastFrame) return;
                            if (WebSocketConnectionD06.this._onBinaryMessage == null) return;
                            try {
                                WebSocketConnectionD06.this._onBinaryMessage.onMessage(this._aggregate.array(), this._aggregate.getIndex(), this._aggregate.length());
                                break;
                            }
                            finally {
                                this._opcode = (byte)-1;
                                this._aggregate.clear();
                            }
                        }
                        case 2: {
                            Log.debug("PING {}", this);
                            if (WebSocketConnectionD06.this._closedOut) return;
                            WebSocketConnectionD06.this._connection.sendControl((byte)3, buffer.array(), buffer.getIndex(), buffer.length());
                            break;
                        }
                        case 3: {
                            Log.debug("PONG {}", this);
                            break;
                        }
                        case 1: {
                            int code = -1;
                            String message = null;
                            if (buffer.length() >= 2) {
                                code = buffer.array()[buffer.getIndex()] * 255 + buffer.array()[buffer.getIndex() + 1];
                                if (buffer.length() > 2) {
                                    message = new String(buffer.array(), buffer.getIndex() + 2, buffer.length() - 2, "UTF-8");
                                }
                            }
                            WebSocketConnectionD06.this.closeIn(code, message);
                            break;
                        }
                        case 4: {
                            if (WebSocketConnectionD06.this._onTextMessage == null) return;
                            if (lastFrame) {
                                WebSocketConnectionD06.this._onTextMessage.onMessage(buffer.toString("UTF-8"));
                                break;
                            }
                            if (WebSocketConnectionD06.this._connection.getMaxTextMessageSize() < 0) return;
                            if (this._utf8.append(buffer.array(), buffer.getIndex(), buffer.length(), WebSocketConnectionD06.this._connection.getMaxTextMessageSize())) {
                                this._opcode = (byte)4;
                                break;
                            }
                            this._utf8.reset();
                            this._opcode = (byte)-1;
                            WebSocketConnectionD06.this._connection.close(1004, "Text message size > " + WebSocketConnectionD06.this._connection.getMaxTextMessageSize() + " chars");
                            break;
                        }
                        default: {
                            if (WebSocketConnectionD06.this._onBinaryMessage == null) return;
                            if (lastFrame) {
                                WebSocketConnectionD06.this._onBinaryMessage.onMessage(array, buffer.getIndex(), buffer.length());
                                break;
                            }
                            if (WebSocketConnectionD06.this._connection.getMaxBinaryMessageSize() < 0) return;
                            if (buffer.length() > WebSocketConnectionD06.this._connection.getMaxBinaryMessageSize()) {
                                WebSocketConnectionD06.this._connection.close(1004, "Message size > " + WebSocketConnectionD06.this._connection.getMaxBinaryMessageSize());
                                if (this._aggregate != null) {
                                    this._aggregate.clear();
                                }
                                this._opcode = (byte)-1;
                                break;
                            }
                            this._opcode = opcode;
                            if (this._aggregate == null) {
                                this._aggregate = new ByteArrayBuffer(WebSocketConnectionD06.this._connection.getMaxBinaryMessageSize());
                            }
                            this._aggregate.put(buffer);
                            break;
                        }
                    }
                }
                catch (ThreadDeath th) {
                    throw th;
                }
                catch (Throwable th) {
                    Log.warn(th);
                }
                return;
            }
        }

        @Override
        public void close(int code, String message) {
            WebSocketConnectionD06.this._connection.close(code, message);
        }

        public String toString() {
            return WebSocketConnectionD06.this.toString() + "FH";
        }
    }

    private class FrameConnectionD06
    implements WebSocket.FrameConnection {
        volatile boolean _disconnecting;
        int _maxTextMessage;
        int _maxBinaryMessage;

        private FrameConnectionD06() {
            this._maxTextMessage = WebSocketConnectionD06.this._maxTextMessageSize;
            this._maxBinaryMessage = WebSocketConnectionD06.this._maxBinaryMessageSize;
        }

        @Override
        public synchronized void sendMessage(String content) throws IOException {
            if (WebSocketConnectionD06.this._closedOut) {
                throw new IOException("closing");
            }
            byte[] data = content.getBytes("UTF-8");
            WebSocketConnectionD06.this._generator.addFrame((byte)8, (byte)4, data, 0, data.length);
            WebSocketConnectionD06.this._generator.flush();
            WebSocketConnectionD06.this.checkWriteable();
            WebSocketConnectionD06.this._idle.access(WebSocketConnectionD06.this._endp);
        }

        @Override
        public synchronized void sendMessage(byte[] content, int offset, int length) throws IOException {
            if (WebSocketConnectionD06.this._closedOut) {
                throw new IOException("closing");
            }
            WebSocketConnectionD06.this._generator.addFrame((byte)8, (byte)5, content, offset, length);
            WebSocketConnectionD06.this._generator.flush();
            WebSocketConnectionD06.this.checkWriteable();
            WebSocketConnectionD06.this._idle.access(WebSocketConnectionD06.this._endp);
        }

        @Override
        public void sendFrame(byte flags, byte opcode, byte[] content, int offset, int length) throws IOException {
            if (WebSocketConnectionD06.this._closedOut) {
                throw new IOException("closing");
            }
            WebSocketConnectionD06.this._generator.addFrame(flags, opcode, content, offset, length);
            WebSocketConnectionD06.this._generator.flush();
            WebSocketConnectionD06.this.checkWriteable();
            WebSocketConnectionD06.this._idle.access(WebSocketConnectionD06.this._endp);
        }

        @Override
        public void sendControl(byte control, byte[] data, int offset, int length) throws IOException {
            if (WebSocketConnectionD06.this._closedOut) {
                throw new IOException("closing");
            }
            WebSocketConnectionD06.this._generator.addFrame((byte)8, control, data, offset, length);
            WebSocketConnectionD06.this._generator.flush();
            WebSocketConnectionD06.this.checkWriteable();
            WebSocketConnectionD06.this._idle.access(WebSocketConnectionD06.this._endp);
        }

        @Override
        public boolean isMessageComplete(byte flags) {
            return WebSocketConnectionD06.isLastFrame(flags);
        }

        @Override
        public boolean isOpen() {
            return WebSocketConnectionD06.this._endp != null && WebSocketConnectionD06.this._endp.isOpen();
        }

        @Override
        public void close(int code, String message) {
            if (this._disconnecting) {
                return;
            }
            this._disconnecting = true;
            WebSocketConnectionD06.this.closeOut(code, message);
        }

        @Override
        public void setMaxTextMessageSize(int size) {
            this._maxTextMessage = size;
        }

        @Override
        public void setMaxBinaryMessageSize(int size) {
            this._maxBinaryMessage = size;
        }

        @Override
        public int getMaxTextMessageSize() {
            return this._maxTextMessage;
        }

        @Override
        public int getMaxBinaryMessageSize() {
            return this._maxBinaryMessage;
        }

        @Override
        public String getProtocol() {
            return WebSocketConnectionD06.this._protocol;
        }

        @Override
        public byte binaryOpcode() {
            return 5;
        }

        @Override
        public byte textOpcode() {
            return 4;
        }

        @Override
        public byte continuationOpcode() {
            return 0;
        }

        @Override
        public byte finMask() {
            return 8;
        }

        @Override
        public boolean isControl(byte opcode) {
            return WebSocketConnectionD06.isControlFrame(opcode);
        }

        @Override
        public boolean isText(byte opcode) {
            return opcode == 4;
        }

        @Override
        public boolean isBinary(byte opcode) {
            return opcode == 5;
        }

        @Override
        public boolean isContinuation(byte opcode) {
            return opcode == 0;
        }

        @Override
        public boolean isClose(byte opcode) {
            return opcode == 1;
        }

        @Override
        public boolean isPing(byte opcode) {
            return opcode == 2;
        }

        @Override
        public boolean isPong(byte opcode) {
            return opcode == 3;
        }

        @Override
        public void disconnect() {
            this.close(1000, null);
        }

        public String toString() {
            return this.getClass().getSimpleName() + "@" + WebSocketConnectionD06.this._endp.getLocalAddr() + ":" + WebSocketConnectionD06.this._endp.getLocalPort() + "<->" + WebSocketConnectionD06.this._endp.getRemoteAddr() + ":" + WebSocketConnectionD06.this._endp.getRemotePort();
        }

        @Override
        public void setFakeFragments(boolean fake) {
        }

        @Override
        public boolean isFakeFragments() {
            return false;
        }
    }
}

